module Session

  private

  module CustomAssertions

    def create_domain(c)
      post url_for(:controller => "product", :product_id => 8, :action => "new"), :it => c, :create => "button"
      assert_response :success
    end

    def create_demo(c)
      post url_for(:controller => "product", :product_id => 999, :action => "new"), :it => c, :create => "button"
      assert_response :success
    end

    def create_product(c)
      post url_for(:controller => "product_generator", :action => "new"), :product => c
      assert_response :redirect
    end

  end

  def login(name, password)
    open_session do |sess|
      sess.extend(CustomAssertions)
      sess.post url_for(:controller => "user", :action => "login"), :user => { :login => name, :password => password }
      sess.assert_response :redirect
      sess.follow_redirect!
      sess.assert_template "menu/index"
    end
  end
end
