# -*- coding: utf-8 -*-
# app/models/item.rb のクラス Item をテストする。

require 'test_helper'

class MergeableTagTest < ActiveSupport::TestCase
  def setup
    @th = MergeableTag.new(:th, "th", :class => "test")
    @td1 = MergeableTag.new(:td, "td1", :title => "td", :id => "td1")
    @td2 = MergeableTag.new(:td, "td2", :class => "test", :id => "td2")
  end

  def test_new
    assert_kind_of MergeableTag, @th
    assert_kind_of MergeableTag, @td1
    assert_kind_of MergeableTag, @td2
  end

  def test_kind
    assert_equal :th, @th.kind
    assert_equal :td, @td1.kind
    assert_equal :td, @td2.kind
  end

  def test_child
    assert_equal "th", @th.child
    assert_equal "td1", @td1.child
    assert_equal "td2", @td2.child
  end

  def test_attr
    expected = {:class => "test"}
    assert_equal expected, @th.attr
    expected = {:title => "td", :id => "td1"}
    assert_equal expected, @td1.attr
    expected = {:class => "test", :id => "td2"}
    assert_equal expected, @td2.attr
  end

  def test_to_s
    assert_equal "<th class=\"test\">th</th>", @th.to_s
  end

  def test_merge
    expected = {:title => "td", :id => "td1"}
    assert_equal expected, @td1.attr
    expected = {:class => "test", :id => "td2"}
    assert_equal expected, @td2.attr
    @td1.merge(@td2)
    expected = {:title => "td", :id => "td2", :class => "test"}
    assert_equal expected, @td1.attr
    expected = {:class => "test", :id => "td2"}
    assert_equal expected, @td2.attr
  end

  # class については置き換えではなく追加になる。
  def test_merge__class
    x = MergeableTag.new(:td, "td0", :class => "test0")
    y = MergeableTag.new(:td, "td1", :title => "td", :id => "td1")
    z = MergeableTag.new(:td, "td2", :class => "test2", :id => "td2")
    x.merge(y)
    x.merge(z)
    expected = {:class => "test0 test2", :title => "td", :id => "td2"}
    assert_equal expected, x.attr
  end
end
