# -*- coding: utf-8 -*-
# lib/picker.rb のモジュール Picker をテストする。
require 'test_helper'

class PickerTest < ActiveSupport::TestCase

  def setup
    @picker = mock()
    @picker.extend(Picker)
  end

  def test_picking_record?
    @picker.stubs(:input_parameter).returns("calendar")
    assert !@picker.picking_record?
    @picker.stubs(:input_parameter).returns("company")
    assert !@picker.picking_record?
    @picker.stubs(:input_parameter).returns("record(xxyy)")
    assert @picker.picking_record?
  end

  def test_picked_keys
    @picker.stubs(:input_parameter).returns("")
    assert !@picker.picked_keys
    @picker.stubs(:input_parameter).returns("person,company,organization")
    assert_equal %w|person company organization|, @picker.picked_keys
    @picker.stubs(:input_parameter).returns("calendar")
    assert_equal %w|calendar|, @picker.picked_keys
    @picker.stubs(:input_parameter).returns("record(abc)")
    assert_equal %w|abc|, @picker.picked_keys
  end

  def test_picked_atom
    @picker.stubs(:input_parameter).returns("calendar")
    assert_equal "calendar", @picker.picked_atom
    @picker.stubs(:input_parameter).returns("person")
    assert_equal "person", @picker.picked_atom
    @picker.stubs(:input_parameter).returns("record(xxyy)")
    assert_equal "xxyy", @picker.picked_atom
  end

end
