# -*- coding: utf-8 -*-

require 'test_helper'

class ProjectCollaboration::PjInputOptionHelperTest < ActiveSupport::TestCase

  def setup
    @item = mock()
    @item.extend(ProjectCollaboration::PjInputOptionHelper)
  end

  def test_pj_input_option__ok
    @item.expects(:input_type).returns('select')
    @item.expects(:input_parameter).returns('pj_input_option(category_x,column_y)')
    assert @item.pj_input_option?
  end

  def test_pj_input_option__ng1
    @item.expects(:input_type).returns('text')
    assert !@item.pj_input_option?
  end

  def test_pj_input_option__ng2
    @item.expects(:input_type).returns('select')
    @item.expects(:input_parameter).returns('pj_input_option(,)')
    assert !@item.pj_input_option?
  end

  def test_pj_input_option_category
    @item.expects(:input_type).returns('radio')
    @item.expects(:input_parameter).returns('pj_input_option(category_x, obj.project_id)')
    assert_equal "category_x", @item.pj_input_option_category
  end

  def test_pj_input_option_column_name
    @item.expects(:input_type).returns('radio')
    @item.expects(:input_parameter).returns('pj_input_option(category_x, obj.project_id)')
    assert_equal "obj.project_id", @item.pj_input_option_column_name
  end

  def test_pj_input_option_project_id__ok1
    @item.expects(:input_type).returns('radio')
    @item.expects(:input_parameter).returns('pj_input_option(category_x, project_id)')
    x = stub(:project_id => 10)
    x.expects(:respond_to?).with("project_id").returns(true)
    assert_equal 10, @item.pj_input_option_project_id(x)
  end

  def test_pj_input_option_project_id__ok2
    @item.expects(:input_type).returns('select')
    @item.expects(:input_parameter).returns('pj_input_option(category_x, obj.project_id)')
    obj = stub(:project_id => 100)
    obj.expects(:respond_to?).with("project_id").returns(true)
    x = stub(:obj => obj)
    x.expects(:respond_to?).with("obj").returns(true)
    assert_equal 100, @item.pj_input_option_project_id(x)
  end

end
