<?php {
  /*
  $Id: checkout_shipping.php,v 1.1.9.1.2.13 2003/11/26 08:51:36 kasugai Exp $

  osCommerce, Open Source E-Commerce Solutions
  http://www.oscommerce.com

  Copyright (c) 2003 osCommerce

  Released under the GNU General Public License
  */

  require('../lib/catalog/application_top.php');
  require('../lib/catalog/classes/http_client.php');

  // if the customer is not logged on, redirect them to the login page
  if (!tep_session_is_registered('customer_id')) {
    $_SESSION["navigation"]->set_snapshot();
    tep_redirect(tep_href_link(FILENAME_LOGIN, '', 'SSL'));
  }

  // if there is nothing in the customers cart, redirect them to the shopping cart page
  if ($_SESSION["cart"]->count_contents() < 1) {
    tep_redirect(tep_href_link(FILENAME_SHOPPING_CART));
  }

  // if no shipping destination address was selected, use the customers own address as default
  if (!tep_session_is_registered('sendto')) {
    tep_session_register('sendto');
    $_SESSION['sendto'] = $_SESSION["customer_default_address_id"];
  } else {
    // verify the selected shipping address
    $check_address_query = tep_db_query("select count(*) as total from " . TABLE_ADDRESS_BOOK . " where customers_id = '" . (int)$_SESSION["customer_id"] . "' and address_book_id = '" . (int)$_SESSION['sendto'] . "'");
    $check_address = tep_db_fetch_array($check_address_query);

    if ($check_address['total'] != '1') {
      $_SESSION['sendto'] = $_SESSION['customer_default_address_id'];
      if (tep_session_is_registered('shipping')) tep_session_unregister('shipping');
    }
  }

  require(DIR_FS_CLASSES . 'order.php');
  $order = new order;

  // register a random ID in the session to check throughout the checkout procedure
  // against alterations in the shopping cart contents
  if (!tep_session_is_registered('cartID')) tep_session_register('cartID');
  $_SESSION['cartID'] = $_SESSION['cart']->cartID;

  // if the order contains only virtual products, forward the customer to the billing page as
  // a shipping address is not needed
  if ($order->content_type == 'virtual') {
    if (!tep_session_is_registered('shipping')) tep_session_register('shipping');
    $_SESSION['shipping'] = false;
    $_SESSION['sendto'] = false;
    tep_redirect(tep_href_link(FILENAME_CHECKOUT_PAYMENT, '', 'SSL'));
  }

  $total_weight = $_SESSION["cart"]->show_weight();
  $total_count = $_SESSION["cart"]->count_contents();

  // load all enabled shipping modules
  require(DIR_FS_CLASSES . 'shipping.php');
  $shipping_modules = new shipping;

  if ( defined('MODULE_ORDER_TOTAL_SHIPPING_FREE_SHIPPING') && (MODULE_ORDER_TOTAL_SHIPPING_FREE_SHIPPING == 'true') ) {
    $pass = false;

    switch (MODULE_ORDER_TOTAL_SHIPPING_DESTINATION) {
    case 'national':
      if ($order->delivery['country_id'] == STORE_COUNTRY) {
	$pass = true;
      }
      break;
    case 'international':
      if ($order->delivery['country_id'] != STORE_COUNTRY) {
	$pass = true;
      }
      break;
    case 'both':
      $pass = true;
      break;
    }

    $free_shipping = false;
    if ( ($pass == true) && ($order->info['subtotal'] >= MODULE_ORDER_TOTAL_SHIPPING_FREE_SHIPPING_OVER) ) {
      $free_shipping = true;

      include(DIR_FS_LANGUAGES . $_SESSION['language'] . '/modules/order_total/ot_shipping.php');
    }
  } else {
    $free_shipping = false;
  }

  // process the selected shipping method
  if ( isset($_POST['action']) && ($_POST['action'] == 'process') ) {
    if (!tep_session_is_registered('comments')) tep_session_register('comments');
    if (tep_not_null($_POST['comments'])) {
      $_SESSION['comments'] = tep_db_prepare_input($_POST['comments']);
    }

    if (!tep_session_is_registered('shipping')) tep_session_register('shipping');

    if ( (tep_count_shipping_modules() > 0) || ($free_shipping == true) ) {
      if ( (isset($_POST['shipping'])) && (strpos($_POST['shipping'], '_')) ) {
        $_SESSION['shipping'] = $_POST['shipping'];

        list($module, $method) = explode('_', $_SESSION['shipping']);
        if ( is_object($$module) || ($_SESSION['shipping'] == 'free_free') ) {
          if ($_SESSION['shipping'] == 'free_free') {
            $quote[0]['methods'][0]['title'] = FREE_SHIPPING_TITLE;
            $quote[0]['methods'][0]['cost'] = '0';
          } else {
            $quote = $shipping_modules->quote($method, $module);
          }
          if (isset($quote['error'])) {
            tep_session_unregister('shipping');
          } else {
            if ( (isset($quote[0]['methods'][0]['title'])) && (isset($quote[0]['methods'][0]['cost'])) ) {
              $_SESSION['shipping'] = array('id' => $_SESSION['shipping'],
					    'title' => (($free_shipping == true) ?  $quote[0]['methods'][0]['title'] : $quote[0]['module'] . ' (' . $quote[0]['methods'][0]['title'] . ')'),
					    'cost' => $quote[0]['methods'][0]['cost'],
					    'timespec' => $quote[0]['methods'][0]['timespec']  // add for Japanese update
					    );

              tep_redirect(tep_href_link(FILENAME_CHECKOUT_PAYMENT, '', 'SSL'));
            }
          }
        } else {
          tep_session_unregister('shipping');
        }
      }
    } else {
      $_SESSION['shipping'] = false;
                
      tep_redirect(tep_href_link(FILENAME_CHECKOUT_PAYMENT, '', 'SSL'));
    }    
  }

  // get all available shipping quotes
  $quotes = $shipping_modules->quote();

  // if no shipping method has been selected, automatically select the cheapest method.
  // if the modules status was changed when none were available, to save on implementing
  // a javascript force-selection method, also automatically select the cheapest shipping
  // method if more than one module is now enabled
  if ( !tep_session_is_registered('shipping') || ( tep_session_is_registered('shipping') && ($_SESSION['shipping'] == false) && (tep_count_shipping_modules() > 1) ) ) $_SESSION['shipping'] = $shipping_modules->cheapest();

  require(DIR_FS_LANGUAGES . $_SESSION['language'] . '/' . FILENAME_CHECKOUT_SHIPPING);

  $breadcrumb->add(NAVBAR_TITLE_1, tep_href_link(FILENAME_CHECKOUT_SHIPPING, '', 'SSL'));
  $breadcrumb->add(NAVBAR_TITLE_2, tep_href_link(FILENAME_CHECKOUT_SHIPPING, '', 'SSL'));

  // {*1*}
  if (tep_count_shipping_modules() > 0) {
    if ($free_shipping == true) {
      $sprintf1 = sprintf(FREE_SHIPPING_DESCRIPTION, $currencies->format(MODULE_ORDER_TOTAL_SHIPPING_FREE_SHIPPING_OVER));
    } else {
      $quotes_array = array();
      for ($i=0, $n=sizeof($quotes); $i<$n; $i++) {
	if (isset($quotes[$i]['icon']) && tep_not_null($quotes[$i]['icon'])){
	}
        if (isset($quotes[$i]['error'])) {
        } else {
          for ($j=0, $n2=sizeof($quotes[$i]['methods']); $j<$n2; $j++) {
            if ( ($checked == true) || ($n == 1 && $n2 == 1) ) {
            } else {
            }
            if ( ($n > 1) || ($n2 > 1) ) {
	      $quotes_array[$i][$j]['format'] = $currencies->format(tep_add_tax($quotes[$i]['methods'][$j]['cost'], (isset($quotes[$i]['tax']) ? $quotes[$i]['tax'] : 0)));
	      $quotes_array[$i][$j]['tep_draw_radio_field'] = tep_draw_radio_field('shipping', $quotes[$i]['id'] . '_' . $quotes[$i]['methods'][$j]['id'], $checked); 
            } else {
	      $quotes_array[$i][$j]['format'] = $currencies->format(tep_add_tax($quotes[$i]['methods'][$j]['cost'], $quotes[$i]['tax']));
	      $quotes_array[$i][$j]['tep_draw_hidden_field'] = tep_draw_hidden_field('shipping', $quotes[$i]['id'] . '_' . $quotes[$i]['methods'][$j]['id']);

            }
          }
        }
      }
    }
  }

  $tep_draw_textarea_field1 = tep_draw_textarea_field('comments', 'soft', '60', '5');
  $tep_draw_form1 = tep_draw_form('checkout_address', tep_href_link(FILENAME_CHECKOUT_SHIPPING, '', 'SSL'));
  // old htmlpage was here
  $t->assign(array(
		   'checked' => $checked,
		   'free_shipping' => $free_shipping,
		   'quotes' => $quotes,
		   'quotes_array' => $quotes_array,
		   'request_type' => $request_type,
		   'sprintf1' => $sprintf1,
		   'tep_draw_form1' =>  $tep_draw_form1,
		   'tep_draw_textarea_field1' => $tep_draw_textarea_field1,

		   )); 
  tep_assign_template($t,'body_template', 'checkout_shipping.html');
  $t->display('layout.html');

}?>
