-- $ createdb -U skelton_user osc
-- $ psql -U skelton_user osc < osc.sql
--
-- sql file for "osc"

CREATE TABLE auth_user (
	username text not null,
	password text not null, -- to be stored md5 hashed password
	auth_level int not null default 0, -- level of access granted
	auth_perm text default null, --  ',' seperated 

	unique (username)

);

-- logging class for Dino_DB
CREATE TABLE __logging_sql (
	logging_time timestamp not null default current_timestamp,
	func_name text not null,
	query text not null,
	result_option text,
	called_file text
);
CREATE INDEX idx___logging_sql_logging_time
on __logging_sql (logging_time);


-- ڡ
CREATE TABLE page (
	"key" text, -- key
	parent_key text default '', -- ƥڡ
	ctime timestamp not null default current_timestamp, -- 
	mtime timestamp not null default current_timestamp, -- ǽ
	contents text, -- ƥ
	contents_type text not null default 'wiki', -- ƥĥ
	visible boolean not null default 'f', -- Ļ
	enable boolean not null default 't', -- Ѳǽ
	template text default 'default', -- ƥץ졼
	auth_level int not null default 0,
	primary key ("key")
);

-- insert into page("key",visible,template) values('default','t','default');


-- address_book
CREATE SEQUENCE address_book_id_seq;
CREATE TABLE address_book (
	customers_id integer, -- customers_id
	address_book_id integer not null default nextval('address_book_id_seq'::text), -- address_book_id
	entry_gender text not null, -- entry_gender
	entry_company text, -- entry_company
	entry_firstname text not null, -- entry_firstname
	entry_lastname text not null, -- entry_lastname
	entry_street_address text not null, -- entry_street_address
	entry_suburb text, -- entry_suburb
	entry_postcode text not null, -- entry_postcode
	entry_city text not null, -- entry_city
	entry_state text, -- entry_state
	entry_country_id integer not null default 0, -- entry_country_id
	entry_zone_id integer not null default 0, -- entry_zone_id
	entry_telephone text default '', -- entry_telephone
	deliverty_telephone text, -- deliverty_telephone


	primary key (customers_id, address_book_id)
);



-- address_format
CREATE SEQUENCE address_format_id_seq;
CREATE TABLE address_format (
	address_summary text not null, -- address_summary
	address_format text not null, -- address_format
	address_format_id integer not null default nextval('address_format_id_seq'::text), -- address_format_id


	primary key (address_format_id)
);



-- banners
CREATE SEQUENCE banners_id_seq;
CREATE TABLE banners (
	status integer not null default 0, -- status
	date_status_change timestamp, -- date_status_change
	date_added timestamp not null, -- date_added
	date_scheduled timestamp, -- date_scheduled
	expires_date timestamp, -- expires_date
	expires_impressions integer default 0, -- expires_impressions
	banners_html_text text, -- banners_html_text
	banners_group text not null, -- banners_group
	banners_image text not null, -- banners_image
	banners_url text not null, -- banners_url
	banners_title text not null, -- banners_title
	banners_id integer not null default nextval('banners_id_seq'::text), -- banners_id


	primary key (banners_id)
);



-- banners_history
CREATE SEQUENCE banners_history_id_seq;
CREATE TABLE banners_history (
	banners_history_date timestamp not null, -- banners_history_date
	banners_clicked integer not null default 0, -- banners_clicked
	banners_shown integer not null default 0, -- banners_shown
	banners_id integer not null, -- banners_id
	banners_history_id integer not null default nextval('banners_history_id_seq'::text), -- banners_history_id


	primary key (banners_history_id)
);



-- categories
CREATE SEQUENCE categories_id_seq;
CREATE TABLE categories (
	last_modified timestamp, -- last_modified
	date_added timestamp, -- date_added
	sort_order integer, -- sort_order
	parent_id integer not null default 0, -- parent_id
	categories_image text, -- categories_image
	categories_id integer not null default nextval('categories_id_seq'::text), -- categories_id


	primary key (categories_id)
);



-- categories_description

CREATE TABLE categories_description (
	categories_name text not null, -- categories_name
	language_id integer not null default 0, -- language_id
	categories_id integer not null default 0, -- categories_id


	primary key (language_id, categories_id)
);



-- configuration
CREATE SEQUENCE configuration_id_seq;
CREATE TABLE configuration (
	set_function text, -- set_function
	use_function text, -- use_function
	date_added timestamp not null, -- date_added
	last_modified timestamp, -- last_modified
	sort_order integer, -- sort_order
	configuration_group_id integer not null, -- configuration_group_id
	configuration_description text not null, -- configuration_description
	configuration_value text not null, -- configuration_value
	configuration_key text not null, -- configuration_key
	configuration_title text not null, -- configuration_title
	configuration_id integer not null default nextval('configuration_id_seq'::text), -- configuration_id


	primary key (configuration_id)
);



-- configuration_group
CREATE SEQUENCE configuration_group_id_seq;
CREATE TABLE configuration_group (
	visible integer default 0, -- visible
	sort_order integer, -- sort_order
	configuration_group_description text not null, -- configuration_group_description
	configuration_group_title text not null, -- configuration_group_title
	configuration_group_id integer not null default nextval('configuration_group_id_seq'::text), -- configuration_group_id


	primary key (configuration_group_id)
);



-- counter

CREATE TABLE counter (
	counter integer, -- counter
	startdate text, -- startdate


	primary key (counter)
);



-- counter_history

CREATE TABLE counter_history (
	counter integer, -- counter
	month text, -- month


	primary key (counter)
);



-- countries
CREATE SEQUENCE countries_id_seq;
CREATE TABLE countries (
	address_format_id integer not null, -- address_format_id
	countries_iso_code_3 text not null, -- countries_iso_code_3
	countries_iso_code_2 text not null, -- countries_iso_code_2
	countries_name text not null, -- countries_name
	countries_id integer not null default nextval('countries_id_seq'::text), -- countries_id


	primary key (countries_id)
);



-- currencies
CREATE SEQUENCE currencies_id_seq;
CREATE TABLE currencies (
	last_updated timestamp, -- last_updated
	value text, -- value
	decimal_places text, -- decimal_places
	thousands_point text, -- thousands_point
	decimal_point text, -- decimal_point
	symbol_right text, -- symbol_right
	symbol_left text, -- symbol_left
	code text not null, -- code
	title text not null, -- title
	currencies_id integer not null default nextval('currencies_id_seq'::text), -- currencies_id


	primary key (currencies_id)
);



-- customers
CREATE SEQUENCE customers_id_seq;
CREATE TABLE customers (
	customers_newsletter text, -- customers_newsletter
	customers_password text not null, -- customers_password
	customers_fax text, -- customers_fax
	customers_telephone text not null, -- customers_telephone
	customers_default_address_id integer, -- customers_default_address_id
	customers_email_address text not null, -- customers_email_address
	customers_dob timestamp not null, -- customers_dob
	customers_lastname text not null, -- customers_lastname
	customers_firstname text not null, -- customers_firstname
	customers_gender text not null, -- customers_gender
	customers_id integer not null default nextval('customers_id_seq'::text), -- customers_id


	primary key (customers_id)
);



-- customers_basket
CREATE SEQUENCE customers_basket_id_seq;
CREATE TABLE customers_basket (
	customers_basket_date_added text, -- customers_basket_date_added
	final_price decimal(10,2), -- final_price
	customers_basket_quantity integer not null, -- customers_basket_quantity
	products_id text not null, -- products_id
	customers_id integer not null, -- customers_id
	customers_basket_id integer not null default nextval('customers_basket_id_seq'::text), -- customers_basket_id


	primary key (customers_basket_id)
);



-- customers_basket_attributes
CREATE SEQUENCE customers_basket_attr_id_seq;
CREATE TABLE customers_basket_attributes (
	products_options_value_id integer not null, -- products_options_value_id
	products_options_id integer not null, -- products_options_id
	products_id text not null, -- products_id
	customers_id integer not null, -- customers_id
	customers_basket_attributes_id integer not null default nextval('customers_basket_attr_id_seq'::text), -- customers_basket_attributes_id


	primary key (customers_basket_attributes_id)
);



-- customers_info

CREATE TABLE customers_info (
	global_product_notifications integer default 0, -- global_product_notifications
	customers_info_date_account_last_modified timestamp, -- customers_info_date_account_last_modified
	customers_info_date_account_created timestamp, -- customers_info_date_account_created
	customers_info_number_of_logons integer, -- customers_info_number_of_logons
	customers_info_date_of_last_logon timestamp, -- customers_info_date_of_last_logon
	customers_info_id integer, -- customers_info_id


	primary key (customers_info_id)
);



-- languages
CREATE SEQUENCE languages_id_seq;
CREATE TABLE languages (
	sort_order integer, -- sort_order
	directory text, -- directory
	image text, -- image
	code text not null, -- code
	name text not null, -- name
	languages_id integer not null default nextval('languages_id_seq'::text), -- languages_id


	primary key (languages_id)
);



-- manufacturers
CREATE SEQUENCE manufacturers_id_seq;
CREATE TABLE manufacturers (
	last_modified timestamp, -- last_modified
	date_added timestamp, -- date_added
	manufacturers_image text, -- manufacturers_image
	manufacturers_name text not null, -- manufacturers_name
	manufacturers_id integer not null default nextval('manufacturers_id_seq'::text), -- manufacturers_id


	primary key (manufacturers_id)
);



-- manufacturers_info

CREATE TABLE manufacturers_info (
	languages_id integer, -- languages_id
	date_last_click timestamp, -- date_last_click
	url_clicked integer not null default 0, -- url_clicked
	manufacturers_url text not null, -- manufacturers_url
	manufacturers_id integer, -- manufacturers_id


	primary key (languages_id, manufacturers_id)
);



-- newsletters
CREATE SEQUENCE newsletters_id_seq;
CREATE TABLE newsletters (
	locked integer default 0, -- locked
	status integer, -- status
	date_sent timestamp, -- date_sent
	date_added timestamp not null, -- date_added
	module text not null, -- module
	content text not null, -- content
	title text not null, -- title
	newsletters_id integer not null default nextval('newsletters_id_seq'::text), -- newsletters_id


	primary key (newsletters_id)
);



-- orders
CREATE SEQUENCE orders_id_seq;
CREATE TABLE orders (
	orders_id integer not null default nextval('orders_id_seq'::text), -- orders_id
	customers_id integer not null, -- customers_id
	customers_name text not null, -- customers_name
	customers_company text, -- customers_company
	customers_street_address text not null, -- customers_street_address
	customers_suburb text, -- customers_suburb
	customers_city text not null, -- customers_city
	customers_postcode text not null, -- customers_postcode
	customers_state text, -- customers_state
	customers_country text not null, -- customers_country
	customers_telephone text not null, -- customers_telephone
	customers_email_address text not null, -- customers_email_address
	customers_address_format_id integer not null, -- customers_address_format_id
	delivery_name text, -- delivery_name
	delivery_company text, -- delivery_company
	delivery_street_address text, -- delivery_street_address
	delivery_suburb text, -- delivery_suburb
	delivery_city text, -- delivery_city
	delivery_postcode text, -- delivery_postcode
	delivery_state text, -- delivery_state
	delivery_country text, -- delivery_country
	delivery_address_format_id integer, -- delivery_address_format_id
	billing_name text not null, -- billing_name
	billing_company text, -- billing_company
	billing_street_address text not null, -- billing_street_address
	billing_suburb text, -- billing_suburb
	billing_city text not null, -- billing_city
	billing_postcode text not null, -- billing_postcode
	billing_state text, -- billing_state
	billing_country text not null, -- billing_country
	billing_address_format_id integer not null, -- billing_address_format_id
	payment_method text not null, -- payment_method
	cc_type text, -- cc_type
	cc_owner text, -- cc_owner
	cc_number text, -- cc_number
	cc_expires text, -- cc_expires
	last_modified timestamp, -- last_modified
	date_purchased timestamp, -- date_purchased
	orders_status integer not null, -- orders_status
	orders_date_finished timestamp, -- orders_date_finished
	currency text, -- currency
	currency_value decimal(10,2), -- currency_value
	entry_telephone text, -- entry_telephone
	deliverty_telephone text, -- deliverty_telephone
	delivery_telephone text, -- delivery_telephone
	billing_telephone text, -- billing_telephone


	primary key (orders_id)
);



-- orders_products
CREATE SEQUENCE orders_products_id_seq;
CREATE TABLE orders_products (
	orders_products_id integer not null default nextval('orders_products_id_seq'::text), -- orders_products_id
	orders_id integer not null, -- orders_id
	products_id integer not null, -- products_id
	products_model text, -- products_model
	products_name text not null, -- products_name
	products_price decimal(10,2) not null, -- products_price
	final_price decimal(10,2) not null, -- final_price
	products_tax decimal(9,4) not null, -- products_tax
	products_quantity integer not null, -- products_quantity


	primary key (orders_products_id)
);



-- orders_status

CREATE TABLE orders_status (
	orders_status_id integer not null default 0, -- orders_status_id
	language_id integer not null default 0, -- language_id
	orders_status_name text not null, -- orders_status_name


	primary key (orders_status_id, language_id)
);



-- orders_status_history
CREATE SEQUENCE orders_status_history_id_seq;
CREATE TABLE orders_status_history (
	orders_status_history_id integer not null default nextval('orders_status_history_id_seq'::text), -- orders_status_history_id
	orders_id integer not null, -- orders_id
	orders_status_id integer not null, -- orders_status_id
	date_added timestamp not null, -- date_added
	customer_notified integer default 0, -- customer_notified
	comments text, -- comments


	primary key (orders_status_history_id)
);



-- orders_products_attributes
CREATE SEQUENCE orders_products_attr_id_seq;
CREATE TABLE orders_products_attributes (
	orders_products_attributes_id integer not null default nextval('orders_products_attr_id_seq'::text), -- orders_products_attributes_id
	orders_id integer not null, -- orders_id
	orders_products_id integer not null, -- orders_products_id
	products_options text not null, -- products_options
	products_options_values text not null, -- products_options_values
	options_values_price decimal(10,2) not null, -- options_values_price
	price_prefix text not null, -- price_prefix


	primary key (orders_products_attributes_id)
);



-- orders_products_download
CREATE SEQUENCE orders_products_dl_id_seq;
CREATE TABLE orders_products_download (
	orders_products_download_id integer not null default nextval('orders_products_dl_id_seq'::text), -- orders_products_download_id
	orders_id integer not null default 0, -- orders_id
	orders_products_id integer not null default 0, -- orders_products_id
	orders_products_filename text not null default '', -- orders_products_filename
	download_maxdays integer not null default 0, -- download_maxdays
	download_count integer not null default 0, -- download_count


	primary key (orders_products_download_id)
);



-- orders_total
CREATE SEQUENCE orders_total_id_seq;
CREATE TABLE orders_total (
	sort_order integer not null, -- sort_order
	class text not null, -- class
	value text not null, -- value
	text text not null, -- text
	title text not null, -- title
	orders_id integer not null, -- orders_id
	orders_total_id integer not null default nextval('orders_total_id_seq'::text), -- orders_total_id


	primary key (orders_total_id)
);



-- products
CREATE SEQUENCE products_id_seq;
CREATE TABLE products (
	products_ordered integer not null default 0, -- products_ordered
	manufacturers_id integer, -- manufacturers_id
	products_tax_class_id integer not null, -- products_tax_class_id
	products_status integer not null, -- products_status
	products_weight decimal(7,2) not null, -- products_weight
	products_date_available timestamp, -- products_date_available
	products_last_modified timestamp, -- products_last_modified
	products_date_added timestamp not null, -- products_date_added
	products_price decimal(10,2) not null, -- products_price
	products_image text, -- products_image
	products_model text, -- products_model
	products_quantity integer not null, -- products_quantity
	products_id integer not null default nextval('products_id_seq'::text), -- products_id


	primary key (products_id)
);



-- products_attributes
CREATE SEQUENCE products_attr_id_seq;
CREATE TABLE products_attributes (
	price_prefix text not null, -- price_prefix
	options_values_price text not null, -- options_values_price
	options_values_id integer not null, -- options_values_id
	options_id integer not null, -- options_id
	products_id integer not null, -- products_id
	products_attributes_id integer not null default nextval('products_attr_id_seq'::text), -- products_attributes_id


	primary key (products_attributes_id)
);



-- products_attributes_download

CREATE TABLE products_attributes_download (
	products_attributes_maxcount integer default 0, -- products_attributes_maxcount
	products_attributes_maxdays integer default 0, -- products_attributes_maxdays
	products_attributes_filename text not null default '', -- products_attributes_filename
	products_attributes_id integer, -- products_attributes_id


	primary key (products_attributes_id)
);



-- products_description
CREATE SEQUENCE products_description_id_seq;
CREATE TABLE products_description (
	products_viewed integer default 0, -- products_viewed
	products_url text, -- products_url
	products_description text, -- products_description
	products_name text not null default '', -- products_name
	language_id integer not null default 0, -- language_id
	products_id integer not null default nextval('products_description_id_seq'::text), -- products_id


	primary key (language_id, products_id)
);



-- products_notifications

CREATE TABLE products_notifications (
	date_added timestamp not null, -- date_added
	customers_id integer not null, -- customers_id
	products_id integer -- products_id

);



-- products_options

CREATE TABLE products_options (
	products_options_name text not null default '', -- products_options_name
	language_id integer not null default 0, -- language_id
	products_options_id integer not null default 0, -- products_options_id


	primary key (language_id, products_options_id)
);



-- products_options_values

CREATE TABLE products_options_values (
	products_options_values_name text not null default '', -- products_options_values_name
	language_id integer not null default 0, -- language_id
	products_options_values_id integer not null default 0, -- products_options_values_id


	primary key (language_id, products_options_values_id)
);



-- products_options_values_to_products_options
CREATE SEQUENCE products_opt_values_to_id_seq;
CREATE TABLE products_options_values_to_products_options (
	products_options_values_id integer not null, -- products_options_values_id
	products_options_id integer not null, -- products_options_id
	products_options_values_to_products_options_id integer not null default nextval('products_opt_values_to_id_seq'::text), -- products_options_values_to_products_options_id


	primary key (products_options_values_to_products_options_id)
);



-- products_to_categories

CREATE TABLE products_to_categories (
	categories_id integer, -- categories_id
	products_id integer, -- products_id


	primary key (categories_id, products_id)
);



-- reviews
CREATE SEQUENCE reviews_id_seq;
CREATE TABLE reviews (
	reviews_read integer not null default 0, -- reviews_read
	last_modified timestamp, -- last_modified
	date_added timestamp, -- date_added
	reviews_rating integer, -- reviews_rating
	customers_name text not null, -- customers_name
	customers_id integer, -- customers_id
	products_id integer not null, -- products_id
	reviews_id integer not null default nextval('reviews_id_seq'::text), -- reviews_id


	primary key (reviews_id)
);



-- reviews_description

CREATE TABLE reviews_description (
	reviews_text text not null, -- reviews_text
	languages_id integer, -- languages_id
	reviews_id integer, -- reviews_id


	primary key (languages_id, reviews_id)
);



-- sessions

CREATE TABLE sessions (
	value text not null, -- value
	expiry integer not null, -- expiry
	sesskey text, -- sesskey


	primary key (sesskey)
);



-- specials
CREATE SEQUENCE specials_id_seq;
CREATE TABLE specials (
	status boolean not null default 'f', -- status
	date_status_change timestamp, -- date_status_change
	expires_date timestamp, -- expires_date
	specials_last_modified timestamp, -- specials_last_modified
	specials_date_added timestamp, -- specials_date_added
	specials_new_products_price integer not null, -- specials_new_products_price
	products_id integer not null, -- products_id
	specials_id integer not null default nextval('specials_id_seq'::text), -- specials_id


	primary key (specials_id)
);



-- tax_class
CREATE SEQUENCE tax_class_id_seq;
CREATE TABLE tax_class (
	date_added timestamp not null, -- date_added
	last_modified timestamp, -- last_modified
	tax_class_description text not null, -- tax_class_description
	tax_class_title text not null, -- tax_class_title
	tax_class_id integer not null default nextval('tax_class_id_seq'::text), -- tax_class_id


	primary key (tax_class_id)
);



-- tax_rates
CREATE SEQUENCE tax_rates_id_seq;
CREATE TABLE tax_rates (
	date_added timestamp not null, -- date_added
	last_modified timestamp, -- last_modified
	tax_description text not null, -- tax_description
	tax_rate decimal(9,4) not null, -- tax_rate
	tax_priority integer default 0, -- tax_priority
	tax_class_id integer not null, -- tax_class_id
	tax_zone_id integer not null, -- tax_zone_id
	tax_rates_id integer not null default nextval('tax_rates_id_seq'::text), -- tax_rates_id


	primary key (tax_rates_id)
);



-- geo_zones
CREATE SEQUENCE geo_zone_id_seq;
CREATE TABLE geo_zones (
	date_added timestamp not null, -- date_added
	last_modified timestamp, -- last_modified
	geo_zone_description text not null, -- geo_zone_description
	geo_zone_name text not null, -- geo_zone_name
	geo_zone_id integer not null default nextval('geo_zone_id_seq'::text), -- geo_zone_id


	primary key (geo_zone_id)
);



-- whos_online
CREATE TABLE whos_online (
	customer_id integer, -- customer_id
	full_name text not null, -- full_name
	session_id text not null, -- session_id
	ip_address text not null, -- ip_address
	time_entry text not null, -- time_entry
	time_last_click text not null, -- time_last_click
	last_page_url text not null -- last_page_url

);



-- zones
CREATE SEQUENCE zone_id_seq;
CREATE TABLE zones (
	zone_name text not null, -- zone_name
	zone_code text not null, -- zone_code
	zone_country_id integer not null, -- zone_country_id
	zone_id integer not null default nextval('zone_id_seq'::text), -- zone_id


	primary key (zone_id)
);



-- zones_to_geo_zones
CREATE SEQUENCE association_id_seq;
CREATE TABLE zones_to_geo_zones (
	date_added timestamp not null, -- date_added
	last_modified timestamp, -- last_modified
	geo_zone_id integer, -- geo_zone_id
	zone_id integer, -- zone_id
	zone_country_id integer not null, -- zone_country_id
	association_id integer not null default nextval('association_id_seq'::text), -- association_id


	primary key (association_id)
);



-- users

CREATE TABLE users (
	userid text not null, -- userid
	password text not null, -- password
	name text, -- name
	email text, -- email


	primary key (userid)
);



-- permissions

CREATE TABLE permissions (
	userid text not null, -- userid
	permission integer default 0, -- permission


	primary key (userid)
);



-- login
CREATE TABLE login (
	sessionid text not null, -- sessionid
	logintime timestamp not null, -- logintime
	lastaccesstime timestamp not null, -- lastaccesstime
	account text default '', -- account
	loginstatus text, -- loginstatus
	logoutstatus text, -- logoutstatus
	address integer -- address

);


