/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.client;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.EventHandler;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TooManyListenersException;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.prefs.Preferences;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import open.dolphin.client.BlockGlass;
import open.dolphin.client.ChartDocumentMap;
import open.dolphin.client.ChartMediator;
import open.dolphin.client.DirectionDialog;
import open.dolphin.client.DocumentBridgeImpl;
import open.dolphin.client.EditorFrame;
import open.dolphin.client.IChart;
import open.dolphin.client.IChartDocument;
import open.dolphin.client.IKarteViewer;
import open.dolphin.client.IMainWindow;
import open.dolphin.client.KarteDocumentViewer;
import open.dolphin.client.KarteEditor;
import open.dolphin.client.LetterImpl;
import open.dolphin.client.LetterReplyImpl;
import open.dolphin.client.LetterView;
import open.dolphin.client.NewKarteDialog;
import open.dolphin.client.NewKarteParams;
import open.dolphin.client.StatusPanel;
import open.dolphin.client.WindowsMenuAdapter;
import open.dolphin.client.caremapdocument.CareMapDocumentPanel;
import open.dolphin.client.diagnosisdocumentpanel.DiagnosisDocumentPanel;
import open.dolphin.client.imagebrowserdocument.ImageBrowserDocumentPanel;
import open.dolphin.client.karte.DocumentHistoryPanel;
import open.dolphin.client.karte.PatientInspector;
import open.dolphin.client.karte.template.Template;
import open.dolphin.client.karte.template.error.CantReadTemplateException;
import open.dolphin.component.DnDTabbedPane;
import open.dolphin.component.TabTransferHandler;
import open.dolphin.container.Pair;
import open.dolphin.delegater.remote.RemoteDocumentDelegater;
import open.dolphin.helper.IChartCommandAccepter;
import open.dolphin.helper.IMainCommandAccepter;
import open.dolphin.helper.PlugInMenuSupport;
import open.dolphin.helper.StripeRenderer;
import open.dolphin.helper.WindowSupport;
import open.dolphin.infomodel.ClaimBundle;
import open.dolphin.infomodel.DocInfoModel;
import open.dolphin.infomodel.DocumentModel;
import open.dolphin.infomodel.GenericAdapter;
import open.dolphin.infomodel.IInfoModel;
import open.dolphin.infomodel.KarteBean;
import open.dolphin.infomodel.ModuleModel;
import open.dolphin.infomodel.PVTHealthInsuranceModel;
import open.dolphin.infomodel.PatientModel;
import open.dolphin.infomodel.PatientVisitModel;
import open.dolphin.infomodel.SimpleDate;
import open.dolphin.infomodel.VersionModel;
import open.dolphin.log.LogWriter;
import open.dolphin.plugin.IPlugin;
import open.dolphin.plugin.PluginWrapper;
import open.dolphin.project.GlobalConstants;
import open.dolphin.project.GlobalVariables;
import open.dolphin.sendclaim.SendClaimImpl;
import open.dolphin.sendmml.SendMmlImpl;
import open.dolphin.utils.CombinedStringParser;
import open.dolphin.utils.GUIDGenerator;
import open.socket.data.Command;
import open.socket.data.RequestObject;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationContext;
import org.jdesktop.application.ResourceMap;

public class ChartWindow
extends JFrame
implements IChart,
IInfoModel,
IChartCommandAccepter {
    private static final long DELAY = 10L;
    public static final String CHART_STATE = "chartStateProp";
    public static final int CANCEL_PVT = -1;
    private List<DnDTabbedPane> tabbedPanels;
    private static PropertyChangeSupport boundSupport = new PropertyChangeSupport(new Object());
    private PatientInspector inspector;
    private WindowSupport windowSupport;
    private JPanel toolPanel;
    private PatientVisitModel pvt;
    private boolean readOnly;
    private IChart.state chartState;
    private ChartMediator mediator;
    private StateManager status;
    private SendMmlImpl mmlListener;
    private SendClaimImpl claimListener;
    private KarteBean karte;
    private BlockGlass blockGlass;
    private ResourceMap resMap;
    private ScheduledExecutorService scheduler;
    private ScheduledFuture<?> beeperHandle;
    private long statred;
    private long delay = 10L;
    private String name;
    private IMainWindow context;
    private String FKeyword;
    private KarteEditor editor;
    private EditorFrame editorFrame;
    private ChartDocumentMap chartDocuments;
    private boolean isActivated;
    private JPanel karteAndInspectorPanel;
    private JPanel leftPanel;
    private JPanel mainPanel;
    private DnDTabbedPane profilerTabedPane;
    private JPanel rightPanel;
    private JSplitPane splitPane;
    private JSplitPane splitPane1;
    private StatusPanel statusPanel;
    private DnDTabbedPane tabbedPane;

    @Override
    public boolean isActivated() {
        return this.isActivated;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public IMainWindow getContext() {
        return this.context;
    }

    @Override
    public void setContext(IMainWindow context) {
        this.context = context;
    }

    @Override
    public void enter() {
    }

    @Override
    public Callable<Boolean> getStartingTask() {
        return null;
    }

    @Override
    public Callable<Boolean> getStoppingTask() {
        return null;
    }

    @Override
    public IChartDocument getChartDocument(String name) {
        return (IChartDocument)this.chartDocuments.get(name);
    }

    @Override
    public void setChartDocument(String name, IChartDocument document) {
        this.chartDocuments.put(name, document);
    }

    protected ChartWindow(IMainWindow context, PatientVisitModel pvt, boolean isReadOnry) {
        this.initComponents();
        this.context = context;
        this.pvt = pvt;
        this.readOnly = isReadOnry;
        this.chartDocuments = new ChartDocumentMap();
        this.tabbedPane.setTransferHandler(new TabTransferHandler());
        this.profilerTabedPane.setTransferHandler(new TabTransferHandler());
        this.tabbedPanels = new ArrayList<DnDTabbedPane>();
        this.tabbedPanels.add(this.tabbedPane);
        this.tabbedPanels.add(this.profilerTabedPane);
    }

    public void release() {
        try {
            this.inspector.release();
            this.saveLayout("tabLocation", this.getTabLocations());
            this.saveLayout("dividerLocation", this.getDividerLocation());
        }
        catch (IOException ex) {
            LogWriter.error(this.getClass(), ex);
        }
    }

    private void closePatient() {
        if (!this.readOnly) {
            for (IPlugin plugin : this.context.getPlugin().values()) {
                PluginWrapper pluginWrapper = new PluginWrapper(plugin);
                RequestObject request = new RequestObject();
                request.setPlace("");
                request.setPatientId(this.pvt.getPatient().getId());
                request.setCommand(Command.KARTE_CLOSE);
                Object result = pluginWrapper.message(request);
                if (result == null || !pluginWrapper.IsDispatched()) continue;
                pluginWrapper.update(result);
                break;
            }
        }
    }

    private void initComponents() {
        this.splitPane1 = new JSplitPane();
        this.rightPanel = new JPanel();
        this.leftPanel = new JPanel();
        this.mainPanel = new JPanel();
        this.karteAndInspectorPanel = new JPanel();
        this.splitPane = new JSplitPane();
        this.tabbedPane = new DnDTabbedPane();
        this.profilerTabedPane = new DnDTabbedPane();
        this.statusPanel = new StatusPanel();
        this.splitPane1.setDividerLocation(100);
        this.splitPane1.setDividerSize(30);
        this.splitPane1.setContinuousLayout(true);
        this.splitPane1.setName("splitPane1");
        this.splitPane1.setOneTouchExpandable(true);
        this.rightPanel.setBorder(BorderFactory.createEtchedBorder());
        this.rightPanel.setName("rightPanel");
        this.rightPanel.setLayout(new BorderLayout());
        this.splitPane1.setRightComponent(this.rightPanel);
        this.leftPanel.setBorder(BorderFactory.createEtchedBorder());
        this.leftPanel.setName("leftPanel");
        this.leftPanel.setLayout(new BorderLayout());
        this.splitPane1.setLeftComponent(this.leftPanel);
        this.setDefaultCloseOperation(3);
        this.setName("chartFrame");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowActivated(WindowEvent evt) {
                ChartWindow.this.formWindowActivated(evt);
            }

            @Override
            public void windowDeactivated(WindowEvent evt) {
                ChartWindow.this.formWindowDeactivated(evt);
            }
        });
        this.mainPanel.setName("mainPanel");
        this.mainPanel.setLayout(new BorderLayout(0, 7));
        this.karteAndInspectorPanel.setName("karteAndInspectorPanel");
        this.karteAndInspectorPanel.setLayout(new BorderLayout());
        this.splitPane.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.splitPane.setDividerLocation(100);
        this.splitPane.setDividerSize(10);
        this.splitPane.setContinuousLayout(true);
        this.splitPane.setName("splitPane");
        this.splitPane.setOneTouchExpandable(true);
        this.tabbedPane.setName("tabbedPane");
        this.tabbedPane.setOpaque(true);
        this.splitPane.setRightComponent(this.tabbedPane);
        this.profilerTabedPane.setName("profilerTabedPane");
        this.profilerTabedPane.setOpaque(true);
        this.splitPane.setLeftComponent(this.profilerTabedPane);
        this.karteAndInspectorPanel.add((Component)this.splitPane, "Center");
        this.mainPanel.add((Component)this.karteAndInspectorPanel, "Center");
        this.statusPanel.setName("statusPanel");
        this.mainPanel.add((Component)this.statusPanel, "South");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.mainPanel, -1, 454, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap(64, Short.MAX_VALUE).addComponent(this.mainPanel, -2, 260, -2)));
        this.pack();
    }

    private void formWindowActivated(WindowEvent evt) {
        if (evt.getOppositeWindow() != null) {
            this.isActivated = true;
        }
    }

    private void formWindowDeactivated(WindowEvent evt) {
        if (evt.getOppositeWindow() != null) {
            this.isActivated = false;
        }
    }

    private Serializable initialTabLocations() {
        Properties result = new Properties();
        result.setProperty("\u53c2 \u7167", "0.0");
        result.setProperty("\u50b7\u75c5\u540d", "0.1");
        result.setProperty("\u6cbb\u7642\u5c65\u6b74", "0.2");
        String[] location = new String[]{"0.3", "0.4"};
        int index = 0;
        for (IPlugin plugin : this.context.getPlugin().values()) {
            PluginWrapper pluginWrapper = new PluginWrapper(plugin);
            if (pluginWrapper.getType() != IPlugin.Type.container) continue;
            result.setProperty(pluginWrapper.getName(), location[index]);
            ++index;
        }
        result.setProperty("\u30a4\u30e1\u30fc\u30b8", "0.5");
        result.setProperty("\u30a4\u30f3\u30b9\u30da\u30af\u30bf", "1.0");
        return result;
    }

    private Serializable initialBounds() {
        return new Rectangle(5, 20, 990, 740);
    }

    private Serializable initialDividerLocation() {
        Properties result = new Properties();
        result.setProperty("DividerLocation", "240");
        return result;
    }

    private Serializable loadLayout(String type, Serializable defaultValue) throws IOException {
        Serializable result = null;
        ApplicationContext appCtx = GlobalConstants.getApplicationContext();
        result = (Serializable)appCtx.getLocalStorage().load(this.getClass().getName() + "." + type + ".xml");
        if (result == null) {
            result = defaultValue;
        }
        return result;
    }

    private void saveLayout(String type, Serializable layout) throws IOException {
        GlobalConstants.getLocalStorage().save((Object)layout, this.getClass().getName() + "." + type + ".xml");
    }

    private Properties getTabLocations() {
        Properties result = new Properties();
        int panel_index = 0;
        for (DnDTabbedPane pane : this.tabbedPanels) {
            int components = 0;
            for (int index = 0; index < pane.getComponentCount(); ++index) {
                try {
                    if (!((IChartDocument)((Object)pane.getComponentAt(index))).itLayoutSaved()) continue;
                    CombinedStringParser parser = new CombinedStringParser();
                    parser.add(Integer.toString(panel_index));
                    parser.add(Integer.toString(components));
                    result.setProperty(pane.getTitleAt(index), parser.toCombinedString());
                    ++components;
                    continue;
                }
                catch (Exception e) {
                    LogWriter.error(this.getClass(), e);
                }
            }
            ++panel_index;
        }
        return result;
    }

    private Properties getDividerLocation() {
        Properties result = new Properties();
        result.setProperty("DividerLocation", Integer.toString(this.splitPane.getDividerLocation()));
        return result;
    }

    private void applyTabLocations(Properties layout) {
        ArrayList sorters = new ArrayList();
        sorters.add(new HashMap());
        sorters.add(new HashMap());
        Enumeration<?> e = layout.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            CombinedStringParser combinedStringParser = new CombinedStringParser(layout.getProperty(key));
            int value = Integer.parseInt(combinedStringParser.get(0));
            ((Map)sorters.get(value)).put(Integer.parseInt(combinedStringParser.get(1)), key);
        }
        int sorter_index = 0;
        for (Map map : sorters) {
            for (int index = 0; index < map.size(); ++index) {
                String key = (String)map.get(index);
                this.tabbedPanels.get(sorter_index).addTab(key, (Component)this.chartDocuments.get(key));
            }
            ++sorter_index;
        }
    }

    private void applyDividerLocation(Properties layout) {
        this.splitPane.setDividerLocation(Integer.parseInt(layout.getProperty("DividerLocation")));
    }

    @Override
    public void setKeyword(String keyword) {
        this.FKeyword = keyword;
    }

    @Override
    public KarteBean getKarte() {
        return this.karte;
    }

    @Override
    public void setKarte(KarteBean karte) {
        this.karte = karte;
    }

    @Override
    public JFrame getFrame() {
        return this.windowSupport.getFrame();
    }

    @Override
    public StatusPanel getStatusPanel() {
        return this.statusPanel;
    }

    @Override
    public void setStatusPanel(StatusPanel statusPanel) {
        this.statusPanel = statusPanel;
    }

    @Override
    public void setPatientVisit(PatientVisitModel pvt) {
        this.pvt = pvt;
    }

    @Override
    public PatientVisitModel getPatientVisit() {
        return this.pvt;
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    @Override
    public PatientModel getPatient() {
        return this.getKarte().getPatient();
    }

    public void setPatientModel(PatientModel patientModel) {
        this.getKarte().setPatient(patientModel);
    }

    @Override
    public IChart.state getChartState() {
        return this.chartState;
    }

    @Override
    public void setChartState(IChart.state chartState) {
        this.chartState = chartState;
        ChartWindow.fireChanged(this);
    }

    @Override
    public ChartMediator getChartMediator() {
        return this.mediator;
    }

    public void setChartMediator(ChartMediator mediator) {
        this.mediator = mediator;
    }

    @Override
    public void enabledAction(String name, boolean enabled) {
        this.mediator.enabledAction(name, enabled);
    }

    @Override
    public DocumentHistoryPanel getDocumentHistory() {
        return (DocumentHistoryPanel)this.chartDocuments.get("\u6587\u66f8\u5c65\u6b74");
    }

    @Override
    public void showDocument(String tabName) {
        for (int chart_index = 0; chart_index < this.tabbedPane.getTabCount(); ++chart_index) {
            List<JTabbedPane> panels;
            if (this.tabbedPane.getTitleAt(chart_index).equals(tabName)) {
                this.tabbedPane.setSelectedIndex(chart_index);
            }
            if (this.tabbedPane.getTabComponentAt(chart_index) == null || (panels = ((IChartDocument)((Object)this.tabbedPane.getTabComponentAt(chart_index))).getTabbedPanels()) == null) continue;
            for (JTabbedPane pane : panels) {
                for (int patient_index = 0; patient_index < pane.getTabCount(); ++patient_index) {
                    if (!pane.getTitleAt(chart_index).equals(tabName)) continue;
                    pane.setSelectedIndex(chart_index);
                    this.tabbedPane.setSelectedIndex(chart_index);
                }
            }
        }
    }

    public void showDocument(Component target) {
        for (Component component : this.tabbedPane.getComponents()) {
            if (!component.equals(target)) continue;
            this.tabbedPane.setSelectedComponent(target);
            return;
        }
        for (Component component : this.profilerTabedPane.getComponents()) {
            if (!component.equals(target)) continue;
            this.profilerTabedPane.setSelectedComponent(target);
            return;
        }
    }

    public boolean existLetterPane() {
        return this.chartDocuments.isExist(IChartDocument.TYPE.LetterImpl);
    }

    public LetterView getLetterPane() {
        return ((LetterImpl)this.chartDocuments.getAsType(IChartDocument.TYPE.LetterImpl)).getView();
    }

    public boolean existEditorPane(final int mode) {
        boolean result = false;
        try {
            return this.chartDocuments.enumerate(new GenericAdapter<IChartDocument, Object>(){

                @Override
                public boolean onResult(IChartDocument document, Object result) {
                    return document instanceof KarteEditor && ((KarteEditor)document).getMode() == mode;
                }

                @Override
                public void onError(Exception ex) {
                }
            });
        }
        catch (Exception ex) {
            LogWriter.error(this.getClass(), ex);
            return result;
        }
    }

    public boolean existEditorPane() {
        return this.chartDocuments.isExist(IChartDocument.TYPE.KarteEditor);
    }

    public KarteEditor getEditorPane() {
        return (KarteEditor)this.chartDocuments.getAsType(IChartDocument.TYPE.KarteEditor);
    }

    @Override
    public boolean isDirty() {
        return this.chartDocuments.isDirty();
    }

    @Override
    public void start() {
        this.resMap = GlobalConstants.getResourceMap(ChartWindow.class);
        ApplicationContext applicationContext = GlobalConstants.getApplicationContext();
        Application app = applicationContext.getApplication();
        int past = GlobalVariables.getKarteExtractionPeriod();
        GregorianCalendar today = new GregorianCalendar();
        today.add(2, past);
        today.clear(11);
        today.clear(12);
        today.clear(13);
        today.clear(14);
        RemoteDocumentDelegater ddl = new RemoteDocumentDelegater();
        KarteBean karteBean = ddl.getKarte(this.getPatientVisit().getPatient().getId(), today.getTime());
        try {
            karteBean.setPatient(this.getPatientVisit().getPatient());
            this.setKarte(karteBean);
            this.initCustomComponents();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ChartWindow.this.getDocumentHistory().getDocumentHistory();
                }
            });
        }
        catch (IOException ex) {
            LogWriter.error(this.getClass(), ex);
        }
    }

    private String getWindowTitle() {
        String Inspector = this.resMap.getString("inspector", new Object[0]);
        StringBuilder sb = new StringBuilder();
        sb.append(this.getPatient().getFullName());
        sb.append("(");
        String kana = this.getPatient().getKanaName();
        kana = kana.replace("\u3000", " ");
        sb.append(kana).append(")").append(" : ").append(this.getPatient().getPatientId());
        sb.append(Inspector).append(" | ").append(GlobalVariables.getUserId()).append(" | ");
        sb.append(GlobalVariables.getUserModel().getLicenseModel().getLicenseDesc());
        return sb.toString();
    }

    private void RestoreLayouts() throws IOException {
        this.applyTabLocations((Properties)this.loadLayout("tabLocation", this.initialTabLocations()));
        this.setBounds((Rectangle)this.loadLayout("layout", this.initialBounds()));
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    ChartWindow.this.applyDividerLocation((Properties)ChartWindow.this.loadLayout("dividerLocation", ChartWindow.this.initialDividerLocation()));
                }
                catch (IOException ex) {
                    LogWriter.error(this.getClass(), ex);
                }
            }
        });
    }

    private JToolBar decorateToolBar(JToolBar decorationed) {
        Action action = this.mediator.getActions().get("insertText");
        JButton textBtn = new JButton();
        textBtn.setName("textBtn");
        textBtn.setAction(action);
        textBtn.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                Object source = e.getSource();
                if (source instanceof JButton && ((JButton)source).isEnabled()) {
                    JPopupMenu popup = new JPopupMenu();
                    ChartWindow.this.mediator.addTextMenu(popup);
                    if (!e.isPopupTrigger()) {
                        popup.show(e.getComponent(), e.getX(), e.getY());
                    }
                }
            }
        });
        decorationed.add(textBtn);
        action = this.mediator.getActions().get("insertSchema");
        JButton schemaBtn = new JButton();
        schemaBtn.setName("schemaBtn");
        schemaBtn.setAction(action);
        schemaBtn.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                Object source = e.getSource();
                if (source instanceof JButton && ((JButton)source).isEnabled()) {
                    ChartWindow.this.getContext().dispatchMainCommand(IMainCommandAccepter.MainCommand.showSchemaBox);
                }
            }
        });
        decorationed.add(schemaBtn);
        action = this.mediator.getActions().get("insertStamp");
        JButton stampBtn = new JButton();
        stampBtn.setName("stampBtn");
        stampBtn.setAction(action);
        stampBtn.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                Object source = e.getSource();
                if (source instanceof JButton && ((JButton)source).isEnabled()) {
                    JPopupMenu popup = new JPopupMenu();
                    ChartWindow.this.mediator.addStampMenu(popup);
                    popup.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        });
        decorationed.add(stampBtn);
        return decorationed;
    }

    private void initCustomComponents() throws IOException {
        this.setTitle(this.getWindowTitle());
        this.windowSupport = WindowSupport.create(this, this.getWindowTitle());
        JMenuBar menuBar = this.windowSupport.getMenuBar();
        String rdFormat = this.resMap.getString("rdFormat", new Object[0]);
        String rdPrifix = this.resMap.getString("rdDatePrefix", new Object[0]);
        String patienIdPrefix = this.resMap.getString("patientIdPrefix", new Object[0]);
        Date date = this.getKarte().getCreated();
        SimpleDateFormat sdf = new SimpleDateFormat(rdFormat);
        String created = sdf.format(date);
        this.statusPanel.setRightInfo(rdPrifix + created);
        this.statusPanel.setLeftInfo(patienIdPrefix + this.getKarte().getPatient().getPatientId());
        this.mediator = new ChartMediator(this);
        WindowsMenuAdapter appMenu = new WindowsMenuAdapter();
        appMenu.setMenuSupports(this, this.getContext().getMenuSupport(), this.mediator, this.getContext().getPlugin());
        appMenu.build(menuBar, false);
        this.mediator.registerActions(appMenu.getActionMap());
        this.loadDocuments();
        this.RestoreLayouts();
        this.tabbedPane.setSelectedIndex(0);
        this.tabbedPane.addChangeListener(EventHandler.create(ChangeListener.class, this, "tabChanged", ""));
        this.toolPanel = appMenu.getToolPanelProduct();
        this.toolPanel.add((Component)this.inspector.getBasicInfoInspector(), 0);
        this.toolPanel.add(this.decorateToolBar(new JToolBar()));
        this.karteAndInspectorPanel.add((Component)this.toolPanel, "North");
        this.mainPanel.add((Component)this.statusPanel, "South");
        this.setContentPane(this.mainPanel);
        this.resMap.injectComponents((Component)this.mainPanel);
        this.status = new StateManager();
        this.blockGlass = new BlockGlass();
        this.setGlassPane(this.blockGlass);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                ChartWindow.this.processWindowClosing();
            }

            @Override
            public void windowOpened(WindowEvent e) {
                ChartWindow.this.windowOpened(ChartWindow.this);
            }

            @Override
            public void windowClosed(WindowEvent e) {
                ChartWindow.this.windowClosed(ChartWindow.this);
            }

            @Override
            public void windowActivated(WindowEvent e) {
                ChartWindow.this.getDocumentHistory().requestFocus();
            }
        });
        this.setLocationByPlatform(false);
        if (GlobalVariables.getSendMML()) {
            this.mmlListener = (SendMmlImpl)this.getContext().getPlugin("sendMml");
        }
        if (GlobalVariables.getSendClaim()) {
            this.claimListener = (SendClaimImpl)this.getContext().getPlugin("sendClaim");
        }
        this.getFrame().setVisible(true);
        this.statred = System.currentTimeMillis();
        this.scheduler = Executors.newScheduledThreadPool(1);
        Runnable beeper = new Runnable(){

            @Override
            public void run() {
                long time = System.currentTimeMillis() - ChartWindow.this.statred;
                ChartWindow.this.statusPanel.setTimeInfo(time /= 1000L);
            }
        };
        this.beeperHandle = this.scheduler.scheduleAtFixedRate(beeper, this.delay, this.delay, TimeUnit.SECONDS);
    }

    public SendMmlImpl getMMLListener() {
        return this.mmlListener;
    }

    public SendClaimImpl getCLAIMListener() {
        return this.claimListener;
    }

    public void controlMenu() {
        this.status.controlMenu();
    }

    private void loadDocuments() {
        DocumentHistoryPanel documentHistoryPanel = (DocumentHistoryPanel)this.chartDocuments.addPanel(new DocumentHistoryPanel(this, this.FKeyword));
        this.chartDocuments.addPanel(new ImageBrowserDocumentPanel(this));
        this.chartDocuments.addPanel(new CareMapDocumentPanel(this));
        this.chartDocuments.addPanel(new DiagnosisDocumentPanel(this));
        this.chartDocuments.addPanel(new DocumentBridgeImpl(this));
        for (Map.Entry entry : this.context.getPlugin().entrySet()) {
            IChartDocument panel;
            PluginWrapper pluginWrapper = new PluginWrapper((IPlugin)entry.getValue());
            if (pluginWrapper.getType() != IPlugin.Type.panel && pluginWrapper.getType() != IPlugin.Type.container || (panel = pluginWrapper.panel(this)) == null) continue;
            this.chartDocuments.addPanel(panel);
        }
        this.inspector = (PatientInspector)this.chartDocuments.addPanel(new PatientInspector(this, this.FKeyword));
        this.inspector.setBorder(BorderFactory.createEmptyBorder(7, 7, 5, 2));
        this.inspector.setDocumentHistory(documentHistoryPanel);
    }

    public void tabChanged(ChangeEvent e) {
        int index = this.tabbedPane.getSelectedIndex();
        Component component = this.tabbedPane.getComponentAt(index);
        IChartDocument documentPanel = null;
        documentPanel = (IChartDocument)((Object)component);
        documentPanel.enter();
    }

    private boolean newKarte() throws TooManyListenersException, CantReadTemplateException {
        String dept = this.getPatientVisit().getDeptNoTokenize();
        String deptCode = this.getPatientVisit().getDepartmentCode();
        String insuranceUid = this.getPatientVisit().getInsuranceUid();
        String docType = "karte";
        IChart.NewKarteOption option = null;
        IKarteViewer base = null;
        for (IChartDocument document : this.chartDocuments.values()) {
            if (document instanceof DocumentBridgeImpl) {
                DocumentBridgeImpl bridge = (DocumentBridgeImpl)document;
                base = bridge.getBaseKarte();
                continue;
            }
            if (!(document instanceof KarteDocumentViewer)) continue;
            KarteDocumentViewer viwer = (KarteDocumentViewer)document;
            base = viwer.getBaseKarte();
        }
        option = base != null ? (base.getDocType().equals("karte") ? IChart.NewKarteOption.BROWSER_COPY_NEW : IChart.NewKarteOption.BROWSER_NEW) : IChart.NewKarteOption.BROWSER_NEW;
        NewKarteParams params = null;
        Preferences prefs = GlobalVariables.getPreferences();
        if (prefs.getBoolean("karte.showConfirmAtNew", true)) {
            params = this.getNewKarteParams(docType, option, null, dept, deptCode, insuranceUid);
        } else {
            params = new NewKarteParams(option);
            params.setDocType(docType);
            params.setDepartment(dept);
            params.setDepartmentCode(deptCode);
            PVTHealthInsuranceModel[] ins = this.getHealthInsurances();
            params.setPVTHealthInsurance(ins[0]);
            if (insuranceUid != null) {
                for (int i = 0; i < ins.length; ++i) {
                    if (ins[i].getGUID() == null || !insuranceUid.equals(ins[i].getGUID())) continue;
                    params.setPVTHealthInsurance(ins[i]);
                    break;
                }
            }
            switch (option) {
                case BROWSER_NEW: {
                    params.setCreateMode(IChart.NewKarteMode.EMPTY_NEW);
                    break;
                }
                case BROWSER_COPY_NEW: {
                    int cMode = prefs.getInt("karte.createMode", 0);
                    if (cMode == 0) {
                        params.setCreateMode(IChart.NewKarteMode.EMPTY_NEW);
                        break;
                    }
                    if (cMode == 1) {
                        params.setCreateMode(IChart.NewKarteMode.APPLY_RP);
                        break;
                    }
                    if (cMode != 2) break;
                    params.setCreateMode(IChart.NewKarteMode.ALL_COPY);
                    break;
                }
                default: {
                    LogWriter.fatal(this.getClass(), "case default");
                }
            }
            params.setOpenFrame(prefs.getBoolean("karte.placeMode", true));
        }
        if (params == null) {
            return true;
        }
        DocumentModel editModel = null;
        editModel = params.getCreateMode() == IChart.NewKarteMode.EMPTY_NEW ? this.getKarteModelToEdit(params) : (params.getCreateMode() == IChart.NewKarteMode.FROM_TEMPLATE ? this.getKarteModelToEditFromTemplate(params) : this.getKarteModelToEdit(base.getModel(), params));
        if (params.getConfirmDate() != null) {
            editModel.setConfirmDate(params.getConfirmDate());
        }
        this.editor = this.createEditor(params.isOpenFrame(), editModel, this, true, 2);
        this.editor.setIsHospital(params.isHospital());
        this.enabledAction("newDocument", false);
        this.enabledAction("newKarte", false);
        if (params.isOpenFrame()) {
            this.editorFrame = new EditorFrame(this, this.editor);
            this.editorFrame.start();
            this.enabledAction("direction", false);
        } else if (!this.existEditorPane(2)) {
            this.editor.initialize();
            this.editor.start();
            this.addChartDocument((IChartDocument)this.editor, params);
            this.enabledAction("direction", true);
        }
        return true;
    }

    public DocumentModel getKarteModelToEdit(NewKarteParams params) {
        DocumentModel model = new DocumentModel();
        DocInfoModel docInfo = model.getDocInfo();
        docInfo.setDocId(GUIDGenerator.generate(docInfo));
        docInfo.setPurpose("recode");
        if (params != null) {
            docInfo.setDocType(params.getDocType());
        }
        docInfo.setDepartmentDesc(this.getPatientVisit().getDeptNoTokenize());
        docInfo.setDepartment(this.getPatientVisit().getDepartmentCode());
        if (params != null) {
            PVTHealthInsuranceModel insurance = params.getPVTHealthInsurance();
            docInfo.setHealthInsurance(insurance.getInsuranceClassCode());
            docInfo.setHealthInsuranceDesc(insurance.toString());
            docInfo.setHealthInsuranceGUID(insurance.getGUID());
        }
        VersionModel version = new VersionModel();
        version.initialize();
        docInfo.setVersionNumber(version.getVersionNumber());
        docInfo.setStatus("N");
        return model;
    }

    public DocumentModel getKarteModelToEdit(DocumentModel oldModel, NewKarteParams params) {
        DocumentModel newModel = new DocumentModel();
        boolean applyRp = params.getCreateMode() == IChart.NewKarteMode.APPLY_RP;
        this.copyModel(oldModel, newModel, applyRp);
        DocInfoModel docInfo = newModel.getDocInfo();
        docInfo.setDocId(GUIDGenerator.generate(docInfo));
        docInfo.setPurpose("recode");
        docInfo.setDocType(params.getDocType());
        docInfo.setDepartmentDesc(this.getPatientVisit().getDeptNoTokenize());
        docInfo.setDepartment(this.getPatientVisit().getDepartmentCode());
        PVTHealthInsuranceModel insurance = params.getPVTHealthInsurance();
        docInfo.setHealthInsurance(insurance.getInsuranceClassCode());
        docInfo.setHealthInsuranceDesc(insurance.toString());
        docInfo.setHealthInsuranceGUID(insurance.getGUID());
        VersionModel version = new VersionModel();
        version.initialize();
        docInfo.setVersionNumber(version.getVersionNumber());
        docInfo.setStatus("N");
        return newModel;
    }

    private DocumentModel getKarteModelToEditFromTemplate(NewKarteParams params) throws CantReadTemplateException {
        Template template = params.getSelectedTemplate();
        if (template != null) {
            return this.getKarteModelToEdit(template.getBody(), params);
        }
        return this.getKarteModelToEdit(params);
    }

    public DocumentModel getKarteModelToEdit(DocumentModel oldModel) {
        DocInfoModel oldDocInfo = oldModel.getDocInfo();
        DocumentModel newModel = new DocumentModel();
        this.copyModel(oldModel, newModel, false);
        DocInfoModel newInfo = newModel.getDocInfo();
        newInfo.setDocId(GUIDGenerator.generate(newInfo));
        newInfo.setFirstConfirmDate(oldDocInfo.getFirstConfirmDate());
        newInfo.setDocType(oldDocInfo.getDocType());
        newInfo.setPurpose(oldDocInfo.getPurpose());
        newInfo.setTitle(oldDocInfo.getTitle());
        newInfo.setDepartmentDesc(oldDocInfo.getDepartmentDesc());
        newInfo.setDepartment(oldDocInfo.getDepartment());
        newInfo.setHealthInsuranceDesc(oldDocInfo.getHealthInsuranceDesc());
        newInfo.setHealthInsurance(oldDocInfo.getHealthInsurance());
        newInfo.setHealthInsuranceGUID(oldDocInfo.getHealthInsuranceGUID());
        newInfo.setParentId(oldDocInfo.getDocId());
        newInfo.setParentIdRelation("oldEdition");
        newInfo.setParentPk(oldModel.getId());
        VersionModel newVersion = new VersionModel();
        newVersion.setVersionNumber(oldDocInfo.getVersionNumber());
        newVersion.incrementNumber();
        newInfo.setVersionNumber(newVersion.getVersionNumber());
        newInfo.setStatus(oldDocInfo.getStatus());
        return newModel;
    }

    public KarteEditor createEditor(boolean isOpenFrame, DocumentModel editModel, IChart parent, boolean editable, int mode) throws TooManyListenersException {
        KarteEditor result = null;
        result = new KarteEditor(parent);
        result.setOpenFrame(isOpenFrame);
        result.addMMLListner(this.mmlListener);
        result.addCLAIMListner(this.claimListener);
        result.setModel(editModel);
        result.setEditable(editable);
        result.setMode(mode);
        return result;
    }

    private void copyModel(DocumentModel oldModel, DocumentModel newModel, boolean applyRp) {
        if (applyRp) {
            Set<ModuleModel> modules = oldModel.getModules();
            if (modules != null) {
                ArrayList<ModuleModel> apply = new ArrayList<ModuleModel>(5);
                for (ModuleModel bean : modules) {
                    IInfoModel model = bean.getModel();
                    if (!(model instanceof ClaimBundle) || !((ClaimBundle)model).getClassCode().startsWith("2")) continue;
                    apply.add(bean);
                }
                if (!apply.isEmpty()) {
                    newModel.setModules(new LinkedHashSet<ModuleModel>(apply));
                }
            }
        } else {
            newModel.setModules(oldModel.getModules());
            newModel.setSchemas(oldModel.getSchemas());
        }
    }

    private NewKarteParams getNewKarteParams(String docType, IChart.NewKarteOption option, JFrame f, String dept, String deptCode, String insuranceUid) {
        NewKarteParams params = new NewKarteParams(option);
        params.setDocType(docType);
        params.setDepartment(dept);
        params.setDepartmentCode(deptCode);
        params.setHospital(GlobalVariables.getIsHospital());
        List<PVTHealthInsuranceModel> insurances = this.pvt.getPatient().getPvtHealthInsurances();
        if (insurances == null || insurances.isEmpty()) {
            insurances = new ArrayList<PVTHealthInsuranceModel>(1);
            PVTHealthInsuranceModel model = new PVTHealthInsuranceModel();
            model.setInsuranceClass("\u81ea\u8cbb");
            model.setInsuranceClassCode("Z1");
            model.setInsuranceClassCodeSys("MML031");
            insurances.add(model);
        }
        Object[] insModels = insurances.toArray(new PVTHealthInsuranceModel[insurances.size()]);
        params.setInsurances(insModels);
        int index = 0;
        if (insuranceUid != null) {
            for (int i = 0; i < insModels.length; ++i) {
                if (((PVTHealthInsuranceModel)insModels[i]).getGUID() == null || !((PVTHealthInsuranceModel)insModels[i]).getGUID().equals(insuranceUid)) continue;
                index = i;
                break;
            }
        }
        params.setInitialSelectedInsurance(index);
        String text = option == IChart.NewKarteOption.BROWSER_MODIFY ? this.resMap.getString("modifyKarteTitle", new Object[0]) : this.resMap.getString("newKarteTitle", new Object[0]);
        text = GlobalConstants.getFrameTitle(text);
        JFrame frame = f != null ? f : this.getFrame();
        NewKarteDialog od = new NewKarteDialog(frame, text);
        od.setValue(params);
        od.start();
        params = od.getValue();
        return params;
    }

    @Override
    public PVTHealthInsuranceModel[] getHealthInsurances() {
        List<PVTHealthInsuranceModel> insurances = this.pvt.getPatient().getPvtHealthInsurances();
        if (insurances == null || insurances.isEmpty()) {
            insurances = new ArrayList<PVTHealthInsuranceModel>(1);
            PVTHealthInsuranceModel model = new PVTHealthInsuranceModel();
            model.setInsuranceClass("\u81ea\u8cbb");
            model.setInsuranceClassCode("Z1");
            model.setInsuranceClassCodeSys("MML031");
            insurances.add(model);
        }
        return insurances.toArray(new PVTHealthInsuranceModel[insurances.size()]);
    }

    public void addChartDocument(IChartDocument doc, NewKarteParams params) {
        String title = null;
        title = params.getPVTHealthInsurance() != null ? this.getTabTitle(params.getDepartment(), params.getPVTHealthInsurance().getInsuranceClass()) : this.getTabTitle(params.getDepartment(), null);
        this.addChartDocument(doc, title);
    }

    public void addChartDocument(IChartDocument doc, String title) {
        this.tabbedPane.addTab(title, (JPanel)((Object)doc));
        int index = this.tabbedPane.getTabCount() - 1;
        this.tabbedPane.setSelectedIndex(index);
        this.chartDocuments.put(doc.getTitle(), doc);
    }

    public String getTabTitle(String dept, String insurance) {
        String[] depts = dept.split("\\s*,\\s*");
        StringBuilder buf = new StringBuilder();
        buf.append(this.resMap.getString("newKarteTabTitle", new Object[0]));
        if (insurance != null) {
            buf.append("(");
            buf.append(depts[0]);
            buf.append("\u30fb");
            buf.append(insurance);
            buf.append(")");
        }
        return buf.toString();
    }

    private void invokePlugin(Class klass) throws NoSuchMethodException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        if (klass.equals(LetterImpl.class) && this.existLetterPane()) {
            JOptionPane.showMessageDialog(null, "\u65e2\u306b\u7d39\u4ecb\u72b6\u306f\u958b\u304b\u308c\u3066\u3044\u307e\u3059\u3002", "\u7d39\u4ecb\u72b6", 2);
            return;
        }
        Constructor constructor = klass.getConstructor(IChart.class);
        IChartDocument doc = (IChartDocument)constructor.newInstance(this);
        if (doc instanceof KarteEditor) {
            String dept = this.getPatientVisit().getDeptNoTokenize();
            String deptCode = this.getPatientVisit().getDepartmentCode();
            String insuranceUid = this.getPatientVisit().getInsuranceUid();
            IChart.NewKarteOption option = IChart.NewKarteOption.BROWSER_NEW;
            String docType = "s_karte";
            NewKarteParams params = new NewKarteParams(option);
            params.setDocType(docType);
            params.setDepartment(dept);
            params.setDepartmentCode(deptCode);
            PVTHealthInsuranceModel[] ins = this.getHealthInsurances();
            params.setPVTHealthInsurance(ins[0]);
            if (insuranceUid != null) {
                for (int i = 0; i < ins.length; ++i) {
                    if (ins[i].getGUID() == null || !insuranceUid.equals(ins[i].getGUID())) continue;
                    params.setPVTHealthInsurance(ins[i]);
                    break;
                }
            }
            SimpleDate today = new SimpleDate(new GregorianCalendar());
            params.setConfirmDate(SimpleDate.simpleDateToMmldate(today) + "T00:00:00");
            DocumentModel editModel = this.getKarteModelToEdit(params);
            this.editor = (KarteEditor)doc;
            this.editor.setModel(editModel);
            this.editor.setEditable(true);
            this.editor.setMode(1);
            this.editor.initialize();
            this.editor.start();
            this.addChartDocument((IChartDocument)this.editor, params);
        } else {
            doc.start();
            this.addChartDocument(doc, doc.getTitle());
        }
    }

    private boolean newDocument() {
        ArrayList<Pair<String, Class<LetterImpl>>> documents = new ArrayList<Pair<String, Class<LetterImpl>>>(3);
        Pair<String, Class> pair = null;
        pair = new Pair<String, Class<LetterImpl>>("\u7d39\u4ecb\u72b6", LetterImpl.class);
        documents.add(pair);
        pair = new Pair<String, Class<LetterReplyImpl>>("\u7d39\u4ecb\u60a3\u8005\u7d4c\u904e\u5831\u544a\u66f8", LetterReplyImpl.class);
        documents.add(pair);
        pair = new Pair<String, Class<KarteEditor>>("\u30d7\u30ec\u30a4\u30f3\u6587\u66f8(\u53f0\u7d19)", KarteEditor.class);
        documents.add(pair);
        JLabel newDocsLabel = new JLabel();
        newDocsLabel.setName("newDocsLabel");
        this.resMap.injectComponent((Component)newDocsLabel);
        final JList<Object> docList = new JList<Object>(documents.toArray());
        docList.setCellRenderer(new StripeRenderer());
        JPanel panel = new JPanel(new BorderLayout(7, 0));
        panel.add((Component)newDocsLabel, "West");
        panel.add(docList, "Center");
        panel.setBorder(BorderFactory.createEmptyBorder(6, 6, 5, 5));
        JPanel content = new JPanel(new BorderLayout());
        content.add((Component)panel, "Center");
        content.setBorder(BorderFactory.createTitledBorder("\u4f5c\u6210\u3059\u308b\u6587\u66f8"));
        final JButton okButton = new JButton("\u4e86\u89e3");
        JButton cancelButton = new JButton("\u53d6\u6d88\u3057");
        Object[] options = new Object[]{okButton, cancelButton};
        JOptionPane jop = new JOptionPane(content, -1, -1, null, options, okButton);
        final JDialog dialog = jop.createDialog(this.getFrame(), GlobalConstants.getFrameTitle("\u65b0\u898f\u6587\u66f8\u4f5c\u6210"));
        dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent e) {
                docList.requestFocusInWindow();
            }
        });
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    dialog.setVisible(false);
                    dialog.dispose();
                    Pair pair = (Pair)docList.getSelectedValue();
                    Class clsName = (Class)pair.getValue();
                    ChartWindow.this.invokePlugin(clsName);
                }
                catch (NoSuchMethodException ex) {
                    LogWriter.error(this.getClass(), ex);
                }
                catch (InstantiationException ex) {
                    LogWriter.error(this.getClass(), ex);
                }
                catch (IllegalAccessException ex) {
                    LogWriter.error(this.getClass(), ex);
                }
                catch (IllegalArgumentException ex) {
                    LogWriter.error(this.getClass(), ex);
                }
                catch (InvocationTargetException ex) {
                    LogWriter.error(this.getClass(), ex);
                }
            }
        });
        okButton.setEnabled(false);
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                dialog.setVisible(false);
                dialog.dispose();
            }
        });
        docList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int index;
                if (!e.getValueIsAdjusting() && (index = docList.getSelectedIndex()) >= 0) {
                    okButton.setEnabled(true);
                }
            }
        });
        dialog.setVisible(true);
        return true;
    }

    private boolean prepareAll(List<Pair<IChartDocument, JCheckBox>> dirtyList) {
        for (Pair<IChartDocument, JCheckBox> pair : dirtyList) {
            if (!((JCheckBox)pair.value).isSelected() || ((IChartDocument)pair.key).prepare()) continue;
            return false;
        }
        return true;
    }

    private void innerSaveAll(List<Pair<IChartDocument, JCheckBox>> dirtyList) {
        for (Pair<IChartDocument, JCheckBox> pair : dirtyList) {
            if (!((JCheckBox)pair.value).isSelected()) continue;
            ((IChartDocument)pair.key).dispatchChartCommand(IChartCommandAccepter.ChartCommand.save);
        }
    }

    private boolean saveAll(List<Pair<IChartDocument, JCheckBox>> dirtyList) {
        if (this.prepareAll(dirtyList)) {
            this.innerSaveAll(dirtyList);
            return true;
        }
        return false;
    }

    public void processWindowClosing() {
        this.close();
    }

    @Override
    public boolean close() {
        block9: {
            block8: {
                this.closePatient();
                ArrayList<Pair<IChartDocument, JCheckBox>> dirtyList = new ArrayList<Pair<IChartDocument, JCheckBox>>();
                for (IChartDocument component : this.chartDocuments.values()) {
                    if (!component.isDirty()) continue;
                    dirtyList.add(new Pair<IChartDocument, JCheckBox>(component, new JCheckBox(component.getTitle())));
                }
                if (dirtyList.size() <= 0) break block8;
                String saveAll = this.resMap.getString("unsavedtask.saveText", new Object[0]);
                String discard = this.resMap.getString("unsavedtask.discardText", new Object[0]);
                String question = this.resMap.getString("unsavedtask.question", new Object[0]);
                String title = this.resMap.getString("unsavedtask.title", new Object[0]);
                String cancelText = (String)UIManager.get("OptionPane.cancelButtonText");
                Object[] message = new Object[dirtyList.size() + 1];
                message[0] = question;
                int index = 1;
                for (Pair pair : dirtyList) {
                    JCheckBox checkBox = (JCheckBox)pair.value;
                    checkBox.setSelected(true);
                    message[index] = checkBox;
                    ++index;
                }
                int state2 = JOptionPane.showOptionDialog(this.getFrame(), message, GlobalConstants.getFrameTitle(title), -1, 3, null, new String[]{saveAll, discard, cancelText}, saveAll);
                switch (state2) {
                    case 0: {
                        if (this.saveAll(dirtyList)) {
                            this.stop();
                            break;
                        }
                        break block9;
                    }
                    case 1: {
                        this.stop();
                        break;
                    }
                    case 2: {
                        break;
                    }
                    default: {
                        LogWriter.fatal(this.getClass(), "case default");
                        break;
                    }
                }
                break block9;
            }
            this.stop();
        }
        return true;
    }

    @Override
    public void stop() {
        this.beeperHandle.cancel(true);
        for (IChartDocument component : this.chartDocuments.values()) {
            if (component == null) continue;
            component.stop();
        }
        this.mediator.dispose();
        this.release();
        this.inspector.dispose();
        this.getFrame().setVisible(false);
        this.getFrame().setJMenuBar(null);
        this.getFrame().dispose();
    }

    public boolean dispatchMainCommand(IMainCommandAccepter.MainCommand command) {
        switch (command) {
            case close: {
                return this.close();
            }
        }
        return false;
    }

    @Override
    public boolean dispatchChartCommand(IChartCommandAccepter.ChartCommand command) {
        try {
            try {
                switch (command) {
                    case newKarte: {
                        return this.newKarte();
                    }
                    case newDocument: {
                        return this.newDocument();
                    }
                    case close: {
                        return this.close();
                    }
                    case direction: {
                        return this.direction();
                    }
                }
            }
            catch (CantReadTemplateException ex) {
                LogWriter.error(this.getClass(), ex);
            }
        }
        catch (TooManyListenersException ex) {
            LogWriter.error(this.getClass(), ex);
        }
        return false;
    }

    private boolean direction() {
        if (this.editor != null) {
            DirectionDialog direction = new DirectionDialog(null, true, this.editor.getActualModel());
            direction.setVisible(true);
        }
        return true;
    }

    public static void _addPropertyChangeListener(String prop, PropertyChangeListener l) {
        boundSupport.addPropertyChangeListener(prop, l);
    }

    public static void _removePropertyChangeListener(String prop, PropertyChangeListener l) {
        boundSupport.removePropertyChangeListener(prop, l);
    }

    public void windowOpened(ChartWindow opened) {
        this.context.addChart(opened);
        PatientVisitModel model = opened.getPatientVisit();
        IChart.state oldState = model.getState();
        IChart.state newState = IChart.state.CLOSE_NONE;
        switch (oldState) {
            case CLOSE_NONE: {
                newState = IChart.state.OPEN_NONE;
                break;
            }
            case CLOSE_SAVE: {
                newState = IChart.state.OPEN_SAVE;
                break;
            }
            case OPEN_NONE: {
                break;
            }
            case OPEN_SAVE: {
                break;
            }
        }
        model.setState(newState);
        boundSupport.firePropertyChange(CHART_STATE, null, model);
    }

    public void windowClosed(ChartWindow closed) {
        if (this.context.removeChart(closed)) {
            PatientVisitModel model = closed.getPatientVisit();
            IChart.state oldState = model.getState();
            IChart.state newState = IChart.state.CLOSE_NONE;
            switch (oldState) {
                case OPEN_NONE: {
                    newState = IChart.state.CLOSE_NONE;
                    break;
                }
                case OPEN_SAVE: {
                    newState = IChart.state.CLOSE_SAVE;
                    break;
                }
            }
            model.setState(newState);
            boundSupport.firePropertyChange(CHART_STATE, null, model);
            closed = null;
        }
    }

    @Override
    public void closeChartDocument(String label, IChartDocument document) {
        this.tabbedPane.remove((Component)((Object)document));
        this.profilerTabedPane.remove((Component)((Object)document));
        this.chartDocuments.remove(label);
    }

    public static void fireChanged(ChartWindow changed) {
        PatientVisitModel model = changed.getPatientVisit();
        model.setState(changed.getChartState());
    }

    @Override
    public PlugInMenuSupport getPlugins() {
        return this.context.getPlugin();
    }

    protected final class StateManager {
        private ChartState readOnlyState;
        private ChartState noInsuranceState;
        private ChartState ordinalyState;
        private ChartState currentState;

        public StateManager() {
            this.readOnlyState = new ReadOnlyState();
            this.noInsuranceState = new NoInsuranceState();
            this.ordinalyState = new OrdinalyState();
            if (ChartWindow.this.isReadOnly()) {
                this.enterReadOnlyState();
            } else {
                this.enterOrdinalyState();
            }
        }

        public void enterReadOnlyState() {
            this.currentState = this.readOnlyState;
            this.currentState.controlMenu();
        }

        public void enterNoInsuranceState() {
            this.currentState = this.noInsuranceState;
            this.currentState.controlMenu();
        }

        public void enterOrdinalyState() {
            this.currentState = this.ordinalyState;
            this.currentState.controlMenu();
        }

        public void controlMenu() {
            this.currentState.controlMenu();
        }
    }

    protected final class OrdinalyState
    extends ChartState {
        @Override
        public void controlMenu() {
            ChartWindow.this.enabledAction("newKarte", true);
        }
    }

    protected final class NoInsuranceState
    extends ChartState {
        @Override
        public void controlMenu() {
            ChartWindow.this.enabledAction("newKarte", false);
        }
    }

    protected final class ReadOnlyState
    extends ChartState {
        @Override
        public void controlMenu() {
            ChartWindow.this.enabledAction("newKarte", false);
            ChartWindow.this.enabledAction("modifyKarte", false);
        }
    }

    protected abstract class ChartState {
        public abstract void controlMenu();
    }
}

