/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.client;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;
import java.util.prefs.Preferences;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.FileImageInputStream;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.StyledEditorKit;
import open.dolphin.client.AutoKanjiListener;
import open.dolphin.client.ChartMediator;
import open.dolphin.client.ColorChooserComponent;
import open.dolphin.client.IChartDocument;
import open.dolphin.client.IComponentHolder;
import open.dolphin.client.IKarteComposite;
import open.dolphin.client.ImageEntry;
import open.dolphin.client.KarteStyledDocument;
import open.dolphin.client.OrderListTransferable;
import open.dolphin.client.PCodeHelper;
import open.dolphin.client.SOACodeHelper;
import open.dolphin.client.SchemaHolder;
import open.dolphin.client.SchemaHolderTransferHandler;
import open.dolphin.client.SchemaListTransferable;
import open.dolphin.client.SymptomsDialog;
import open.dolphin.client.definition.FontSettings;
import open.dolphin.client.editor.stamp.StampEditorDialog;
import open.dolphin.client.editor.stamp.StampHolder;
import open.dolphin.client.editor.stamp.StampHolderTransferHandler;
import open.dolphin.client.editor.stamp.StampListTransferable;
import open.dolphin.client.schemaeditor.SchemaEditorImpl;
import open.dolphin.container.Pair;
import open.dolphin.dao.SqlDaoFactory;
import open.dolphin.dao.SqlMasterDao;
import open.dolphin.dao.SqlOrcaSetDao;
import open.dolphin.delegater.remote.RemoteStampDelegater;
import open.dolphin.helper.DBTask;
import open.dolphin.helper.ImageHelper;
import open.dolphin.infomodel.BundleDolphin;
import open.dolphin.infomodel.ClaimBundle;
import open.dolphin.infomodel.ClaimItem;
import open.dolphin.infomodel.ExtRefModel;
import open.dolphin.infomodel.IInfoModel;
import open.dolphin.infomodel.InteractEntry;
import open.dolphin.infomodel.MedicineEntry;
import open.dolphin.infomodel.ModuleInfoBean;
import open.dolphin.infomodel.ModuleModel;
import open.dolphin.infomodel.SchemaModel;
import open.dolphin.infomodel.SsKijyoEntry;
import open.dolphin.infomodel.StampModel;
import open.dolphin.log.LogWriter;
import open.dolphin.project.GlobalConstants;

public class KartePane
implements DocumentListener,
MouseListener,
CaretListener,
PropertyChangeListener,
IKarteComposite {
    private static final int TITLE_LENGTH = 15;
    private static final Color UNEDITABLE_COLOR = new Color(227, 250, 207);
    private JTextPane textPane;
    private String myRole;
    private IChartDocument parent;
    private StampHolderTransferHandler stampHolderTransferHandler;
    private SchemaHolderTransferHandler schemaHolderTransferHandler;
    private int stampId;
    private boolean dirty;
    private boolean hasSelection;
    private ChartMediator.CompState curState;
    private int initialLength;
    private ChartMediator mediator;
    private String docId;
    private Color uneditableColor = UNEDITABLE_COLOR;
    private IComponentHolder[] drragedStamp;
    private int draggedCount;
    private int droppedCount;

    public KartePane(IChartDocument parent) {
        this.parent = parent;
    }

    public void setMargin(Insets margin) {
        this.textPane.setMargin(margin);
    }

    public void setPreferredSize(Dimension size) {
        this.textPane.setPreferredSize(size);
    }

    public void setSize(Dimension size) {
        this.textPane.setMinimumSize(size);
        this.textPane.setMaximumSize(size);
    }

    public IChartDocument getParent() {
        return this.parent;
    }

    public void setUneditableColor(Color uneditableColor) {
        this.uneditableColor = uneditableColor;
    }

    public Color getUneditableColor() {
        return this.uneditableColor;
    }

    protected void setDocId(String docId) {
        this.docId = docId;
    }

    protected String getDocId() {
        return this.docId;
    }

    protected void setMediator(ChartMediator mediator) {
        this.mediator = mediator;
    }

    public ChartMediator getMediator() {
        return this.mediator;
    }

    public void setMyRole(String myRole) {
        this.myRole = myRole;
    }

    public String getMyRole() {
        return this.myRole;
    }

    public void setTextPane(JTextPane textPane) {
        this.textPane = textPane;
        if (this.textPane != null) {
            KarteStyledDocument doc = new KarteStyledDocument();
            this.textPane.setDocument(doc);
            this.textPane.putClientProperty("kartePane", this);
            this.textPane.setFont(FontSettings.getKarteDefaultFont());
            doc.setParent(this);
            this.stampHolderTransferHandler = new StampHolderTransferHandler();
            this.schemaHolderTransferHandler = new SchemaHolderTransferHandler();
        } else {
            LogWriter.error(this.getClass(), "setTextPane(JTextPane textPane) textPane is null");
        }
    }

    public JTextPane getTextPane() {
        return this.textPane;
    }

    protected KarteStyledDocument getDocument() {
        return (KarteStyledDocument)this.getTextPane().getDocument();
    }

    public void setInitialLength(int initialLength) {
        this.initialLength = initialLength;
    }

    public int getInitialLength() {
        return this.initialLength;
    }

    public int getDraggedCount() {
        return this.draggedCount;
    }

    public void setDraggedCount(int draggedCount) {
        this.draggedCount = draggedCount;
    }

    public int getDroppedCount() {
        return this.droppedCount;
    }

    public void setDroppedCount(int droppedCount) {
        this.droppedCount = droppedCount;
    }

    public IComponentHolder[] getDrragedStamp() {
        return this.drragedStamp;
    }

    public void setDrragedStamp(IComponentHolder[] drragedStamp) {
        this.drragedStamp = drragedStamp;
    }

    public void init(boolean editable, ChartMediator mediator) {
        this.setMediator(mediator);
        ActionMap map = this.getTextPane().getActionMap();
        KeyStroke keystroke = KeyStroke.getKeyStroke(90, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
        map.put(keystroke, mediator.getAction("undo"));
        keystroke = KeyStroke.getKeyStroke(89, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
        map.put(keystroke, mediator.getAction("redo"));
        keystroke = KeyStroke.getKeyStroke(88, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
        map.put(keystroke, mediator.getAction("cut"));
        keystroke = KeyStroke.getKeyStroke(67, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
        map.put(keystroke, mediator.getAction("copy"));
        keystroke = KeyStroke.getKeyStroke(86, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
        map.put(keystroke, mediator.getAction("paste"));
        this.getTextPane().setDragEnabled(true);
        this.getTextPane().addMouseListener(this);
        this.getTextPane().addCaretListener(this);
        this.setEditableProp(editable);
    }

    public void setEditableProp(boolean editable) {
        this.getTextPane().setEditable(editable);
        if (editable) {
            this.getTextPane().getDocument().addDocumentListener(this);
            this.getTextPane().addFocusListener(AutoKanjiListener.getInstance());
            this.getTextPane().getDocument().addUndoableEditListener(this.mediator);
            if (this.myRole.equals("soa")) {
                SOACodeHelper helper = new SOACodeHelper(this, this.getMediator());
            } else {
                PCodeHelper pCodeHelper = new PCodeHelper(this, this.getMediator());
            }
            this.getTextPane().setBackground(Color.WHITE);
            this.getTextPane().setOpaque(true);
        } else {
            this.getTextPane().getDocument().removeDocumentListener(this);
            this.getTextPane().removeFocusListener(AutoKanjiListener.getInstance());
            this.getTextPane().getDocument().removeUndoableEditListener(this.mediator);
            this.setBackgroundUneditable();
        }
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        boolean newDirty = this.getDocument().getLength() > this.getInitialLength();
        this.setDirty(newDirty);
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        boolean newDirty = this.getDocument().getLength() > this.getInitialLength();
        this.setDirty(newDirty);
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
    }

    @Override
    public void caretUpdate(CaretEvent e) {
        boolean newSelection;
        boolean bl = newSelection = e.getDot() != e.getMark();
        if (newSelection != this.hasSelection) {
            this.hasSelection = newSelection;
            this.curState = this.hasSelection ? (this.getMyRole().equals("soa") ? ChartMediator.CompState.SOA_TEXT : ChartMediator.CompState.P_TEXT) : (this.getMyRole().equals("soa") ? ChartMediator.CompState.SOA : ChartMediator.CompState.P);
            this.controlMenus(this.mediator.getActions());
        }
    }

    public void clear() {
        this.getTextPane().getDocument().removeDocumentListener(this);
        this.getTextPane().removeMouseListener(this);
        this.getTextPane().removeFocusListener(AutoKanjiListener.getInstance());
        this.getTextPane().removeCaretListener(this);
        try {
            KarteStyledDocument doc = this.getDocument();
            doc.remove(0, doc.getLength());
            doc = null;
        }
        catch (Exception e) {
            LogWriter.error(this.getClass(), e);
        }
        this.setTextPane(null);
    }

    private void controlMenus(ActionMap map) {
        if (this.getTextPane() != null) {
            switch (this.curState) {
                case NONE: {
                    break;
                }
                case SOA: {
                    if (!this.getTextPane().isEditable()) break;
                    map.get("paste").setEnabled(this.canPaste());
                    map.get("insertText").setEnabled(true);
                    map.get("insertSchema").setEnabled(true);
                    break;
                }
                case SOA_TEXT: {
                    map.get("cut").setEnabled(this.getTextPane().isEditable());
                    map.get("copy").setEnabled(true);
                    boolean pasteOk = this.getTextPane().isEditable() && this.canPaste();
                    map.get("paste").setEnabled(pasteOk);
                    break;
                }
                case P: {
                    if (!this.getTextPane().isEditable()) break;
                    map.get("paste").setEnabled(this.canPaste());
                    map.get("insertText").setEnabled(true);
                    map.get("insertStamp").setEnabled(true);
                    break;
                }
                case P_TEXT: {
                    map.get("cut").setEnabled(this.getTextPane().isEditable());
                    map.get("copy").setEnabled(true);
                    boolean pasteOk = this.getTextPane().isEditable() && this.canPaste();
                    map.get("paste").setEnabled(pasteOk);
                    break;
                }
                default: {
                    LogWriter.fatal(this.getClass(), "case default");
                }
            }
        }
    }

    @Override
    public void enter(ActionMap map) {
        this.curState = this.getMyRole().equals("soa") ? ChartMediator.CompState.SOA : ChartMediator.CompState.P;
        this.controlMenus(map);
    }

    @Override
    public void exit(ActionMap map) {
    }

    @Override
    public Component getComponent() {
        return this.getTextPane();
    }

    protected JPopupMenu createMenus() {
        final JPopupMenu contextMenu = new JPopupMenu();
        contextMenu.add(this.mediator.getAction("cut"));
        contextMenu.add(this.mediator.getAction("copy"));
        contextMenu.add(this.mediator.getAction("paste"));
        contextMenu.add(new JSeparator());
        contextMenu.add(this.mediator.getAction("fontLarger"));
        contextMenu.add(this.mediator.getAction("fontSmaller"));
        contextMenu.add(this.mediator.getAction("fontStandard"));
        contextMenu.add(this.mediator.getAction("fontBold"));
        contextMenu.add(this.mediator.getAction("fontItalic"));
        contextMenu.add(this.mediator.getAction("fontUnderline"));
        contextMenu.add(this.mediator.getAction("leftJustify"));
        contextMenu.add(this.mediator.getAction("centerJustify"));
        contextMenu.add(this.mediator.getAction("rightJustify"));
        if (this.getTextPane().isEditable()) {
            ColorChooserComponent ccl = new ColorChooserComponent();
            ccl.addPropertyChangeListener("selectedColor", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent e) {
                    Color selected = (Color)e.getNewValue();
                    StyledEditorKit.ForegroundAction action = new StyledEditorKit.ForegroundAction("selected", selected);
                    action.actionPerformed(new ActionEvent(KartePane.this.getTextPane(), 1001, "foreground"));
                    contextMenu.setVisible(false);
                }
            });
            JLabel l = new JLabel("  \u30ab\u30e9\u30fc:");
            JPanel p = new JPanel(new FlowLayout(0, 5, 5));
            p.add(l);
            p.add(ccl);
            contextMenu.add(p);
        } else {
            contextMenu.addSeparator();
        }
        if (this.getMyRole().equals("p")) {
            this.mediator.addStampMenu(contextMenu, this);
        } else {
            this.mediator.addTextMenu(contextMenu);
        }
        return contextMenu;
    }

    private void mabeShowPopup(MouseEvent e) {
        if (e.isPopupTrigger()) {
            JPopupMenu contextMenu = this.createMenus();
            contextMenu.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.mabeShowPopup(e);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.mabeShowPopup(e);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    protected void setBackgroundUneditable() {
        this.getTextPane().setBackground(this.getUneditableColor());
        this.getTextPane().setOpaque(true);
    }

    public void setRole(String role) {
        this.setMyRole(role);
    }

    protected boolean isDirty() {
        return this.getTextPane().isEditable() ? this.dirty : false;
    }

    public void setDirty(boolean newDirty) {
        if (newDirty != this.dirty) {
            this.dirty = newDirty;
            this.getParent().setDirty(this.dirty);
        }
    }

    protected String getTitle() {
        try {
            KarteStyledDocument doc = this.getDocument();
            int len = doc.getLength();
            int freeTop = 0;
            int freeLen = len - freeTop;
            freeLen = freeLen < 15 ? freeLen : 15;
            return this.getTextPane().getText(freeTop, freeLen).trim();
        }
        catch (Exception e) {
            LogWriter.error(this.getClass(), e);
            return null;
        }
    }

    public void setLogicalStyle(String str) {
        this.getDocument().setLogicalStyle(str);
    }

    public void clearLogicalStyle() {
        this.getDocument().clearLogicalStyle();
    }

    public void makeParagraph() {
        this.getDocument().makeParagraph();
    }

    public void insertFreeString(String s, AttributeSet a) {
        this.getDocument().insertFreeString(s, a);
    }

    private void stampWithSymptomCheck(final ModuleModel stamp, IInfoModel model, SqlMasterDao dao, final String notice) {
        boolean isCancel = false;
        List<Pair<InteractEntry, SsKijyoEntry>> symptoms = this.checkSymptom(dao, model);
        if (!symptoms.isEmpty()) {
            SymptomsDialog symptomDialog = new SymptomsDialog((Frame)((JFrame)this.textPane.getRootPane().getParent()), true, dao, symptoms);
            symptomDialog.setVisible(true);
            isCancel = symptomDialog.IsCancel();
        }
        if (!isCancel && stamp != null) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    stamp.getModuleInfo().setStampStatus(notice);
                    StampHolder stampHolder = new StampHolder(KartePane.this, stamp);
                    stampHolder.setTransferHandler(KartePane.this.stampHolderTransferHandler);
                    KarteStyledDocument targetDocument = KartePane.this.getDocument();
                    targetDocument.stamp(stampHolder);
                }
            });
        }
    }

    public void stamp(ModuleModel stamp) {
        IInfoModel model = stamp.getModel();
        GregorianCalendar gc = new GregorianCalendar();
        if (model instanceof ClaimBundle) {
            SqlMasterDao dao = (SqlMasterDao)SqlDaoFactory.create("dao.master");
            ArrayList<MedicineEntry> updates = new ArrayList<MedicineEntry>();
            ClaimBundle.Enabled enabled = ((BundleDolphin)model).getStampEnabled(updates, gc);
            if (enabled == ClaimBundle.Enabled.UPDATE_AVAILABLE) {
                if (JOptionPane.showConfirmDialog(null, "\u671f\u9650\u5207\u308c\u306e\u9805\u76ee\u3092\u542b\u3080\u30b9\u30bf\u30f3\u30d7\u3092\u8cbc\u308a\u4ed8\u3051\u307e\u3059\u3002" + System.getProperty("line.separator") + "\u3088\u308d\u3057\u3044\u3067\u3059\u304b\uff1f", "\u78ba\u8a8d", 0) == 0) {
                    this.stampWithSymptomCheck(stamp, model, dao, "\uff08\u671f\u9650\u5207\u308c\uff09");
                }
            } else {
                this.stampWithSymptomCheck(stamp, model, dao, "");
            }
        }
    }

    public void flowStamp(ModuleModel stamp) {
        if (stamp != null) {
            StampHolder holder = new StampHolder(this, stamp);
            holder.setTransferHandler(this.stampHolderTransferHandler);
            KarteStyledDocument doc = this.getDocument();
            doc.flowStamp(holder);
        }
    }

    public void stampSchema(final SchemaModel schema) {
        if (schema != null) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SchemaHolder h = new SchemaHolder(KartePane.this, schema);
                    h.setTransferHandler(KartePane.this.schemaHolderTransferHandler);
                    KarteStyledDocument doc = KartePane.this.getDocument();
                    doc.stampSchema(h);
                }
            });
        }
    }

    public void flowSchema(SchemaModel schema) {
        if (schema != null) {
            SchemaHolder h = new SchemaHolder(this, schema);
            h.setTransferHandler(this.schemaHolderTransferHandler);
            KarteStyledDocument doc = (KarteStyledDocument)this.getTextPane().getDocument();
            doc.flowSchema(h);
        }
    }

    public void insertTextStamp(final String s) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                KarteStyledDocument doc = KartePane.this.getDocument();
                doc.insertTextStamp(s);
            }
        });
    }

    public void stampInfoDropped(ModuleInfoBean stampInfo) {
        String entity = stampInfo.getEntity();
        String role = stampInfo.getStampRole();
        if (entity.equals("diagnosis")) {
            Toolkit.getDefaultToolkit().beep();
            return;
        }
        if (entity.equals("text")) {
            this.applyTextStamp(stampInfo);
            return;
        }
        if (role.equals("orcaSet")) {
            this.applyOrcaSet(stampInfo);
            return;
        }
        if (stampInfo.isSerialized()) {
            this.applySerializedStamp(stampInfo);
            return;
        }
        ModuleModel stamp = new ModuleModel();
        stamp.setModuleInfo(stampInfo);
        StampEditorDialog stampEditor = new StampEditorDialog(entity, stamp);
        stampEditor.addPropertyChangeListener("value", this);
        stampEditor.start();
    }

    public void stampInfoDropped(final List<ModuleInfoBean> addList) {
        final RemoteStampDelegater sdl = new RemoteStampDelegater();
        DBTask<List<StampModel>> task = new DBTask<List<StampModel>>(this.parent.getParentContext()){

            @Override
            protected List<StampModel> doInBackground() throws Exception {
                List<StampModel> list = sdl.getStamp(addList);
                return list;
            }

            @Override
            public void succeeded(List<StampModel> list) {
                if (list != null) {
                    for (int i = 0; i < list.size(); ++i) {
                        ModuleInfoBean stampInfo = (ModuleInfoBean)addList.get(i);
                        StampModel theModel = list.get(i);
                        IInfoModel model = theModel.toInfoModel();
                        if (model == null) continue;
                        ModuleModel stamp = new ModuleModel();
                        stamp.setModel(model);
                        stamp.setModuleInfo(stampInfo);
                        KartePane.this.stamp(stamp);
                    }
                }
            }
        };
        task.execute();
    }

    public void textStampInfoDropped(final List<ModuleInfoBean> addList) {
        final RemoteStampDelegater sdl = new RemoteStampDelegater();
        DBTask<List<StampModel>> task = new DBTask<List<StampModel>>(this.parent.getParentContext()){

            @Override
            protected List<StampModel> doInBackground() throws Exception {
                List<StampModel> list = sdl.getStamp(addList);
                return list;
            }

            @Override
            public void succeeded(List<StampModel> list) {
                if (list != null) {
                    for (int i = 0; i < list.size(); ++i) {
                        StampModel theModel = list.get(i);
                        IInfoModel model = theModel.toInfoModel();
                        if (model == null) continue;
                        KartePane.this.insertTextStamp(model.toString() + System.getProperty("line.separator"));
                    }
                }
            }
        };
        task.execute();
    }

    private void applyTextStamp(final ModuleInfoBean stampInfo) {
        final RemoteStampDelegater sdl = new RemoteStampDelegater();
        DBTask<StampModel> task = new DBTask<StampModel>(this.parent.getParentContext()){

            @Override
            protected StampModel doInBackground() throws Exception {
                StampModel getStamp = sdl.getStamp(stampInfo.getStampId());
                return getStamp;
            }

            @Override
            public void succeeded(StampModel result) {
                if (result != null) {
                    try {
                        IInfoModel model = result.toInfoModel();
                        if (model != null) {
                            KartePane.this.insertTextStamp(model.toString());
                        }
                    }
                    catch (Exception e) {
                        LogWriter.error(this.getClass(), e);
                    }
                }
            }
        };
        task.execute();
    }

    private List<Pair<InteractEntry, SsKijyoEntry>> checkSymptom(SqlMasterDao dao, IInfoModel importModel) {
        ArrayList<Pair<InteractEntry, SsKijyoEntry>> result = new ArrayList<Pair<InteractEntry, SsKijyoEntry>>();
        ArrayList<String> onStampCode = new ArrayList<String>();
        for (ClaimItem item : this.getDocument().getClaimItems()) {
            onStampCode.add(item.getCode());
        }
        ClaimItem[] importClaims = ((ClaimBundle)importModel).getClaimItem();
        for (int index = 0; index < importClaims.length; ++index) {
            dao.getSsKijyoEntry(importClaims[index].getCode(), onStampCode, result);
        }
        return result;
    }

    private void applySerializedStamp(final ModuleInfoBean stampInfo) {
        final RemoteStampDelegater sdl = new RemoteStampDelegater();
        DBTask<StampModel> task = new DBTask<StampModel>(this.parent.getParentContext()){

            @Override
            protected StampModel doInBackground() throws Exception {
                StampModel getStamp = sdl.getStamp(stampInfo.getStampId());
                return getStamp;
            }

            @Override
            public void succeeded(StampModel result) {
                IInfoModel model;
                if (result != null && (model = result.toInfoModel()) instanceof ClaimBundle) {
                    ModuleModel stamp = new ModuleModel();
                    stamp.setModel(model);
                    stamp.setModuleInfo(stampInfo);
                    KartePane.this.stamp(stamp);
                }
            }
        };
        task.execute();
    }

    private void applyOrcaSet(final ModuleInfoBean stampInfo) {
        final SqlOrcaSetDao sdl = new SqlOrcaSetDao();
        DBTask<List<ModuleModel>> task = new DBTask<List<ModuleModel>>(this.parent.getParentContext()){

            @Override
            protected List<ModuleModel> doInBackground() throws Exception {
                List<ModuleModel> models = sdl.getStampFromOrca(stampInfo);
                return models;
            }

            @Override
            public void succeeded(List<ModuleModel> models) {
                if (models != null) {
                    for (ModuleModel stamp : models) {
                        KartePane.this.stamp(stamp);
                    }
                }
            }
        };
        task.execute();
    }

    private boolean showMaxSizeMessage() {
        int maxImageWidth = 522;
        int maxImageHeight = 522;
        final Preferences pref = Preferences.userNodeForPackage(this.getClass());
        String title = GlobalConstants.getFrameTitle("\u753b\u50cf\u30b5\u30a4\u30ba\u306b\u3064\u3044\u3066");
        JLabel msg1 = new JLabel("\u30ab\u30eb\u30c6\u306b\u633f\u5165\u3059\u308b\u753b\u50cf\u306f\u3001\u6700\u5927\u3067 " + maxImageWidth + " x " + maxImageHeight + " pixcel \u306b\u5236\u9650\u3057\u3066\u3044\u307e\u3059\u3002");
        JLabel msg2 = new JLabel("\u753b\u50cf\u3092\u7e2e\u5c0f\u3057\u30ab\u30eb\u30c6\u306b\u5c55\u958b\u3057\u307e\u3059\u304b?");
        final JCheckBox cb = new JCheckBox("\u4eca\u5f8c\u3053\u306e\u30e1\u30c3\u30bb\u30fc\u30b8\u3092\u8868\u793a\u3057\u306a\u3044");
        cb.setFont(FontSettings.getKarteFont(0));
        cb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                pref.putBoolean("showImageSizeMessage", !cb.isSelected());
            }
        });
        JPanel p1 = new JPanel(new FlowLayout(0, 0, 3));
        p1.add(msg1);
        JPanel p2 = new JPanel(new FlowLayout(0, 0, 3));
        p2.add(msg2);
        JPanel p3 = new JPanel(new FlowLayout(0, 0, 3));
        p3.add(cb);
        JPanel box = new JPanel();
        box.setLayout(new BoxLayout(box, 1));
        box.add(p1);
        box.add(p2);
        box.add(p3);
        box.setBorder(BorderFactory.createEmptyBorder(0, 0, 11, 11));
        Window w = SwingUtilities.getWindowAncestor(this.getTextPane());
        int option = JOptionPane.showOptionDialog(w, new Object[]{box}, GlobalConstants.getFrameTitle(title), -1, 1, GlobalConstants.getImageIcon("about_32.gif"), new String[]{"\u7e2e\u5c0f\u3059\u308b", "\u53d6\u6d88\u3059"}, "\u7e2e\u5c0f\u3059\u308b");
        return option == 0;
    }

    private void showNoReaderMessage() {
        Window w = SwingUtilities.getWindowAncestor(this.getTextPane());
        JOptionPane.showMessageDialog(w, "\u9078\u629e\u3057\u305f\u753b\u50cf\u3092\u8aad\u3080\u3053\u3068\u304c\u3067\u304d\u308b\u30ea\u30fc\u30c0\u304c\u5b58\u5728\u3057\u307e\u305b\u3093\u3002", GlobalConstants.getFrameTitle("\u753b\u50cf\u30a4\u30f3\u30dd\u30fc\u30c8"), 2);
    }

    public void imageEntryDropped(final ImageEntry entry) {
        int width = entry.getWidth();
        int height = entry.getHeight();
        int maxImageWidth = 522;
        int maxImageHeight = 522;
        Preferences pref = Preferences.userNodeForPackage(this.getClass());
        boolean ok = true;
        if (width == 0 || height == 0) {
            ImageIcon icon = entry.getImageIcon();
            width = icon.getIconWidth();
            height = icon.getIconHeight();
            if ((width > maxImageWidth || height > maxImageHeight) && pref.getBoolean("showImageSizeMessage", true)) {
                ok = this.showMaxSizeMessage();
            }
        } else if ((width > maxImageWidth || height > maxImageHeight) && pref.getBoolean("showImageSizeMessage", true)) {
            ok = this.showMaxSizeMessage();
        }
        if (!ok) {
            return;
        }
        DBTask<ImageIcon> task = new DBTask<ImageIcon>(this.parent.getParentContext()){

            @Override
            protected ImageIcon doInBackground() throws Exception {
                URL url = new URL(entry.getUrl());
                BufferedImage importImage = ImageIO.read(url);
                int width = importImage.getWidth();
                int height = importImage.getHeight();
                int maxImageWidth = 522;
                int maxImageHeight = 522;
                if (width > maxImageWidth || height > maxImageHeight) {
                    importImage = ImageHelper.getFirstScaledInstance(importImage, maxImageWidth);
                }
                return new ImageIcon(importImage);
            }

            @Override
            public void succeeded(ImageIcon icon) {
                if (icon != null) {
                    SchemaModel schema = new SchemaModel();
                    schema.setIcon(icon);
                    ExtRefModel ref = new ExtRefModel();
                    ref.setContentType("image/jpeg");
                    ref.setTitle("Schema Image");
                    schema.setExtRef(ref);
                    KartePane.this.stampId++;
                    String fileName = KartePane.this.getDocId() + "-" + KartePane.this.stampId + ".jpg";
                    schema.setFileName(fileName);
                    ref.setHref(fileName);
                    ArrayList<SchemaEditorImpl> loader = new ArrayList<SchemaEditorImpl>();
                    loader.add(new SchemaEditorImpl());
                    Iterator iter = loader.iterator();
                    if (iter.hasNext()) {
                        final SchemaEditorImpl editor = (SchemaEditorImpl)iter.next();
                        editor.setSchema(schema);
                        editor.setEditable(true);
                        editor.addPropertyChangeListener(KartePane.this);
                        Runnable awt = new Runnable(){

                            @Override
                            public void run() {
                                editor.start();
                            }
                        };
                        EventQueue.invokeLater(awt);
                    }
                }
            }
        };
        task.execute();
    }

    public void insertImage(String path) {
        if (path == null) {
            return;
        }
        String suffix = path.toLowerCase();
        int index = suffix.lastIndexOf(46);
        if (index == 0) {
            this.showNoReaderMessage();
            return;
        }
        Iterator<ImageReader> readers = ImageIO.getImageReadersBySuffix(suffix = suffix.substring(index + 1));
        if (!readers.hasNext()) {
            this.showNoReaderMessage();
            return;
        }
        ImageReader reader = readers.next();
        int width = 0;
        int height = 0;
        String name = null;
        try {
            File file = new File(path);
            name = file.getName();
            reader.setInput(new FileImageInputStream(file), true);
            width = reader.getWidth(0);
            height = reader.getHeight(0);
        }
        catch (Exception e) {
            LogWriter.error(KartePane.class, e.getMessage());
            return;
        }
        reader = null;
        ImageEntry entry = new ImageEntry();
        entry.setPath(path);
        entry.setFileName(name);
        entry.setNumImages(1);
        entry.setWidth(width);
        entry.setHeight(height);
        this.imageEntryDropped(entry);
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        Object o;
        String prop = e.getPropertyName();
        if (prop.equals("imageProp")) {
            SchemaModel schema = (SchemaModel)e.getNewValue();
            if (schema != null) {
                this.stampSchema(schema);
            }
        } else if (prop.equals("value") && (o = e.getNewValue()) != null) {
            ModuleModel stamp = (ModuleModel)o;
            this.stamp(stamp);
        }
    }

    protected boolean canPaste() {
        boolean ret = false;
        Transferable t = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(null);
        if (t == null) {
            return false;
        }
        if (t.isDataFlavorSupported(DataFlavor.stringFlavor)) {
            return true;
        }
        if (this.getMyRole().equals("p")) {
            if (t.isDataFlavorSupported(OrderListTransferable.orderListFlavor)) {
                ret = true;
            }
        } else if (t.isDataFlavorSupported(StampListTransferable.stampListFlavor) || t.isDataFlavorSupported(SchemaListTransferable.schemaListFlavor)) {
            ret = true;
        }
        return ret;
    }

    public void removeStamp(StampHolder sh) {
        this.getDocument().removeStamp(sh.getStartPos(), 2);
    }

    public void removeStamp(StampHolder[] sh) {
        if (sh != null && sh.length > 0) {
            for (int i = 0; i < sh.length; ++i) {
                this.removeStamp(sh[i]);
            }
        }
    }

    public void removeSchema(SchemaHolder sh) {
        this.getDocument().removeStamp(sh.getStartPos(), 2);
    }

    public void removeSchema(SchemaHolder[] sh) {
        if (sh != null && sh.length > 0) {
            for (int i = 0; i < sh.length; ++i) {
                this.removeSchema(sh[i]);
            }
        }
    }
}

