/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.client;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Collection;
import java.util.GregorianCalendar;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import open.dolphin.client.CalendarTableModel;
import open.dolphin.infomodel.SimpleDate;
import open.dolphin.project.GlobalSettings;

public class LiteCalendarPanel
extends JPanel
implements PropertyChangeListener {
    private static final long serialVersionUID = -3472737594106311587L;
    public static final String SELECTED_DATE_PROP = "selectedDateProp";
    public static final String MARK_LIST_PROP = "markListProp";
    private static final int TITLE_ALIGN = 0;
    private static final int TITLE_FONT_SIZE = 14;
    private static final Font TITLE_FONT = new Font("Dialog", 0, 14);
    private static final Font CALENDAR_FONT = new Font("Dialog", 0, 12);
    private static final Font OUTOF_MONTH_FONT = new Font("Dialog", 0, 9);
    private int relativeMonth;
    private int year;
    private int month;
    private CalendarTableModel tableModel;
    private PropertyChangeSupport boundSupport;
    private Object selectedDate;
    private JLabel titleLabel;
    private SimpleDate today;
    private Color titleFore = GlobalSettings.getColors(GlobalSettings.Parts.CALENDAR_TITLE_FORE);
    private Color titleBack = GlobalSettings.getColors(GlobalSettings.Parts.CALENDAR_TITLE_BACK);
    private int titleAlign = 0;
    private Font titleFont = TITLE_FONT;
    private int cellWidth = 27;
    private int cellHeight = 18;
    private int autoResizeMode = 4;
    private boolean cellSelectionEnabled = true;
    private Color sundayFore = GlobalSettings.getColors(GlobalSettings.Parts.SUNDAY_FORE);
    private Color saturdayFore = GlobalSettings.getColors(GlobalSettings.Parts.SATURDAY_FORE);
    private Color weekdayFore = GlobalSettings.getColors(GlobalSettings.Parts.WEEKDAY_FORE);
    private Color outOfMothFore = GlobalSettings.getColors(GlobalSettings.Parts.OUTOFMONTH_FORE);
    private Color calendarBack = GlobalSettings.getColors(GlobalSettings.Parts.CALENDAR_BACK);
    private Color todayBack = GlobalSettings.getColors(GlobalSettings.Parts.TODAY_BACK);
    private Color birthdayBack = GlobalSettings.getColors(GlobalSettings.Parts.BIRTHDAY_BACK);
    private Font calendarFont = CALENDAR_FONT;
    private Font outOfMonthFont = OUTOF_MONTH_FONT;
    private JScrollPane jScrollPane1;
    private JTable table;

    public LiteCalendarPanel() {
        this.initComponents();
    }

    public LiteCalendarPanel(int n, boolean addTitle, Map<String, Color> colorTable) {
        this.initComponents();
        this.relativeMonth = n;
        GregorianCalendar gc = new GregorianCalendar();
        gc.clear(14);
        gc.clear(13);
        gc.clear(12);
        gc.clear(11);
        gc.add(2, this.relativeMonth);
        this.year = gc.get(1);
        this.month = gc.get(2);
        this.tableModel = new CalendarTableModel(this.year, this.month);
        this.table.setModel(this.tableModel);
        this.setAutoResizeMode(this.autoResizeMode);
        this.table.setBackground(this.calendarBack);
        this.table.setSelectionMode(0);
        this.setCellSelectionEnabled(this.cellSelectionEnabled);
        this.setCellWidth(this.cellWidth);
        this.setCellHeight(this.cellHeight);
        DateRenderer dateRenderer = new DateRenderer(colorTable);
        dateRenderer.setHorizontalAlignment(4);
        this.table.setDefaultRenderer(Object.class, dateRenderer);
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() != 1) {
                    return;
                }
                Point p = e.getPoint();
                int row = LiteCalendarPanel.this.table.rowAtPoint(p);
                int col = LiteCalendarPanel.this.table.columnAtPoint(p);
                if (row != -1 && col != -1) {
                    SimpleDate o = LiteCalendarPanel.this.tableModel.getDate(row, col);
                    LiteCalendarPanel.this.setSelectedDate(o);
                }
            }
        });
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)this.table.getTableHeader(), "North");
        panel.add((Component)this.table, "Center");
        this.setTitleLabel(String.format("%04d\u5e74%02d\u6708", this.year, this.month + 1));
        this.setTitleAlign(this.titleAlign);
        this.setTitleFont(this.titleFont);
        this.setTitleFore(this.titleFore);
        this.setTitleBack(this.titleBack);
        this.getTitleLabel().setOpaque(true);
        this.setLayout(new BorderLayout());
        if (addTitle) {
            this.add((Component)this.getTitleLabel(), "North");
        }
        this.add((Component)panel, "Center");
        this.setBorder(BorderFactory.createEtchedBorder());
        this.boundSupport = new PropertyChangeSupport(this);
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.table = new JTable();
        this.jScrollPane1.setName("jScrollPane1");
        this.table.setModel(new DefaultTableModel(new Object[][]{{"1", "1", "1", "1", "1", "1", "1"}, {"1", "1", "1", "1", "1", "1", "1"}, {"1", "1", "1", "1", "1", "1", "1"}, {"1", "1", "1", "1", "1", "1", "1"}, {"1", "1", "1", "1", "1", "1", "1"}}, new String[]{"\u65e5", "\u6708", "\u706b", "\u6c34", "\u6728", "\u91d1", "\u571f"}){
            Class[] types;
            {
                this.types = new Class[]{String.class, String.class, String.class, String.class, String.class, String.class, String.class};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }
        });
        this.table.setName("table");
        this.jScrollPane1.setViewportView(this.table);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -2, 375, -2).addContainerGap(13, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -2, 275, -2).addContainerGap(13, Short.MAX_VALUE)));
    }

    public int getYear() {
        return this.year;
    }

    public int getMonth() {
        return this.month;
    }

    @Override
    public void addPropertyChangeListener(String prop, PropertyChangeListener l) {
        if (this.boundSupport == null) {
            this.boundSupport = new PropertyChangeSupport(this);
        }
        this.boundSupport.addPropertyChangeListener(prop, l);
    }

    @Override
    public void removePropertyChangeListener(String prop, PropertyChangeListener l) {
        if (this.boundSupport == null) {
            this.boundSupport = new PropertyChangeSupport(this);
        }
        this.boundSupport.removePropertyChangeListener(prop, l);
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        String prop = e.getPropertyName();
        if (prop.equals(MARK_LIST_PROP)) {
            Collection list = (Collection)e.getNewValue();
            this.tableModel.setMarkDates(list);
        }
    }

    public void setSelectedDate(Object o) {
        Object old = this.selectedDate;
        this.selectedDate = o;
        if (this.selectedDate instanceof String) {
            SimpleDate sd = new SimpleDate(this.getYear(), this.getMonth(), Integer.parseInt((String)this.selectedDate));
            this.selectedDate = sd;
        }
        this.boundSupport.firePropertyChange(SELECTED_DATE_PROP, old, this.selectedDate);
    }

    public JTable getTable() {
        return this.table;
    }

    public CalendarTableModel getTableModel() {
        return this.tableModel;
    }

    public int getRelativeMonth() {
        return this.relativeMonth;
    }

    public SimpleDate getFirstDate() {
        return this.tableModel.getFirstDate();
    }

    public SimpleDate getLastDate() {
        return this.tableModel.getLastDate();
    }

    public void setTitleFore(Color titleFore) {
        this.titleFore = titleFore;
        this.getTitleLabel().setForeground(titleFore);
    }

    public Color getTitleFore() {
        return this.titleFore;
    }

    private void setTitleBack(Color titleBack) {
        this.titleBack = titleBack;
        this.getTitleLabel().setBackground(titleBack);
    }

    private void setTitleAlign(int titleAlign) {
        this.titleAlign = titleAlign;
        this.getTitleLabel().setHorizontalAlignment(titleAlign);
    }

    private void setTitleFont(Font titleFont) {
        this.titleFont = titleFont;
        this.getTitleLabel().setFont(titleFont);
    }

    public void setCellWidth(int cellWidth) {
        this.cellWidth = cellWidth;
        TableColumn column = null;
        for (int i = 0; i < 7; ++i) {
            column = this.table.getColumnModel().getColumn(i);
            column.setPreferredWidth(cellWidth);
        }
    }

    public int getCellWidth() {
        return this.cellWidth;
    }

    public void setCellHeight(int cellHeight) {
        this.cellHeight = cellHeight;
        this.table.setRowHeight(cellHeight);
    }

    public int getCellHeight() {
        return this.cellHeight;
    }

    public void setAutoResizeMode(int mode) {
        this.autoResizeMode = mode;
    }

    public int getAutoResizeMode() {
        return this.autoResizeMode;
    }

    public void setCellSelectionEnabled(boolean cellSelectionEnabled) {
        this.cellSelectionEnabled = cellSelectionEnabled;
    }

    public boolean isCellSelectionEnabled() {
        return this.cellSelectionEnabled;
    }

    public void setSundayFore(Color sundayFore) {
        this.sundayFore = sundayFore;
    }

    public Color getSundayFore() {
        return this.sundayFore;
    }

    public void setSaturdayFore(Color saturdayFore) {
        this.saturdayFore = saturdayFore;
    }

    public Color getSaturdayFore() {
        return this.saturdayFore;
    }

    public void setWeekdayFore(Color weekdayFore) {
        this.weekdayFore = weekdayFore;
    }

    public Color getWeekdayFore() {
        return this.weekdayFore;
    }

    public void setOutOfMothFore(Color outOfMothFore) {
        this.outOfMothFore = outOfMothFore;
    }

    public Color getOutOfMothFore() {
        return this.outOfMothFore;
    }

    public void setCalendarBack(Color calendarBack) {
        this.calendarBack = calendarBack;
    }

    public Color getCalendarBack() {
        return this.calendarBack;
    }

    public void setTodayBack(Color todayBack) {
        this.todayBack = todayBack;
    }

    public Color getTodayBack() {
        return this.todayBack;
    }

    public void setBirthdayBack(Color birthdayBack) {
        this.birthdayBack = birthdayBack;
    }

    public Color getBirthdayBack() {
        return this.birthdayBack;
    }

    public void setCalendarFont(Font calendarFont) {
        this.calendarFont = calendarFont;
    }

    public Font getCalendarFont() {
        return this.calendarFont;
    }

    public void setOutOfMonthFont(Font outOfMonthFont) {
        this.outOfMonthFont = outOfMonthFont;
    }

    public Font getOutOfMonthFont() {
        return this.outOfMonthFont;
    }

    public void setToday(SimpleDate today) {
        this.today = today;
    }

    public void setTitleLabel(JLabel titleLabel) {
        this.titleLabel = titleLabel;
    }

    public JLabel getTitleLabel() {
        return this.titleLabel;
    }

    private void setTitleLabel(String labelText) {
        this.setTitleLabel(new JLabel(labelText));
    }

    protected class DateRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 5817292848730765481L;
        Map<String, Color> event;

        public DateRenderer(Map<String, Color> eventColorTable) {
            this.setOpaque(true);
            this.setHorizontalAlignment(4);
            this.event = eventColorTable;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean isFocused, int row, int col) {
            Component compo = super.getTableCellRendererComponent(table, value, isSelected, isFocused, row, col);
            if (compo != null && value != null) {
                String day = null;
                Color color = null;
                if (value instanceof SimpleDate) {
                    day = ((SimpleDate)value).toString();
                    color = LiteCalendarPanel.this.today != null && LiteCalendarPanel.this.today.compareTo((SimpleDate)value) == 0 ? this.event.get("TODAY") : this.event.get(((SimpleDate)value).getEventCode());
                } else if (value instanceof String) {
                    day = (String)value;
                    color = LiteCalendarPanel.this.today != null && LiteCalendarPanel.this.today.equalDate(LiteCalendarPanel.this.year, LiteCalendarPanel.this.month, Integer.parseInt(day)) ? this.event.get("TODAY") : LiteCalendarPanel.this.getCalendarBack();
                }
                ((JLabel)compo).setText(day);
                if (col == 0) {
                    this.setForeground(LiteCalendarPanel.this.getSundayFore());
                } else if (col == 6) {
                    this.setForeground(LiteCalendarPanel.this.getSaturdayFore());
                } else {
                    this.setForeground(LiteCalendarPanel.this.getWeekdayFore());
                }
                if (LiteCalendarPanel.this.tableModel.isOutOfMonth(row, col)) {
                    this.setFont(LiteCalendarPanel.this.getOutOfMonthFont());
                    this.setBackground(LiteCalendarPanel.this.getCalendarBack());
                } else {
                    this.setFont(LiteCalendarPanel.this.getCalendarFont());
                    this.setBackground(color);
                }
            }
            return compo;
        }
    }
}

