/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.client;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.security.auth.login.LoginException;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import open.dolphin.client.AutoRomanListener;
import open.dolphin.client.BlockGlass;
import open.dolphin.client.settings.ProjectSettingDialog;
import open.dolphin.delegater.remote.RemoteUserDelegater;
import open.dolphin.helper.PlugInMenuSupport;
import open.dolphin.infomodel.UserModel;
import open.dolphin.log.LogWriter;
import open.dolphin.plugin.IPlugin;
import open.dolphin.plugin.PluginWrapper;
import open.dolphin.project.DolphinPrincipal;
import open.dolphin.project.GlobalConstants;
import open.dolphin.project.GlobalSettings;
import open.dolphin.project.GlobalVariables;
import open.socket.data.Command;
import open.socket.data.RequestObject;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationContext;
import org.jdesktop.application.Task;
import org.jdesktop.application.TaskMonitor;
import org.jdesktop.layout.GroupLayout;

public class LoginDialog
extends JDialog {
    private BlockGlass blockGlass;
    private RemoteUserDelegater userDlg;
    private int tryCount;
    private int maxTryCount;
    private LoginStatus result;
    private PropertyChangeSupport boundSupport;
    private DolphinPrincipal principal;
    private StateMgr stateMgr;
    private ApplicationContext context;
    private PlugInMenuSupport plugins;
    private JButton cancelBtn;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JButton loginBtn;
    private JPasswordField passwordField;
    private JProgressBar progressBar;
    private JButton settingBtn;
    private JLabel stLabel;
    private JTextField userIdField;

    public LoginDialog(Frame parent, boolean modal, PlugInMenuSupport plugins) {
        super(parent, modal);
        this.plugins = plugins;
        this.boundSupport = new PropertyChangeSupport(this);
        this.initComponents();
        this.progressBar.setVisible(false);
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jPanel1 = new JPanel();
        this.jPanel2 = new JPanel();
        this.jLabel2 = new JLabel();
        this.userIdField = new JTextField();
        this.jLabel3 = new JLabel();
        this.passwordField = new JPasswordField();
        this.progressBar = new JProgressBar();
        this.stLabel = new JLabel();
        this.jPanel3 = new JPanel();
        this.settingBtn = new JButton();
        this.cancelBtn = new JButton();
        this.loginBtn = new JButton();
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        this.jLabel1.setIcon(new ImageIcon(this.getClass().getResource("/open/dolphin/resources/images/opendolphin2.JPG")));
        this.jLabel1.setText("jLabel1");
        this.jPanel2.setLayout(new GridLayout(3, 2));
        this.jLabel2.setHorizontalAlignment(4);
        this.jLabel2.setText("\u30e6\u30fc\u30b6ID\uff1a");
        this.jPanel2.add(this.jLabel2);
        this.jPanel2.add(this.userIdField);
        this.jLabel3.setHorizontalAlignment(4);
        this.jLabel3.setText("\u30d1\u30b9\u30ef\u30fc\u30c9\uff1a");
        this.jPanel2.add(this.jLabel3);
        this.jPanel2.add(this.passwordField);
        this.jPanel2.add(this.progressBar);
        this.jPanel2.add(this.stLabel);
        this.jPanel3.setLayout(new GridLayout(1, 0));
        this.settingBtn.setText("\u8a2d \u5b9a");
        this.jPanel3.add(this.settingBtn);
        this.cancelBtn.setText("\u53d6\u6d88\u3057");
        this.jPanel3.add(this.cancelBtn);
        this.loginBtn.setText("\u30ed\u30b0\u30a4\u30f3");
        this.loginBtn.setEnabled(false);
        this.jPanel3.add(this.loginBtn);
        GroupLayout jPanel1Layout = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)jPanel1Layout);
        jPanel1Layout.setHorizontalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((Component)this.jPanel3, -2, 280, -2).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((Component)this.jPanel2, -1, 280, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap(86, Short.MAX_VALUE).add((Component)this.jPanel3, -2, 31, -2)).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((Component)this.jPanel2, -2, 70, -2).addContainerGap(47, Short.MAX_VALUE))));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel1, -2, 350, -2).add(18, 18, 18).add((Component)this.jPanel1, -2, -1, -2).addContainerGap(23, Short.MAX_VALUE)));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add(10, 10, 10).add((Component)this.jPanel1, -2, -1, -2)).add((Component)this.jLabel1, -2, 150, -2));
        this.pack();
    }

    @Override
    public void addPropertyChangeListener(String prop, PropertyChangeListener listener) {
        this.boundSupport.addPropertyChangeListener(prop, listener);
    }

    @Override
    public void removePropertyChangeListener(String prop, PropertyChangeListener listener) {
        this.boundSupport.addPropertyChangeListener(prop, listener);
    }

    public void start() {
        this.principal = new DolphinPrincipal();
        if (GlobalVariables.isValid()) {
            this.principal.setFacilityId(GlobalVariables.getFacilityId());
            this.principal.setUserId(GlobalVariables.getUserId());
        }
        this.initCustomComponents();
        this.bindModelToView();
        int width = this.getWidth();
        int height = this.getHeight();
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        int n = GlobalConstants.isMac() ? 3 : 2;
        int left = (screen.width - width) / 2;
        int top = (screen.height - height) / n;
        this.setLocation(left, top);
        this.setVisible(true);
    }

    public LoginStatus getResult() {
        return this.result;
    }

    private void notifyResult(final LoginStatus ret) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                LoginDialog.this.boundSupport.firePropertyChange("LOGIN_PROP", (Object)-100, (Object)ret);
            }
        });
    }

    public void tryLogin() {
        this.stLabel.setText("\u73fe\u5728\u30ed\u30b0\u30a4\u30f3\u4e2d\u3067\u3059.");
        if (this.userDlg == null) {
            this.userDlg = new RemoteUserDelegater();
        }
        if (this.maxTryCount == 0) {
            this.maxTryCount = 5;
        }
        ++this.tryCount;
        this.bindViewToModel();
        final String password = new String(this.passwordField.getPassword());
        ApplicationContext appCtx = GlobalConstants.getApplicationContext();
        Application app = appCtx.getApplication();
        Task<UserModel, Void> task = new Task<UserModel, Void>(app){

            protected UserModel doInBackground() throws Exception {
                UserModel userModel = LoginDialog.this.userDlg.login(LoginDialog.this.principal, password);
                if (!LoginDialog.this.onLogin(userModel)) {
                    throw new LoginException();
                }
                return userModel;
            }

            protected void succeeded(UserModel userModel) {
                if (userModel != null) {
                    GlobalVariables.setUserId(LoginDialog.this.principal.getUserId());
                    GlobalVariables.setUserModel(userModel);
                    GlobalVariables.setDolphinPrincipal(LoginDialog.this.principal);
                    LoginDialog.this.result = LoginStatus.AUTHENTICATED;
                    LoginDialog.this.notifyClose(LoginDialog.this.result);
                }
            }

            protected void cancelled() {
            }

            protected void failed(Throwable cause) {
                LoginDialog.this.stLabel.setText("  ");
                if (LoginDialog.this.tryCount <= LoginDialog.this.maxTryCount && cause instanceof Exception) {
                    LoginDialog.this.userDlg.dispatchError(((Object)((Object)this)).getClass(), (Exception)cause, "");
                    String errMsg = LoginDialog.this.userDlg.getErrorMessage();
                    LoginDialog.this.showMessageDialog(errMsg);
                } else {
                    LoginDialog.this.showMessageDialog("\u30ed\u30b0\u30a4\u30f3\u56de\u6570\u304c\u4e0a\u9650\u306b\u9054\u3057\u305f\u305f\u3081\u30ed\u30b0\u30a4\u30f3\u30d7\u30ed\u30bb\u30b9\u3092\u7d42\u4e86\u3057\u307e\u3059\u3002");
                    LoginDialog.this.result = LoginStatus.NOT_AUTHENTICATED;
                    LoginDialog.this.notifyClose(LoginDialog.this.result);
                }
            }

            protected void interrupted(InterruptedException e) {
            }
        };
        final TaskMonitor taskMonitor = appCtx.getTaskMonitor();
        taskMonitor.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                String propertyName = e.getPropertyName();
                if ("started".equals(propertyName)) {
                    LoginDialog.this.setBusy(true);
                } else if ("done".equals(propertyName)) {
                    LoginDialog.this.setBusy(false);
                    taskMonitor.removePropertyChangeListener((PropertyChangeListener)this);
                }
            }
        });
        appCtx.getTaskService().execute((Task)task);
    }

    private boolean onLogin(UserModel userModel) {
        try {
            for (IPlugin plugin : this.plugins.values()) {
                PluginWrapper pluginWrapper = new PluginWrapper(plugin);
                RequestObject request = new RequestObject();
                request.setUserId(userModel.getId());
                request.setUserName(userModel.getSirName());
                request.setCommand(Command.LOGIN);
                Object responce = pluginWrapper.message(request);
                if (responce == null || !pluginWrapper.IsDispatched()) continue;
                pluginWrapper.update((Object)this.result);
                return true;
            }
        }
        catch (Exception e) {
            LogWriter.error(this.getClass(), e);
        }
        return true;
    }

    private void setBusy(boolean busy) {
        if (busy) {
            this.blockGlass.block();
            this.userIdField.setEnabled(false);
            this.passwordField.setEnabled(false);
            this.settingBtn.setEnabled(false);
            this.loginBtn.setEnabled(false);
            this.cancelBtn.setEnabled(false);
        } else {
            this.userIdField.setEnabled(true);
            this.passwordField.setEnabled(true);
            this.settingBtn.setEnabled(true);
            this.loginBtn.setEnabled(true);
            this.cancelBtn.setEnabled(true);
            this.blockGlass.unblock();
        }
    }

    private void showMessageDialog(String msg) {
        String title = this.getTitle();
        JOptionPane.showMessageDialog(null, msg, title, 2);
    }

    private void notifyClose(LoginStatus result) {
        this.setVisible(false);
        this.dispose();
        this.notifyResult(result);
    }

    private void initCustomComponents() {
        if (GlobalSettings.isTrial()) {
            this.setTitle("\u30ed\u30b0\u30a4\u30f3-OpenDolphin-1.9");
        } else {
            this.setTitle("\u30ed\u30b0\u30a4\u30f3-OpenDolphin-1.9.2.1a");
        }
        this.getRootPane().setDefaultButton(this.loginBtn);
        this.blockGlass = new BlockGlass();
        this.setGlassPane(this.blockGlass);
        this.connect();
    }

    private void connect() {
        this.stateMgr = new StateMgr();
        DocumentListener dl = new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                LoginDialog.this.stateMgr.checkButtons();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                LoginDialog.this.stateMgr.checkButtons();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                LoginDialog.this.stateMgr.checkButtons();
            }
        };
        this.userIdField.getDocument().addDocumentListener(dl);
        this.userIdField.addFocusListener(AutoRomanListener.getInstance());
        this.userIdField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoginDialog.this.stateMgr.onUserIdAction();
            }
        });
        DocumentListener d2 = new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                LoginDialog.this.stateMgr.checkButtons();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                LoginDialog.this.stateMgr.checkButtons();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                LoginDialog.this.stateMgr.checkButtons();
            }
        };
        this.passwordField.getDocument().addDocumentListener(d2);
        this.passwordField.addFocusListener(AutoRomanListener.getInstance());
        this.passwordField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoginDialog.this.stateMgr.onPasswordAction();
            }
        });
        this.settingBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoginDialog.this.doSettingDialog();
            }
        });
        this.cancelBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoginDialog.this.doCancel();
            }
        });
        this.loginBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoginDialog.this.tryLogin();
            }
        });
        this.loginBtn.setEnabled(false);
        this.addWindowListener(this.stateMgr);
    }

    private void bindModelToView() {
        if (this.principal.getUserId() != null && !this.principal.getUserId().equals("")) {
            this.userIdField.setText(this.principal.getUserId());
        }
    }

    private void bindViewToModel() {
        String id = this.userIdField.getText().trim();
        if (!id.equals("")) {
            this.principal.setUserId(id);
        }
    }

    public void doSettingDialog() {
        this.blockGlass.block();
        ProjectSettingDialog sd = new ProjectSettingDialog(this.plugins);
        PropertyChangeListener pl = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                LoginDialog.this.setNewParams((Boolean)evt.getNewValue());
            }
        };
        sd.addPropertyChangeListener("SETTING_PROP", pl);
        sd.setLoginState(false);
        sd.start();
    }

    public void setNewParams(Boolean newValue) {
        this.blockGlass.unblock();
        boolean valid = newValue;
        if (valid) {
            this.principal.setUserId(GlobalVariables.getUserId());
            this.principal.setFacilityId(GlobalVariables.getFacilityId());
            this.bindModelToView();
            this.passwordField.requestFocus();
        }
    }

    public void doCancel() {
        this.setVisible(false);
        this.dispose();
        this.result = LoginStatus.CANCELD;
        this.notifyResult(this.result);
    }

    class StateMgr
    extends WindowAdapter {
        public void checkButtons() {
            boolean passwdEmpty;
            boolean userEmpty = LoginDialog.this.userIdField.getText().length() == 0;
            boolean bl = passwdEmpty = LoginDialog.this.passwordField.getPassword().length == 0;
            if (!userEmpty && !passwdEmpty) {
                LoginDialog.this.loginBtn.setEnabled(true);
            } else {
                LoginDialog.this.loginBtn.setEnabled(false);
            }
        }

        public void onUserIdAction() {
            if (LoginDialog.this.userIdField.getText().length() != 0) {
                if (LoginDialog.this.passwordField.getPassword().length == 0) {
                    LoginDialog.this.passwordField.requestFocus();
                } else {
                    LoginDialog.this.loginBtn.doClick();
                }
            }
        }

        public void onPasswordAction() {
            if (LoginDialog.this.userIdField.getText().equals("")) {
                LoginDialog.this.userIdField.requestFocus();
            } else if (LoginDialog.this.passwordField.getPassword().length != 0) {
                LoginDialog.this.loginBtn.doClick();
            }
        }

        @Override
        public void windowClosing(WindowEvent e) {
            LoginDialog.this.doCancel();
        }

        @Override
        public void windowOpened(WindowEvent e) {
            if (!LoginDialog.this.userIdField.getText().trim().equals("")) {
                LoginDialog.this.passwordField.requestFocus();
            }
        }
    }

    public static enum LoginStatus {
        AUTHENTICATED,
        NOT_AUTHENTICATED,
        CANCELD;

    }
}

