/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.dao;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import open.dolphin.dao.DaoBean;
import open.dolphin.log.LogWriter;
import open.dolphin.project.GlobalVariables;

public class SqlDaoBean
extends DaoBean {
    private static final String DRIVER = "org.postgresql.Driver";
    private static final int PORT = 5432;
    private static final String DATABASE = "orca";
    private static final String USER = "orca";
    private static final String PASSWD = "";
    String dataBase;
    String driver;
    boolean trace = true;
    protected static final String ORCA_DB_VER45 = "040500-1";
    protected static final String ORCA_DB_VER46 = "040600-1";
    protected static final String ORCA_DB_VER47 = "040700-1";
    protected static final String ORCA_DB_VER48 = "040800-1";
    private static int hospNum;
    private static String dbVersion;

    public SqlDaoBean() {
        this.setDriver(DRIVER);
        this.setHost(GlobalVariables.getClaimAddress());
        this.setPort(5432);
        this.setDatabase("orca");
        this.setUser("orca");
        this.setPasswd(PASSWD);
        this.setHospNumFromOrca();
    }

    protected String getOrcaDbVersion() {
        return dbVersion;
    }

    protected int getHospNumFromOrca() {
        return hospNum;
    }

    protected void setHospNumFromOrca() {
        ResultSet rs;
        if (dbVersion != null) {
            return;
        }
        Connection con = null;
        Statement st = null;
        hospNum = 1;
        String jmari = GlobalVariables.getJMARICode();
        StringBuilder sb = new StringBuilder();
        sb.append("select hospnum, kanritbl from tbl_syskanri where kanricd='1001' and kanritbl like '%");
        sb.append(jmari);
        sb.append("%'");
        String sql = sb.toString();
        try {
            con = this.getConnection();
            st = con.createStatement();
            rs = st.executeQuery(sql);
            if (rs.next()) {
                hospNum = rs.getInt(1);
            }
        }
        catch (Exception e) {
            this.processError(e);
            this.closeConnection(con);
            this.closeStatement(st);
        }
        sql = "select version from tbl_dbkanri where kanricd='ORCADB00'";
        try {
            con = this.getConnection();
            st = con.createStatement();
            rs = st.executeQuery(sql);
            if (rs.next()) {
                dbVersion = rs.getString(1);
            }
        }
        catch (Exception e) {
            this.processError(e);
            this.closeConnection(con);
            this.closeStatement(st);
        }
    }

    public String getDriver() {
        return this.driver;
    }

    public void setDriver(String driver) {
        this.driver = driver;
        try {
            Class.forName(driver);
        }
        catch (ClassNotFoundException cnfe) {
            LogWriter.error(this.getClass(), cnfe);
        }
    }

    public String getDatabase() {
        return this.dataBase;
    }

    public void setDatabase(String base) {
        this.dataBase = base;
    }

    protected String getURL() {
        StringBuffer buf = new StringBuffer();
        buf.append("jdbc:postgresql://");
        buf.append(this.host);
        buf.append(":");
        buf.append(this.port);
        buf.append("/");
        buf.append(this.dataBase);
        return buf.toString();
    }

    public boolean getTrace() {
        return this.trace;
    }

    public void setTrace(boolean b) {
        this.trace = b;
    }

    public Connection getConnection() throws Exception {
        return DriverManager.getConnection(this.getURL(), this.user, this.passwd);
    }

    public String addSingleQuote(String s) {
        StringBuilder buf = new StringBuilder();
        buf.append("'");
        buf.append(s);
        buf.append("'");
        return buf.toString();
    }

    public String addSingleQuoteComa(String s) {
        StringBuilder buf = new StringBuilder();
        buf.append("'");
        buf.append(s);
        buf.append("',");
        return buf.toString();
    }

    public void closeStatement(Statement st) {
        if (st != null) {
            try {
                st.close();
            }
            catch (SQLException e) {
                LogWriter.error(this.getClass(), e);
            }
        }
    }

    public void closeConnection(Connection con) {
        if (con != null) {
            try {
                con.close();
            }
            catch (SQLException e) {
                LogWriter.error(this.getClass(), e);
            }
        }
    }
}

