/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.dao;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import open.dolphin.dao.SqlDaoBean;
import open.dolphin.infomodel.DiseaseEntry;
import open.dolphin.log.LogWriter;
import open.dolphin.order.ClaimConst;
import open.dolphin.utils.StringTool;

public final class SqlDiseaseMasterDao
extends SqlDaoBean {
    private int totalCount;
    private static final String CODE_FILLER = "ZZZ";
    private static final String PREFIX_CODE1 = "ZZZ1";
    private static final String PREFIX_CODE2 = "ZZZ2";
    private static final String TYPE_CODE1 = "ZZZ3";
    private static final String TYPE_CODE2 = "ZZZ4";
    private static final String PART_CODE = "ZZZ7";
    private static final String POSTFIX_CODE = "ZZZ8";

    public int getTotalCount() {
        return this.totalCount;
    }

    public String toLongCode(String code) {
        if (code.length() == 4) {
            return CODE_FILLER + code;
        }
        return code;
    }

    public String getSerchClass(String code) {
        String longCode = this.toLongCode(code).substring(0, 4);
        if (longCode.equals(PREFIX_CODE1) || longCode.equals(PREFIX_CODE2)) {
            return ClaimConst.SubTypeSet.PREFIX.getName();
        }
        if (longCode.equals(TYPE_CODE1) || longCode.equals(TYPE_CODE2)) {
            return ClaimConst.SubTypeSet.TYPE.getName();
        }
        if (longCode.equals(PART_CODE)) {
            return ClaimConst.SubTypeSet.PART.getName();
        }
        if (longCode.equals(POSTFIX_CODE)) {
            return ClaimConst.SubTypeSet.POSTFIX.getName();
        }
        return "";
    }

    public List getByName(String master, String name, boolean startsWith, String serchClassCode, String sortBy, String order) {
        List<DiseaseEntry> results = null;
        if (master.equals(ClaimConst.MasterSet.DIAGNOSIS.getName())) {
            if (serchClassCode.equals("")) {
                results = StringTool.isAllDigit(name) ? this.getDiseaseByCode(name, startsWith, sortBy, order) : this.getDiseaseByName(name, startsWith, sortBy, order);
            } else if (serchClassCode.equals(ClaimConst.SubTypeSet.NAMES.getName())) {
                results = this.getDiseaseNames(name);
            } else if (serchClassCode.equals(ClaimConst.SubTypeSet.PREFIX.getName())) {
                results = this.getDiseasePrefixFromOrca(name, sortBy);
            } else if (serchClassCode.equals(ClaimConst.SubTypeSet.TYPE.getName())) {
                results = this.getDiseaseTypeFromOrca(name, sortBy);
            } else if (serchClassCode.equals(ClaimConst.SubTypeSet.PART.getName())) {
                results = this.getDiseasePartFromOrca(name, sortBy);
            } else if (serchClassCode.equals(ClaimConst.SubTypeSet.POSTFIX.getName())) {
                results = this.getDiseasePostfixFromOrca(name, sortBy);
            }
        } else {
            throw new RuntimeException("Unsupported master: " + master);
        }
        return results;
    }

    private List<DiseaseEntry> getDiseaseByName(String text, boolean startsWith, String sortBy, String order) {
        List<DiseaseEntry> result = null;
        String sql = null;
        if (!startsWith) {
            sql = this.buildDiseaseSql("byomei ~ ", text, sortBy, order, true);
            result = this.getDiseaseCollection(sql);
        }
        if (this.isNoError() && (result == null || result.size() == 0)) {
            sql = this.buildDiseaseSql("byomei ~ ", text, sortBy, order, false);
            result = this.getDiseaseCollection(sql);
        }
        return result;
    }

    private List<DiseaseEntry> getDiseaseByCode(String text, boolean startsWith, String sortBy, String order) {
        List<DiseaseEntry> ret = null;
        String sql = null;
        if (!startsWith) {
            sql = this.buildDiseaseSql("byomeicd ~ ", text, sortBy, order, true);
            ret = this.getDiseaseCollection(sql);
        }
        if (this.isNoError() && (ret == null || ret.size() == 0)) {
            sql = this.buildDiseaseSql("byomeicd ~ ", text, sortBy, order, true);
            ret = this.getDiseaseCollection(sql);
        }
        return ret;
    }

    private List<DiseaseEntry> getDiseaseNames(String text) {
        int end_index;
        ArrayList<DiseaseEntry> result = new ArrayList<DiseaseEntry>();
        String key = text;
        ArrayList<String> keyList = new ArrayList<String>();
        int start_index = 0;
        while (key.length() != 0 && (end_index = this.matchMostLongKeywordFromOrca(key)) != 0) {
            keyList.add(key.substring(start_index, end_index));
            key = key.substring(end_index, key.length());
        }
        for (String _key : keyList) {
            result.addAll(this.getDiseaseNameFromOrca(_key));
        }
        return result;
    }

    private int matchMostLongKeywordFromOrca(String text) {
        int index;
        List<DiseaseEntry> result = null;
        for (index = 0; index < text.length(); ++index) {
            String key = text.substring(0, index + 1);
            result = this.getDiseaseCollection("select byomeicd, byomei, byomeikana, icd10_1, haisiymd from tbl_byomei where byomei ~ '^" + key + "'");
            if (result.size() == 0) break;
        }
        return index;
    }

    private List<DiseaseEntry> getDiseaseNameFromOrca(String text) {
        return this.getDiseaseCollection("select byomeicd, byomei, byomeikana, icd10_1, haisiymd from tbl_byomei where byomei = '" + text + "'");
    }

    public List<DiseaseEntry> getDiseaseCodeFromOrca(String text) {
        return this.getDiseaseCollection("select byomeicd, byomei, byomeikana, icd10_1, haisiymd from tbl_byomei where byomeicd = '" + this.toLongCode(text) + "'");
    }

    private List<DiseaseEntry> getDiseasePrefixFromOrca(String text, String sortBy) {
        String order = "";
        if (!StringTool.isEmptyString(sortBy)) {
            order = " order by " + sortBy;
        }
        String query = "select byomeicd, byomei, byomeikana, icd10_1, haisiymd from tbl_byomei where byomeicd ~ '^ZZZ1' or byomeicd ~ '^ZZZ2'" + order;
        if (!StringTool.isEmptyString(text)) {
            query = "select byomeicd, byomei, byomeikana, icd10_1, haisiymd from tbl_byomei where (byomei ~ '" + text + "') and (byomeicd ~ '^" + PREFIX_CODE1 + "' or byomeicd ~ '^" + PREFIX_CODE2 + "')" + order;
        }
        return this.getDiseaseCollection(query);
    }

    private List<DiseaseEntry> getDiseaseTypeFromOrca(String text, String sortBy) {
        String order = "";
        if (!StringTool.isEmptyString(sortBy)) {
            order = " order by " + sortBy;
        }
        return this.getDiseaseCollection("select byomeicd, byomei, byomeikana, icd10_1, haisiymd from tbl_byomei where (byomei ~ '" + text + "') and (byomeicd ~ '^" + TYPE_CODE1 + "' or byomeicd ~ '^" + TYPE_CODE2 + "')" + order);
    }

    private List<DiseaseEntry> getDiseasePartFromOrca(String text, String sortBy) {
        String order = "";
        if (!StringTool.isEmptyString(sortBy)) {
            order = " order by " + sortBy;
        }
        return this.getDiseaseCollection("select byomeicd, byomei, byomeikana, icd10_1, haisiymd from tbl_byomei where (byomei ~ '" + text + "') and byomeicd ~ '^" + PART_CODE + "'" + order);
    }

    private List<DiseaseEntry> getDiseasePostfixFromOrca(String text, String sortBy) {
        String order = "";
        if (!StringTool.isEmptyString(sortBy)) {
            order = " order by " + sortBy;
        }
        return this.getDiseaseCollection("select byomeicd, byomei, byomeikana, icd10_1, haisiymd from tbl_byomei where (byomei ~ '" + text + "') and byomeicd ~ '^" + POSTFIX_CODE + "'" + order);
    }

    private String buildDiseaseSql(String field, String text, String sortBy, String order, boolean forward) {
        String word = null;
        StringBuilder buf = new StringBuilder();
        buf.append("select byomeicd, byomei, byomeikana, icd10_1, haisiymd from tbl_byomei where ");
        word = text;
        buf.append(field);
        if (forward) {
            buf.append(this.addSingleQuote("^" + word));
        } else {
            buf.append(this.addSingleQuote(word));
        }
        String orderBy = this.getOrderBy(sortBy, order);
        if (orderBy == null) {
            orderBy = " order by byomeikana";
        }
        buf.append(orderBy);
        String sql = buf.toString();
        return sql;
    }

    private List<DiseaseEntry> getDiseaseCollection(String sql) {
        try {
            Connection con = null;
            ArrayList<DiseaseEntry> collection = null;
            ArrayList<DiseaseEntry> outUse = null;
            Statement st = null;
            try {
                con = this.getConnection();
                st = con.createStatement();
                ResultSet rs = st.executeQuery(sql);
                DiseaseEntry de = null;
                collection = new ArrayList<DiseaseEntry>();
                outUse = new ArrayList<DiseaseEntry>();
                while (rs.next()) {
                    de = new DiseaseEntry();
                    de.setCode(rs.getString(1));
                    de.setName(rs.getString(2));
                    de.setKana(rs.getString(3));
                    de.setIcdTen(rs.getString(4));
                    de.setDisUseDate(rs.getString(5));
                    if (de.isInUse()) {
                        collection.add(de);
                        continue;
                    }
                    outUse.add(de);
                }
                rs.close();
                collection.addAll(outUse);
                this.closeStatement(st);
                this.closeConnection(con);
                return collection;
            }
            catch (Exception e) {
                this.processError(e);
                this.closeConnection(con);
                this.closeStatement(st);
            }
        }
        catch (Exception ex) {
            LogWriter.error(this.getClass(), ex);
        }
        return null;
    }

    private String getOrderBy(String sortBy, String order) {
        StringBuilder buf = null;
        if (sortBy != null) {
            buf = new StringBuilder();
            buf.append(" order by ");
            buf.append(sortBy);
        }
        if (order != null) {
            buf.append(" ");
            buf.append(order);
        }
        return buf != null ? buf.toString() : null;
    }
}

