/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import open.dolphin.dao.SqlDaoBean;
import open.dolphin.infomodel.BundleDolphin;
import open.dolphin.infomodel.BundleImage;
import open.dolphin.infomodel.BundleMed;
import open.dolphin.infomodel.ClaimItem;
import open.dolphin.infomodel.IStampInfo;
import open.dolphin.infomodel.ModuleInfoBean;
import open.dolphin.infomodel.ModuleModel;
import open.dolphin.infomodel.OrcaInputCd;
import open.dolphin.infomodel.OrcaInputSet;
import open.dolphin.infomodel.SinryoCode;
import open.dolphin.log.LogWriter;
import open.dolphin.order.MMLTable;
import open.dolphin.project.GlobalSettings;
import open.dolphin.project.GlobalVariables;

public class SqlOrcaSetDao
extends SqlDaoBean {
    private static final String DRIVER = "org.postgresql.Driver";
    private static final int PORT = 5432;
    private static final String DATABASE = "orca";
    private static final String USER = "orca";
    private static final String PASSWD = "";
    private static final String S_SET = "S";
    private static final String P_SET = "P";
    private static final String RP_KBN_START = "2";
    private static final String SHINRYO_KBN_START = ".";
    private static final int SHINRYO_KBN_LENGTH = 3;
    private static final String KBN_RP = "220";
    private static final String KBN_RAD = "700";
    private static final String KBN_GENERAL = "999";

    public SqlOrcaSetDao() {
        this.setDriver(DRIVER);
        this.setHost(GlobalVariables.getClaimAddress());
        if (GlobalSettings.isTrial()) {
            this.setPort(10329);
        } else {
            this.setPort(5432);
        }
        this.setDatabase("orca");
        this.setUser("orca");
        this.setPasswd(PASSWD);
    }

    public List<OrcaInputCd> getInputSetFromOrca() {
        Connection con = null;
        ArrayList<OrcaInputCd> collection = null;
        Statement st = null;
        String sql = null;
        StringBuilder sb = new StringBuilder();
        sb.append("select * from tbl_inputcd where ");
        if (GlobalVariables.getOrcaVersion().startsWith("4")) {
            int hospnum = this.getHospNumFromOrca();
            sb.append("hospnum=");
            sb.append(hospnum);
            sb.append(" and ");
        }
        sb.append("inputcd like 'P%' or inputcd like 'S%' order by inputcd");
        sql = sb.toString();
        boolean v4 = GlobalVariables.getOrcaVersion().startsWith("4");
        try {
            con = this.getConnection();
            st = con.createStatement();
            ResultSet rs = st.executeQuery(sql);
            collection = new ArrayList<OrcaInputCd>();
            while (rs.next()) {
                String cd;
                OrcaInputCd inputCd = new OrcaInputCd();
                if (!v4) {
                    inputCd.setHospId(rs.getString(1));
                    inputCd.setCdsyu(rs.getString(2));
                    inputCd.setInputCd(rs.getString(3));
                    inputCd.setSryKbn(rs.getString(4));
                    inputCd.setSryCd(rs.getString(5));
                    inputCd.setDspSeq(rs.getInt(6));
                    inputCd.setDspName(rs.getString(7));
                    inputCd.setTermId(rs.getString(8));
                    inputCd.setOpId(rs.getString(9));
                    inputCd.setCreYmd(rs.getString(10));
                    inputCd.setUpYmd(rs.getString(11));
                    inputCd.setUpHms(rs.getString(12));
                    cd = inputCd.getInputCd();
                    if (cd.length() > 6) {
                        cd = cd.substring(0, 6);
                        inputCd.setInputCd(cd);
                    }
                } else {
                    inputCd.setCdsyu(rs.getString(1));
                    inputCd.setInputCd(rs.getString(2));
                    inputCd.setSryKbn(rs.getString(3));
                    inputCd.setSryCd(rs.getString(4));
                    inputCd.setDspSeq(rs.getInt(5));
                    inputCd.setDspName(rs.getString(6));
                    inputCd.setTermId(rs.getString(7));
                    inputCd.setOpId(rs.getString(8));
                    inputCd.setCreYmd(rs.getString(9));
                    inputCd.setUpYmd(rs.getString(10));
                    inputCd.setUpHms(rs.getString(11));
                    cd = inputCd.getInputCd();
                    if (cd.length() > 6) {
                        cd = cd.substring(0, 6);
                        inputCd.setInputCd(cd);
                    }
                    ModuleInfoBean info = inputCd.getStampInfo();
                }
                collection.add(inputCd);
            }
            rs.close();
            this.closeStatement(st);
            this.closeConnection(con);
            return collection;
        }
        catch (Exception e) {
            this.processError(e);
            this.closeConnection(con);
            this.closeStatement(st);
            return null;
        }
    }

    public List<ModuleModel> getStampFromOrca(ModuleInfoBean inputSetInfo) {
        ArrayList<ModuleModel> result = new ArrayList<ModuleModel>();
        String setCd = inputSetInfo.getStampId();
        String stampName = inputSetInfo.getStampName();
        int hospnum = -1;
        if (GlobalVariables.getOrcaVersion().startsWith("4")) {
            hospnum = this.getHospNumFromOrca();
        }
        Connection con = null;
        PreparedStatement ps1 = null;
        PreparedStatement ps2 = null;
        String sql1 = null;
        String sql2 = null;
        StringBuilder sb1 = new StringBuilder();
        if (GlobalVariables.getOrcaVersion().startsWith("4")) {
            sb1.append("select inputcd,suryo1,suryo2,kaisu from tbl_inputset where hospnum=? and setcd=? and yukoedymd='99999999' order by setseq");
            sql1 = sb1.toString();
        } else {
            sb1.append("select inputcd,suryo1,suryo2,kaisu from tbl_inputset where setcd=? and yukoedymd='99999999' order by setseq");
            sql1 = sb1.toString();
        }
        StringBuilder sb2 = new StringBuilder("select srysyukbn,name,taniname,ykzkbn,sstkijuncd1,sstkijuncd2,sstkijuncd3,sstkijuncd4,sstkijuncd5,sstkijuncd6,sstkijuncd7,sstkijuncd8,sstkijuncd9,sstkijuncd10 from tbl_tensu where ");
        if (GlobalVariables.getOrcaVersion().startsWith("4")) {
            sb2.append("hospnum=? and srycd=? and yukoedymd='99999999'");
        } else {
            sb2.append("srycd=? and yukoedymd='99999999'");
        }
        sql2 = sb2.toString();
        try {
            con = this.getConnection();
            ps1 = con.prepareStatement(sql1);
            if (hospnum > 0) {
                ps1.setInt(1, hospnum);
                ps1.setString(2, setCd);
            } else {
                ps1.setString(1, setCd);
            }
            ResultSet rs = ps1.executeQuery();
            ArrayList<OrcaInputSet> list = new ArrayList<OrcaInputSet>();
            while (rs.next()) {
                OrcaInputSet inputSet = new OrcaInputSet();
                inputSet.setInputCd(rs.getString(1));
                inputSet.setSuryo1(rs.getFloat(2));
                inputSet.setSuryo2(rs.getFloat(3));
                inputSet.setKaisu(rs.getInt(4));
                list.add(inputSet);
            }
            rs.close();
            this.closeStatement(ps1);
            ModuleModel stamp = null;
            BundleDolphin bundle = null;
            ps2 = con.prepareStatement(sql2);
            if (list != null && list.size() > 0) {
                for (OrcaInputSet inputSet : list) {
                    ResultSet rs2;
                    String inputcd = inputSet.getInputCd();
                    if (inputcd.startsWith(SHINRYO_KBN_START)) {
                        stamp = this.createStamp(stampName, inputcd);
                        if (stamp == null) continue;
                        bundle = (BundleDolphin)stamp.getModel();
                        result.add(stamp);
                        continue;
                    }
                    if (hospnum > 0) {
                        ps2.setInt(1, hospnum);
                        ps2.setString(2, inputcd);
                    } else {
                        ps2.setString(1, inputcd);
                    }
                    if (!(rs2 = ps2.executeQuery()).next()) continue;
                    String code = inputcd;
                    String kbn = rs2.getString(1);
                    String name = rs2.getString(2);
                    String number = String.valueOf(inputSet.getSuryo1());
                    String unit = rs2.getString(3);
                    String ykzkbn = rs2.getString(4);
                    ClaimItem item = new ClaimItem(code, number);
                    item.setName(name);
                    item.setSuryo1(inputSet.getSuryo1());
                    item.setSuryo2(inputSet.getSuryo2());
                    item.setClassCodeSystem("Claim003");
                    if (code.startsWith("1")) {
                        item.setClassCode(String.valueOf(0));
                        if (bundle == null && (stamp = this.createStamp(stampName, kbn)) != null) {
                            bundle = (BundleDolphin)stamp.getModel();
                            result.add(stamp);
                        }
                        if (bundle == null) continue;
                        bundle.setBundleNumber(inputSet.getKaisu());
                        bundle.addClaimItem(item);
                        continue;
                    }
                    if (code.startsWith("6")) {
                        String receiptCode;
                        item.setClassCode(String.valueOf(2));
                        item.setNumberCode("10");
                        item.setNumberCodeSystem("Claim004");
                        item.setUnit(unit);
                        item.setYkzKbn(ykzkbn);
                        if (bundle == null && (stamp = this.createStamp(stampName, receiptCode = rs2.getString(4).equals("1") ? "210" : "230")) != null) {
                            bundle = (BundleDolphin)stamp.getModel();
                            result.add(stamp);
                        }
                        if (bundle == null) continue;
                        bundle.setBundleNumber(inputSet.getKaisu());
                        bundle.addClaimItem(item);
                        continue;
                    }
                    if (code.startsWith("7")) {
                        item.setClassCode(String.valueOf(1));
                        item.setNumberCode("21");
                        item.setNumberCodeSystem("Claim004");
                        item.setUnit(unit);
                        if (bundle == null && (stamp = this.createStamp(stampName, KBN_GENERAL)) != null) {
                            bundle = (BundleDolphin)stamp.getModel();
                            result.add(stamp);
                        }
                        if (bundle == null) continue;
                        bundle.setBundleNumber(inputSet.getKaisu());
                        bundle.addClaimItem(item);
                        continue;
                    }
                    if (code.startsWith("001")) {
                        if (bundle == null && (stamp = this.createStamp(stampName, KBN_RP)) != null) {
                            bundle = (BundleDolphin)stamp.getModel();
                            result.add(stamp);
                        }
                        if (bundle == null) continue;
                        bundle.setAdmin(name);
                        bundle.setAdminCode(code);
                        bundle.setBundleNumber(inputSet.getKaisu());
                        continue;
                    }
                    if (inputcd.startsWith("002")) {
                        item.setClassCode(String.valueOf(0));
                        if (bundle == null && (stamp = this.createStamp(stampName, KBN_RAD)) != null) {
                            bundle = (BundleDolphin)stamp.getModel();
                            result.add(stamp);
                        }
                        if (bundle == null) continue;
                        bundle.addClaimItem(item);
                        continue;
                    }
                    if (SinryoCode.isComment(code)) {
                        item.setClassCode(String.valueOf(0));
                        ArrayList<String> ary = new ArrayList<String>();
                        for (int i = 0; i < 10; ++i) {
                            ary.add(rs2.getString(i + 5));
                        }
                        item.setSstKijunCdSet(ary);
                        item.setNumber(PASSWD);
                        if (bundle == null && (stamp = this.createStamp(stampName, kbn)) != null) {
                            bundle = (BundleDolphin)stamp.getModel();
                            result.add(stamp);
                        }
                        if (bundle == null) continue;
                        bundle.addClaimItem(item);
                        continue;
                    }
                    if (!SinryoCode.isJihi(code) && !SinryoCode.isZanryoHaiki(code)) continue;
                    item.setClassCode(String.valueOf(0));
                    if (bundle == null && (stamp = this.createStamp(stampName, KBN_GENERAL)) != null) {
                        bundle = (BundleDolphin)stamp.getModel();
                        result.add(stamp);
                    }
                    if (bundle == null) continue;
                    bundle.addClaimItem(item);
                }
                this.closeStatement(ps2);
            }
            this.closeConnection(con);
        }
        catch (Exception e) {
            this.processError(e);
            this.closeConnection(con);
            this.closeStatement(ps1);
            this.closeStatement(ps2);
        }
        return result;
    }

    public ModuleModel createStamp(String stampName, String code) {
        ModuleModel result = null;
        if (code != null) {
            if (code.startsWith(SHINRYO_KBN_START)) {
                code = code.substring(1);
            }
            if (code.length() > 3) {
                code = code.substring(0, 3);
            }
            result = new ModuleModel();
            IStampInfo stampInfo = result.getModuleInfo();
            stampInfo.setStampName(stampName);
            stampInfo.setStampRole("p");
            BundleDolphin bundle = null;
            if (code.startsWith(RP_KBN_START)) {
                bundle = new BundleMed();
                result.setModel(bundle);
                String inOut = GlobalVariables.getPreferences().getBoolean("rp.out", true) ? "\u9662\u5916\u51e6\u65b9" : "\u9662\u5185\u51e6\u65b9";
                bundle.setMemo(inOut);
            } else if (code.equals(KBN_RAD)) {
                bundle = new BundleImage();
                result.setModel(bundle);
            } else {
                bundle = new BundleDolphin();
                result.setModel(bundle);
            }
            bundle.setClassCode(code);
            bundle.setClassCodeSystem("Claim007");
            bundle.setClassName(MMLTable.getClaimClassCodeName(code));
            String[] entityOrder = this.getEntityOrderName(code);
            if (entityOrder != null) {
                stampInfo.setEntity(entityOrder[0]);
                bundle.setOrderName(entityOrder[1]);
            }
        }
        return result;
    }

    private String[] getEntityOrderName(String receiptCode) {
        try {
            int number = Integer.parseInt(receiptCode);
            if (number >= 110 && number <= 125) {
                return new String[]{"baseChargeOrder", "\u8a3a\u65ad\u6599"};
            }
            if (number >= 130 && number <= 139) {
                return new String[]{"instractionChargeOrder", "\u6307\u5c0e"};
            }
            if (number >= 140 && number <= 149) {
                return new String[]{"stayOnHomeChargeOrder", "\u5728\u5b85"};
            }
            if (number >= 200 && number <= 299) {
                return new String[]{"medOrder", "RP"};
            }
            if (number >= 300 && number <= 331) {
                return new String[]{"injectionOrder", "\u6ce8 \u5c04"};
            }
            if (number >= 400 && number <= 499) {
                return new String[]{"treatmentOrder", "\u51e6 \u7f6e"};
            }
            if (number >= 500 && number <= 599) {
                return new String[]{"surgeryOrder", "\u624b\u8853"};
            }
            if (number >= 600 && number <= 699) {
                return new String[]{"testOrder", "\u691c\u67fb"};
            }
            if (number >= 700 && number <= 799) {
                return new String[]{"radiologyOrder", "\u753b\u50cf\u8a3a\u65ad"};
            }
            if (number >= 800 && number <= 899) {
                return new String[]{"otherOrder", "\u305d\u306e\u4ed6"};
            }
            return new String[]{"generalOrder", "\u6c4e \u7528"};
        }
        catch (Exception e) {
            LogWriter.error(this.getClass(), e);
            return null;
        }
    }
}

