/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.infomodel;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.StringTokenizer;
import open.dolphin.infomodel.IInfoModel;
import open.dolphin.log.LogWriter;
import open.dolphin.utils.AgeCalculator;

public class ModelUtils
implements IInfoModel {
    public static String trimTime(String mmlDate) {
        if (mmlDate != null) {
            int index = mmlDate.indexOf(84);
            if (index > -1) {
                return mmlDate.substring(0, index);
            }
            return mmlDate;
        }
        return null;
    }

    public static String trimDate(String mmlDate) {
        if (mmlDate != null) {
            int index = mmlDate.indexOf(84);
            if (index > -1) {
                return mmlDate.substring(index + 1, index + 6);
            }
            return mmlDate;
        }
        return null;
    }

    public static String getAgeBirthday(String mmlBirthday) {
        String age = AgeCalculator.getAge(mmlBirthday);
        if (age != null) {
            StringBuffer buf = new StringBuffer();
            buf.append(age);
            buf.append(" (");
            buf.append(mmlBirthday);
            buf.append(")");
            return buf.toString();
        }
        return null;
    }

    public static GregorianCalendar getCalendar(String mmlDate) {
        try {
            String daySt;
            mmlDate = ModelUtils.trimTime(mmlDate);
            StringTokenizer st = new StringTokenizer(mmlDate, "-");
            String yearSt = st.nextToken();
            String monthSt = st.nextToken();
            if (monthSt.startsWith("0")) {
                monthSt = monthSt.substring(1);
            }
            if ((daySt = st.nextToken()).startsWith("0")) {
                daySt = daySt.substring(1);
            }
            int year = Integer.parseInt(yearSt);
            int month = Integer.parseInt(monthSt);
            int day = Integer.parseInt(daySt);
            return new GregorianCalendar(year, --month, day);
        }
        catch (Exception e) {
            LogWriter.error(ModelUtils.class, e);
            return null;
        }
    }

    public static Date getDateAsObject(String mmlDate) {
        if (mmlDate != null) {
            try {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                return sdf.parse(mmlDate);
            }
            catch (Exception e) {
                LogWriter.error(ModelUtils.class, e);
            }
        }
        return null;
    }

    public static Date getDateTimeAsObject(String mmlDate) {
        if (mmlDate != null) {
            try {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
                return sdf.parse(mmlDate);
            }
            catch (Exception e) {
                LogWriter.error(ModelUtils.class, e);
            }
        }
        return null;
    }

    public static String getDateAsString(Date date) {
        if (date != null) {
            try {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                return sdf.format(date);
            }
            catch (Exception e) {
                LogWriter.error(ModelUtils.class, e);
            }
        }
        return null;
    }

    public static String getDateTimeAsString(Date date) {
        if (date != null) {
            try {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
                return sdf.format(date);
            }
            catch (Exception e) {
                LogWriter.error(ModelUtils.class, e);
            }
        }
        return null;
    }

    public static String getDateAsFormatString(Date date, String format) {
        if (date != null) {
            try {
                SimpleDateFormat sdf = new SimpleDateFormat(format);
                return sdf.format(date);
            }
            catch (Exception e) {
                LogWriter.error(ModelUtils.class, e);
            }
        }
        return null;
    }

    public static Date getDateFromString(String source, String format) {
        if (source == null) {
            return null;
        }
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        try {
            return sdf.parse(source);
        }
        catch (ParseException ex) {
            LogWriter.error(ModelUtils.class, ex);
            return null;
        }
    }

    public static String Convert(String formatFrom, String formatTo, String dateString) {
        SimpleDateFormat from = new SimpleDateFormat(formatFrom);
        SimpleDateFormat to = new SimpleDateFormat(formatTo);
        try {
            return to.format(from.parse(dateString));
        }
        catch (ParseException ex) {
            LogWriter.error("ModelUtils", "Convert");
            return "";
        }
    }

    public static String getGenderDesc(String gender) {
        if (gender != null) {
            String test = gender.toLowerCase();
            if (test.equals("male")) {
                return "\u7537";
            }
            if (test.equals("female")) {
                return "\u5973";
            }
            return "\u4e0d\u660e";
        }
        return "\u4e0d\u660e";
    }

    public static String getMemo(String memo) {
        if (memo == null) {
            return "";
        }
        return memo;
    }

    public boolean isValidModel() {
        return true;
    }

    public static String[] splitDiagnosis(String diagnosis) {
        if (diagnosis == null) {
            return null;
        }
        String[] ret = null;
        try {
            ret = diagnosis.split("\\s*,\\s*");
        }
        catch (Exception e) {
            LogWriter.error("ModelUtils", "splitDiagnosis");
        }
        return ret;
    }

    public static String getDiagnosisName(String hasAlias) {
        String[] splits = ModelUtils.splitDiagnosis(hasAlias);
        return splits != null && splits.length == 2 && splits[0] != null ? splits[0] : hasAlias;
    }

    public static String getDiagnosisAlias(String hasAlias) {
        String[] splits = ModelUtils.splitDiagnosis(hasAlias);
        return splits != null && splits.length == 2 && splits[1] != null ? splits[1] : null;
    }
}

