/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.infomodel;

public class SinryoCode {
    private static final String[] sinryoCodeRegExp = new String[]{"^\\d{9}$"};
    private static final String[] noFormatCommentRegExp = new String[]{"^810000001$", "^0082\\d{5}$", "^82\\d{7}$", "^0085\\d{5}$", "^85\\d{7}$"};
    private static final String[] prefixCommentRegExp = new String[]{"^0083\\d{5}$", "^83\\d{7}$"};
    private static final String[] complexCommentRegExp = new String[]{"^0084\\d{5}$", "^84\\d{7}$"};
    private static final String[] tonyoRegExp = new String[]{"^0010008\\d\\d$"};
    private static final String[] JIHI_HIKAZEI_REGEXP = new String[]{"^095\\d{6}$", "^950\\d{6}$"};
    private static final String[] JIHI_KAZEI_REGEXP = new String[]{"^096\\d{6}$", "^960\\d{6}$"};
    private static final String[] ZANRYO_HAIKI_REGEXP = new String[]{"^09930\\d{4}"};

    public static boolean isComment(String s) {
        return s != null && (SinryoCode.isNoFormatComment(s) || SinryoCode.isPrefixComment(s) || SinryoCode.isComplexComment(s));
    }

    public static boolean isNoFormatComment(String s) {
        return s != null && SinryoCode.isValid(s) && SinryoCode.matches(s, noFormatCommentRegExp);
    }

    public static boolean isPrefixComment(String s) {
        return s != null && SinryoCode.isValid(s) && SinryoCode.matches(s, prefixCommentRegExp);
    }

    public static boolean isComplexComment(String s) {
        return s != null && SinryoCode.isValid(s) && SinryoCode.matches(s, complexCommentRegExp);
    }

    public static boolean isTonyo(String s) {
        return s != null && SinryoCode.isValid(s) && SinryoCode.matches(s, tonyoRegExp);
    }

    public static boolean isJihi(String s) {
        return SinryoCode.isValid(s) && (SinryoCode.isJihiHikazei(s) || SinryoCode.isJihiKazei(s));
    }

    public static boolean isJihiHikazei(String s) {
        return SinryoCode.isValid(s) && SinryoCode.matches(s, JIHI_HIKAZEI_REGEXP);
    }

    public static boolean isJihiKazei(String s) {
        return SinryoCode.isValid(s) && SinryoCode.matches(s, JIHI_KAZEI_REGEXP);
    }

    public static boolean isZanryoHaiki(String s) {
        return SinryoCode.isValid(s) && SinryoCode.matches(s, ZANRYO_HAIKI_REGEXP);
    }

    public static boolean isValid(String s) {
        return s != null && SinryoCode.matches(s, sinryoCodeRegExp);
    }

    public static boolean matches(String s, String[] formats) {
        for (String f : formats) {
            if (!s.matches(f)) continue;
            return true;
        }
        return false;
    }
}

