/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.order;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.EnumSet;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import open.dolphin.client.GUIConst;
import open.dolphin.client.editor.stamp.StampModelEditor;
import open.dolphin.order.ClaimConst;
import open.dolphin.order.MasterSetPanel;
import open.dolphin.order.PharmaceuticalsTablePanel;

public final class PharmaceuticalsStampEditor
extends StampModelEditor {
    private static final String MEDICINE_TABLETITLE_BORDER = "\u51e6\u65b9\u30bb\u30c3\u30c8";
    private static final String EDITOR_NAME = "\u51e6\u65b9";
    private PharmaceuticalsTablePanel editorPanel;
    private MasterSetPanel masterPanel;

    @Override
    public void start() {
        this.setTitle(EDITOR_NAME);
        this.editorPanel = new PharmaceuticalsTablePanel(this);
        this.editorPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), MEDICINE_TABLETITLE_BORDER));
        EnumSet<ClaimConst.MasterSet> set = EnumSet.of(ClaimConst.MasterSet.MEDICAL_SUPPLY, ClaimConst.MasterSet.ADMINISTRATION, ClaimConst.MasterSet.INJECTION_MEDICINE, ClaimConst.MasterSet.TOOL_MATERIAL);
        this.masterPanel = new MasterSetPanel(set);
        this.masterPanel.startMedicine(this.editorPanel);
        JPanel top = new JPanel(new BorderLayout());
        top.add((Component)this.editorPanel, "Center");
        this.setLayout(new BoxLayout(this, 1));
        this.add(top);
        this.add(this.masterPanel);
        this.setPreferredSize(GUIConst.DEFAULT_STAMP_EDITOR_SIZE);
    }

    @Override
    public Object getValue() {
        return this.editorPanel.getValue();
    }

    @Override
    public void setValue(Object val) {
        this.editorPanel.setValue(val);
    }

    @Override
    public void dispose() {
        this.masterPanel.stopMedicine(this.editorPanel);
    }
}

