/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.table;

import java.awt.Color;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import open.dolphin.project.GlobalSettings;

public class DocumentHistoryRenderer
extends JLabel
implements TableCellRenderer {
    private static final Color DEFAULT_ODD_COLOR = GlobalSettings.getColors(GlobalSettings.Parts.ODD);
    private static final Color DEFAULT_EVENN_COLOR = GlobalSettings.getColors(GlobalSettings.Parts.EVEN);
    private static final Color SEND_HISTORY_COLOR = GlobalSettings.getColors(GlobalSettings.Parts.SEND_HISTORY);
    private static final Color TEMPORARY_HISTORY_COLOR = GlobalSettings.getColors(GlobalSettings.Parts.TEMPORARY_HISTORY);
    private Color oddColor;
    private Color evenColor;
    private Color sendHistoryColor;
    private Color temporaryColor;

    public DocumentHistoryRenderer() {
        this(DEFAULT_ODD_COLOR, DEFAULT_EVENN_COLOR, SEND_HISTORY_COLOR, TEMPORARY_HISTORY_COLOR);
    }

    public DocumentHistoryRenderer(Color oddColor, Color evenColor, Color sendColor, Color temporaryColor) {
        this.setOpaque(true);
        this.setOddColor(oddColor);
        this.setEvenColor(evenColor);
        this.setSendHistoryColor(sendColor);
        this.setTemporaryColor(temporaryColor);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (value != null) {
            if (value instanceof String) {
                this.setText((String)value);
                if (column == 3) {
                    if (((String)value).equals("\u9001\u4fe1\u6e08\u307f")) {
                        this.setBackground(this.getSendHistoryColor());
                    } else if (((String)value).equals("\u4fdd\u5b58")) {
                        this.setBackground(this.getEvenColor());
                    } else {
                        this.setBackground(this.getTemporaryColor());
                    }
                } else {
                    this.setForeground(table.getForeground());
                    if (row % 2 == 0) {
                        this.setBackground(this.getEvenColor());
                    } else {
                        this.setBackground(this.getOddColor());
                    }
                }
                if (isSelected) {
                    this.setBackground(table.getSelectionBackground());
                    this.setForeground(table.getSelectionForeground());
                }
            } else {
                this.setText(value.toString());
            }
        }
        return this;
    }

    public void setOddColor(Color oddColor) {
        this.oddColor = oddColor;
    }

    public Color getOddColor() {
        return this.oddColor;
    }

    public void setEvenColor(Color evenColor) {
        this.evenColor = evenColor;
    }

    public Color getEvenColor() {
        return this.evenColor;
    }

    public void setSendHistoryColor(Color sendHistoryColor) {
        this.sendHistoryColor = sendHistoryColor;
    }

    public Color getSendHistoryColor() {
        return this.sendHistoryColor;
    }

    public void setTemporaryColor(Color temporaryColor) {
        this.temporaryColor = temporaryColor;
    }

    public Color getTemporaryColor() {
        return this.temporaryColor;
    }
}

