/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4cheri.srom;

import org.apache.log4j.Logger;
import org.dcm4che.data.Dataset;
import org.dcm4che.data.DcmValueException;
import org.dcm4che.dict.DictionaryFactory;
import org.dcm4che.dict.UIDDictionary;
import org.dcm4che.srom.RefSOP;

class RefSOPImpl
implements RefSOP {
    static Logger log = Logger.getLogger(RefSOPImpl.class);
    private static UIDDictionary uidDict = DictionaryFactory.getInstance().getDefaultUIDDictionary();
    private final String refSOPClassUID;
    private final String refSOPInstanceUID;

    public RefSOPImpl(String refSOPClassUID, String refSOPInstanceUID) {
        if (refSOPClassUID.length() == 0) {
            throw new IllegalArgumentException(refSOPClassUID);
        }
        if (refSOPInstanceUID.length() == 0) {
            throw new IllegalArgumentException(refSOPInstanceUID);
        }
        this.refSOPClassUID = refSOPClassUID;
        this.refSOPInstanceUID = refSOPInstanceUID;
    }

    public RefSOPImpl(Dataset ds) throws DcmValueException {
        this(ds.getString(528720), ds.getString(528725));
    }

    private static boolean hasValue(String s) {
        return s != null && s.length() > 0;
    }

    public static RefSOP newRefSOP(Dataset ds) throws DcmValueException {
        if (ds == null) {
            return null;
        }
        String cuid = ds.getString(528720);
        if (!RefSOPImpl.hasValue(cuid)) {
            log.warn("Missing Ref SOP Class UID - ignore reference");
            return null;
        }
        String iuid = ds.getString(528725);
        if (!RefSOPImpl.hasValue(iuid)) {
            log.warn("Missing Ref SOP Instance UID - ignore reference");
            return null;
        }
        return new RefSOPImpl(cuid, iuid);
    }

    public String toString() {
        return uidDict.lookup(this.refSOPClassUID) + "[" + this.refSOPInstanceUID + "]";
    }

    public void toDataset(Dataset ds) {
        ds.putUI(528720, this.refSOPClassUID);
        ds.putUI(528725, this.refSOPInstanceUID);
    }

    public final String getRefSOPClassUID() {
        return this.refSOPClassUID;
    }

    public final String getRefSOPInstanceUID() {
        return this.refSOPInstanceUID;
    }

    public final int hashCode() {
        return this.refSOPInstanceUID.hashCode();
    }

    public final boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RefSOP)) {
            return false;
        }
        RefSOP refSOP = (RefSOP)o;
        return this.refSOPInstanceUID.equals(refSOP.getRefSOPInstanceUID());
    }
}

