/*
 * OpenI2CRADIO
 * EEPROM utils
 * Copyright (C) 2013-06-10 K.Ohta <whatisthis.sowhat ai gmail.com>
 * License: GPL2+LE
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2,
 *  or (at your option) any later version.
 *  This library / program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *  See the GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this library; see the file COPYING. If not, write to the
 *  Free Software Foundation, 51 Franklin Street, Fifth Floor, Boston,
 *  MA 02110-1301, USA.
 *
 *  As a special exception, if you link this(includeed from sdcc) library
 *  with other files, some of which are compiled with SDCC,
 *  to produce an executable, this library does not by itself cause
 *  the resulting executable to be covered by the GNU General Public License.
 *  This exception does not however invalidate any other reasons why
 *  the executable file might be covered by the GNU General Public License.
 */

#include <stdarg.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#if defined(__SDCC)
#include <sdcc-lib.h>
#include <pic18fregs.h> /* ONLY FOR PIC18x */
#include <delay.h>
#else
#include <xc.h>
#endif
#include <signal.h>

#include "commondef.h"
#include "iodef.h"
#include "idle.h"
#include "i2c_io.h"
#include "akc6955.h"
#include "lcd_acm1602.h"
#include "ui.h"
#include "eeprom.h"
#include "ioports.h"
#include "menu.h"
#include "power.h"
#include "adc_int.h"

void save_eeprom(void)
{
    unsigned int p[1];
    unsigned int sum[1];
        unsigned char i;
    unsigned char j;
    unsigned char *q = (char *)(&setup);

    *p = 0;
    *sum = 0;
    // Magic word
    writeword_eeprom(p, sum, 0x1298);
    // amfreq
    for(i = 0; i < sizeof(__radioset_t); i++) {
        writebyte_eeprom(p, sum, *q);
        q++;
    }

    // Write checksum
    eeprom_writebyte(*p, sum[0] >> 8);
    eeprom_writebyte(*p + 1, sum[0] & 0xff);
}

unsigned char load_eeprom(void)
{
    unsigned int p[1];
    unsigned int sum[1];
    unsigned char i;
    unsigned char *q = (unsigned char *)(&setup);
    unsigned char j;
    unsigned int magic;

    p[0] = 0;
    sum[0] = 0;
    // Magic word
    magic = readword_eeprom(p, sum);
    if(magic != 0x1298) return 0x01; // NO MAGICWORD
    // amfreq
    for(i = 0; i < sizeof(__radioset_t); i++ ){
        *q = readbyte_eeprom(p, sum);
        q++;
    }
    magic = (eeprom_readbyte(p[0]) << 8) + eeprom_readbyte(p[0] + 1);

    if(sum[0] != magic) return 0x00;
    return 0xff;
}

/*
 * Check eeprom, and format/restore.
 */
void check_eeprom(void)
{
    unsigned char c;
        switch(load_eeprom()) {
        case 0x01: // No magic-word
            idle_time_ms(2000);
            c = printhelp_2lines("EEPROM FORMAT", "Press any key");
            _CLS();
            _LOCATE(0,0);
            printstr("Formatting...  ");
            format_eeprom(2,250);
            _LOCATE(0,0);
            printstr("Save defaults  ");
            setdefault();
            save_eeprom();
            break;
        case 0x00: // Checksum error
           idle_time_ms(2000);
            c = printhelp_2lines("X-) Sum error", "Press any key");
            c = pollkey_single();
            _CLS();
            _LOCATE(0,0);
            printstr("Formatting...");
            format_eeprom(2,250);
//            writeword_eeprom(0, &sum, 0x1298);
            _LOCATE(0,0);
            printstr("Save defaults");
            setdefault();
            save_eeprom();
            break;
        case 0xff: // Success
            return;
            break;
        default: // Unknown error
            break;
    }
    valinit();
}
