/*
 * OpenI2CRADIO
 * I/O Port defines / KEYBOARD.
 * Copyright (C) 2013-08-22 K.Ohta <whatisthis.sowhat ai gmail.com>
 * License: GPL2+LE
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2,
 *  or (at your option) any later version.
 *  This library / program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *  See the GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this library; see the file COPYING. If not, write to the
 *  Free Software Foundation, 51 Franklin Street, Fifth Floor, Boston,
 *  MA 02110-1301, USA.
 *
 *  As a special exception, if you link this(includeed from sdcc) library
 *  with other files, some of which are compiled with SDCC,
 *  to produce an executable, this library does not by itself cause
 *  the resulting executable to be covered by the GNU General Public License.
 *  This exception does not however invalidate any other reasons why
 *  the executable file might be covered by the GNU General Public License.
 */

#ifndef IODEF_KEY_H
#define	IODEF_KEY_H

#ifdef	__cplusplus
extern "C" {
#endif


#define _KEY_SENDPORT LATA
#define _KEY_RECVPORT PORTB
#define _KEY_GRP1MASK 0x01
#define _KEY_GRP2MASK 0x02
#define _KEY_GRP3MASK 0x04
#define _KEY_GRP4MASK 0x08
#define _KEY_SENDPORTMASK (_KEY_GRP1MASK | _KEY_GRP2MASK | _KEY_GRP3MASK | _KEY_GRP4MASK)
#define _KEY_SEND_GRP1 LATAbits.LATA0
#define _KEY_SEND_GRP2 LATAbits.LATA1
#define _KEY_SEND_GRP3 LATAbits.LATA2
#define _KEY_SEND_GRP4 LATAbits.LATA3
#define _KEY_POS1MASK(p) p.b0
#define _KEY_POS2MASK(p) p.b1
#define _KEY_POS3MASK(p) p.b2
#define _KEY_POS4MASK(p) p.b3

typedef  union {
    struct {
    unsigned BIT0A:1;
    unsigned BIT1A:1;
    unsigned BIT2A:1;
    unsigned BIT3A:1;

    unsigned BIT0B:1;
    unsigned BIT1B:1;
    unsigned BIT2B:1;
    unsigned BIT3B:1;

    unsigned BIT0C:1;
    unsigned BIT1C:1;
    unsigned BIT2C:1;
    unsigned BIT3C:1;

    unsigned BIT0D:1;
    unsigned BIT1D:1;
    unsigned BIT2D:1;
    unsigned BIT3D:1;

    };
    unsigned char byte[2];
} keyin_defs;

enum {
    charcode_null = 0,
    charcode_1,
    charcode_2,
    charcode_3,
    charcode_4,
    charcode_5,
    charcode_6,
    charcode_7,
    charcode_8,
    charcode_9,
    charcode_a,
    charcode_b,
    charcode_c,
    charcode_d,
    charcode_e,
    charcode_f,
    charcode_0,
    // Special keys was removed.
};



#ifdef	__cplusplus
}
#endif

#endif	/* IODEF_KEY_H */

