/*
 * OpenI2CRADIO
 * Menu sub-routines.
 * Copyright (C) 2013-06-21 K.Ohta <whatisthis.sowhat ai gmail.com>
 * License: GPL2+LE
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2,
 *  or (at your option) any later version.
 *  This library / program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *  See the GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this library; see the file COPYING. If not, write to the
 *  Free Software Foundation, 51 Franklin Street, Fifth Floor, Boston,
 *  MA 02110-1301, USA.
 *
 *  As a special exception, if you link this(includeed from sdcc) library
 *  with other files, some of which are compiled with SDCC,
 *  to produce an executable, this library does not by itself cause
 *  the resulting executable to be covered by the GNU General Public License.
 *  This exception does not however invalidate any other reasons why
 *  the executable file might be covered by the GNU General Public License.
 */

#include "menu.h"
#include "menu_memoryfreq.h"
#include "power.h"
#include "commondef.h"


void toggle_amfm(void)
{
    unsigned int freq;
    if(setup.fm != 0){
        setup.fm = 0;
        setup.fmfreq_bank[setup.fmband] = setup.fmfreq;
  //      akc6955_set_amband(amband);
        freq = setup.amfreq_bank[setup.amband];
    } else {
        setup.fm = 0xff;
        setup.amfreq_bank[setup.amband] = setup.amfreq;
//        akc6955_set_fmband(fmband);
        freq = setup.fmfreq_bank[setup.fmband];
    }
    akc6955_chg_fm(setup.fm, freq);
    idle_time_ms(500);
//    akc6955_set_freq(freq);
}



void set_stereomode(void)
{
    __bitops_t mode;
    mode.byte = 0x00;
    if(setup.stereo == 0x00){
            mode.b0 = 1; // Force mono
    } else if(setup.stereo < 0x80){
            mode.b1 = 1; // Force stereo
    }
    akc6955_set_stereomode(mode.byte);
}

void set_stereo(void)
{
    
    if(setup.stereo == 0xff) {// Force Mono
        setup.stereo = 0x00;
    } else if(setup.stereo == 0x00) { //Mono->Stereo
        setup.stereo = 0x7f;
    } else { // Default, Stereo->auto
        setup.stereo = 0xff;
    }
    set_stereomode();
}


void set_volume(void)
{
    unsigned char c;
    unsigned char d;
    unsigned char p;
    unsigned char fact;

    _CLS();
    do {
    _LOCATE(0,0);
     d = akc6955_getvolumemode();
      if(d == 0){
         _PUTCHAR('D');
       } else {
         _PUTCHAR('K');
       }
     printstr(" Vol:");
     print_numeric_nosupress(setup.volume, 2);
     printstr("  F:Exit");
     _LOCATE(0,1);
     printstr("Pre:");
     _PUTCHAR('0' + (setup.prevolume & 3));
     _LOCATE(16-4, 1);
     if(setup.lowboost == 0x00){
         printstr("   ");
     } else {
         printstr("LOW");
     }
     _HOME();
//     c = pollkeys(pollkeybuf, 5, 1);
 //    p = 0;
     c = pollkey_single_timeout(22, 1); // 506ms
     switch(c) {
             case charcode_6:
                 setup.volume++;
                 if(setup.volume > 63) setup.volume = 63;
                 break;
             case charcode_4:
                 setup.volume--;
                 if(setup.volume < 23) setup.volume = 23;
                 break;
             case charcode_f:
                 _CLS();
                 return;
             case charcode_a:
                 fact = 0xff;
                 if(d != 0){
                     fact = 0x00;
                 }
                 akc6955_setvolumemode(fact);
                 break;
             case charcode_b:
                 setup.prevolume++;
                 if(setup.prevolume > 3) setup.prevolume = 0;
                 akc6955_set_prevolume(setup.prevolume);
                 break;
             case charcode_d:
                 fact = 0x00;
                 if(setup.lowboost == 0x00){
                     fact = 0xff;
                 }
                 setup.lowboost = fact;
                 akc6955_set_lowboost(setup.lowboost);
                 break;
             default:
                 break;
         }
         if(setup.volume < 24){
             set_examp_mute(1);
        } else {
             set_examp_mute(0);
        }
        akc6955_setvolume(setup.volume);
//    _HOME();
    } while(1);
}


void scan_start(void)
{
    unsigned char c;
    unsigned char cc;
    unsigned char n;
    _CLS();
    scanflag = 0;
    do {
        do {
             c = pollkey_single_timeout(20, 0) ; // 23*20 = 460ms
//            n = pollkeys(pollkeybuf, 19, 1);
            update_status();
//            _HOME();
//            _LOCATE(0,0);
            cc = ' ';
            if((akc6955_chk_donescan() == 0) && (scanflag != 0)){
                cc = '>';
            }
            _PUTCHAR(cc);
            printstr("Scan A/4/6/F");
            print_freq(1);
            _HOME();
        } while(c == charcode_null);
       // c = pollkeybuf[0];
      // New Scan
       switch(c){
           case charcode_6:
               scanflag = 0xff;
               akc6955_do_scan(0xff);
               break;
           case charcode_4:
               scanflag = 0xff;
               akc6955_do_scan(0);
               break;
           case charcode_a:
               akc6955_abort_scan();
               goto _l0;
               break;
           case charcode_f:
               goto _l0;
               break;
           default:
               break;
       }
    } while(1);
_l0:
    _CLS();
}

void setfreq_direct(void)
{
    unsigned int val;
    _CLS();
    _LOCATE(0,0);
    printstr("Set Freq:");
    _LOCATE(0,1);
    if(setup.fm != 0){
        // FM
        printstr("FM ");
        val = setup.fmfreq;
        val = read_numeric(val, 5, 7, 1);
        setup.fmfreq = val;
    } else {
        // FM
        printstr("AM ");
        val = setup.amfreq;
        val = read_numeric(val, 5, 7, 1);
        setup.amfreq = val;
    }
    akc6955_set_freq(val);
}

void setband_direct(void)
{
    unsigned int band;
    unsigned int freq;
    _CLS();
    _LOCATE(0,0);
    if(setup.fm != 0){
        printstr("Set Band:FM#");
        band = setup.fmband & 7;
        setup.fmfreq_bank[setup.fmband] = setup.fmfreq;
        setup.fmband = read_numeric(band, 2, 7, 1);
        setup.fmfreq = setup.fmfreq_bank[setup.fmband];
        akc6955_set_fmband(setup.fmband);
        freq = setup.fmfreq;
    } else {
        printstr("Set Band:AM#");
        band = setup.amband & 0x1f;
        setup.amfreq_bank[setup.amband] = setup.amfreq;
        setup.amband = read_numeric(band, 2, 7, 1);
        setup.amfreq = setup.amfreq_bank[setup.amband];
        akc6955_set_amband(setup.amband);
        freq = setup.amfreq;
    }
    akc6955_do_tune();
    akc6955_set_freq(freq);
}

void call_userband(unsigned char num)
{
    unsigned int freq;
    unsigned int ch;
    unsigned char start;
    unsigned char end;
    unsigned char mode3k;
    unsigned char freq2;
    _userband_t *p;

    if(num >= USER_BAND_NUM) return;
    
    p = &(setup.am_usrbands[num]);
    if(setup.fm != 0){
        p = &(setup.fm_usrbands[num]);
    }
    freq = p->freq;
    start = p->start;
    end = p->stop;
    mode3k = p->mode3k;
    if(setup.fm != 0) {
        ch = ((freq - 3000) / 5) * 2;
        setup.fmband = AKC6955_BAND_FMUSER;
    } else {
        unsigned int q = 5;
        if(mode3k != 0) q = 3;
        ch = freq / q;
        setup.amband = AKC6955_BAND_AMUSER;
    }

    if(start > end) {
        unsigned char tmp;
        tmp = start;
        start = end;
        end = tmp;
    }
    
    freq2 = ch / 32;
    if(freq2 > end) {
        ch = end * 32;
    }
    if(freq2 < start){
        ch = start * 32;
    }
    akc6955_set_userband(start, end, ch, mode3k);
}

void set_userband(void)
{
    unsigned int from,to;
    unsigned char c;
    unsigned char pp;
    unsigned char mode3k;
    char cc;

    _CLS();
    _LOCATE(0,0);
    printstr("User ch:");
    c = pollkey_single();

    if(c > charcode_0) return;
    if(c < charcode_1) return;
    if(c == charcode_0) {
        c = 0;
    } else {
        c = c - charcode_1 + 1;
    }
    if(c >= USER_BAND_NUM) return;

    if(setup.fm != 0){
        from = setup.fm_usrbands[c].start * 80 + 3000; // 32*25/10
        to = setup.fm_usrbands[c].stop * 80 + 3000;
        _CLS();
        _LOCATE(0,0);
        _LOCATE(0,0);
        printstr("FM#");
        print_numeric_nosupress(c, 1);
        _LOCATE(0,1);
        printstr(" From:");
        from = read_numeric(from, 5, 7, 1);
        _LOCATE(0,1);
        printstr(" To:  ");
        to = read_numeric(to, 5, 7, 1);
        setup.fm_usrbands[c].start = (from - 3000) / 80;
        setup.fm_usrbands[c].stop = (to - 3000) / 80;
        setup.fm_usrbands[c].freq = from * 80 + 3000;
        setup.fm_userbandnum = c;
    } else {
        mode3k = setup.am_usrbands[c].mode3k;
        pp = 96; // 3*32
        if(mode3k == 0) pp = 160; // 5*32
        from = setup.am_usrbands[c].start * pp;
        to = setup.am_usrbands[c].stop * pp;
        _CLS();
        _LOCATE(0,0);
        printstr("AM#");
        print_numeric_nosupress(c, 1);
        printstr(" Step:");
        _LOCATE(0,1);
        printstr("0=3k 1=5k");
        cc = pollkey_single();
        if(cc == charcode_0){
            pp = 96;
            mode3k = 0xff;
        } else if(cc = charcode_1) {
            pp = 160;
            mode3k = 0;
        }
        _CLS();
        _LOCATE(0,0);
        printstr("AM#");
        print_numeric_nosupress(c, 1);
        _LOCATE(0,1);
        printstr(" From:");
        from = read_numeric(from, 5, 7, 1);
        _LOCATE(0,1);
        printstr(" To:  ");
        to = read_numeric(to, 5, 7, 1);
        setup.am_usrbands[c].start = from / pp;
        setup.am_usrbands[c].stop = to  / pp;
        setup.am_usrbands[c].mode3k = mode3k;
        setup.am_usrbands[c].freq = from * pp;
        setup.am_userbandnum = c;
    }
    call_userband(c);
    _CLS();
}

void input_userband(void)
{
    unsigned char c;
    do{
    _CLS();
    _LOCATE(0,0);
    printstr("User Band");
    _LOCATE(0,1);
    printstr("   #");
    c = pollkey_single();

    if((c >= charcode_a) && (c <= charcode_f)){
        break;
    }
    if(c == charcode_0) {
        _PUTCHAR('0');
        if(setup.fm != 0){
           setup.fm_userbandnum = 0;
        } else {
           setup.am_userbandnum = 0;
        }
        call_userband(0);
    } else {
        c = c - charcode_1 + 1;
        if(c < USER_BAND_NUM) {
            _PUTCHAR(c + '0');
            if(setup.fm != 0){
               setup.fm_userbandnum = c;
            } else {
                setup.am_userbandnum = c;
            }
            call_userband(c);
        }
    }
    idle(setup.ui_idlecount);
    } while(1);
    _CLS();
}


void menu_poweroff(void)
{
    unsigned char c;
    c = printhelp_2lines("Poweroff", "A=Yes");
    if(c == charcode_a) {
        shutdown(1);
    }
}

void setup_akc6955(void)
{
    akc6955_writecmd(AKC6955_POWER, 0xc0);  // You musto *not* mute, set b2 to '0".
    akc6955_writecmd(AKC6955_VOLUME, 0xc0); // You must select to radio(b1 = '0).
    if(setup.fm == 0) {
        akc6955_set_amband(setup.amband);
        if(setup.amband == AKC6955_BAND_AMUSER) call_userband(setup.am_userbandnum);
        setup.amfreq = setup.amfreq_bank[setup.amband];
        akc6955_chg_fm(0, setup.amfreq); // Set to AM
        akc6955_set_freq(setup.amfreq);
    } else {
        akc6955_set_fmband(setup.fmband);
        if(setup.fmband == AKC6955_BAND_FMUSER) call_userband(setup.fm_userbandnum);
        setup.fmfreq = setup.fmfreq_bank[setup.fmband];
        akc6955_chg_fm(0xff, setup.fmfreq); // Set to AM
        akc6955_set_freq(setup.fmfreq);
    }// Dummy, TBS (954KHz)
    akc6955_set_power(0xff); // Power ON
    akc6955_setvolume(36); // Temporally
    akc6955_set_thresh_fmcnr(setup.threshold_fmcnr);
    akc6955_set_thresh_amcnr(setup.threshold_amcnr);
    akc6955_set_thresh_width(setup.threshold_width);
    akc6955_set_thresh_fmstereo(setup.threshold_fmstereo);
    akc6955_setvolumemode(0);
    akc6955_set_lowboost(setup.lowboost);
    set_stereomode();
}

void menu_save(void)
{
    unsigned char c;
    c = printhelp_2lines("Save settings", "A=Yes");
    if(c == charcode_a) {
        save_eeprom();
    }
}

void menu_load(void)
{
    unsigned char c;
    c = printhelp_2lines("Load settings", "A=Yes B=Init");
    if(c == charcode_a) {
        c = load_eeprom();
        if( c != 0xff) {
            _CLS();
            _LOCATE(0,0);
            c = printhelp_2lines("X) Load Error", "A=Fix");
            setdefault();
            if(c == charcode_a){
                save_eeprom();
            }
        }
        setup_akc6955();
    } else if(c == charcode_b){
        setdefault();
        setup_akc6955();
    }
}

void setup_menu(void)
{
    unsigned char c;
    unsigned int val;

    c = printhelp_2lines("Setup F=HELP", "5=Return");
    switch(c){
        case charcode_3:
            _CLS();
            _LOCATE(0,0);
            printstr("BL Level:");
            val = read_numeric(setup.backlight_level, 3, 0,1);
            if(val > 255) val = 255;
            if(val < 10) val = 15;
            setup.backlight_level = (unsigned char)val;
            break;
        case charcode_4:
            _CLS();
            _LOCATE(0,0);
            printstr("FM Bandwidth:");
            akc6955_get_fmbandwidth(val);
            val = read_numeric(val, 1, 0, 1) & 3;
            setup.fmbandwidth = (unsigned char)val;
            akc6955_set_fmbandwidth(setup.fmbandwidth);
            break;
        case charcode_5:
            break;
        case charcode_7:
            _CLS();
            _LOCATE(0,0);
            printstr("FM-CNR threshold:");
            val = setup.threshold_fmcnr;
            val = read_numeric(val, 1, 0, 1);
            akc6955_set_thresh_fmcnr((unsigned char)val);
            break;
        case charcode_8:
            _CLS();
            _LOCATE(0,0);
            printstr("AM-CNR threshold:");
            val = setup.threshold_amcnr;
            val = read_numeric(val, 1, 0, 1);
            akc6955_set_thresh_amcnr((unsigned char)val);
            break;
        case charcode_9:
            _CLS();
            _LOCATE(0,0);
            printstr("Stereo threshold:");
            val = setup.threshold_fmstereo;
            val = read_numeric(val, 1, 0, 1);
            akc6955_set_thresh_fmstereo((unsigned char)val);
            break;
        case charcode_0:
            menu_poweroff();
            break;
        case charcode_a:
            menu_load();
            break;
        case charcode_c:
            menu_save();
            break;
        case charcode_d:
            setdefault();
            break;
        case charcode_e:
            _CLS();
            _LOCATE(0,0);
            printstr("BL Long:");
            val = read_numeric(setup.backlight_long, 3, 0,1);
            if(val > 999) val = 999;
            setup.backlight_long = val;
            break;
        case charcode_f:
            setup_help();
            break;
        default:
            break;
    }
}
/*
 * Main Menu : initial-screen -> 'F'.
 */
void main_menu(void)
{
    unsigned char c;
    unsigned int val;

    _CLS();
    _HOME();
    _LOCATE(0,0);
    printstr("Menu:F=HELP");
    _LOCATE(0,1);
    printstr("B=CANCEL");
    c = pollkey_single(); // 1012ms
        if(c == charcode_1){
            // Band
            setband_direct();
        } else if(c == charcode_3){
            // Band
            setfreq_direct();
        }else if(c == charcode_4){
            on_call_userfreq();
            // Scan
        }else if(c == charcode_5){
         //   scan_start();
            // Scan
        }else if(c == charcode_6){
            on_set_userfreq();
            // Scan
        } else if(c == charcode_7){
            menu_poweroff();
        } else if(c == charcode_8){
            // Set volume
            set_volume();
        } else if(c == charcode_9){
            _CLS();
            _LOCATE(0,0);
            printstr("Sig width:");
            val = setup.threshold_width;
            val = read_numeric(val, 1, 0, 1);
            akc6955_set_thresh_width((unsigned char)val);
            // Set NF
        } else if(c == charcode_0){
            // Setup Menu
            setup_menu();
        } else if(c == charcode_a){
            toggle_amfm();
        } else if(c == charcode_c){
            // Set userband
            set_userband();
        } else if(c == charcode_d){
            // Call userband
            input_userband();
        } else if (c == charcode_f){
            mainmenu_help();
            // HELP
        }
       _CLS();
       _LOCATE(0,0);
}

