/*
 * OpenI2CRADIO
 * Internal eeprom Handler
 * Copyright (C) 2013-06-13 K.Ohta <whatisthis.sowhat ai gmail.com>
 * License: GPL2+LE
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2,
 *  or (at your option) any later version.
 *  This library / program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *  See the GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this library; see the file COPYING. If not, write to the
 *  Free Software Foundation, 51 Franklin Street, Fifth Floor, Boston,
 *  MA 02110-1301, USA.
 *
 *  As a special exception, if you link this(includeed from sdcc) library
 *  with other files, some of which are compiled with SDCC,
 *  to produce an executable, this library does not by itself cause
 *  the resulting executable to be covered by the GNU General Public License.
 *  This exception does not however invalidate any other reasons why
 *  the executable file might be covered by the GNU General Public License.
 */

#if defined(__SDCC)
#include <sdcc-lib.h>
#include <pic18fregs.h> /* ONLY FOR PIC18x */
#else
#include <xc.h>
#endif
#include <signal.h>
#include "iodef.h"
#include "ui.h"
#include "eeprom.h"
#include "idle.h"
#include "ioports.h"

unsigned char eeprom_readbyte(unsigned int offset)
{

    // Set address.
    EEADR = (offset & 0x0ff);
#if defined(pic46k20) || defined(pic26k20)
    EEADRH = (offset & 0x300)>>8;
#endif
    // set eecon to read.
    EECON1bits.EEPGD = 0;
    EECON1bits.CFGS  = 0;
    EECON1bits.RD    = 1;

    return EEDATA;
}

unsigned char eeprom_writebyte(unsigned int offset, unsigned char data)
{
    EEDATA = data;
    // Set address.
    EEADR = offset & 0x0ff;
#if defined(pic46k20) || defined(pic26k20)
    EEADRH = (offset & 0x300)>>8;
#endif
    // set eecon to write.
    EECON1bits.EEPGD = 0;
    EECON1bits.CFGS  = 0;
    EECON1bits.WREN = 1;

//    INTCONbits.GIE = 0; // Disable Interrupt
    // Dummy write , needs from datasheet.
    EECON2 = 0x55;
    EECON2 = 0xaa;
    EECON1bits.WR = 1;

    do {
#ifdef __SDCC
        delay1ktcy(8);
#else
        __delay_ms(1);
#endif 
    } while(EECON1bits.WR != 0);
  //  if(EECON1bits.WRERR != 0){
        // Write-Error occured.
  //     EECON1bits.WREN = 0;
  //     INTCONbits.GIE = 1;
  //     return 0; // Error
  //  }
    // Write OK.
//    INTCONbits.GIE = 1; // Enable Interrupt
    EECON1bits.WREN = 0;
    return 0xff;
}

unsigned char readbyte_eeprom(unsigned int *p, unsigned int *sum)
{
    unsigned char b;

    ClrWdt();

    b = eeprom_readbyte(*p);
    *sum = calcsum_byte(*sum, b);
    *p = *p + 1;

    return b;
}

unsigned int readword_eeprom(unsigned int *p, unsigned int *sum)
{
    unsigned char h,l;
    unsigned int s;

//    ClrWdt();

    h = readbyte_eeprom(p, sum);
    l = readbyte_eeprom(p, sum);

    s = (h << 8) | l;
    return s;
}



unsigned int calcsum_byte(unsigned int seed, unsigned char byte)
{
    return seed + byte;
}

unsigned char checksum_eeprom(unsigned int seed, unsigned int offset, unsigned int bytes)
{
    unsigned int i;
    unsigned int p = offset;
    unsigned int sum = seed;
    unsigned char d;
    unsigned int check;

    for(i = 0; i < bytes; i++) {
        d = eeprom_readbyte(p);
        sum = calcsum_byte(sum, d);
        p++;
    }
    check = (eeprom_readbyte(p) << 8) + eeprom_readbyte(p+1);
    if(check != sum) return 0x00; // Bad
    return 0xff;
}

unsigned int writebyte_eeprom(unsigned int *p, unsigned int *sum, unsigned char b)
{
    ClrWdt();
    if(eeprom_writebyte(*p, b) == 0) return *p; // Error
    *sum = calcsum_byte(*sum, b);
    *p = *p + 1;
    return 0xffff;
}

unsigned int writeword_eeprom(unsigned int *p, unsigned int *sum, unsigned int word)
{
//    ClrWdt();
    if(writebyte_eeprom(p, sum, word >> 8) == 0) return *p; // Error
    if(writebyte_eeprom(p, sum, word & 0xff) == 0) return *p; // Error
    return 0xffff;
}


unsigned int format_eeprom(unsigned int start, unsigned int bytes)
{
    unsigned int i;
    unsigned int p = start;
    
    for(i = 0; i < bytes; i++) {
        ClrWdt();
        if(eeprom_writebyte(p, 0xff) == 0) {
            return p;
        }
//        _LOCATE(0,0);
//        print_numeric_nosupress(i, 3);
//        p = p + 1;
    }
    _CLS();
    _LOCATE(0,0);
    return 0xffff; // Normal end
}
