/*
 * OpenI2CRADIO
 * I/O Port defines / LCD.
 * Copyright (C) 2013-08-22 K.Ohta <whatisthis.sowhat ai gmail.com>
 * License: GPL2+LE
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2,
 *  or (at your option) any later version.
 *  This library / program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *  See the GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this library; see the file COPYING. If not, write to the
 *  Free Software Foundation, 51 Franklin Street, Fifth Floor, Boston,
 *  MA 02110-1301, USA.
 *
 *  As a special exception, if you link this(includeed from sdcc) library
 *  with other files, some of which are compiled with SDCC,
 *  to produce an executable, this library does not by itself cause
 *  the resulting executable to be covered by the GNU General Public License.
 *  This exception does not however invalidate any other reasons why
 *  the executable file might be covered by the GNU General Public License.
 */

#ifndef IODEF_LCD_H
#define	IODEF_LCD_H

#ifdef	__cplusplus
extern "C" {
#endif


#define _LCD_BACKLIGHT LATC
#define _LCD_BACKLIGHT_BIT b1
#define _LCD_BACKLIGHT_TRIS TRISC
//#else
//#define _LCD_BACKLIGHT _PORTC_RC2_MASK
//#endif // __SDCC

#define _LCD_PORT LATC

/*
 * LCD Control: Default register values, You should re-define in iodef.h if you need.
 */

#ifdef _LCD_IF_4BIT
/*
 * 4bit Interface, Used Below:
 * PORTD: RD0 : RS
 *        RD1 : RW
 *        RD2 : EN
 *        RD4-RD7: DATA(4-7).
 */
#ifndef _LCDPORT_DATA
#define _LCDPORT_DATA PORTD
#define _LCDPORT_TRIS_DATA TRISD
#define _LCDPORT_LATCH_DATA LATD
#define _LCDPORT_BUSYMASK 0b10000000
#define _LCDPORT_READMASK TRIS_D_RVAL
#define _LCDPORT_DATA_SHIFT 4
#endif

#ifndef _LCDPORT_CONT
#define _LCDPORT_CONT PORTD
#define _LCDPORT_TRIS_CONT TRISD
#define _LCDPORT_CONT_LATCH LATD
#define _LCDPORT_CONT_RSbit b0
#define _LCDPORT_CONT_RWbit b1
#define _LCDPORT_CONT_ENbit b2
#define _LCDPORT_CONT_BLbit b3
#define _LCDPORT_CONT_RS LATDbits.LATD0
#define _LCDPORT_CONT_RW LATDbits.LATD1
#define _LCDPORT_CONT_EN LATDbits.LATD2
#endif

#else
/*
 * 8bit Interface, Used Below:
 * PORTE: RE0 : RS
 *        RE1 : RW
 *        RE2 : EN
 * PORTD: RD0-RD7: DATA(0-7).
 */
// 8bit I/F
 #ifndef _LCDPORT_DATA
#define _LCDPORT_DATA PORTD
#define _LCDPORT_TRIS_DATA TRISD
#define _LCDPORT_LATCH_DATA LATD
#define _LCDPORT_BUSYMASK 0b10000000
#define _LCDPORT_READMASK TRIS_D_RVAL
 #endif

 #ifndef _LCDPORT_CONT
#define _LCDPORT_CONT PORTE
#define _LCDPORT_TRIS_CONT TRISE
#define _LCDPORT_CONT_RSbit 0
#define _LCDPORT_CONT_RWbit 1
#define _LCDPORT_CONT_ENbit 2
#define _LCDPORT_CONT_RS _PORTE_RE0
#define _LCDPORT_CONT_RW _PORTE_RE1
#define _LCDPORT_CONT_EN _PORTE_RE2
#define _LCDPORT_CONT_LATCH LATE
 #endif
#endif


#ifdef	__cplusplus
}
#endif

#endif	/* IODEF_LCD_H */

