/*
 * OpenI2CRADIO
 * Menu sub-routines: Memory Freq.
 * Copyright (C) 2013-08-14 K.Ohta <whatisthis.sowhat ai gmail.com>
 * License: GPL2+LE
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2,
 *  or (at your option) any later version.
 *  This library / program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *  See the GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this library; see the file COPYING. If not, write to the
 *  Free Software Foundation, 51 Franklin Street, Fifth Floor, Boston,
 *  MA 02110-1301, USA.
 *
 *  As a special exception, if you link this(includeed from sdcc) library
 *  with other files, some of which are compiled with SDCC,
 *  to produce an executable, this library does not by itself cause
 *  the resulting executable to be covered by the GNU General Public License.
 *  This exception does not however invalidate any other reasons why
 *  the executable file might be covered by the GNU General Public License.
 */

#include "menu.h"
#include "power.h"
#include "commondef.h"
#include "eeprom.h"
#include "backlight.h"

void call_freqbank(unsigned int num)
{
    unsigned char _fm;
    unsigned char _band;
    unsigned char _userband;
    unsigned int bank = num;
    unsigned int n = num;

    if(num >= USER_MEMORY_NUM) return;


    _fm = setup.memoryfreqs[n].fm;
    _userband = setup.memoryfreqs[n].band;
    _band = _userband & 0x1f;
    _userband = _userband >> 5;
    if(_fm) { // AM
        setup.fmband = _band;
        setup.fm_userbandnum = _userband;
    } else {
        setup.amband = _band;
        setup.am_userbandnum = _userband;
    }
    setup.memorynum = num;
    akc6955_chg_fm(_fm, setup.memoryfreqs[n].freq);
}


void set_freqbank(unsigned int num)
{
    unsigned char _fm;
    unsigned char _band;
    unsigned char _userband;
    unsigned int _freq;
    unsigned int n = num;

    if(num >= USER_MEMORY_NUM) return;


    _fm = setup.fm;
    _freq = setup.amfreq;
    _userband = setup.am_userbandnum;
    _band = setup.amband;
    if(_fm){
        _userband = setup.fm_userbandnum;
        _band = setup.fmband;
        _freq = setup.fmfreq;
    }
    setup.memoryfreqs[n].fm = _fm;
    setup.memoryfreqs[n].band = (_userband << 5) | (_band & 0x1f);
    setup.memoryfreqs[n].freq = _freq;

    save_eeprom();
}


void on_call_userfreq(void)
{
    unsigned long val = USER_MEMORY_NUM;
    _CLS();
    //_LOCATE(0,0);
    printstr("Mem: 00-");
    print_numeric_nosupress(val - 1, 2);
    val = read_numeric(val, 2, 4, 1);
    if(val < 0x80000000) call_freqbank(val);
}

void on_set_userfreq(void)
{
    unsigned long val = USER_MEMORY_NUM;
    unsigned char n;
    unsigned char c;
    _CLS();
    //_LOCATE(0,0);
    printstr("Set Mem: 00-");
    print_numeric_nosupress(val - 1, 2);
    val = read_numeric(val, 2, 4, 1);
    _HOME();
    if(val >= 0x80000000) return;
    printstr("OK? A=OK       ");
    c = pollkey_single();
    if(c != charcode_a) return;
    set_freqbank(val);
}

void on_updown_userfreq(void)
{
    unsigned int _freq;
    unsigned char _fm;
    unsigned char _band;
    unsigned char _userband;
    unsigned char c;
    unsigned char dispf = 0xff;

    _fm = setup.fm;
    _freq = setup.amfreq;
    _userband = setup.am_userbandnum;
    _band = setup.amband;
    if(_fm){
        _userband = setup.fm_userbandnum;
        _band = setup.fmband;
        _freq = setup.fmfreq;
    }

    _CLS();
    do {
        if(dispf != 0) {
            _LOCATE_0_0();
            printstr("CH:");
            print_numeric_nosupress(setup.memorynum, 2);
            printstr(" HELP = F");
            update_status();
            print_freq(1);
            _HOME();
        }
        c = pollkey_single_timeout(41, 1); // About 1s
        backlight_reset(c);
        dispf = backlight_dec(dispf);
       switch(c) {
           case charcode_7: // UP 1CH
                setup.memorynum++;
                if(setup.memorynum >= USER_MEMORY_NUM) setup.memorynum = 0;
                call_freqbank(setup.memorynum);
                break;
           case charcode_1: // Down 1CH
               if(setup.memorynum == 0) setup.memorynum = USER_MEMORY_NUM;
               setup.memorynum--;
               call_freqbank(setup.memorynum);
               break;
            case charcode_5: // Recall
               call_freqbank(setup.memorynum);
               break;
            case charcode_d: // Reset
               if(_fm) { // AM
                    setup.fmband = _band;
                    setup.fm_userbandnum = _userband;
                    setup.fmfreq = _freq;
               } else {
                    setup.amband = _band;
                    setup.am_userbandnum = _userband;
                    setup.amfreq = _freq;
               }
               akc6955_chg_fm(_fm, _freq);
               break;
           case charcode_4:
               on_call_userfreq();
               break;
           case charcode_6:
               on_set_userfreq();
               break;
           case charcode_a:
                goto _l0;
                break;
           case charcode_f:
               userfreq_help();
                _CLS();
               break;
           case charcode_e: // Set Light
           default:
               break;
           }
            idle_time_ms(9); // Pad 9ms, 1Loop = 1000ms.
    } while(1);
_l0:
    _CLS();

}
