/*
 * OpenI2CRADIO
 * Menu sub-routines / Setup.
 * Copyright (C) 2013-09-11 K.Ohta <whatisthis.sowhat ai gmail.com>
 * License: GPL2+LE
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2,
 *  or (at your option) any later version.
 *  This library / program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *  See the GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this library; see the file COPYING. If not, write to the
 *  Free Software Foundation, 51 Franklin Street, Fifth Floor, Boston,
 *  MA 02110-1301, USA.
 *
 *  As a special exception, if you link this(includeed from sdcc) library
 *  with other files, some of which are compiled with SDCC,
 *  to produce an executable, this library does not by itself cause
 *  the resulting executable to be covered by the GNU General Public License.
 *  This exception does not however invalidate any other reasons why
 *  the executable file might be covered by the GNU General Public License.
 */

#include "menu.h"
#include "menu_memoryfreq.h"
#include "power.h"
#include "commondef.h"
#include "backlight.h"

void menu_save(void)
{
    unsigned char c;
    c = printhelp_2lines("Save settings", "A=Yes");
    if(c == charcode_a) {
        save_eeprom();
    }
}

void menu_load(void)
{
    unsigned char c;
    c = printhelp_2lines("Load settings", "A=Yes B=Init");
    if(c == charcode_a) {
        c = load_eeprom();
        if( c != 0xff) {
            _CLS();
            //_LOCATE(0,0);
            c = printhelp_2lines("X) Load Error", "A=Fix");
            setdefault();
            if(c == charcode_a){
                save_eeprom();
            }
        }
        setup_akc6955();
    } else if(c == charcode_b){
        setdefault();
        setup_akc6955();
    }
}

void setup_menu(void)
{
    unsigned char c;
    unsigned long val;
    unsigned int val2;

    c = printhelp_2lines("Setup F=HELP", "5=Return");
    _CLS();
    //_LOCATE(0,0);
    switch(c){
        case charcode_3:
            printstr("BL Level:");
            val = read_numeric(setup.backlight_level, 3, 0,1);
            if(val < 0x80000000) {
                if(val > 255) val = 255;
                if(val < 10) val = 15;
                setup.backlight_level = (unsigned char)val;
                lcd_setbacklight(0xff, val);
            }
            break;
        case charcode_4:
            printstr("FM Bandwidth:");
            akc6955_get_fmbandwidth(val);
            val = read_numeric(val, 1, 0, 1);
            if(val < 0x80000000) {
                setup.fmbandwidth = val & 3;
                akc6955_set_fmbandwidth(setup.fmbandwidth);
            }
            break;
        case charcode_5:
            break;
        case charcode_6:
            printstr("UI Update:");
            val = read_numeric(setup.ui_idlecount, 4, 0, 1);
            if((val & 0x80000000) == 0) {
                val2 = (unsigned int)val;
                if(val2 > 5000) val2 = 5000; // Idle MAX=5000ms.
                if(val2 < 100) val2 = 100;
                setup.ui_idlecount = val2;
                ui_idlepad = val2 % 92;
                ui_idlekey = val2 / 23;
            }
            break;
        case charcode_7:
            printstr("FM-CNR:");
            val = setup.threshold_fmcnr;
            val = read_numeric(val, 1, 0, 1);
            if(val < 0x80000000) akc6955_set_thresh_fmcnr(val & 3);
            break;
        case charcode_8:
            printstr("AM-CNR:");
            val = setup.threshold_amcnr;
            val = read_numeric(val, 1, 0, 1);
            if(val < 0x80000000) akc6955_set_thresh_amcnr(val & 3);
            break;
        case charcode_9:
            printstr("Stereo th:");
            val = setup.threshold_fmstereo;
            val = read_numeric(val, 1, 0, 1);
            if(val < 0x80000000) akc6955_set_thresh_fmstereo(val & 3);
            break;
        case charcode_0:
            menu_poweroff();
            break;
        case charcode_a:
            menu_load();
            break;
        case charcode_c:
            menu_save();
            break;
        case charcode_d:
            setdefault();
            break;
        case charcode_e:
            printstr("BL Long:");
            val = read_numeric(setup.backlight_long, 3, 0,1);
            if(val < 0x80000000) {
                if(val > 999) val = 999;
                setup.backlight_long = val;
            }
            break;
        case charcode_f:
            setup_help();
            break;
        default:
            break;
    }
    _CLS();
    //_LOCATE(0,0);
}

