/*
 * Decompiled with CFR 0.152.
 */
package net.black_cow.opennip.ui.swing;

import net.black_cow.opennip.opennipcore.NipObserver;
import net.black_cow.opennip.opennipcore.NipPlayer;
import net.black_cow.opennip.opennipcore.NipStone;
import net.black_cow.opennip.ui.swing.OpenNipUI;
import net.black_cow.opennip.ui.swing.UIConstant;

public class ConcreteNipObserver
implements NipObserver {
    private OpenNipUI ui;

    ConcreteNipObserver(OpenNipUI ui) {
        this.ui = ui;
    }

    @Override
    public void onBothPlayersCannotPutStone() {
        this.ui.setMessage("\u4e21\u8005\u7f6e\u3051\u308b\u5834\u6240\u304c\u306a\u3044\u305f\u3081\u3001\u30b2\u30fc\u30e0\u7d42\u4e86\u3067\u3059\u3002");
        this.ui.showDialog("\u4e21\u8005\u7f6e\u3051\u308b\u5834\u6240\u304c\u306a\u3044\u305f\u3081\u3001\u30b2\u30fc\u30e0\u7d42\u4e86\u3067\u3059\u3002", 1800L, UIConstant.DESCRIPTION_FONT, null);
    }

    @Override
    public void onGameEnd(NipPlayer winner, int winnerScore, int loserScore) {
        if (winner == null) {
            this.ui.setMessage("\u30b2\u30fc\u30e0\u7d42\u4e86\uff01" + winnerScore + "\u5bfe" + loserScore + "\u3067\u5f15\u304d\u5206\u3051\u3067\u3059\u3002");
            this.ui.showDialog("<html>\u30b2\u30fc\u30e0\u7d42\u4e86\uff01<br>" + winnerScore + "\u5bfe" + loserScore + "\u3067\u5f15\u304d\u5206\u3051\u3067\u3059\u3002</html>", 1800L, UIConstant.DESCRIPTION_FONT, null);
        } else {
            String color = winner.getColor().equals((Object)NipStone.Color.BLACK) ? "\u9ed2" : "\u767d";
            this.ui.setMessage("\u30b2\u30fc\u30e0\u7d42\u4e86\uff01" + winnerScore + "\u5bfe" + loserScore + "\u3067" + color + "\u306e\u52dd\u3061\u3002");
            this.ui.showDialog("<html>\u30b2\u30fc\u30e0\u7d42\u4e86\uff01<br>" + winnerScore + "\u5bfe" + loserScore + "\u3067" + color + "\u306e\u52dd\u3061\u3002</html>", 1800L, UIConstant.DESCRIPTION_FONT, null);
        }
    }

    @Override
    public void onGameStart() {
        this.ui.refresh();
        this.ui.setMessage("\u30b2\u30fc\u30e0\u30b9\u30bf\u30fc\u30c8\uff01");
        this.ui.showDialog("\u30b2\u30fc\u30e0\u30b9\u30bf\u30fc\u30c8\uff01", 1500L, UIConstant.GAME_START_FONT, null);
    }

    @Override
    public void onNewStone(int row, int column, NipStone.Color color) {
        this.ui.drawBoard(row, column, color);
        this.ui.incrementScore(color);
        this.ui.refreshInformation();
        try {
            Thread.sleep(400L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void onNoPlaceToPut(NipPlayer player) {
        String color = player.getColor().equals((Object)NipStone.Color.BLACK) ? "\u9ed2" : "\u767d";
        String other = player.getColor().equals((Object)NipStone.Color.WHITE) ? "\u9ed2" : "\u767d";
        this.ui.setMessage(String.valueOf(color) + "\u306f\u7f6e\u3051\u308b\u5834\u6240\u304c\u306a\u3044\u305f\u3081\u3001" + other + "\u306b\u30bf\u30fc\u30f3\u304c\u79fb\u308a\u307e\u3059\u3002");
        this.ui.showDialog("<html>" + color + "\u306f\u7f6e\u3051\u308b\u5834\u6240\u304c\u306a\u3044\u305f\u3081\u3001<br>" + other + "\u306b\u30bf\u30fc\u30f3\u304c\u79fb\u308a\u307e\u3059\u3002</html>", 1800L, UIConstant.DESCRIPTION_FONT, null);
    }

    @Override
    public void onPlayerTurn(NipPlayer player) {
        String color = player.getColor().equals((Object)NipStone.Color.BLACK) ? "\u9ed2" : "\u767d";
        this.ui.setMessage(String.valueOf(color) + "\u306e\u30bf\u30fc\u30f3\u3002");
    }

    @Override
    public void onStoneColorChanged(int row, int column, NipStone.Color color) {
        this.ui.drawBoard(row, column, color);
        this.ui.incrementScore(color);
        this.ui.decrementScore(color.equals((Object)NipStone.Color.BLACK) ? NipStone.Color.WHITE : NipStone.Color.BLACK);
        this.ui.refreshInformation();
        try {
            Thread.sleep(400L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void onStoneColorChangedFinished() {
    }
}

