/*
 * Decompiled with CFR 0.152.
 */
package net.black_cow.opennip.opennipcore;

import java.util.ArrayList;
import java.util.List;
import net.black_cow.opennip.opennipcore.NipObserver;
import net.black_cow.opennip.opennipcore.NipPlayer;
import net.black_cow.opennip.opennipcore.NipStone;
import net.black_cow.opennip.opennipcore.NipTable;

public class NipManager {
    private NipPlayer first;
    private NipPlayer second;
    private NipTable table;
    private NipPlayer currentPlayer;
    private List<NipObserver> observers = new ArrayList<NipObserver>();

    public NipManager(NipPlayer first, NipPlayer second) {
        this.first = first;
        this.second = second;
        this.table = new NipTable();
        this.table.initTable();
        first.init(this.table, NipStone.Color.BLACK, second);
        second.init(this.table, NipStone.Color.WHITE, first);
        this.currentPlayer = first;
    }

    public void addObservers(NipObserver observer) {
        this.observers.add(observer);
        this.table.addObservers(observer);
    }

    public void play() {
        this.notifyObserversOnGameStart(this.table);
        while (this.table.getBlankCellCount() != 0 && this.table.getStoneCount(NipStone.Color.BLACK) != 0 && this.table.getStoneCount(NipStone.Color.WHITE) != 0) {
            this.notifyObserversPlayerTurn(this.currentPlayer);
            if (this.currentPlayer.canPutStone()) {
                this.currentPlayer.putStone();
            } else {
                if (!this.currentPlayer.getAnotherPlayer().canPutStone()) {
                    this.notifyBothPlayersCannotPutStone();
                    break;
                }
                this.notifyObserversOnNoPlaceToPut(this.currentPlayer);
            }
            this.currentPlayer = this.currentPlayer.getAnotherPlayer();
        }
        this.judgeAndNotifyResult();
    }

    public NipStone.Color getCellColor(int row, int column) {
        return this.table.getCellColor(row, column);
    }

    public int getStoneCount(NipStone.Color color) {
        return this.table.getStoneCount(color);
    }

    private void judgeAndNotifyResult() {
        int secondPlayerScore;
        int firstPlayerScore = this.table.getStoneCount(NipStone.Color.BLACK);
        if (firstPlayerScore > (secondPlayerScore = this.table.getStoneCount(NipStone.Color.WHITE))) {
            this.notifyObserversOnGameEnd(this.first, firstPlayerScore, secondPlayerScore);
        } else if (firstPlayerScore < secondPlayerScore) {
            this.notifyObserversOnGameEnd(this.second, secondPlayerScore, firstPlayerScore);
        } else {
            this.notifyObserversOnGameEnd(null, firstPlayerScore, secondPlayerScore);
        }
    }

    private void notifyObserversOnGameStart(NipTable table) {
        for (NipObserver observer : this.observers) {
            observer.onGameStart();
        }
    }

    private void notifyObserversOnGameEnd(NipPlayer winner, int winnerScore, int loserScore) {
        for (NipObserver observer : this.observers) {
            observer.onGameEnd(winner, winnerScore, loserScore);
        }
    }

    private void notifyObserversPlayerTurn(NipPlayer player) {
        for (NipObserver observer : this.observers) {
            observer.onPlayerTurn(player);
        }
    }

    private void notifyObserversOnNoPlaceToPut(NipPlayer player) {
        for (NipObserver observer : this.observers) {
            observer.onNoPlaceToPut(player);
        }
    }

    private void notifyBothPlayersCannotPutStone() {
        for (NipObserver observer : this.observers) {
            observer.onBothPlayersCannotPutStone();
        }
    }
}

