/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.util;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.StringTokenizer;
import org.postgresql.Driver;
import org.postgresql.jdbc1.AbstractJdbc1Connection;
import org.postgresql.jdbc1.AbstractJdbc1ResultSet;
import org.postgresql.util.PSQLException;

public class Serialize {
    protected Connection conn;
    protected String tableName;
    protected String className;
    protected Class ourClass;
    private static final String[][] tp = new String[][]{{"boolean", "bool"}, {"double", "float8"}, {"float", "float4"}, {"int", "int4"}, {"long", "int8"}, {"short", "int2"}, {"java.lang.String", "text"}, {"java.lang.Integer", "int4"}, {"java.lang.Float", "float4"}, {"java.lang.Double", "float8"}, {"java.lang.Short", "int2"}, {"char", "char"}, {"byte", "int2"}};

    public Serialize(Connection conn, String type) throws SQLException {
        try {
            this.conn = conn;
            if (Driver.logDebug) {
                Driver.debug("Serialize: initializing instance for type: " + type);
            }
            this.tableName = Serialize.toPostgreSQL(conn, type);
            this.className = type;
            this.ourClass = Class.forName(this.className);
        }
        catch (ClassNotFoundException cnfe) {
            if (Driver.logDebug) {
                Driver.debug("Serialize: " + this.className + " java class not found");
            }
            throw new PSQLException("postgresql.serial.noclass", (Object)type);
        }
        boolean status = false;
        String sql = conn.getMetaData().supportsSchemasInTableDefinitions() ? "SELECT 1 FROM pg_catalog.pg_type t, pg_catalog.pg_class c WHERE t.typrelid=c.oid AND c.relkind='r' AND t.typname='" + this.tableName + "' AND pg_table_is_visible(c.oid) " : "SELECT 1 FROM pg_type t, pg_class c WHERE t.typrelid=c.oid AND c.relkind='r' AND t.typname='" + this.tableName + "'";
        ResultSet rs = conn.createStatement().executeQuery(sql);
        if (rs != null) {
            if (rs.next()) {
                status = true;
                if (Driver.logDebug) {
                    Driver.debug("Serialize: " + this.tableName + " table found");
                }
            }
            rs.close();
        }
        if (!status) {
            if (Driver.logDebug) {
                Driver.debug("Serialize: " + this.tableName + " table not found");
            }
            throw new PSQLException("postgresql.serial.table", (Object)type);
        }
    }

    public Serialize(Connection c, Object o) throws SQLException {
        this(c, o.getClass().getName());
    }

    public Serialize(Connection c, Class cls) throws SQLException {
        this(c, cls.getName());
    }

    public Object fetch(long oid) throws SQLException {
        try {
            ResultSet rs;
            if (Driver.logDebug) {
                Driver.debug("Serialize.fetch: attempting to instantiate object of type: " + this.ourClass.getName());
            }
            Object obj = this.ourClass.newInstance();
            if (Driver.logDebug) {
                Driver.debug("Serialize.fetch: instantiated object of type: " + this.ourClass.getName());
            }
            Field[] f = this.ourClass.getFields();
            boolean hasOID = false;
            int oidFIELD = -1;
            StringBuffer sb = new StringBuffer("select");
            int sep = 32;
            for (int i = 0; i < f.length; ++i) {
                String n = f[i].getName();
                if (n.equals("oid")) {
                    hasOID = true;
                    oidFIELD = i;
                }
                sb.append((char)sep);
                sb.append(n);
                sep = 44;
            }
            sb.append(" from ");
            sb.append(this.tableName);
            sb.append(" where oid=");
            sb.append(oid);
            if (Driver.logDebug) {
                Driver.debug("Serialize.fetch: " + sb.toString());
            }
            if ((rs = this.conn.createStatement().executeQuery(sb.toString())) != null) {
                if (rs.next()) {
                    for (int i = 0; i < f.length; ++i) {
                        if (Modifier.isFinal(f[i].getModifiers())) continue;
                        if (f[i].getType().getName().equals("short")) {
                            f[i].setShort(obj, rs.getShort(i + 1));
                            continue;
                        }
                        if (f[i].getType().getName().equals("char")) {
                            f[i].setChar(obj, rs.getString(i + 1).toCharArray()[0]);
                            continue;
                        }
                        if (f[i].getType().getName().equals("byte")) {
                            f[i].setByte(obj, rs.getByte(i + 1));
                            continue;
                        }
                        if (f[i].getType().getName().equals("boolean")) {
                            if (rs.getString(i + 1).equals("t")) {
                                f[i].setBoolean(obj, true);
                                continue;
                            }
                            f[i].setBoolean(obj, false);
                            continue;
                        }
                        f[i].set(obj, rs.getObject(i + 1));
                    }
                }
            } else {
                throw new PSQLException("postgresql.unexpected");
            }
            rs.close();
            return obj;
        }
        catch (IllegalAccessException iae) {
            throw new SQLException(iae.toString());
        }
        catch (InstantiationException ie) {
            throw new SQLException(ie.toString());
        }
    }

    public int store(Object o) throws SQLException {
        return (int)this.storeObject(o);
    }

    public long storeObject(Object o) throws SQLException {
        try {
            String n;
            int i;
            Field[] f = this.ourClass.getFields();
            boolean hasOID = false;
            int oidFIELD = -1;
            boolean update = false;
            for (int i2 = 0; i2 < f.length; ++i2) {
                String n2 = f[i2].getName();
                if (!n2.equals("oid")) continue;
                hasOID = true;
                oidFIELD = i2;
                update = f[i2].getInt(o) > 0;
            }
            StringBuffer sb = new StringBuffer(update ? "update " + this.tableName + " set" : "insert into " + this.tableName + " ");
            int sep = update ? 32 : 40;
            for (i = 0; i < f.length; ++i) {
                n = f[i].getName();
                if (n.equals("oid")) continue;
                sb.append((char)sep);
                sep = 44;
                sb.append(n);
                if (!update) continue;
                sb.append('=');
                if (f[i].get(o) == null) {
                    sb.append("null");
                    continue;
                }
                if (f[i].getType().getName().equals("java.lang.String") || f[i].getType().getName().equals("char")) {
                    sb.append('\'');
                    sb.append(this.fixString(f[i].get(o).toString()));
                    sb.append('\'');
                    continue;
                }
                sb.append(f[i].get(o).toString());
            }
            if (update) {
                sb.append(" where oid = " + f[oidFIELD].getInt(o));
            }
            if (!update) {
                sb.append(") values ");
                sep = 40;
                for (i = 0; i < f.length; ++i) {
                    n = f[i].getName();
                    if (n.equals("oid")) continue;
                    sb.append((char)sep);
                    sep = 44;
                    if (f[i].get(o) == null) {
                        sb.append("null");
                        continue;
                    }
                    if (f[i].getType().getName().equals("java.lang.String") || f[i].getType().getName().equals("char")) {
                        sb.append('\'');
                        sb.append(this.fixString(f[i].get(o).toString()));
                        sb.append('\'');
                        continue;
                    }
                    sb.append(f[i].get(o).toString());
                }
                sb.append(')');
            }
            if (Driver.logDebug) {
                Driver.debug("Serialize.store: " + sb.toString());
            }
            ResultSet rs = ((AbstractJdbc1Connection)((Object)this.conn)).ExecSQL(sb.toString());
            if (update) {
                if (rs != null) {
                    rs.close();
                }
                return f[oidFIELD].getInt(o);
            }
            long newOID = ((AbstractJdbc1ResultSet)((Object)rs)).getLastOID();
            rs.close();
            if (hasOID) {
                f[oidFIELD].setLong(o, newOID);
            }
            return newOID;
        }
        catch (IllegalAccessException iae) {
            throw new SQLException(iae.toString());
        }
    }

    private String fixString(String s) {
        StringTokenizer tok;
        StringBuffer buf;
        int idx = -1;
        if (s == null) {
            return "";
        }
        idx = s.indexOf("'");
        if (idx > -1) {
            buf = new StringBuffer();
            tok = new StringTokenizer(s, "'");
            if (idx > 0) {
                buf.append(tok.nextToken());
            }
            while (tok.hasMoreTokens()) {
                buf.append("''").append(tok.nextToken());
            }
            s = buf.toString();
        }
        if ((idx = s.indexOf("\\")) > -1) {
            buf = new StringBuffer();
            tok = new StringTokenizer(s, "\\");
            if (idx > 0) {
                buf.append(tok.nextToken());
            }
            while (tok.hasMoreTokens()) {
                buf.append("\\\\").append(tok.nextToken());
            }
            s = buf.toString();
        }
        return s;
    }

    public static void create(Connection con, Object o) throws SQLException {
        Serialize.create(con, o.getClass());
    }

    public static void create(Connection conn, Class c) throws SQLException {
        if (c.isInterface()) {
            throw new PSQLException("postgresql.serial.interface");
        }
        String tableName = Serialize.toPostgreSQL(conn, c.getName());
        String sql = conn.getMetaData().supportsSchemasInTableDefinitions() ? "SELECT 1 FROM pg_catalog.pg_class WHERE relkind='r' AND relname='" + tableName + "' AND pg_table_is_visible(oid) " : "SELECT 1 FROM pg_class WHERE relkind='r' AND relname='" + tableName + "'";
        ResultSet rs = conn.createStatement().executeQuery(sql);
        if (rs.next()) {
            if (Driver.logDebug) {
                Driver.debug("Serialize.create: table " + tableName + " exists, skipping");
            }
            rs.close();
            return;
        }
        if (Driver.logDebug) {
            Driver.debug("Serialize.create: table " + tableName + " not found, creating");
        }
        StringBuffer sb = new StringBuffer("create table ");
        sb.append(tableName);
        int sep = 40;
        Field[] fields = c.getFields();
        for (int i = 0; i < fields.length; ++i) {
            int j;
            Class<?> type = fields[i].getType();
            if (fields[i].getName().equals("oid")) continue;
            sb.append((char)sep);
            sb.append(fields[i].getName());
            sb.append(' ');
            sep = 44;
            if (type.isArray()) continue;
            String n = type.getName();
            for (j = 0; j < tp.length && !tp[j][0].equals(n); ++j) {
            }
            if (j < tp.length) {
                sb.append(tp[j][1]);
                continue;
            }
            Serialize.create(conn, type);
            sb.append(Serialize.toPostgreSQL(conn, n));
        }
        sb.append(")");
        if (Driver.logDebug) {
            Driver.debug("Serialize.create: " + sb);
        }
        conn.createStatement().executeUpdate(sb.toString());
    }

    public static String toPostgreSQL(Connection con, String name) throws SQLException {
        DatabaseMetaData dbmd = con.getMetaData();
        int maxNameLength = dbmd.getMaxTableNameLength();
        return Serialize.toPostgreSQL(maxNameLength, name);
    }

    public static String toPostgreSQL(String name) throws SQLException {
        return Serialize.toPostgreSQL(31, name);
    }

    private static String toPostgreSQL(int maxNameLength, String name) throws SQLException {
        if ((name = name.toLowerCase()).indexOf("_") > -1) {
            throw new PSQLException("postgresql.serial.underscore");
        }
        if (name.length() > maxNameLength && (name = name.substring(name.lastIndexOf(".") + 1)).length() > maxNameLength) {
            throw new PSQLException("postgresql.serial.namelength", (Object)name, new Integer(name.length()));
        }
        return name.replace('.', '_');
    }

    public static String toClassName(String name) throws SQLException {
        name = name.toLowerCase();
        return name.replace('_', '.');
    }
}

