package openolap.viewer;

import javax.xml.parsers.*;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import java.io.*;

import org.xml.sax.*;

//for selectSingleNode
import org.apache.xpath.*;
import org.w3c.dom.traversal.*;

import javax.xml.transform.*;
import javax.xml.transform.stream.*;
import javax.xml.transform.dom.*;

public class XMLConverter {
	DocumentBuilderFactory dbfactory;
	DocumentBuilder builder;

	public XMLConverter() {
		try {
			// hLgr_[t@Ng𐶐
			dbfactory = DocumentBuilderFactory.newInstance();
			// hLgr_[𐶐
			builder = dbfactory.newDocumentBuilder();
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	public Node selectSingleNode(Document doc,String xpath) {
		try{
			NodeIterator nl = XPathAPI.selectNodeIterator(doc,xpath);
			return nl.nextNode();

		} catch (Exception e) {
			e.printStackTrace();
		}
		return null;
	}

	public String toXMLText(Document doc) {
		try{
			TransformerFactory transFactory = TransformerFactory.newInstance();
			Transformer transformer = transFactory.newTransformer();
			transformer.setOutputProperty("encoding","Shift_JIS");//Shift_JISŏo
			DOMSource source = new DOMSource(doc);
			StringWriter writer = new StringWriter();
			StreamResult result = new StreamResult(writer); 
			transformer.transform(source, result);
			return writer.toString();
		} catch (Exception e) {
			e.printStackTrace();
		}
		return null;
	}

	public String toXMLText(Element ele) {
		try{
			TransformerFactory transFactory = TransformerFactory.newInstance();
			Transformer transformer = transFactory.newTransformer();
			transformer.setOutputProperty("encoding","Shift_JIS");//Shift_JISŏo
			DOMSource source = new DOMSource(ele);
			StringWriter writer = new StringWriter();
			StreamResult result = new StreamResult(writer); 
			transformer.transform(source, result);
			return writer.toString();
		} catch (Exception e) {
			e.printStackTrace();
		}
		return null;
	}

	public String toXMLText(Node node) {
		try{
			TransformerFactory transFactory = TransformerFactory.newInstance();
			Transformer transformer = transFactory.newTransformer();
			transformer.setOutputProperty("encoding","Shift_JIS");//Shift_JISŏo
			DOMSource source = new DOMSource(node);
			StringWriter writer = new StringWriter();
			StreamResult result = new StreamResult(writer); 
			transformer.transform(source, result);
			return writer.toString();
		} catch (Exception e) {
			e.printStackTrace();
		}
		return null;
	}

	public Document toXMLDocument(String XMLString) {
		try{
			InputSource input = new InputSource(new StringReader(XMLString));
			Document doc = builder.parse(input);
			return doc;
		} catch (Exception e) {
			e.printStackTrace();
		}
		return null;
	}

	public Document readFile(String filepath) {
		try{
			File a = new File(filepath);
			FileInputStream b = new FileInputStream(a);
			BufferedInputStream input = new BufferedInputStream(b);
			Document doc = builder.parse(input);
			return doc;
		} catch (Exception e) {
			e.printStackTrace();
		}
		return null;
	}

	public boolean saveFile(String filepath,Document doc) {
		try{
			TransformerFactory transFactory = TransformerFactory.newInstance();
			Transformer transformer = transFactory.newTransformer();
			transformer.setOutputProperty("encoding","Shift_JIS");//Shift_JISŏo

			DOMSource source = new DOMSource(doc);
			File file = new File(filepath); 
			FileOutputStream out = new FileOutputStream(file); 
			StreamResult result = new StreamResult(out); 
			transformer.transform(source, result);
		} catch (Exception e) {
			e.printStackTrace();
		}
		return true;
	}

	public String transformDocument(String xslFilepath,Document xmlDoc) {
		try{
			TransformerFactory transFactory = TransformerFactory.newInstance();
			Transformer transformer = transFactory.newTransformer(new StreamSource(xslFilepath));

//ȉ̌`ɂƁAXSLTVersionHeaderĂ܂B
//Transformer transformer = transFactory.newTransformer(xsltDocS);

			transformer.setOutputProperty("encoding","Shift_JIS");//Shift_JISŏo

			StringWriter writer = new StringWriter();
			StreamResult result = new StreamResult(writer); 

			DOMSource xmlDocS = new DOMSource(xmlDoc);
			transformer.transform(xmlDocS, result);

			return writer.toString();

		} catch (Exception e) {
			e.printStackTrace();
		}
		return null;
	}
}
