/*  OpenOlap viewer
 *  pbP[WFopenolap.viewer
 *  t@CFController.java
 *  FNCAg̗vServletNXłB
 *
 *  쐬: 2004/01/05
 */

package openolap.viewer.controller;

import java.io.IOException;

import javax.servlet.RequestDispatcher;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import openolap.viewer.common.CommonSettings;
import openolap.viewer.common.Messages;

/**
 * NXFController<br>
 * FR}h킷C^[tF[XłB
 */
public class Controller extends HttpServlet {

	// ********** \bh **********

	/**
	 * T[ubg̏sB
	 * @param config ServletConfigIuWFNg
	 * @exception ServletException Servlet̏ŗO
	 */
	public void init(ServletConfig config) throws ServletException {
		super.init(config);
	}

	/**
	 * T[ubg̏IsB
	 */
	public void destroy() {
	}

	/**
	 * HTTPNGXg󂯂ďsB
	 * @param request HttpServletRequestIuWFNg
	 * @param response HttpServletResponseIuWFNg
	 * @exception ServletException ɗO
	 * @exception IOException ɗO
	 */
	protected void processRequest(
		HttpServletRequest request,HttpServletResponse response) 
		throws ServletException,java.io.IOException {

		// R[hݒ
		request.setCharacterEncoding("Shift_JIS");

		// RlNVv[ݒ
		String connectionPoolName = request.getParameter("poolName");
		if (connectionPoolName != null) { // NGXg
			if (!"".equals(connectionPoolName)) { // 󕶎ł͂Ȃ
				request.getSession().setAttribute("connectionPoolName", connectionPoolName);
			} else {
				if (request.getSession().getAttribute("connectionPoolName") == null) {
					throw new IllegalStateException();
				}
			}
		}

		// T[`pXݒiPostgrespj
		String sourceName = Messages.getString("DAOFactory.sourceName"); //$NON-NLS-1$
		if (sourceName.equals("postgreSQL")) { //$NON-NLS-1$
			String searchPathName = request.getParameter("schemaName");
			if (searchPathName != null) { // NGXg
				if (!"".equals(searchPathName)) { // 󕶎ł͂Ȃ
					request.getSession().setAttribute("searchPathName", searchPathName);
				} else {
					if (request.getSession().getAttribute("searchPathName") == null) {
						throw new IllegalStateException();
					}
				}
			}
		}
		
		// 
		ServletContext context = getServletConfig().getServletContext();
		if ( context.getAttribute("apCommonSettings") == null ) {
			InitializeStatus.initApStatus(request, context);
		}

		String page;
		try {
			// ĂяoƖI
			RequestHelper helper = new RequestHelper(request, response, getServletConfig());
			Command command = helper.getCommand();
	
			if (command == null) { throw new IllegalStateException(); }
			if (context == null) { throw new IllegalStateException();	}

			// ƖĂяo
			page = command.execute(helper, (CommonSettings) context.getAttribute("apCommonSettings"));
		} catch(Exception e) {
			e.printStackTrace();
			return;
		}

			//NGXgɑΉy[WɃfBXpb`
			if(page != null) {
				dispatch(request,response,page);
			}

	}

	/**
	 * HTTP GETnhOB
	 * @param request HttpServletRequestIuWFNg
	 * @param response HttpServletResponseIuWFNg
	 * @exception ServletException ɗO
	 * @exception IOException ɗO
	 */
	protected void doGet(
		HttpServletRequest request,
		HttpServletResponse response)
		throws ServletException, IOException {

		processRequest(request,response);
	}

	/**
	 * HTTP POSTnhOB
	 * @param request HttpServletRequestIuWFNg
	 * @param response HttpServletResponseIuWFNg
	 * @exception ServletException ɗO
	 * @exception IOException ɗO
	 */
	protected void doPost(
		HttpServletRequest request,
		HttpServletResponse response)
		throws ServletException, IOException {

		processRequest(request,response);
	}

	/**
	 * JSP/HTMLւdispatchsB
	 * @param request HttpServletRequestIuWFNg
	 * @param response HttpServletResponseIuWFNg
	 * @param page dispatchJSP/HTMLւ̃pX
	 * @exception ServletException ɗO
	 * @exception IOException ɗO
	 */
	protected void dispatch(
		HttpServletRequest request,
		HttpServletResponse response,
		String page) 
		throws ServletException,java.io.IOException {

		RequestDispatcher dispatcher = getServletContext().getRequestDispatcher(page);
		dispatcher.forward(request,response);
	}

}
