/*  OpenOlap viewer
 *  pbP[WFopenolap.viewer.controller
 *  t@CFSearchDimensionMemberCommand.java
 *  FfBVo[^ꂽŌNXłB
 *
 *  쐬: 2004/01/09
 */
package openolap.viewer.controller;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;

import javax.servlet.ServletException;

import openolap.viewer.Dimension;
import openolap.viewer.Report;
import openolap.viewer.common.CommonSettings;
import openolap.viewer.common.Constants;
import openolap.viewer.dao.DAOFactory;
import openolap.viewer.dao.DimensionMemberDAO;


/**
 *  NXFSearchDimensionMemberCommand<br>
 *  FfBVo[^ꂽŌNXłB
 */
public class SearchDimensionMemberCommand implements Command {

	// ********** CX^Xϐ **********

	/** RequestHelperIuWFNg */
	private RequestHelper requestHelper = null;

	// ********** \bh **********

	/**
	 * LŃo[<br>
	 *   |"dimNumber" p[^Ŏw肳ꂽ<br>
	 *   |"listMemberName" o[̖́iChJ[hF*A_j<br>
	 *   |"listLevel" o[̃x<br>
	 * ʂŃZN^{fB[y[W߂B
	 * @param helper RequestHelperIuWFNg
	 * @param commonSettings AvP[V̋ʐݒIuWFNg
	 * @return dispatchJSP/HTML̃pX
	 * @exception ServletException ɗO
	 * @exception IOException ɗO
	 */
	public String execute(RequestHelper helper, CommonSettings commonSettings)
		throws ServletException, IOException {

			this.requestHelper = helper;

			Report report = (Report) this.requestHelper.getRequest().getSession().getAttribute("report");

			String AxisID = this.requestHelper.getRequest().getParameter("dimNumber");
			if(AxisID.equals(Constants.MeasureID)){	// ǒȂ̂ŁAW[ł邱Ƃ͂肦Ȃ
				throw new IllegalStateException();
			}

			Dimension dim = (Dimension) report.getAxisByID(AxisID);

			Connection conn = null;
			DAOFactory daoFactory = DAOFactory.getDAOFactory();
			conn = daoFactory.getConnection((String)helper.getRequest().getSession().getAttribute("connectionPoolName"),
											(String)helper.getRequest().getSession().getAttribute("searchPathName"));

			DimensionMemberDAO dimMemberDAO =  daoFactory.getDimensionMemberDAO(conn);

			String searchMemName = this.requestHelper.getRequest().getParameter("listMemberName");
			String searchLevel   = this.requestHelper.getRequest().getParameter("listLevel");

			String shortNameCondition = null;
			String longNameCondition = null;

			if(dim.getDispMemberNameType().equals(Dimension.DISP_SHORT_NAME)){
				shortNameCondition = searchMemName;
			} else if(dim.getDispMemberNameType().equals(Dimension.DISP_LONG_NAME)){
				longNameCondition = searchMemName;
			} else {
				throw new IllegalStateException();
			}
			
			try {
				ArrayList dimMemberList;
				dimMemberList =	dimMemberDAO.selectDimensionMembers(
								dim,
								shortNameCondition,
								longNameCondition,
								searchLevel,
								null);
				dim.setAxisMemberList(dimMemberList);

			} catch (SQLException e) {
				e.printStackTrace();
			} catch (Exception e) {
				e.printStackTrace();
			} finally {
				if(conn != null){
					try {
						conn.close();
					} catch (SQLException e) {
						e.printStackTrace();
					}
				}
			}

			return "/spread/SelecterSearch.jsp";

	}
}
