/*  OpenOlap viewer
 *  pbP[WFopenolap.viewer.dao
 *  t@CFCellDataSQL.java
 *  FZf[^擾ɎgpSQL킷NXłB
 *
 *  쐬: 2004/02/01
 */
package openolap.viewer.dao;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.StringTokenizer;

import openolap.viewer.Axis;
import openolap.viewer.Dimension;
import openolap.viewer.Edge;
import openolap.viewer.MeasureMember;
import openolap.viewer.Report;
import openolap.viewer.common.CommonSettings;
import openolap.viewer.common.Constants;
import openolap.viewer.common.StringUtil;

/**
 *  NXFCellDataSQL<br>
 *  FZf[^擾ɎgpSQL킷NXłB
 */
public class CellDataSQL {

	// ********** CX^Xϐ **********

	/** ReportIuWFNg */
	private Report report = null;

	/** GbWɔzuꂽɑΉFacte[ũJA擾ΏۃW[Xg */
	private ArrayList colFactKeyColumnList = new ArrayList();

	/** sGbWɔzuꂽɑΉFacte[ũJA擾ΏۃW[Xg */
	private ArrayList rowFactKeyColumnList = new ArrayList();

	/** y[WGbWɔzuꂽɑΉFacte[ũJA擾ΏۃW[Xg */
	private ArrayList pageFactKeyColumnList = new ArrayList();


	/** Facte[u */
	private String factTableName = null;


	/** 
	 * ɔzuꂽWHERE߂킷IuWFNgB
	 * ̎킷Facte[ũL[JKeyƂA擾ΏۂƂȂ郁o[L[XgValueɎB
	 */
	private LinkedHashMap colWhereClauseMap = new LinkedHashMap();

	/** 
	 * sɔzuꂽWHERE߂킷IuWFNgB
	 * ̎킷Facte[ũL[JKeyƂA擾ΏۂƂȂ郁o[L[XgValueɎB
	 */
	private LinkedHashMap rowWhereClauseMap = new LinkedHashMap();

	/** 
	 * y[WɔzuꂽWHERE߂킷IuWFNgB
	 * ̎킷Facte[ũL[JKeyƂA擾ΏۂƂȂ郁o[L[XgValueɎB
	 */
	private LinkedHashMap pageWhereClauseMap = new LinkedHashMap();

	// W[y[WGbWɂƂ̃ftHgo[L[(UName)
	private String measureDefaultMember = null;


	// ********** static \bh **********

	/**
	 * CellDataSQLIuWFNg𐶐B
	 * @param report |[gIuWFNg
	 * @param conn ConnecionIuWFNg
	 * @param items eGbW̎IDXg
	 * @param selectKeys f[^擾ΏۂƂȂEswb_KeyXg
	 *		  selectKeys[0]Fwb_KeyXg
	 *		  selectKeys[1]Fswb_KeyXg
	 * @param formatValue lɃW[o[ɐݒ肳ꂽMeasureMemberTypȅKpȂtrueAPʂ݂̂낦鏑KpȂfalse
	 * @param commonSettings AvP[V̋ʐݒ킷IuWFNg
	 * @return CellDataSQLIuWFNg
	 */
	public static CellDataSQL getSelectReportDataSQL(Report report, Connection conn, Object[] items, Object[] selectKeys, boolean formatValue, CommonSettings commonSettings) {

		CellDataSQL cellDataSQL = new CellDataSQL();

		int i;
		int j;
		int k;
		StringTokenizer st;

		// |[gIuWFNgZbg
		cellDataSQL.setReport(report);

		// t@Nge[uݒ
		cellDataSQL.setFactTableName(DAOFactory.getDAOFactory().getCubeDAO(null).getFactTableName(report.getCube().getCubeSeq()));

		
		String[] edgeAxisInfoList;		// GbW̎i[IuWFNg
		String axisID;					// ID
		String tmpItemValuePair[];		// e[uIDKEYi[z
										// Y0Fe[uIDAY1FKEY

		String measureMemberKey = "";	// 擾ɐݒ肷郁W[Key
		String meaIndex = "";			// W[Index
		int selectedMeasureNum = 1;	// f[^擾ΏۂƂȂ郁W[̃o[
	
		for ( i = 0; i < items.length; i++ ) {	// GbW̐s
			edgeAxisInfoList = (String[])items[i];
			for ( j = 0; j < edgeAxisInfoList.length; j++ ) {	//GbWɔzuꂽs
				if ( i == 2 ) {	
				// y[WGbW̏ꍇ
				// tmpHieItems̔z̊evf́Ae[uIDKEYȂB
				// j<ID>:<KEY> 
				// 	F̏ꍇj     1:0
				// 	FW[̏ꍇj 16:<UNAME>(1`50)
					st = new StringTokenizer(edgeAxisInfoList[j],":");
					tmpItemValuePair = new String[st.countTokens()];
					k = 0;
					while ( st.hasMoreTokens() ) {
						tmpItemValuePair[k] = st.nextToken();
						k++;
					}
					axisID      		= tmpItemValuePair[0];	// ID
					measureMemberKey 	= tmpItemValuePair[1];	// o[KEY
					selectedMeasureNum 	= 1;
				} else {		// sEGbW̏ꍇ
					axisID = edgeAxisInfoList[j];
					selectedMeasureNum = report.getTotalMeasureMemberNumber();	// L[u̎SW[
				}
	
				if ( Constants.MeasureID.equals(axisID) ) {	// W[
					String measureLists = "";	// W[Xg
					for ( k = 0; k < selectedMeasureNum; k++ ) {
						if ( i == 2 ) {
							meaIndex = measureMemberKey.substring(measureMemberKey.indexOf("_") + 1, measureMemberKey.length());
	
							if ( (meaIndex.length() == 2) && (meaIndex.substring(0,1).equals("0") ) ) {
								meaIndex = meaIndex.substring(1,2);
							}
	
							// (y[Wɔzuꂽꍇ)W[̃ftHgo[o^
							cellDataSQL.setMeasureDefaultMember(meaIndex);
	
						} else {
							meaIndex = Integer.toString(k+1);
						}
						MeasureMember measureMember = (MeasureMember) report.getMeasure().getAxisMemberByUniqueName(meaIndex);
						if ( measureMember.isSelected() ) {	// ZN^ł͂ĂȂȂ
							if ( measureLists != "" ) {
								measureLists += ",";
							}

							String measureString = null;
							if (formatValue) { // ltH[}bgtŎ擾
								measureString = StringUtil.regReplaceAll("%measure%", "MEASURE[" + meaIndex + "]", measureMember.getMeasureMemberType().getFunction_name());
							} else { // lPʃtH[}bĝ݂Ŏ擾
								String unitFunctionID = measureMember.getMeasureMemberType().getUnitFunctionID();
								measureString = StringUtil.regReplaceAll("%measure%", "MEASURE[" + meaIndex + "]", commonSettings.getMeasureMemberTypeByID(unitFunctionID).getFunction_name());
							}
							measureLists += measureString + " as measure_" + meaIndex;

						}
					}

					// SELECT
					cellDataSQL.addFactKeyColumnList(i, measureLists);

				} else {	// fBV

					String factKeyColumn = "";

					// ZNg
					if ( Integer.valueOf(axisID).intValue() < 10 ) {
						factKeyColumn = "DIM_0" + axisID;
					} else {

						factKeyColumn = "DIM_"  + axisID;
					}
					cellDataSQL.addFactKeyColumnList(i, factKeyColumn);
	
					// WHERE
					if ( i == 2 ) {// y[WGbW
						ArrayList tmpList = new ArrayList();
						tmpList.add(measureMemberKey);
						cellDataSQL.putWhereClauseMap(i, factKeyColumn, tmpList);

					} else {		// sAGbW
						String[] selectEdgeKeys = (String[])selectKeys[i];		// Iꂽo[Xg̏W(GbWP)
						String   selectAxisKeys = selectEdgeKeys[j];			// Iꂽo[Xg
						cellDataSQL.putWhereClauseMap(i, factKeyColumn, StringUtil.splitString(selectAxisKeys,","));

					}
				}
			}
		}
		
		return cellDataSQL;
	}

	// ********** \bh **********

	/**
	 * Zf[^擾SQL߂B
	 * @return SQL
	 */
	public String getSQLString() {

		// SELECTóifBV{W[j
		// W[̍i݂͂Ŕf
		String SQL = this.getSelectClause();

		SQL += " FROM ";
		SQL += getFactTableName();

		// WHEREóifBV̂݁j
		SQL += " WHERE ";

		SQL += this.getWhereClause(this.getColWhereClauseMap());
		if (colWhereClauseMap.size()>0) { // COLɃfBVzuĂ
			if (rowWhereClauseMap.size()>0) {	// ROWɃfBVzuĂ
				SQL += " and ";
			}
		}
		SQL += this.getWhereClause(this.getRowWhereClauseMap());

		if (pageWhereClauseMap.size()>0) {	// y[WɎzuĂȂꍇ
				SQL += " and ";
			SQL += this.getWhereClause(this.getPageWhereClauseMap());
		}
		
		return SQL;
	}




	/**
	 * \[gς݂̃Zf[^擾SQL߂B
	 * @return SQL
	 */
	public String getSQLStringForSortData() {
		
		// SELECTo
		String SQL = this.getSelectClause();

		SQL += " FROM (";
		SQL += "   SELECT * FROM ";
		SQL += getFactTableName();		
		
		// FROM̕₢킹WHERE𐶐
		SQL += " WHERE " + this.getWhereClause(this.getColWhereClauseMap());
		if (colWhereClauseMap.size()>0) { // COLɃfBVzuĂ
			if (rowWhereClauseMap.size()>0) {	// ROWɃfBVzuĂ
				SQL += " and ";
			}
		}
		SQL += this.getWhereClause(this.getRowWhereClauseMap());

		if (pageWhereClauseMap.size()>0) {	// y[WɎzuĂȂꍇ
				SQL += " and ";
			SQL += this.getWhereClause(this.getPageWhereClauseMap());
		}
		
		// FROM̕₢킹镔𐶐
		SQL += " ) as fact ";

		Iterator edgeIt = report.getEdgeList().iterator();

		while (edgeIt.hasNext()) {
			Edge edge = (Edge) edgeIt.next();
			Iterator axisIt = edge.getAxisList().iterator();
			while (axisIt.hasNext()) {
				Axis axis = (Axis) axisIt.next();

				if (axis instanceof Dimension) {
					Dimension dimension = (Dimension) axis;

					SQL += ",(SELECT * FROM oo_dim_tree('";
					SQL +=     "oo_dim_" + dimension.getDimensionSeq() + "_" + dimension.getPartSeq() + "'";
					SQL +=     ",null,',";

					String factColumnName = "DIM_";
					if (dimension.getId().length() < 2){
						factColumnName += "0";
					}
					factColumnName += dimension.getId();
					ArrayList memberKeyList = (ArrayList) this.getAxisWhereClauseMap(edge.getPosition()).get(factColumnName);
					SQL += StringUtil.joinList(memberKeyList, ",");

					SQL +=     ",')) as oo_dim_" + dimension.getDimensionSeq() + "_" + dimension.getPartSeq();

				}
			}
		}

		// WHEREit@NgƃfBVJoin`j𐶐
		// Orderby𐶐
		SQL += " where ";
		edgeIt = report.getEdgeList().iterator();
		int i = 0;
		while (edgeIt.hasNext()) {
			Edge edge = (Edge) edgeIt.next();
			Iterator axisIt = edge.getAxisList().iterator();
			while (axisIt.hasNext()) {
				Axis axis = (Axis) axisIt.next();
				if (axis instanceof Dimension) {
					Dimension dimension = (Dimension) axis;
					if (i!=0) {
						SQL += " and ";
					}

					String factColumnName = "DIM_";
					if (dimension.getId().length() < 2){
						factColumnName += "0";
					}
					factColumnName += dimension.getId();
					SQL +=     "fact." + factColumnName + "=";
					SQL +=     "oo_dim_" + dimension.getDimensionSeq() + "_" + dimension.getPartSeq() + ".key";
					i++;
				}
			}
		}

		// Orderby𐶐(AsAy[W̏)
		SQL += " order by ";

		// Row
		Edge edge = report.getEdgeByType(Constants.Row);
		Iterator it = edge.getAxisList().iterator();
		i = 0;
		while (it.hasNext()) {
			Axis axis = (Axis) it.next();
			if (axis instanceof Dimension) {
				Dimension dimension = (Dimension) axis;
				if (i!=0) {
					SQL += ",";
				}
				SQL +=     "oo_dim_" + dimension.getDimensionSeq() + "_" + dimension.getPartSeq() + ".rownum";
				i++;
			}
		}

		// Col
		edge = report.getEdgeByType(Constants.Col);
		it = edge.getAxisList().iterator();
		while (it.hasNext()) {
			Axis axis = (Axis) it.next();
			if (axis instanceof Dimension) {
				Dimension dimension = (Dimension) axis;
				if (i!=0) {
					SQL += ",";
				}
				SQL +=     "oo_dim_" + dimension.getDimensionSeq() + "_" + dimension.getPartSeq() + ".rownum";
				i++;
			}
		}		
		
		
		// Page
		edge = report.getEdgeByType(Constants.Page);
		it = edge.getAxisList().iterator();
		while (it.hasNext()) {
			Axis axis = (Axis) it.next();
			if (axis instanceof Dimension) {
				Dimension dimension = (Dimension) axis;
				if (i!=0) {
					SQL += ",";
				}
				SQL +=     "oo_dim_" + dimension.getDimensionSeq() + "_" + dimension.getPartSeq() + ".rownum";
				i++;
			}
		}		



//		edgeIt = report.getEdgeList().iterator();
//		i = 0;
//		while (edgeIt.hasNext()) {
//			Edge edge = (Edge) edgeIt.next();
//			Iterator axisIt = edge.getAxisList().iterator();
//			while (axisIt.hasNext()) {
//				Axis axis = (Axis) axisIt.next();
//				if (axis instanceof Dimension) {
//					Dimension dimension = (Dimension) axis;
//					if (i!=0) {
//						SQL += ",";
//					}
//					SQL +=     "oo_dim_" + dimension.getDimensionSeq() + "_" + dimension.getPartSeq() + ".rownum";
//					i++;
//				}
//			}
//		}


		return SQL;
	}







	// t@Nge[ufBVe[uփ}bsOĴ̃Xg(J}؂̕)GbWƂɎ擾
	// ȂAW[͏O
	// return)
	//   string[0]:GbW̃JXg(String,J}؂)
	//   string[1]:GbW̃JXg(String,J}؂)
	//   string[2]:y[WGbW̃JXg(String,J}؂)

	public String[] getDimsFactKeyColumnList() {
		String axesFactKeyColumnList[] = new String[3];
		axesFactKeyColumnList[0] = StringUtil.joinList(StringUtil.exceptElement(colFactKeyColumnList, "MEASURE"), ",");
		axesFactKeyColumnList[1] = StringUtil.joinList(StringUtil.exceptElement(rowFactKeyColumnList, "MEASURE"), ",");
		axesFactKeyColumnList[2] = StringUtil.joinList(StringUtil.exceptElement(pageFactKeyColumnList, "MEASURE"), ",");
		
		return axesFactKeyColumnList;
	}



	// ********** private\bh **********

	/**
	 * Zf[^߂SQLWHERE߂߂B
	 * @param edgeWhereClauseMap
	 * @return WHERE
	 */
	private String getWhereClause(LinkedHashMap edgeWhereClauseMap) {
		
		String edgeWhereClause = "";
		
		Iterator iter = edgeWhereClauseMap.keySet().iterator();
		int i = 0;
		while (iter.hasNext()) {
			if(i>0) {
				edgeWhereClause += " and ";
			}
			String factKeyColumn = (String) iter.next();
			edgeWhereClause += factKeyColumn + " in (";

			ArrayList memberKeyList = (ArrayList) edgeWhereClauseMap.get(factKeyColumn);
			edgeWhereClause += StringUtil.joinList(memberKeyList, ",");
			edgeWhereClause += ")";

			i++;
		}
		
		return edgeWhereClause;
	}

	/**
	 * Zf[^߂SQLSELECT߂߂B
	 * @return SELECT
	 */
	private String getSelectClause() {

		String SQL = "SELECT ";		
		SQL += StringUtil.joinList(this.getColFactKeyColumnList(), ",");
		SQL += "," + StringUtil.joinList(this.getRowFactKeyColumnList(), ",");
		if (pageFactKeyColumnList.size()>0) {
			SQL += "," + StringUtil.joinList(this.getPageFactKeyColumnList(), ",");
		}
		
		return SQL;
	}

	// ********** Setter \bh **********


	/**
	 * |[gIuWFNgǉ
	 * @param report ReportIuWFNg
	 */
	public void setReport(Report report) {
		this.report = report;
	}


	/**
	 * t@Ng̃L[JXgǉ
	 * @param edgePositionID GbWID(0:A1:sA2:y[W)
	 * @param factKeyColumn
	 */
	public void addFactKeyColumnList(int edgePositionID, String factKeyColumn) {
		if (edgePositionID==0) {
			this.colFactKeyColumnList.add(factKeyColumn);
		} else if (edgePositionID==1){
			this.rowFactKeyColumnList.add(factKeyColumn);
		} else if (edgePositionID==2){
			this.pageFactKeyColumnList.add(factKeyColumn);
		} else {
			throw new IllegalArgumentException();
		}
	}

	/**
	 * sGbWփt@Ng̃L[JǉB
	 * @param factKeyColumn L[J
	 */
	public void addColFactKeyColumnList(String factKeyColumn) {
		this.colFactKeyColumnList.add(factKeyColumn);
	}

	/**
	 * GbWփt@Ng̃L[JǉB
	 * @param factKeyColumn L[J
	 */
	public void addRowFactKeyColumnList(String factKeyColumn) {
		this.rowFactKeyColumnList.add(factKeyColumn);
	}

	/**
	 * y[WGbWփt@Ng̃L[JǉB
	 * @param factKeyColumn L[J
	 */
	public void addPageFactKeyColumnList(String factKeyColumn) {
		this.pageFactKeyColumnList.add(factKeyColumn);
	}

	/**
	 * t@Nge[uݒ肷B
	 * @param string t@Nge[u
	 */
	public void setFactTableName(String string) {
		this.factTableName = string;
	}

	/**
	 * t@Nge[uݒ肷B
	 * @param edgePositionID GbWID(0:A1:sA2:y[W)
	 * @param factKeyColumn L[J
	 * @param memberKeyList o[L[Xg
	 */
	public void putWhereClauseMap(int edgePositionID, String factKeyColumn, ArrayList memberKeyList) {
		if (edgePositionID == 0){
			this.colWhereClauseMap.put(factKeyColumn, memberKeyList);
		} else if (edgePositionID == 1) {
			this.rowWhereClauseMap.put(factKeyColumn, memberKeyList);
		} else if (edgePositionID == 2) {
			this.pageWhereClauseMap.put(factKeyColumn, memberKeyList);
		} else {
			throw new IllegalArgumentException();
		}
	}

	/**
	 * WHERE߂킷MapIuWFNgǉB
	 * @param factKeyColumn L[J
	 * @param memberKeyList o[L[Xg
	 */
	public void putColWhereClauseMap(String factKeyColumn, ArrayList memberKeyList) {
		this.colWhereClauseMap.put(factKeyColumn, memberKeyList);
	}


	/**
	 * sWHERE߂킷MapIuWFNgǉB
	 * @param factKeyColumn L[J
	 * @param memberKeyList o[L[Xg
	 */
	public void putRowWhereClauseMap(String factKeyColumn, ArrayList memberKeyList) {
		this.rowWhereClauseMap.put(factKeyColumn, memberKeyList);
	}

	/**
	 * y[WWHERE߂킷MapIuWFNgǉB
	 * @param factKeyColumn L[J
	 * @param memberKeyList o[L[Xg
	 */
	public void putPageWhereClauseMap(String factKeyColumn, ArrayList memberKeyList) {
		this.pageWhereClauseMap.put(factKeyColumn, memberKeyList);
	}

	/**
	 * y[WWHERE߂킷MapIuWFNgǉB
	 * @param string W[̃ftHgo[KEY
	 */
	public void setMeasureDefaultMember(String string) {
		measureDefaultMember = string;
	}


	// ********** Getter \bh **********

	/**
	 * |[gIuWFNg߂B
	 * @return |[gIuWFNg
	 */
	public Report getReport() {
		return report;
	}

	/**
	 * w肳ꂽGbWɔzuꂽWHERE߂킷IuWFNg߂B
	 * @return w肳ꂽGbWɔzuꂽWHERE߂킷IuWFNg
	 */
	public LinkedHashMap getAxisWhereClauseMap(String edgePosition) {
		if (edgePosition == null){
			return null;
		}

		if (Constants.Col.equals(edgePosition)) {
			return colWhereClauseMap;
		} else if (Constants.Row.equals(edgePosition)) {
			return rowWhereClauseMap;
		} else if (Constants.Page.equals(edgePosition)) {
			return pageWhereClauseMap;
		} else {
			return null;
		}
		
	}
	


	/**
	 * GbWɔzuꂽɑΉFacte[ũJA擾ΏۃW[Xg߂B
	 * @return L[JXg
	 */
	public ArrayList getColFactKeyColumnList() {
		return colFactKeyColumnList;
	}

	/**
	 * ɔzuꂽWHERE߂킷IuWFNg߂B
	 * @return ɔzuꂽWHERE߂킷IuWFNg
	 */
	public LinkedHashMap getColWhereClauseMap() {
		return colWhereClauseMap;
	}

	/**
	 * t@Nge[u߂B
	 * @return t@Nge[u
	 */
	public String getFactTableName() {
		return factTableName;
	}

	/**
	 * y[WGbWɔzuꂽɑΉFacte[ũJA擾ΏۃW[Xg߂B
	 * @return L[JXg
	 */
	public ArrayList getPageFactKeyColumnList() {
		return pageFactKeyColumnList;
	}

	/**
	 * y[WɔzuꂽWHERE߂킷IuWFNg߂B
	 * @return y[WɔzuꂽWHERE߂킷IuWFNg
	 */
	public LinkedHashMap getPageWhereClauseMap() {
		return pageWhereClauseMap;
	}

	/**
	 * sGbWɔzuꂽɑΉFacte[ũJA擾ΏۃW[Xg߂B
	 * @return L[JXg
	 */
	public ArrayList getRowFactKeyColumnList() {
		return rowFactKeyColumnList;
	}

	/**
	 * sɔzuꂽWHERE߂킷IuWFNg߂B
	 * @return y[WɔzuꂽWHERE߂킷IuWFNg
	 */
	public LinkedHashMap getRowWhereClauseMap() {
		return rowWhereClauseMap;
	}

	/**
	 * W[y[WGbWɂƂ̃ftHgo[L[(UName)߂B
	 * @return ftHgo[L[
	 */
	public String getMeasureDefaultMember() {
		return measureDefaultMember;
	}


}
