/*  OpenOlap viewer
 *  pbP[WFopenolap.viewer.dao
 *  t@CFDAOFactory.java
 *  FiǗNXQ̃IuWFNg𐶐钊ۃNXłB
 *
 *  쐬: 2004/01/06
 */
package openolap.viewer.dao;

import java.sql.Connection;

import openolap.viewer.Axis;
import openolap.viewer.common.Messages;
import openolap.viewer.controller.RequestHelper;

/**
 *  ۃNXFDAOFactory<br>
 *  FiǗNXQ̃IuWFNg𐶐钊ۃNXłB
 */
public abstract class DAOFactory {

	// ********** CX^Xϐ **********

    // RequestHelper
	protected RequestHelper helper = null;

	// ********** ۃ\bh **********

	/**
	 * Connection PoolConnection擾AConnection܂B
	 * @param connectionPoolName server.xmlAweb.xmlŐݒ肵ĂRlNVv[
	 * @param attr1 Cӂ̈
	 * @return Connection IuWFNg
	 */
	public abstract Connection getConnection(String connectionPoolName, String attr1);

	/**
	 * fBVIuWFNg̉iǗIuWFNg߂B
	 * @param conn Connection IuWFNg
	 * @return DimensionDAO IuWFNg
	 */
	public abstract DimensionDAO getDimensionDAO(Connection conn);

	/**
	 * W[IuWFNg̉iǗIuWFNg߂B
	 * @param conn Connection IuWFNg
	 * @return MeasureDAO IuWFNg
	 */
	public abstract MeasureDAO getMeasureDAO(Connection conn);

	/**
	 * W[o[IuWFNg̉iǗIuWFNg߂B
	 * @param conn Connection IuWFNg
	 * @return MeasureMemberDAO IuWFNg
	 */
	public abstract MeasureMemberDAO getMeasureMemberDAO(Connection conn);

	/**
	 * |[gIuWFNg̉iǗIuWFNg߂B
	 * @param conn Connection IuWFNg
	 * @return ReportDAO IuWFNg
	 */
	public abstract ReportDAO getReportDAO(Connection conn);

	/**
	 * L[uIuWFNg̉iǗIuWFNg߂B
	 * @param conn Connection IuWFNg
	 * @return CubeDAO IuWFNg
	 */
	public abstract CubeDAO getCubeDAO(Connection conn);

	/**
	 * xIuWFNg̉iǗIuWFNg߂B
	 * @param conn Connection IuWFNg
	 * @return AxisLevelDAO IuWFNg
	 */
	public abstract AxisLevelDAO getAxisLevelDAO(Connection conn);

	/**
	 * fBVo[IuWFNg̉iǗIuWFNg߂B
	 * @param conn Connection IuWFNg
	 * @return DimensionMemberDAO IuWFNg
	 */
	public abstract DimensionMemberDAO getDimensionMemberDAO(Connection conn);

	/**
	 * Zf[^IuWFNg̉iǗIuWFNg߂B
	 * @param conn Connection IuWFNg
	 * @return CellDataDAO IuWFNg
	 */
	public abstract CellDataDAO getCellDataDAO(Connection conn);

	/**
	 * W[o[^CvIuWFNg̉iǗIuWFNg߂B
	 * @param conn Connection IuWFNg
	 * @return MeasureMemberTypeDAO IuWFNg
	 */
	public abstract MeasureMemberTypeDAO getMeasureMemberTypeDAO(Connection conn);

	/**
	 * IuWFNg̉iǗIuWFNg߂B
	 * @param conn Connection IuWFNg
	 * @return PostgresAxisDAO IuWFNg
	 */
	public abstract AxisDAO getAxisDAO(Connection conn);

	/**
	 * o[IuWFNg̉iǗIuWFNg߂B
	 * @param conn Connection IuWFNg
	 * @return AxisMemberDAO IuWFNg
	 */
	public abstract AxisMemberDAO getAxisMemberDAO(Connection conn);

	/**
	 * o[IuWFNg̉iǗIuWFNg߂B
	 * @param conn Connection IuWFNg
	 * @param axis 킷IuWFNg
	 * @return AxisMemberDAO IuWFNg
	 */
	public abstract AxisMemberDAO getAxisMemberDAO(Connection conn, Axis axis);

	/**
	 * FIuWFNg̉iǗIuWFNg߂B
	 * @param conn Connection IuWFNg
	 * @return ColorDAO IuWFNg
	 */
	public abstract ColorDAO getColorDAO(Connection conn);

	/**
	 * [U[IuWFNg̉iǗIuWFNg߂B
	 * @param conn Connection IuWFNg
	 * @return UserDAO IuWFNg
	 */
	public abstract UserDAO getUserDAO(Connection conn); 

	/**
	 * ZLeBIuWFNg̉iǗIuWFNg߂B
	 * @param conn Connection IuWFNg
	 * @return SecurityDAO IuWFNg
	 */
	public abstract SecurityDAO getSecurityDAO(Connection conn); 


	// ********** \bh **********

	/**
	 * f[^\[X̃^CvɉFactoryIuWFNg߂܂B
	 *   f[^\[X̃^CvFviewer.properties"DAOFactory.sourceName"Ŏw
	 * @return DAOFactory IuWFNg
	 */
	public static DAOFactory getDAOFactory() {
		String sourceName = Messages.getString("DAOFactory.sourceName"); //$NON-NLS-1$
		if (sourceName.equals("postgreSQL")) { //$NON-NLS-1$
			return new PostgresDAOFactory();
		} else {
			throw new UnsupportedOperationException();
		}
	}

}
