/*  OpenOlap viewer
 *  pbP[WFopenolap.viewer.dao
 *  t@CFPostgresCellDataDAO.java
 *  FZf[^IuWFNg̉iǗNXłB
 *
 *  쐬: 2004/01/09
 */
package openolap.viewer.dao;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.StringTokenizer;

import javax.servlet.http.HttpServletRequest;

import openolap.viewer.CellData;
import openolap.viewer.EdgeCoordinates;
import openolap.viewer.MeasureMember;
import openolap.viewer.Report;
import openolap.viewer.common.Constants;


/**
 *  NXFPostgresCellDataDAO<br>
 *  FZf[^IuWFNg̉iǗNXłB
 */
public class PostgresCellDataDAO implements CellDataDAO {

	// ********** CX^Xϐ **********

	/** ConnectionIuWFNg */
	private Connection conn = null;


	// ********** RXgN^ **********

	/**
	 * Zf[^IuWFNg̉iǗIuWFNg𐶐܂B
	 */
	PostgresCellDataDAO(Connection conn) {
		this.conn = conn;
	}

	// ********** \bh **********

	/**
	 * Zf[^IuWFNg̃Xg߂B
	 * @param cellDataSQL Zf[^擾pSQL킷IuWFNg
	 * @param items AsAy[WGbW̎IDXg
	 *        items[0]FGbWɔzuꂽID̔z
	 *        items[1]FGbWɔzuꂽID̔z
	 *        items[2]Fy[WGbWɔzuꂽIDƂ̃ftHgo[L[̔z
	 * @param request HttpServletRequestIuWFNg
	 * @param report |[gIuWFNg
	 * @param colCoordinatesList W
	 * @param rowCoordinatesList sW
	 * @return Zf[^IuWFNg̃Xg
	 * @exception SQLException ɗO
	 */
	public ArrayList selectCellDatas(CellDataSQL cellDataSQL, Object[] items, HttpServletRequest request, Report report, ArrayList colCoordinatesList, ArrayList rowCoordinatesList, String SQLType) throws SQLException {

		String[] FKColLists = cellDataSQL.getDimsFactKeyColumnList();
		// FKColListsFGbWɔzuꂽfBVւ̃t@Nge[ũJXgiFDIM_03,DIM_02j
		//			   i珇ɕԁBiAW[̏ꍇ͔΂j
		// 	FKColLists[0]:
		// 	FKColLists[1]:s

		ArrayList cellDataList = new ArrayList();	// ɂ擾Zf[^IuWFNgi[p

		// f[^
		Statement stmt = null;
		ResultSet rs   = null;
		try {
			stmt = conn.createStatement();
			
			String SQL = "";
			if (CellDataDAO.normalSQLTypeString.equals(SQLType)) {
				SQL = cellDataSQL.getSQLString();
			} else if (CellDataDAO.sortedSQLTypeString.equals(SQLType)) {
				SQL = cellDataSQL.getSQLStringForSortData();
			} else {
				throw new IllegalArgumentException();
			}

			rs = stmt.executeQuery(SQL);

			int i;
			StringTokenizer st = null;
			while ( rs.next() ) {

				LinkedHashMap colIdKeyMap = new LinkedHashMap();	// IDƂ̃oL[(ResultSet̊eR[h擾)
				LinkedHashMap rowIdKeyMap = new LinkedHashMap();	// sIDƂ̃oL[(ResultSet̊eR[h擾)


				// f[^R[hsEɔzuꂽKEY擾
				for ( i = 0; i < 2; i++ ) {
					st = new StringTokenizer(FKColLists[i],",");
					String[] edgeItemIDs = (String[]) items[i];	//  or s̎IDz
					int j=0;	// JE^BW[͔΂
					while ( st.hasMoreTokens() ) {	//  or sɐݒ肳ꂽ̐s(W[ꍇ́A̐-1)
						if( edgeItemIDs[j].equals(Constants.MeasureID) ) {
							j++;
						}
						String edgeItemID = edgeItemIDs[j];	// ID(W[͊܂܂Ȃ)

						LinkedHashMap axisIdKeyMap = null;

						if ( i == 0) {			// 
							axisIdKeyMap = colIdKeyMap;
						} else if ( i == 1 ) {	// s
							axisIdKeyMap = rowIdKeyMap;
						}
						axisIdKeyMap.put(Integer.decode(edgeItemID), rs.getString(st.nextToken()));
						j++;
					}
				}

				// f[^R[h胁W[Xg擾
				if (( this.getTempMeasurePosition(items).equals(Constants.Col)) || this.getTempMeasurePosition(items).equals(Constants.Row)) {
					// ʂ̂PR[hCellDataIuWFNg̏W𐶐

					for ( i = 0; i < report.getTotalMeasureMemberNumber(); i++ ) {

						// ZN^őΏۂ͂Ă邩`FbN
						MeasureMember measureMember = (MeasureMember) report.getMeasure().getAxisMemberByUniqueName(Integer.toString(i+1));
						if (!measureMember.isSelected()){
							 continue;
						}


						LinkedHashMap tmpColIdKeyMap = null;
						LinkedHashMap tmpRowIdKeyMap = null;

						// W[ǉ
						if ( this.getTempMeasurePosition(items).equals(Constants.Col)) {
							tmpColIdKeyMap = addMeasureMemInfo(colIdKeyMap, Integer.toString(i+1), report, items);
							tmpRowIdKeyMap = rowIdKeyMap;
 						} else if (this.getTempMeasurePosition(items).equals(Constants.Row)) {
							tmpColIdKeyMap = colIdKeyMap;
							tmpRowIdKeyMap = addMeasureMemInfo(rowIdKeyMap, Integer.toString(i+1), report, items);
						}

						CellData cellData = this.createCellData( tmpColIdKeyMap, 
																  tmpRowIdKeyMap, 
																  rs.getString("measure_" + (i+1)), 	// l
																  colCoordinatesList, 
																  rowCoordinatesList,
																  Integer.toString(i+1)); // W[o[UName

 						if (cellData != null) {
							cellDataList.add(cellData);	// Zf[^IuWFNg̏Wɒǉ
 						}
					}

				} else if ( this.getTempMeasurePosition(items).equals(Constants.Page) ) {
					// ʂ̂PR[hPCellDataIuWFNg𐶐
					CellData cellData = this.createCellData(colIdKeyMap, 
															 rowIdKeyMap, 
															 rs.getString("measure_" + cellDataSQL.getMeasureDefaultMember()), 	// l
															 colCoordinatesList, 
															 rowCoordinatesList,
															 cellDataSQL.getMeasureDefaultMember());// W[o[UName

					if (cellData != null) {
						cellDataList.add(cellData);	// Zf[^IuWFNg̏Wɒǉ
					}

				}

			 }
	
		} catch (SQLException e) {
			throw e;
		} catch (Exception e) {
			e.printStackTrace();
		} finally {
			try {
				if (rs != null){
					rs.close();
				}
			} catch (SQLException e) {
				throw e;
			} finally {
				try {
					if (stmt != null){
						stmt.close();
					}
				} catch (SQLException e) {
					throw e;
				}
			}
		}

		return cellDataList;
	}


	// ********** private\bh **********

	/**
	 * NCAg瑗MꂽƂɃW[̔zuGbW߂B
	 * @param items AsAy[WGbW̎IDXg
	 *        items[0]FGbWɔzuꂽID̔z
	 *        items[1]FGbWɔzuꂽID̔z
	 *        items[2]Fy[WGbWɔzuꂽIDƂ̃ftHgo[L[̔z
	 * @return GbW̎ނ킷iuCOLvAuROWvAuPAGEvj
	 * @exception SQLException ɗO
	 */
	private String getTempMeasurePosition(Object[] items) {

		int i = 0;

		// IDXg
		String[] colItemIDs = (String[]) items[0];
		for ( i = 0; i < colItemIDs.length; i++ ) {
			if (colItemIDs[i].equals(Constants.MeasureID) ){
				return Constants.Col;
			}
		}
		
		// sIDXg
		String[] rowItemIDs = (String[]) items[1];
		for ( i = 0; i < rowItemIDs.length; i++ ) {
			if (rowItemIDs[i].equals(Constants.MeasureID) ){
				return Constants.Row;
			}
		}
		return Constants.Page;
	}


	/**
	 * W[̃GbWł̃CfbNXi0startj߂B
	 * @param items AsAy[WGbW̎IDXg
	 *        items[0]FGbWɔzuꂽID̔z
	 *        items[1]FGbWɔzuꂽID̔z
	 *        items[2]Fy[WGbWɔzuꂽIDƂ̃ftHgo[L[̔z
	 * @return GbWł̃CfbNX
	 */
	private int getTempMeasureHieIndex(Object[] items) {

		int i = 0;

		// IDXg
		String[] colItemIDs = (String[]) items[0];
		for ( i = 0; i < colItemIDs.length; i++ ) {
			if (colItemIDs[i].equals(Constants.MeasureID) ){
				return i;
			}
		}
		
		// sIDXg
		String[] rowItemIDs = (String[]) items[1];
		for ( i = 0; i < rowItemIDs.length; i++ ) {
			if (rowItemIDs[i].equals(Constants.MeasureID) ){
				return i;
			}
		}
		return -1;
	}

	/**
	 * W[݂GbWiors)LinkedHashMap(ID,o[L[)ɁAW[ǉ
	 * @param targetEdgeMap s܂͗MapIuWFNg
	 * @param measureKey W[L[
	 * @param report |[gIuWFNg
	 * @param items AsAy[WGbW̎IDXg
	 *        items[0]FGbWɔzuꂽID̔z
	 *        items[1]FGbWɔzuꂽID̔z
	 *        items[2]Fy[WGbWɔzuꂽIDƂ̃ftHgo[L[̔z
	 * @return IDKeyɎAo[L[ValueɎLinkedHashMapIuWFNg
	 */
	private LinkedHashMap addMeasureMemInfo(LinkedHashMap targetEdgeMap, String measureKey, Report report,Object[] items) {
		LinkedHashMap newHashMap = new LinkedHashMap();

		// W[̃GbWł̃CfbNX(0start)
		int measureHieIndex = this.getTempMeasureHieIndex(items);

		// W[\ǉ
		if ( measureHieIndex == targetEdgeMap.size()) {	// ŏIiW[
			newHashMap.putAll(targetEdgeMap);
			newHashMap.put(Integer.decode(Constants.MeasureID), measureKey);
		} else {
			Iterator it = targetEdgeMap.keySet().iterator();
			int i = 0;
			while (it.hasNext()) {
				Integer id = (Integer) it.next();
				String key = (String) targetEdgeMap.get(id);
				
				if ( i == measureHieIndex ) {
					newHashMap.put(Integer.decode(Constants.MeasureID), measureKey);
				} 
				newHashMap.put(id, key);
				i++;
			}
		}

		return newHashMap;
	}

	/**
	 * CellDataIuWFNg߂B
	 * 쐬łȂꍇnull߂B
	 * @param colIdKeyMap ̎IDKeyɂAo[L[ValueɎMapIuWFNg
	 * @param rowIdKeyMap s̎IDKeyɂAo[L[ValueɎMapIuWFNg
	 * @param value l
	 * @param colCoordinatesList sEdgeCoordinatesIuWFNg̃Xg
	 * @param rowCoordinatesList EdgeCoordinatesIuWFNg̃Xg
	 * @param measureMemberUName W[o[UniqueName
	 * @return IDKeyɎAo[L[ValueɎLinkedHashMapIuWFNg
	 */

	private CellData createCellData(LinkedHashMap colIdKeyMap, LinkedHashMap rowIdKeyMap, String value, ArrayList colCoordinatesList, ArrayList rowCoordinatesList, String measureMemberUName) {

		// EdgeCoordinatesIuWFNg擾
		EdgeCoordinates colCoordinates = null;
			Iterator colIt = colCoordinatesList.iterator();
			while (colIt.hasNext()) {
				EdgeCoordinates edgeCoordinates = (EdgeCoordinates) colIt.next();
				LinkedHashMap axisIdKeyMap = edgeCoordinates.getAxisIdMemKeyMap();
				if ( mapHasSameKeyAndValue(colIdKeyMap, axisIdKeyMap) ) {
					colCoordinates = edgeCoordinates;
					break;
				}
			}
		
		// sEdgeCoordinatesIuWFNg擾
		EdgeCoordinates rowCoordinates = null;
		Iterator rowIt = rowCoordinatesList.iterator();
		while (rowIt.hasNext()) {
			EdgeCoordinates edgeCoordinates = (EdgeCoordinates) rowIt.next();
			LinkedHashMap axisIdKeyMap = edgeCoordinates.getAxisIdMemKeyMap();
			if ( mapHasSameKeyAndValue(rowIdKeyMap, axisIdKeyMap) ) {
				rowCoordinates = edgeCoordinates;
				break;
			}
		}

		if ( (colCoordinates == null) || (rowCoordinates == null) ) {
		// ȉꍇɁA擾f[^ɑ΂ASQLԂf[^璷łꍇB
		// ̏ꍇACellDataIuWFNg͐Ȃ
		// j0iFID16A1iFID1̂ƂAID16̃o(Key=0)ɑ鎲ID1̃o(Key=1)Ńh
		//     DB̎擾ʂɂ́AID16Key0ȊÕoɑ鎲ID1̃o(Key=1)̒l܂܂

			return null;
		}

		
		// CellDataIuWFNg
		CellData cellData = new CellData(colCoordinates, rowCoordinates, measureMemberUName);
		cellData.setValue(value);	// lݒ
		
		return cellData;
	}


	/**
	 * ^ꂽQLinkedHashMapKeyValueꍇtrueAȂꍇfalse߂B
	 * @param map1 ̎IDKeyɂAo[L[ValueɎMapIuWFNg
	 * @param map2 s̎IDKeyɂAo[L[ValueɎMapIuWFNg
	 * @return Key,Value
	 */
	private boolean mapHasSameKeyAndValue( LinkedHashMap map1, LinkedHashMap map2  ) {
		if ( ( map1 == null) || ( map2 == null) ) { return false; }

		// vfr
		if ( map1.size() != map2.size() ) {
			return false;
		}
		
		// vfriKeyAvalue̎lj
		Iterator it1 = map1.keySet().iterator();
		Iterator it2 = map2.keySet().iterator();
		while ( it1.hasNext() ) {
			Integer map1Key = (Integer) it1.next();
			Integer map2Key = (Integer) it2.next();

			if ( !map1Key.equals(map2Key) ) {
				return false;
			}

			String map1Value = (String) map1.get(map1Key);
			String map2Value = (String) map2.get(map1Key);

			if ( !map1Value.equals(map2Value) ) {
				return false;
			}
		}
		return true;
	}


}
