/*  OpenOlap viewer
 *  pbP[WFopenolap.viewer.dao
 *  t@CFPostgresSecurityDAO.java
 *  FZLeB̉iǗNXłB
 *
 *  쐬: 2004/01/30
 */
package openolap.viewer.dao;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

import openolap.viewer.Security;
import openolap.viewer.common.CommonUtils;

/**
 *  NXFPostgresUserDAO<br>
 *  F[U[̉iǗNXłB
 */
public class PostgresSecurityDAO implements SecurityDAO {

	// ********** CX^Xϐ **********

	/** ConnectionIuWFNg */
	Connection conn = null;

	// ********** RXgN^ **********

	/**
	 *  [U[̉iǗIuWFNg𐶐܂B
	 */
	public PostgresSecurityDAO (Connection conn) {
		this.conn = conn;
	}


	// ********** \bh **********
	
	/**
	 * ^ꂽ[U[IDA|[gIDƂɃZLeBIuWFNg߂B<br>
	 * @param userID [U[ID
	 * @param reportID |[gID
	 * @return ZLeBIuWFNg
	 * @exception SQLException ɗO
	 */
	public Security getSecurity(String userID, String reportID) throws SQLException {

		Security security = null;

		String SQL = "";
		SQL += "select ";
		SQL += "    right_flg,";		// {         1FA0FȂ
		SQL += "    export_flg ";		// GNX|[g  1FA0FȂ
		SQL += "from ";
		SQL += "    oo_sec_func(" + userID + "," + reportID + ")";
//System.out.println("select security SQL:" + SQL);

		Statement stmt = null;
		ResultSet rs = null;

		try {
			stmt = conn.createStatement();
			rs = stmt.executeQuery(SQL);

			while ( rs.next() ) {
				security = new Security(CommonUtils.FLGTobool(rs.getString("right_flg")),
										 CommonUtils.FLGTobool(rs.getString("export_flg")));
			}
		

		} catch (SQLException e) {
			throw e;
		} catch (Exception e) { 
			e.printStackTrace();
		} finally {
			try {
				if (rs != null){
					rs.close();
				}
			} catch (SQLException e) {
				throw e;
			} finally {
				try {
					if (stmt != null){
						stmt.close();
					}
				} catch (SQLException e) {
					throw e;
				}
			}
		}
		
		return security;
	}

}
