/*  OpenOlap viewer
 *  pbP[WFopenolap.viewer.controller
 *  t@CFGetReportInfoCommand.java
 *  F|[gXML`ŏo͂NXłB
 *
 *  쐬: 2004/01/09
 */
package openolap.viewer.controller;

import java.io.IOException;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.xml.parsers.ParserConfigurationException;

import org.apache.log4j.Logger;
import org.xml.sax.SAXException;

import openolap.viewer.Axis;
import openolap.viewer.AxisLevel;
import openolap.viewer.Dimension;
import openolap.viewer.Edge;
import openolap.viewer.Measure;
import openolap.viewer.MeasureMember;
import openolap.viewer.Report;
import openolap.viewer.Security;
import openolap.viewer.User;
import openolap.viewer.chart.ChartXMLCreator;
import openolap.viewer.common.CommonSettings;
import openolap.viewer.common.CommonUtils;
import openolap.viewer.common.StringUtil;
import openolap.viewer.dao.DAOFactory;
import openolap.viewer.dao.DimensionMemberDAO;

/**
 *  NXFGetReportInfoCommand<br>
 *  F|[gXML`ŏo͂NXłB
 */
public class GetReportInfoCommand implements Command {

	// ********** CX^Xϐ **********

	/** RequestHelperIuWFNg */
	private RequestHelper requestHelper = null;

	/** MOIuWFNg */
	private Logger log = Logger.getLogger(GetReportInfoCommand.class.getName());

	// ********** \bh **********

	/**
	 * |[gXML`ŏo͂܂B<br>
	 * JSPdispatchs킸ɒXMLo͂邽߁Anull߂B
	 * @param helper RequestHelperIuWFNg
	 * @param commonSettings AvP[V̋ʐݒIuWFNg
	 * @return null
	 * @exception IOException ɗO
	 */
	public String execute(RequestHelper helper, CommonSettings commonSettings) 
		throws IOException {

			this.requestHelper = helper;
			HttpServletRequest request = this.requestHelper.getRequest();
			HttpSession session = this.requestHelper.getRequest().getSession();

			Report report = (Report) session.getAttribute("report");
			User user = (User) session.getAttribute("user");

			Connection conn = null;

			try {
				DAOFactory daoFactory = DAOFactory.getDAOFactory();
				conn = daoFactory.getConnection((String)helper.getRequest().getSession().getAttribute("connectionPoolName"),
												(String)helper.getRequest().getSession().getAttribute("searchPathName"));
				// XMLo
				this.outputXML(helper, report, user, conn);

			} catch (SQLException e) {
				this.outputErrorXML(helper, e);
			} catch (ParserConfigurationException e) {
				this.outputErrorXML(helper, e);
			} catch (SAXException e) {
				this.outputErrorXML(helper, e);
			} catch (IOException e) {
				this.outputErrorXML(helper, e);
			} catch (Exception e) {
				this.outputErrorXML(helper, e);
			} finally {
				if(conn != null){
					try {
						conn.close();
					} catch (SQLException e) {
						this.outputErrorXML(helper, e);
					}
				}
			}

			return null;

	}

	// ********** private \bh **********

	/**
	 * ftHgo[L[null̏ꍇA"NA"ɕϊB
	 * @param defaultMemKey ftHgo[L[
	 * @return ftHgo[L[
	 */
	private String changeDefaultMemberKey(String defaultMemKey) {
		if(defaultMemKey == null) { 
			return "NA";
		} else {
			return defaultMemKey;
		}
	}

	/**
	 * |[gXML`ŏo͂܂B
	 * @param helper RequestHelperIuWFNg
	 * @param report |[gIuWFNg
	 * @param user [U[IuWFNg
	 * @param conn ConnectionIuWFNg
	 * @exception IOException ɗO
	 * @exception SQLException |[g擾ɗO
	 */
	private void outputXML(RequestHelper helper, Report report, User user, Connection conn) throws SQLException, ParserConfigurationException, SAXException, IOException {

		DAOFactory daoFactory = DAOFactory.getDAOFactory();
		DimensionMemberDAO dimMemberDAO = daoFactory.getDimensionMemberDAO(conn);


		StringBuffer reportInfoXML = new StringBuffer(2048);	// ReportXMLi[p

		// ReportXMLJn
		reportInfoXML.append("<?xml version=\"1.0\" encoding=\"Shift_JIS\"?>");
		reportInfoXML.append("<root>");
			reportInfoXML.append("<OlapInfo>");
				reportInfoXML.append("<ReportInfo>");
					reportInfoXML.append("<Report>");
						reportInfoXML.append("<ReportID>");
							reportInfoXML.append(report.getReportID());
						reportInfoXML.append("</ReportID>");
						reportInfoXML.append("<ReportName>");
							reportInfoXML.append(report.getReportName());
						reportInfoXML.append("</ReportName>");
						reportInfoXML.append("<isNewReport>");
							reportInfoXML.append(CommonUtils.boolToFLG(report.isNewReport()));
						reportInfoXML.append("</isNewReport>");
						reportInfoXML.append("<displayScreenType>");		// ʕX^C
							reportInfoXML.append(report.getDisplayScreenType());	// (0:Sʕ\i\jA1:Sʕ\iOtjA2:ci\AOt))
						reportInfoXML.append("</displayScreenType>");
						reportInfoXML.append("<currentChartID>");		// \̃OtID
							ChartXMLCreator chartXMLCreator = new ChartXMLCreator();
							String chartID = null;
							if("NA".equals(report.getCurrentChart())){
								chartID = report.getCurrentChart();
							} else {
								chartID = chartXMLCreator.chartNameToId(ChartXMLCreator.getChartXMLFilePath(helper), report.getCurrentChart());
							}
							reportInfoXML.append(chartID);
						reportInfoXML.append("</currentChartID>");
						reportInfoXML.append("<colorType>");		// Fݒ̃^Cvi1FhԂA2FnCCgj
							reportInfoXML.append(report.getColorType());
						reportInfoXML.append("</colorType>");
					reportInfoXML.append("</Report>");
				reportInfoXML.append("</ReportInfo>");
				reportInfoXML.append("<CubeInfo>");
					reportInfoXML.append("<Cube>");
						reportInfoXML.append("<CubeName>");
							reportInfoXML.append(report.getCube().getCubeName());
						reportInfoXML.append("</CubeName>");
					reportInfoXML.append("</Cube>");
				reportInfoXML.append("</CubeInfo>");

			reportInfoXML.append("<AxesInfo>");


			// ̔zuꏊ𐶐
			Iterator edgeIt = report.getEdgeList().iterator();
			while (edgeIt.hasNext()) {
				Edge edge = (Edge) edgeIt.next();
				Iterator axisIt = edge.getAxisList().iterator();
				reportInfoXML.append(StringUtil.addStartTAGMark(edge.getPosition()));
				while (axisIt.hasNext()) {
					Axis axis = (Axis) axisIt.next();
					reportInfoXML.append("<HierarchyID>" + axis.getId()  + "</HierarchyID>");
				}
				reportInfoXML.append(StringUtil.addEndTAGMark(edge.getPosition()));
			}

			// AxisID̏Ő
			ArrayList axisList = report.getAxisOrderByID();
			Iterator axisIt = axisList.iterator();
			while (axisIt.hasNext()) {
				Axis axis = (Axis) axisIt.next();

				reportInfoXML.append("<HierarchyInfo name=\"" + axis.getName() + "\" id=\""+ axis.getId() +"\">");
				reportInfoXML.append("<DefaultMemberKey>"+ changeDefaultMemberKey(axis.getDefaultMemberKey()) +"</DefaultMemberKey>");
				reportInfoXML.append("<Comment>" + StringUtil.changeNullToEmpty(axis.getComment()) + "</Comment>");

				// o[̕\^Cv𐶐
				String displayMemberNameType = null;
				if(axis instanceof Dimension) {
					displayMemberNameType = dimMemberDAO.transferMemberDisplayTypeFromModelToXML(((Dimension)axis).getDispMemberNameType());
				} else {
					displayMemberNameType = dimMemberDAO.transferMemberDisplayTypeFromModelToXML(Dimension.DISP_SHORT_NAME);
				}
				reportInfoXML.append("<DisplayMemberType>" + displayMemberNameType + "</DisplayMemberType>");
					
				Iterator levelIt = axis.getAxisLevelList().iterator();
				while (levelIt.hasNext()) {
					AxisLevel axisLevel = (AxisLevel) levelIt.next();
					reportInfoXML.append("<Level>");
						reportInfoXML.append("<LNum>");
							reportInfoXML.append(axisLevel.getLevelNumber());
						reportInfoXML.append("</LNum>");
						reportInfoXML.append("<LName>");
							reportInfoXML.append(axisLevel.getName());
						reportInfoXML.append("</LName>");
						reportInfoXML.append("<Comment>");
							reportInfoXML.append(StringUtil.changeNullToEmpty(axisLevel.getComment()));
						reportInfoXML.append("</Comment>");
					reportInfoXML.append("</Level>");
				}
				reportInfoXML.append("</HierarchyInfo>");

			}

			reportInfoXML.append("</AxesInfo>");
		reportInfoXML.append("</OlapInfo>");

		// [Uo
		reportInfoXML.append("<UserInfo>");
			reportInfoXML.append("<UserName>");
				reportInfoXML.append(user.getName());
			reportInfoXML.append("</UserName>");
			reportInfoXML.append("<isAdmin>");
				reportInfoXML.append(CommonUtils.boolToFLG(user.isAdmin()));
			reportInfoXML.append("</isAdmin>");
			reportInfoXML.append("<isPersonalReportSavable>");
				reportInfoXML.append(CommonUtils.boolToFLG(user.isPersonalReportSavable()));
			reportInfoXML.append("</isPersonalReportSavable>");
			reportInfoXML.append("<isThisReportExportable>");
					Security security = (Security)helper.getRequest().getSession().getAttribute("security");
					reportInfoXML.append(CommonUtils.boolToFLG(security.isReportExportable()));
			reportInfoXML.append("</isThisReportExportable>");
			reportInfoXML.append("<exportType>");
				reportInfoXML.append(user.getExportFileType());
			reportInfoXML.append("</exportType>");
		reportInfoXML.append("</UserInfo>");

		// o񐶐
		reportInfoXML.append("<Axes>");

			// fBVo擾AB
			reportInfoXML.append(dimMemberDAO.getDimensionMemberXML(report));

			// W[𐶐
			Measure measure = report.getMeasure();
			Iterator meaMemIt = measure.getAxisMemberList().iterator();
			reportInfoXML.append("<Members name=\"" + measure.getName() + "\" id=\"" + measure.getId() +  "\">");

			while (meaMemIt.hasNext()) {
				MeasureMember measureMember = (MeasureMember) meaMemIt.next();

				if(!measureMember.isSelected()) {	// ZN^ŕ\ΏۊOƂĂ郁o͏o͂Ȃ
					continue;
				}

				reportInfoXML.append("<Member id=\"" + measureMember.getId() + "\">");
				reportInfoXML.append("    <UName>" + measureMember.getUniqueName() + "</UName>");
				reportInfoXML.append("    <Code>" + measureMember.getMeasureName() + "</Code>");
				reportInfoXML.append("    <Caption>" + measureMember.getMeasureName() + "</Caption>");
				reportInfoXML.append("    <Caption2>" + measureMember.getMeasureName() + "</Caption2>");
				reportInfoXML.append("    <LNum>1</LNum>");
				reportInfoXML.append("    <isDrilled>false</isDrilled>");
				reportInfoXML.append("    <isLeaf>true</isLeaf>");
				reportInfoXML.append("</Member>");

			}
			reportInfoXML.append("</Members>");

		reportInfoXML.append("</Axes>");
		reportInfoXML.append("</root>");


		// XMLo͏
		this.requestHelper.getResponse().setContentType("text/xml; charset=Shift_JIS");
		PrintWriter out = this.requestHelper.getResponse().getWriter();


		// XML̏o
		out.print(reportInfoXML.toString());
			if(log.isInfoEnabled()) {	// Oo
				log.info("XML(report info)F\n" + reportInfoXML.toString());
			}

	}

	/**
	 * |[gXMLɃG[Ƃ킷XMLvfo͂܂B
	 * @param helper RequestHelperIuWFNg
	 * @param e |[gXMLɔExceptionIuWFNg
	 * @exception IOException ɗO
	 */
	private void outputErrorXML(RequestHelper helper, Exception e) throws IOException {

		// Wo͂ւ̏o
		e.printStackTrace();

	
		// G[\vfǉ
		//   o͂XML`łꍇFroot̊OisErrorvfǉāAXML񐮌`ƂB
		//   o͂XML`łȂꍇFisErrorvfǉĂAXML͔񐮌`̂܂܁B
		//  񐮌`Ƃ邱ƂŁAMSXSLloadŃG[𔭐AG[sȂ킹B
		PrintWriter out = this.requestHelper.getResponse().getWriter();
		out.println("<isError>1</isError>");

		// MO
		log.error("|[gXMLɃG[BF", e);
		
	}

}
