/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import org.jfree.chart.LegendItem;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.entity.XYItemEntity;
import org.jfree.chart.event.RendererChangeEvent;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.CrosshairState;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.AbstractXYItemRenderer;
import org.jfree.chart.renderer.XYItemRenderer;
import org.jfree.chart.renderer.XYItemRendererState;
import org.jfree.chart.urls.XYURLGenerator;
import org.jfree.data.XYDataset;
import org.jfree.ui.RectangleEdge;
import org.jfree.util.BooleanList;
import org.jfree.util.PublicCloneable;

public class StandardXYItemRenderer
extends AbstractXYItemRenderer
implements XYItemRenderer,
Cloneable,
PublicCloneable,
Serializable {
    public static final int SHAPES = 1;
    public static final int LINES = 2;
    public static final int SHAPES_AND_LINES = 3;
    public static final int IMAGES = 4;
    public static final int DISCONTINUOUS = 8;
    public static final int DISCONTINUOUS_LINES = 10;
    private boolean plotShapes;
    private boolean plotLines;
    private boolean plotImages;
    private boolean plotDiscontinuous;
    private double gapThreshold = 1.0;
    private Boolean shapesFilled;
    private BooleanList seriesShapesFilled;
    private Boolean defaultShapesFilled;

    public StandardXYItemRenderer() {
        this(2, null);
    }

    public StandardXYItemRenderer(int type) {
        this(type, null);
    }

    public StandardXYItemRenderer(int type, XYToolTipGenerator toolTipGenerator) {
        this(type, toolTipGenerator, null);
    }

    public StandardXYItemRenderer(int type, XYToolTipGenerator toolTipGenerator, XYURLGenerator urlGenerator) {
        this.setToolTipGenerator(toolTipGenerator);
        this.setURLGenerator(urlGenerator);
        if ((type & 1) != 0) {
            this.plotShapes = true;
        }
        if ((type & 2) != 0) {
            this.plotLines = true;
        }
        if ((type & 4) != 0) {
            this.plotImages = true;
        }
        if ((type & 8) != 0) {
            this.plotDiscontinuous = true;
        }
        this.shapesFilled = null;
        this.seriesShapesFilled = new BooleanList();
        this.defaultShapesFilled = Boolean.TRUE;
    }

    public boolean getPlotShapes() {
        return this.plotShapes;
    }

    public void setPlotShapes(boolean flag) {
        if (this.plotShapes != flag) {
            this.plotShapes = flag;
            this.notifyListeners(new RendererChangeEvent(this));
        }
    }

    public boolean getItemShapeFilled(int series, int item) {
        return this.getSeriesShapesFilled(series);
    }

    public boolean getSeriesShapesFilled(int series) {
        if (this.shapesFilled != null) {
            return this.shapesFilled;
        }
        Boolean flag = this.seriesShapesFilled.getBoolean(series);
        if (flag != null) {
            return flag;
        }
        return this.defaultShapesFilled;
    }

    public void setShapesFilled(boolean filled) {
        if (filled) {
            this.setShapesFilled(Boolean.TRUE);
        } else {
            this.setShapesFilled(Boolean.FALSE);
        }
    }

    public void setShapesFilled(Boolean filled) {
        this.shapesFilled = filled;
    }

    public void setSeriesShapesFilled(int series, Boolean flag) {
        this.seriesShapesFilled.setBoolean(series, flag);
    }

    public Boolean getDefaultShapesFilled() {
        return this.defaultShapesFilled;
    }

    public void setDefaultShapesFilled(Boolean flag) {
        this.defaultShapesFilled = flag;
    }

    public boolean getPlotLines() {
        return this.plotLines;
    }

    public void setPlotLines(boolean flag) {
        if (this.plotLines != flag) {
            this.plotLines = flag;
            this.notifyListeners(new RendererChangeEvent(this));
        }
    }

    public double getGapThreshold() {
        return this.gapThreshold;
    }

    public void setGapThreshold(double t) {
        this.gapThreshold = t;
        this.notifyListeners(new RendererChangeEvent(this));
    }

    public boolean getPlotImages() {
        return this.plotImages;
    }

    public void setPlotImages(boolean flag) {
        if (this.plotImages != flag) {
            this.plotImages = flag;
            this.notifyListeners(new RendererChangeEvent(this));
        }
    }

    public boolean getPlotDiscontinuous() {
        return this.plotDiscontinuous;
    }

    public LegendItem getLegendItem(int datasetIndex, int series) {
        XYDataset dataset;
        LegendItem result = null;
        XYPlot plot = this.getPlot();
        if (plot != null && (dataset = plot.getDataset(datasetIndex)) != null) {
            String label;
            String description = label = dataset.getSeriesName(series);
            Shape shape = this.getSeriesShape(series);
            boolean shapeFilled = this.getSeriesShapesFilled(series);
            Paint paint = this.getSeriesPaint(series);
            Paint outlinePaint = this.getSeriesOutlinePaint(series);
            Stroke stroke = this.getSeriesStroke(series);
            result = new LegendItem(label, description, shape, shapeFilled, paint, stroke, outlinePaint, stroke);
        }
        return result;
    }

    public void drawItem(Graphics2D g2, XYItemRendererState state, Rectangle2D dataArea, PlotRenderingInfo info, XYPlot plot, ValueAxis domainAxis, ValueAxis rangeAxis, XYDataset dataset, int series, int item, CrosshairState crosshairState, int pass) {
        Image image;
        Shape entityArea = null;
        EntityCollection entities = null;
        if (info != null) {
            entities = info.getOwner().getEntityCollection();
        }
        PlotOrientation orientation = plot.getOrientation();
        Paint paint = this.getItemPaint(series, item);
        Stroke seriesStroke = this.getItemStroke(series, item);
        g2.setPaint(paint);
        g2.setStroke(seriesStroke);
        Number x1n = dataset.getXValue(series, item);
        Number y1n = dataset.getYValue(series, item);
        if (y1n == null || x1n == null) {
            return;
        }
        double x1 = x1n.doubleValue();
        double y1 = y1n.doubleValue();
        RectangleEdge xAxisLocation = plot.getDomainAxisEdge();
        RectangleEdge yAxisLocation = plot.getRangeAxisEdge();
        double transX1 = domainAxis.valueToJava2D(x1, dataArea, xAxisLocation);
        double transY1 = rangeAxis.valueToJava2D(y1, dataArea, yAxisLocation);
        if (this.getPlotLines() && item > 0) {
            Number x0n = dataset.getXValue(series, item - 1);
            Number y0n = dataset.getYValue(series, item - 1);
            if (y0n != null && x0n != null) {
                double x0 = x0n.doubleValue();
                double y0 = y0n.doubleValue();
                boolean drawLine = true;
                if (this.getPlotDiscontinuous()) {
                    int numX = dataset.getItemCount(series);
                    double minX = dataset.getXValue(series, 0).doubleValue();
                    double maxX = dataset.getXValue(series, numX - 1).doubleValue();
                    boolean bl = drawLine = x1 - x0 <= (maxX - minX) / (double)numX * this.getGapThreshold();
                }
                if (drawLine) {
                    double transX0 = domainAxis.valueToJava2D(x0, dataArea, xAxisLocation);
                    double transY0 = rangeAxis.valueToJava2D(y0, dataArea, yAxisLocation);
                    if (Double.isNaN(transX0) || Double.isNaN(transY0) || Double.isNaN(transX1) || Double.isNaN(transY1)) {
                        return;
                    }
                    if (orientation == PlotOrientation.HORIZONTAL) {
                        state.workingLine.setLine(transY0, transX0, transY1, transX1);
                    } else if (orientation == PlotOrientation.VERTICAL) {
                        state.workingLine.setLine(transX0, transY0, transX1, transY1);
                    }
                    if (state.workingLine.intersects(dataArea)) {
                        g2.draw(state.workingLine);
                    }
                }
            }
        }
        if (this.getPlotShapes()) {
            Shape shape = this.getItemShape(series, item);
            if (orientation == PlotOrientation.HORIZONTAL) {
                shape = this.createTransformedShape(shape, transY1, transX1);
            } else if (orientation == PlotOrientation.VERTICAL) {
                shape = this.createTransformedShape(shape, transX1, transY1);
            }
            if (shape.intersects(dataArea)) {
                if (this.getItemShapeFilled(series, item)) {
                    g2.fill(shape);
                } else {
                    g2.draw(shape);
                }
            }
            entityArea = shape;
        }
        if (this.getPlotImages() && (image = this.getImage(plot, series, item, transX1, transY1)) != null) {
            Point hotspot = this.getImageHotspot(plot, series, item, transX1, transY1, image);
            g2.drawImage(image, (int)(transX1 - hotspot.getX()), (int)(transY1 - hotspot.getY()), null);
            entityArea = new Rectangle2D.Double(transX1 - hotspot.getX(), transY1 - hotspot.getY(), image.getWidth(null), image.getHeight(null));
        }
        if (this.isItemLabelVisible(series, item)) {
            this.drawItemLabel(g2, orientation, dataset, series, item, transX1, transY1, y1 < 0.0);
        }
        this.updateCrosshairValues(crosshairState, x1, y1, transX1, transY1, orientation);
        if (entities != null) {
            if (entityArea == null) {
                entityArea = new Rectangle2D.Double(transX1 - 2.0, transY1 - 2.0, 4.0, 4.0);
            }
            String tip = null;
            XYToolTipGenerator generator = this.getToolTipGenerator(series, item);
            if (generator != null) {
                tip = generator.generateToolTip(dataset, series, item);
            }
            String url = null;
            if (this.getURLGenerator() != null) {
                url = this.getURLGenerator().generateURL(dataset, series, item);
            }
            XYItemEntity entity = new XYItemEntity(entityArea, dataset, series, item, tip, url);
            entities.addEntity(entity);
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj instanceof StandardXYItemRenderer) {
            StandardXYItemRenderer r = (StandardXYItemRenderer)obj;
            if (super.equals(obj)) {
                boolean b0 = this.plotShapes == r.plotShapes;
                boolean b1 = this.plotLines == r.plotLines;
                boolean b2 = this.plotImages == r.plotImages;
                boolean b3 = this.plotDiscontinuous == r.plotDiscontinuous;
                boolean b4 = this.gapThreshold == r.gapThreshold;
                return b0 && b1 && b2 && b3 && b4;
            }
        }
        return false;
    }

    protected Image getImage(Plot plot, int series, int item, double x, double y) {
        return null;
    }

    protected Point getImageHotspot(Plot plot, int series, int item, double x, double y, Image image) {
        int height = image.getHeight(null);
        int width = image.getWidth(null);
        return new Point(width / 2, height / 2);
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

