/*  OpenOlap viewer
 *  pbP[WFopenolap.viewer
 *  t@CFCellData.java
 *  F|[g̃Zf[^킷NXłB
 *
 *  쐬: 2004/01/19
 */
package openolap.viewer;

import java.io.Serializable;
import java.util.*;


/**
 *  NXFCellData
 *  F|[g̃Zf[^킷NXłB
 */
public class CellData implements Serializable {

	// ********** CX^Xϐ **********

	/** ̍W\IuWFNg */
	final private EdgeCoordinates colCoordinates;

	/** s̍W\IuWFNg */
	final private EdgeCoordinates rowCoordinates;

	/** ̃f[^郁W[o[UniqueName(viewerUA0̒ʔ) */
	final private String measureMemberUniqueName;

	/** ̃f[^郁W[o[̃W[V[PXԍ */
	final private String measureSeq;
	
	/** Zl */
	private String value = null;

	// ********** RXgN^ **********

	/**
	 * Zf[^IuWFNg𐶐܂B
	 */
	public CellData(EdgeCoordinates colCoordinates, EdgeCoordinates rowCoordinates, String measureMemberUniqueName, String measureSeq) {
		this.colCoordinates = colCoordinates;
		this.rowCoordinates = rowCoordinates;
		this.measureMemberUniqueName = measureMemberUniqueName;
		this.measureSeq = measureSeq;
	}

	// ********** Setter \bh **********

	/**
	 * Zf[^ɒlZbgB
	 * @param string Zf[^̒l
	 */
	public void setValue(String string) {
		value = string;
	}

	// ********** Getter \bh **********

	/**
	 * Z̗WIuWFNg߂B
	 * @return WIuWFNg
	 */
	public EdgeCoordinates getColCoordinates() {
		return colCoordinates;
	}

	/**
	 * Z̍sWIuWFNg߂B
	 * @return sWIuWFNg
	 */
	public EdgeCoordinates getRowCoordinates() {
		return rowCoordinates;
	}

	/**
	 * Z̒l߂B
	 * ʉ݋LAJ}LAPʏ́AW[o[̐ݒɏ]B
	 * @return Zl
	 */
	public String getValue() {
		return value;
	}

	/**
	 * Z̒lʉ݋LAJ}tH[}bgŋ߂B
	 * ȂAW[o[ɑ΂Pʐݒ͈pB
	 *    (PʁF~)F	\3,000,000  3000000
	 *      (PʁFS~)F	\3,000  3000  
	 * @return Zliʉ݋LAJ}tH[}bgj
	 */
	public String getValue2() {
		return replace(replace(value,"",""),",","");
	}

	/**
	 * ̃f[^郁W[o[UniqueName߂B
	 * @return W[o[UniqueName(viewerUA0̒ʔ)
	 */
	public String getMeasureMemberUniqueName() {
		return measureMemberUniqueName;
	}

	/**
	 * ̃f[^郁W[o[measureSeq߂B
	 * @return W[o[measureSeq
	 */
	public String getMeasureSeq() {
		return measureSeq;
	}



	/**
	*u܂B
	*@param strTarget Ώە
	*@param strOldStr uΏە
	*@param strOldNew u镶
	*@return strResult uꂽ
	*/
	private static String replace(String strTarget, String strOldStr, String strOldNew){
	    String strSplit[];
	    String strResult;

	    strSplit = split(strTarget, strOldStr);
	    strResult = strSplit[0];
	    for (int i = 1; i < strSplit.length; i ++){
	        strResult += strOldNew + strSplit[i];
	    }

	    return strResult;
	}

	/**
	*replace\bhœIɎgp
	*/
	private static String[] split(String strTarget, String strDelimiter){
	    String strResult[];
	    Vector objResult;
	    int intDelimiterLen;
	    int intStart;
	    int intEnd;

	    objResult = new java.util.Vector();
	    strTarget += strDelimiter;
	    intDelimiterLen = strDelimiter.length();
	    intStart = 0;
	    while ((intEnd = strTarget.indexOf(strDelimiter, intStart)) >= 0){
	        objResult.addElement(strTarget.substring(intStart, intEnd));
	        intStart = intEnd + intDelimiterLen;
	    }

	    strResult = new String[objResult.size()];
	    objResult.copyInto(strResult);
	    return strResult;
	}


}
