/*  OpenOlap viewer
 *  pbP[WFopenolap.viewer
 *  t@CFReport.java
 *  F|[g킷NXłB
 *
 *  쐬: 2003/12/29
 */

package openolap.viewer;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.TreeMap;

import openolap.viewer.common.Constants;
import openolap.viewer.common.Messages;
import openolap.viewer.controller.RequestHelper;
import openolap.viewer.dao.DAOFactory;
import openolap.viewer.dao.DimensionMemberDAO;
import openolap.viewer.dao.ReportDAO;

/**
 *  NXFReport
 *  F|[g킷NXłB
 */
public class Report implements Serializable {

	// ********** ÓIϐ **********

	/** {|[g [Uhc */
	static public String basicReportUserID = "0";

	/** {|[g Qƌ|[ghc */
	static public String basicReportReferenceReportID = null;

	/** {|[g |[g̎ */
	static public String basicReportOwnerFLG = "1";

	/** l|[g |[g̎ */
	static public String personalReportOwnerFLG = "2";

	/** l|[g l|[ĝ̖ɂڔ */
	static public String personalReportNameSuffix = "il|[gj";

	// ********** CX^Xϐ **********

	/** |[gID */
	final private String reportID;

	/** |[g */
	private String reportName = null;

	/** eID(|[gi[tH_ID) */
	private String parentID;

	/** l|[g쐬[UID */
	protected String userID = null;

	/** l|[gQƂĂ{|[gID */
	protected String referenceReportID = null;

	/** |[g̎({|[gAl|[g̊eꍇłƂĺAbasicReportOwnerFLG,personalReportOwnerFLGQƁB) */
	private String reportOwnerFLG = null;

	/** ʃ^Cvi0:Sʕ\i\jA1:Sʕ\iOtjA2:ci\AOt)j **/
	private String displayScreenType = "0";
	
	/** ftHgŕ\`[g̖ **/
	private String currentChart = "NA";

	/** L[u */
	final private Cube cube;

	/** GbW킷IuWFNgXg */
	final private ArrayList edgeList;

	/** nCCgi[XML */
	private String highLightXML;

	/** Fݒ̃^Cvi1FhԂA2FnCCgj */
	private String colorType = "1";

	/** F킷IuWFNg̃Xg */
	final private ArrayList colorList;

	/** Ԏ */
	final private boolean hasTimeDim;

	/** VK쐬Ŗۑ̃|[g(true)A|[g(false) */
	private boolean isNewReport = false;

	// ********** RXgN^ **********

	/**
	 * |[gIuWFNg𐶐܂B
	 */
	public Report(String reportID, String reportName, String userID, String referenceReportID, String reportOwnerFLG, Cube cube, ArrayList edgeList, ArrayList colorList, boolean hasTimeDim){
		this.reportID = reportID;
		this.reportName = reportName;
		this.parentID = null;
		this.userID = userID;
		this.referenceReportID = referenceReportID;
		this.reportOwnerFLG = reportOwnerFLG;
		this.cube = cube;
		this.edgeList = edgeList;
		this.highLightXML = null;
		this.colorList = colorList;
		this.hasTimeDim = hasTimeDim;
	}


	// ********** ÓI\bh **********

	/**
	 * ԎꍇtrueAȂꍇfalse߂B
	 * @param edgeList Xg
	 */
	public static boolean investigateTimeDimension(ArrayList edgeList) {
		Edge col = (Edge)Edge.getTheEdge("COL",edgeList);
		Edge row = (Edge)Edge.getTheEdge("ROW",edgeList);
		Edge page = (Edge)Edge.getTheEdge("PAGE",edgeList);

		return (col.investigateTimeDimension() || row.investigateTimeDimension() || page.investigateTimeDimension());
	}

	/**
	 * ^ꂽfBVXgAW[XgzuGbW킷IuWFNg̃Xg߂B
	 * @param dimList fBV킷IuWFNg̃Xg
	 * @param measure W[킷IuWFNg
	 * @return GbW킷IuWFNg̃Xg
	 */
	public static ArrayList initializeEdge(ArrayList dimList, Measure measure) {
		if ( (dimList == null) || (measure == null) ) { throw new IllegalArgumentException(); }
		if (dimList.size() < 1) { throw new IllegalArgumentException(); }

		Col col = null;
		Row row = null;
		Page page = null;
		ArrayList pageAxisList = new ArrayList();

		dimList.add(measure);

		col = new Col((Axis)dimList.get(0));
		row = new Row((Axis)dimList.get(1));

		if ( dimList.size()-2 > 0 ) { // fBVӂȏ㎝iy[WGbWjꍇ
			for(int i=0; i<(dimList.size()-2); i++){
				pageAxisList.add(dimList.get(i+2));
				page = new Page(pageAxisList);
			}
		} else {	// y[WGbWɎ݂ȂꍇAArrayList
			page = new Page(new ArrayList());
		}

		ArrayList edgeList = new ArrayList();
		edgeList.add(col);
		edgeList.add(row);
		edgeList.add(page);

		return edgeList;
	}

	public static String getInitialReportName() {
		return Messages.getString("Report.tempInitialReportName"); //$NON-NLS-1$
	}

	// ********** \bh **********

	/**
	 * ReportIuWFNg̍sAGbWɔzuꂽfBVɁAo[IuWFNgZbg
	 * @param helper RequestHelper킷IuWFNg̃Xg
	 * @param report |[g킷IuWFNg
	 * @param conn RlNV킷IuWFNg
	 */
	public void setSelectedCOLROWDimensionMembers(RequestHelper helper, Report report, Connection conn) throws SQLException {

		DimensionMemberDAO dimMemberDAO = DAOFactory.getDAOFactory().getDimensionMemberDAO(conn);

		Iterator it = report.getEdgeList().iterator();
		while (it.hasNext()) {
			Edge edge = (Edge) it.next();
			Iterator it2 = edge.getAxisList().iterator();

			if (edge.getPosition().equals(Constants.Page)) {
				continue;
			}

			int i = 0;
			while (it2.hasNext()) {
				Axis axis = (Axis) it2.next();
				Dimension dim = null;
				if(axis instanceof Dimension) {
					dim = (Dimension) axis;
				} else {
					i++;
					continue;
				}

				String selectedMemberList = "";
				if (edge.getPosition().equals(Constants.Col)) {
					selectedMemberList = "'," + helper.getRequest().getSession().getAttribute("viewCol" + i + "KeyList_hidden") + ",'";
				} else if (edge.getPosition().equals(Constants.Row)) {
					selectedMemberList = "'," + helper.getRequest().getSession().getAttribute("viewRow" + i + "KeyList_hidden") + ",'";
				}

				ArrayList dimMemberList = dimMemberDAO.selectDimensionMembers(dim, null, null, null, selectedMemberList);
				dim.clearAxisMember();
				dim.addAllAxisMember(dimMemberList);

				i++;
			}
		}
	}


	/**
	 * |[g̃fBVIuWFNgo[폜
	 */
	public void clearDimensionMembers() {

		Iterator it = edgeList.iterator();
		while (it.hasNext()) {
			Edge edge = (Edge) it.next();
			Iterator it2 = edge.getAxisList().iterator();
			while (it2.hasNext()) {
				Axis axis = (Axis) it2.next();
				if(!axis.isMeasure()){
					axis.clearAxisMember();
				}
			}
		}
	}


	/**
	 * |[g̎fBV߂B
	 * @return fBV
	 */
	public int getTotalDimensionNumber(){

		Iterator it = edgeList.iterator();
		int dimCounter = 0;
		while (it.hasNext()) {
			Edge edge = (Edge) it.next();
			Iterator it2 = edge.getAxisList().iterator();
			while (it2.hasNext()) {
				Axis axis = (Axis) it2.next();
				if(!axis.isMeasure()){
					dimCounter++;
				}
			}
		}

		return dimCounter;
	}

	/**
	 * |[g̎W[o[߂B
	 * @return W[o[
	 */
	public int getTotalMeasureMemberNumber(){
		ArrayList measureMemberList = this.getMeasure().getAxisMemberList();
		return measureMemberList.size();
	}

	/**
	 * ^ꂽ̂̃GbWIuWFNg߂B
	 * @param edgeType GbW킷́iCOL,ROW,PAGEj
	 * @return GbWIuWFNg
	 */
	public Edge getEdgeByType(String edgeType) {
		Iterator it = edgeList.iterator();
		while (it.hasNext()) {
			Edge edge = (Edge) it.next();
			if (edge.getPosition().equals(edgeType)){
				return edge;
			}
		}
		return null;
	}

	/**
	 * W[IuWFNg߂B
	 * @return W[IuWFNg
	 */
	public Measure getMeasure() {
		Iterator it = this.getEdgeList().iterator();
		while (it.hasNext()) {
			Edge edge = (Edge) it.next();
			if(edge.getMeasure() != null) {
				return edge.getMeasure();
			}
		}
		throw new IllegalStateException();
	}

	/**
	 * ^ꂽID̎IuWFNg߂B
	 * IuWFNg݂Ȃꍇnull߂B
	 * @return IuWFNg
	 */
	public Axis getAxisByID(String sourceID) {
		Iterator it = this.getEdgeList().iterator();
		while (it.hasNext()) {
			Edge edge = (Edge) it.next();
			Iterator axisIt = edge.getAxisList().iterator();

			while (axisIt.hasNext()) {
				Axis axis = (Axis) axisIt.next();

				if(axis.getId().equals(sourceID)) {
					return axis;
				}
			}
		}
		return null;
	}


	/**
	 * |[gSĂ̎IuWFNgw肳ꂽGbW̏Ŏ擾B
	 * eGbWɕ݂̎ꍇ́AiIndex̏ƂB
	 * @param firstEdgePosition  ORDER BYňԖڂɎw肳GbW^Cv(Constants.Col or Constants.Row or Constants.Page)
	 * @param secondEdgePosition ORDER BYœԖڂɎw肳GbW^Cv(Constants.Col or Constants.Row or Constants.Page)
	 * @param thirdEdgePosition  ORDER BYŎOԖڂɎw肳GbW^Cv(Constants.Col or Constants.Row or Constants.Page)
	 * @param includeMeasure   W[܂߂邩ǂH
	 * @return IuWFNg̃Xg
	 */
	public ArrayList getAxisOrderByEdgePosition(String firstEdgePosition, String secondEdgePosition, String thirdEdgePosition, boolean includeMeasure) {
		if((!Constants.Col.equals(firstEdgePosition)) && (!Constants.Col.equals(secondEdgePosition)) && (Constants.Col.equals(thirdEdgePosition)) ) {
			throw new IllegalArgumentException();
		}
		if((!Constants.Row.equals(firstEdgePosition)) && (!Constants.Row.equals(secondEdgePosition)) && (Constants.Row.equals(thirdEdgePosition)) ) {
			throw new IllegalArgumentException();
		}
		if((!Constants.Page.equals(firstEdgePosition)) && (!Constants.Page.equals(secondEdgePosition)) && (Constants.Page.equals(thirdEdgePosition)) ) {
			throw new IllegalArgumentException();
		}
		if((firstEdgePosition.equals(secondEdgePosition)) || (firstEdgePosition.equals(thirdEdgePosition)) || (secondEdgePosition.equals(thirdEdgePosition))) {
			throw new IllegalArgumentException();
		}

		ArrayList axisList = new ArrayList();

		// first
			Edge edge = this.getEdgeByType(firstEdgePosition);
			Iterator it = edge.getAxisList().iterator();
			while (it.hasNext()) {
				Axis axis = (Axis) it.next();
				if ((!includeMeasure) && axis instanceof Measure) {
					continue;
				} else {
					axisList.add(axis);
				}
			}

		// second
			edge = this.getEdgeByType(secondEdgePosition);
			it = edge.getAxisList().iterator();
			while (it.hasNext()) {
				Axis axis = (Axis) it.next();
				if ((!includeMeasure) && axis instanceof Measure) {
					continue;
				} else {
					axisList.add(axis);
				}
			}

		// third
			edge = this.getEdgeByType(thirdEdgePosition);
			it = edge.getAxisList().iterator();
			while (it.hasNext()) {
				Axis axis = (Axis) it.next();
				if ((!includeMeasure) && axis instanceof Measure) {
					continue;
				} else {
					axisList.add(axis);
				}
			}

		return axisList;
	}

	/**
	 * |[gSĂ̎IuWFNgAxisId ̏Ŏ擾B
	 * @return IuWFNg̃Xg
	 */
	public ArrayList getAxisOrderByID() {
		ArrayList axisList = new ArrayList();

		TreeMap axisIdObjMap = new TreeMap();
		Iterator it = this.getEdgeList().iterator();
		while (it.hasNext()) {
			Edge edge = (Edge) it.next();
			Iterator axisIt = edge.getAxisList().iterator();

			while (axisIt.hasNext()) {
				Axis axis = (Axis) axisIt.next();
				axisIdObjMap.put(Integer.decode(axis.getId()), axis);
			}
		}

		Iterator axisIt = axisIdObjMap.keySet().iterator();
		while (axisIt.hasNext()) {
			Integer axisID = (Integer) axisIt.next();
			Axis axis = (Axis) axisIdObjMap.get(axisID) ;
			axisList.add(axis);
		}

		return axisList;
	}

	/**
	 * ^ꂽzuĂGbŴ̖߂B
	 * IuWFNg݂Ȃꍇnull߂B
	 * @param oAxis 킷IuWFNg
	 * @return GbW̖
	 */
	public String getThisAxisPosition(Axis oAxis) {
		if (oAxis == null){ return null; }
		Iterator it = this.getEdgeList().iterator();
		while (it.hasNext()) {
			Edge edge = (Edge) it.next();
			if (edge.hasThisAxis(oAxis)){
				return edge.getPosition();
			}
		}
		return null;
	}

	/**
	 * ^ꂽzuĂGbŴ̖߂B
	 * IuWFNg݂Ȃꍇnull߂B
	 * @param id ID
	 * @return GbW̖
	 */
	public String getThisAxisPosition(String id) {
		if (id == null){ return null; }
		Iterator it = this.getEdgeList().iterator();
		while (it.hasNext()) {
			Edge edge = (Edge) it.next();
			if (edge.hasThisAxis(id)){
				return edge.getPosition();
			}
		}
		return null;
	}

	/**
	 * ^ꂽID̎IuWFNgGbW폜
	 * @param id ID
	 */
	public void deleteAxis(String axisID) {

		Iterator it = this.getEdgeList().iterator();
		while (it.hasNext()) {
			Edge edge = (Edge) it.next();
			Iterator axisIt = edge.getAxisList().iterator();

			int i = 0;
			while (axisIt.hasNext()) {
				Axis axis = (Axis) axisIt.next();
				if(axis.getId().equals(axisID)) {
					// GbWXgA^ꂽ폜
					edge.getAxisList().remove(i);					
					break;
				}
				i++;
			}
		}
	}



	/**
	 * ^ꂽGbWɔzuĂꍇtrueAzuĂȂꍇfalse߂B
	 * @param oAxis IuWFNg
	 * @return GbWɔzuĂ邩
	 */
	public boolean isInCol(Axis oAxis) {
		if (oAxis == null){ return false; }
		if (this.getThisAxisPosition(oAxis).equals(Constants.Col)) {
			return true;
		} else {
			return false;
		}
	}

	/**
	 * ^ꂽGbWɔzuĂꍇtrueAzuĂȂꍇfalse߂B
	 * @param axisId ID
	 * @return GbWɔzuĂ邩
	 */
	public boolean isInCol(String axisId) {
		if (axisId == null){ return false; }
		if (this.getThisAxisPosition(axisId).equals(Constants.Col)) {
			return true;
		} else {
			return false;
		}
	}


	/**
	 * ^ꂽsGbWɔzuĂꍇtrueAzuĂȂꍇfalse߂B
	 * @param oAxis IuWFNg
	 * @return sGbWɔzuĂ邩
	 */
	public boolean isInRow(Axis oAxis) {
		if (oAxis == null){ return false; }
		if (this.getThisAxisPosition(oAxis).equals(Constants.Row)) {
			return true;
		} else {
			return false;
		}
	}

	/**
	 * ^ꂽsGbWɔzuĂꍇtrueAzuĂȂꍇfalse߂B
	 * @param axisId ID
	 * @return sGbWɔzuĂ邩
	 */
	public boolean isInRow(String axisId) {
		if (axisId == null){ return false; }
		if (this.getThisAxisPosition(axisId).equals(Constants.Row)) {
			return true;
		} else {
			return false;
		}
	}

	/**
	 * ^ꂽy[WGbWɔzuĂꍇtrueAzuĂȂꍇfalse߂B
	 * @param oAxis IuWFNg
	 * @return y[WGbWɔzuĂ邩
	 */
	public boolean isInPage(Axis oAxis) {
		if (oAxis == null){ return false; }
		if (this.getThisAxisPosition(oAxis).equals(Constants.Page)) {
			return true;
		} else {
			return false;
		}
	}

	/**
	 * ^ꂽy[WGbWɔzuĂꍇtrueAzuĂȂꍇfalse߂B
	 * @param axisId ID
	 * @return y[WGbWɔzuĂ邩
	 */
	public boolean isInPage(String axisId) {
		if (axisId == null){ return false; }
		if (this.getThisAxisPosition(axisId).equals(Constants.Page)) {
			return true;
		} else {
			return false;
		}
	}

	/**
	 * ^ꂽzuĂGbWł̒iCfbNX߂B
	 * CfbNX́u0vstart̒lłB
	 * ƂnullnĂꍇ́u-1v߂B
	 * ^ꂽ݂Ȃꍇ́u0v߂B
	 * @param oAxis IuWFNg
	 * @return GbWł̒iCfbNX
	 */
	public int getHieIndex(Axis oAxis) {
		if (oAxis == null){ return -1; }
		Iterator it = this.getEdgeList().iterator();
		while (it.hasNext()) {
			Edge edge = (Edge) it.next();
			if (edge.getAxisIndexInEdge(oAxis) != -1) {
				return edge.getAxisIndexInEdge(oAxis);
			}
		}
		return 0;
	}

	/**
	 * ^ꂽzuĂGbWł̒iCfbNX߂B
	 * CfbNX́u0vstart̒lłB
	 * ƂnullnĂꍇ́u-1v߂B
	 * ^ꂽ݂Ȃꍇ́u-1v߂B
	 * @param axisID ID
	 * @return GbWł̒iCfbNX
	 */
	public int getHieIndex(String axisID) {
		if (axisID == null){ return -1; }
		Iterator it = this.getEdgeList().iterator();
		while (it.hasNext()) {
			Edge edge = (Edge) it.next();
			if (edge.getAxisIndexInEdge(axisID) != -1) {
				return edge.getAxisIndexInEdge(axisID);
			}
		}
		return -1;
	}

	/**
	 * w肳ꂽGbWɔzuꂽo[̑gݍ킹߂B
	 * @param edgeName 
	 * @return o[̑gݍ킹
	 */
	public int getAxisMeberComboNum(String edgeName) {
		if ( (!Constants.Col.equals(edgeName)) && (!Constants.Row.equals(edgeName)) && (!Constants.Page.equals(edgeName)) ) {
			throw new IllegalStateException();
		}

		int totalNumber = 1;
		ArrayList edgeAxesList = this.getEdgeByType(Constants.Col).getAxisList();
		Iterator iter = edgeAxesList.iterator();
		while (iter.hasNext()) {
			Axis axis = (Axis) iter.next();
			totalNumber = totalNumber * (axis.getAxisMemberList().size());
		} 

		return totalNumber;
	}

	/**
	 * F\IuWFNg|[gɒǉB
	 * @param color F킷IuWFNg
	 */
	public void addColor(Color color) {
		if(color == null) { throw new IllegalArgumentException(); }
		this.colorList.add(color);
	}

	/**
	 * F\IuWFNg̃Xg|[gɒǉB
	 * @param color F킷IuWFNg
	 */
	public void addColor(ArrayList colorList) {
		if(colorList == null) { throw new IllegalArgumentException(); }

		Iterator it = colorList.iterator();
		while (it.hasNext()) {
			Color color = (Color) it.next();
			this.colorList.add(color);
		}
	}

	/**
	 * F\IuWFNg̃XgNAB
	 */
	public void clearColorList() {
		this.colorList.clear();
		
	}

	/**
	 * wb_[̐F\IuWFNg̃Xg߂B
	 * @return color F킷IuWFNg
	 */
	public ArrayList getHeaderColorList() {
		ArrayList headerColorList = new ArrayList();
		Iterator it = this.colorList.iterator();
		while (it.hasNext()) {
			Color color = (Color) it.next();
			if(color.isHeader()){
				headerColorList.add(color);
			}
		}
		return headerColorList;
	}

	/**
	 * f[^e[u̐F\IuWFNg̃Xg߂B
	 * @return color F킷IuWFNg
	 */
	public ArrayList getSpreadColorList() {
		ArrayList spreadColorList = new ArrayList();
		Iterator it = this.colorList.iterator();
		while (it.hasNext()) {
			Color color = (Color) it.next();
			if(!color.isHeader()){
				spreadColorList.add(color);
			}
		}
		return spreadColorList;
	}

	/**
	 * |[gۑB
	 * @param conn RlNV킷IuWFNg
	 * @exception SQLException DBւ̃|[gۑŗO
	 */
	public void saveReport(Connection conn) throws SQLException {
		DAOFactory daoFactory = DAOFactory.getDAOFactory();

		ReportDAO reportDAO = daoFactory.getReportDAO(conn);
		reportDAO.saveReport(this, conn);
	}

	/**
	 * VKl|[gۑB
	 * @param conn RlNV킷IuWFNg
	 * @exception SQLException DBւ̃|[gۑŗO
	 */
	public void saveNewPersonalReport(String newReportName, String userID, Connection conn) throws SQLException {
		DAOFactory daoFactory = DAOFactory.getDAOFactory();

		ReportDAO reportDAO = daoFactory.getReportDAO(conn);
		reportDAO.saveNewPersonalReport(this, newReportName, userID, conn);
	}



	/**
	 * ̃CX^X̕\߂B
	 * @return StringIuWFNg
	 */
	public String toString() {

		String sep = System.getProperty("line.separator");

		String stringInfo = "";
		stringInfo += "Report.reportID:" + this.reportID + sep;
		stringInfo += "Report.reportName:" + this.reportName + sep;
		stringInfo += "Report.parentID:" + this.parentID + sep;
		stringInfo += "Report.userID:" + this.userID + sep;
		stringInfo += "Report.referenceReportID:" + this.referenceReportID + sep;
		stringInfo += "Report.reportOwnerFLG:" + this.reportOwnerFLG + sep;
		stringInfo += "Report.displayScreenType:" + this.displayScreenType + sep;
		stringInfo += "Report.currentChart:" + this.currentChart + sep;
		stringInfo += "Report.highLightXML:" + this.highLightXML + sep;
		stringInfo += "Report.colorType:" + this.colorType + sep;
		stringInfo += "Report.hasTimeDim:" + String.valueOf(this.hasTimeDim) + sep;
		stringInfo += "Report.isNewReport:" + String.valueOf(this.isNewReport) + sep;

		stringInfo += "--- cube info ---" + sep;
		stringInfo += this.cube.toString();

		stringInfo += "--- edge info ---" + sep;		
		Iterator it = this.getEdgeList().iterator();
		while (it.hasNext()) {
			Edge edge = (Edge) it.next();

			stringInfo += "edge position:" + edge.getPosition() + " -- start " + sep;

			Iterator axisIt = edge.getAxisList().iterator();
			while (axisIt.hasNext()) {
				Axis axis = (Axis) axisIt.next();

				stringInfo += "-- axis -- " + sep;
				stringInfo += axis.toString();
			}

			stringInfo += "edge position:" + edge.getPosition() + " -- end  " + sep;

		}		
		
//		stringInfo += "--- color info ---" + sep;

		return stringInfo;

	}

	// ********** Setter \bh **********

	/**
	 * [UIDZbgB
	 * @param [UID
	 */
	public void setUserID(String userID) {
		this.userID = userID;
	}

	/**
	 * Qƌ|[gIDZbgB
	 * @param Qƌ|[gID
	 */
	public void setReferenceReportID(String referenceReportID) {
		this.referenceReportID = referenceReportID;
	}

	/**
	 * |[g̎ނZbgB
	 * @param |[g̎
	 */
	public void setScopeKindFLG(String reportOwnerFLG) {
		this.reportOwnerFLG = reportOwnerFLG;
	}

	/**
	 * |[gZbgB
	 * @param string |[g
	 */
	public void setReportName(String string) {
		reportName = string;
	}

	/**
	 * |[gIDZbgB
	 * @param string |[gID
	 */
	public void setParentID(String string) {
		parentID = string;
	}

	public void setHighLightXML(String string) {
		highLightXML = string;
	}


	public void setColorType(String string) {
		colorType = string;
	}

	/**
	 * VK|[gtOZbgB
	 * @param string |[gID
	 */
	public void setNewReport(boolean b) {
		isNewReport = b;
	}

	/**
	 * ʃ^CvZbgB
	 * @param screenType ʃ^Cv
	 */
	public void setDisplayScreenType(String screenType) {
		this.displayScreenType = screenType;
	}


	/**
	 * ftHg`[ĝ̖ZbgB
	 * @param currentChart `[g̖
	 */
	public void setCurrentChart(String currentChart) {
		this.currentChart = currentChart;
	}



	// ********** Getter \bh **********

	/**
	 * |[g߂B
	 * @return |[g
	 */
	public String getReportName() {
		return reportName;
	}

	/**
	 * |[gID߂B
	 * @return |[gID
	 */
	public String getReportID() {
		return reportID;
	}

	/**
	 * |[g̐eIDi|[gi[tH_IDj߂B
	 * @return |[gID
	 */
	public String getParentID() {
		return parentID;
	}

	public String getHighLightXML() {
		return highLightXML;
	}

	public String getColorType() {
		return colorType;
	}

	/**
	 * [UID߂B
	 * @return [UID
	 */
	public String getUserID() {
		return userID;
	}
	
	/**
	 * Qƌ|[gID߂B
	 * @return Qƌ|[gID
	 */
	public String getReferenceReportID() {
		return referenceReportID;
	}
	
	/**
	 * |[g̎ނ߂B
	 * @return |[g̎
	 *            {|[g(=Report.basicReportOwnerFLG)
	 *            l|[g(=Report.personalReportOwnerFLG)
	 */
	public String getReportOwnerFLG() {
		return reportOwnerFLG;
	}

	/**
	 * ʃ^Cv߂B
	 * @return screenType ʃ^Cv
	 */
	public String getDisplayScreenType() {
		return displayScreenType;
	}


	/**
	 * ftHg`[ĝ̖߂B
	 * @return currentChart `[g̖
	 */
	public String getCurrentChart() {
		return currentChart;
	}

	/**
	 * L[u߂B
	 * @return |[gID
	 */
	public Cube getCube() {
		return cube;
	}

	/**
	 * IuWFNg̃Xg߂B
	 * @return IuWFNg̃Xg
	 */
	public ArrayList getEdgeList() {
		return edgeList;
	}

	/**
	 * FIuWFNg̃Xg߂B
	 * @return FIuWFNg̃Xg
	 */
	public ArrayList getColorList() {
		return colorList;
	}

	/**
	 * ԎĂtrueAȂfalse߂B
	 * @return IuWFNg̃Xg
	 */
	public boolean hasTimeDim() {
		return hasTimeDim;
	}

	/**
	 * VK쐬Ŗۑ̃|[głtrueA|[głfalse߂B
	 * @return VK|[g
	 */
	public boolean isNewReport() {
		return isNewReport;
	}

}
