/*
 * 쐬: 2004/07/26
 */
package openolap.viewer.chart;

import java.awt.Color;
import java.awt.Font;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.StringTokenizer;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspWriter;

import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.Legend;
import org.jfree.chart.StandardLegend;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.StandardEntityCollection;
import org.jfree.chart.imagemap.StandardToolTipTagFragmentGenerator;
import org.jfree.chart.labels.StandardCategoryToolTipGenerator;
import org.jfree.chart.labels.StandardPieItemLabelGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.DatasetRenderingOrder;
import org.jfree.chart.plot.MultiplePiePlot;
import org.jfree.chart.plot.PiePlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.AreaRenderer;
import org.jfree.chart.renderer.BarRenderer;
import org.jfree.chart.renderer.BarRenderer3D;
import org.jfree.chart.renderer.CategoryItemRenderer;
import org.jfree.chart.renderer.LineAndShapeRenderer;
import org.jfree.chart.renderer.StackedAreaRenderer;
import org.jfree.chart.renderer.StackedBarRenderer;
import org.jfree.chart.renderer.StackedBarRenderer3D;
import org.jfree.chart.servlet.ServletUtilities;
import org.jfree.chart.title.TextTitle;
import org.jfree.data.CategoryDataset;
import org.jfree.data.Dataset;
import org.jfree.data.DefaultCategoryDataset;
import org.jfree.data.DefaultPieDataset;
import org.jfree.data.PieDataset;
import org.jfree.util.TableOrder;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/**
 * @author Administrator
 *
 */
public class ChartCreator {

	// ********** CX^Xϐ **********

	/** `[gIuWFNg */
	JFreeChart chart = null;

	/** `[g̃vbg*/
	Plot plot = null;

	/** `[g^Cv*/
	String chartType = null;

	/** f[^Zbg̔z   */
	ArrayList<Dataset> dataSetList = null;

	/** `[g̕   */
	int chartWidth   = 0;

	/** `[g̍ */
	int chartHeight  = 0;

	// ********** \bh **********

	// `[g\XMLƂɃ`[g̐ݒsȂ
	public void createChart( Document doc ) throws IllegalAccessException, NoSuchFieldException {
		
		//`[gXMLݒ
		this.setChartByDoc(doc);
		
		//`[g^Cg̕FXMLݒ
		this.setChartTitleColorByDoc(doc);

		//`[g̃tHgݒ
		this.setChartTitleFont(doc);
		
		//`[gwiFXMLݒ
		this.setBackgroundColorByDoc(doc);
		
		//rXMLݒ
		this.setLegendByDoc(doc);
		
		//vbgGAwiF̐ݒ
		this.setPlotBackgroundColorByDoc(doc);
		
		//_E܂Eʃ`[g
		if(this.getPlot() instanceof CategoryPlot) {

			//JeS̐ݒ
			this.setCategoryAxisByDoc(doc);

			//Seriesݒ
			this.setSeriesAxisByDoc(doc);

//			//h_Eݒ
//			enableDrillDown(renderer,(DefaultCategoryDataset)helper.codeDataset);

		//~`[g
		} else if ((this.getPlot() instanceof PiePlot) ||
					 (this.getPlot() instanceof MultiplePiePlot)){

			//vbgGAwiFݒi~`[gpj
			this.setMultiPiePlotBGColor(doc);
		
			//~`[gpxݒ
			this.setPieLabel(doc);
			
			//c[`bv̐ݒ
			this.setToolTipForPie(doc);
			
			//tHg̐ݒ
			this.setPieFont(doc);
			
			//h_Eݒ
//			enableDrillDown(piePlot,(DefaultPieDataset)helper.codeDataset);			//~	
//			enableDrillDown(piePlot,(DefaultCategoryDataset)helper.codeDataset);	//~			
			
		}

		
	}


	/**
	 *  `[giXMLjƂɁAChartIuWFNgѕAݒ肷B
	 */
	public void setChartByDoc( Document doc ) {
		
		this.chart = createChartObject(doc);						// JFreeChartIuWFNgXMLƂɐ

		this.setPlot(this.chart);							// vbgݒ
		this.setChartWidth(getChartWidthByDoc(doc));		// `[gXML擾
		this.setChartHeight(getChartHeightByDoc(doc));		// `[gXML擾
	}


	/**
	 *  `[giXMLjƂɁA`[g^Cg̕Fݒ肷B
	 */
	public void setChartTitleColorByDoc(Document doc) {

		Element root         = doc.getDocumentElement();
		Element chartInfo    = (Element)root.getElementsByTagName("ChartInfo").item(0);
		String titleColor    = chartInfo.getElementsByTagName("TitleColor").item(0).getFirstChild().getNodeValue();

		TextTitle title = this.getChart().getTitle();
		title.setPaint(createColor(titleColor));
		
	}

	/**
	 *  `[giXMLjƂɁA`[g^Cg̃tHgݒ肷B
	 */
	public void setChartTitleFont(Document doc) throws IllegalAccessException, NoSuchFieldException {

		TextTitle title = this.getChart().getTitle();
		title.setFont(this.getFont(doc));
		
	}
	
	
	/**
	 *  `[giXMLjƂɁA`[gwiFݒ肷B
	 */
	public void setBackgroundColorByDoc(Document doc) {
		
		Element root         = doc.getDocumentElement();
		Element chartInfo    = (Element)root.getElementsByTagName("ChartInfo").item(0);
		String chartBGColor  = chartInfo.getElementsByTagName("ChartBGColor").item(0).getFirstChild().getNodeValue();
		
		this.getChart().setBackgroundPaint(createColor(chartBGColor));
		
	}

	/**
	 *  `[giXMLjƂɁAvbgGA̔wiFݒ肷B
	 */
	public void setPlotBackgroundColorByDoc(Document doc) {

		Element root         = doc.getDocumentElement();
		Element chartInfo    = (Element)root.getElementsByTagName("ChartInfo").item(0);
		String plotBGColor  = chartInfo.getElementsByTagName("PlotBGColor").item(0).getFirstChild().getNodeValue();
		
		this.getChart().getPlot().setBackgroundPaint(createColor(plotBGColor));		
		
	}

	/**
	 *  `[giXMLjƂɁArݒ肷B
	 */
	public void setLegendByDoc(Document doc) throws IllegalAccessException, NoSuchFieldException {
		
		Element root          = doc.getDocumentElement();
		Element chartInfo     = (Element)root.getElementsByTagName("ChartInfo").item(0);
		String legendPosition = chartInfo.getElementsByTagName("LegendPosition").item(0).getFirstChild().getNodeValue();

		// ȑꍇArꏊw肵ĕ\
		if (("North".equals(legendPosition)) || ("South".equals(legendPosition)) || 
		     ("East".equals(legendPosition)) ||  ("West".equals(legendPosition)) ) {
			
			StandardLegend legend = new StandardLegend();
			int legendPositionID = 0;

			if("North".equals(legendPosition)) {
				legendPositionID = Legend.NORTH;
			} else if ("South".equals(legendPosition)) {
				legendPositionID = Legend.SOUTH;
			} else if ("East".equals(legendPosition)) {
				legendPositionID = Legend.EAST;
			} else if ("West".equals(legendPosition)) {
				legendPositionID = Legend.WEST;
			}

			legend.setAnchor(legendPositionID);
			chart.setLegend(legend);
			legend.setItemFont(this.getFont(doc));
			
		// rȂ
		} else {
			// rݒ肵Ȃi\Ȃj
		}
		
	}



	/**
	 *  `[gHTML֏o͂iC[WPNG`j
	 */
	public void outPNGChart(HttpServletRequest request, JspWriter out ) throws IOException {

		ChartRenderingInfo info = new ChartRenderingInfo(new StandardEntityCollection());
		String filename = ServletUtilities.saveChartAsPNG(chart, this.chartWidth, this.chartHeight, info, request.getSession());
		String chartURL = request.getContextPath() + "/servlet/DisplayChart?filename=" + filename;
		String imageMap = ChartUtilities.getImageMap("chart",info,new StandardToolTipTagFragmentGenerator(), new CustomURLTagFragmentGenerator());
		out.println("<IMG SRC=\"" + chartURL + "\" usemap=\"#chart\" />");
		out.println(imageMap);		
	}

	/**
	 *  `[gHTML֏o͂iC[WJPEG`j
	 */
//	public void outJPEGChart( ) {
//	}


	/**
	 *  `[g̃C[W𒼐ڏo͂iC[WPNG`j
	 */
	public void outDirectPNGChart(HttpServletResponse response) throws IOException {

		OutputStream out = response.getOutputStream();
		response.setContentType("image/png");
		ChartUtilities.writeChartAsPNG(out, chart, chartWidth, chartHeight);
	
	}



	/**
	 *  JeS()ݒ肷郁\bh
	 */	
	public void setCategoryAxisByDoc(Document doc) throws IllegalAccessException, NoSuchFieldException {

		Element root              = doc.getDocumentElement();
		Element category          = (Element)root.getElementsByTagName("Category").item(0);
		String categoryLabelColor = category.getElementsByTagName("LabelColor").item(0).getFirstChild().getNodeValue();

		CategoryPlot categoryPlot = (CategoryPlot)this.getPlot();
		CategoryAxis categoryAxis = categoryPlot.getDomainAxis(); //̎擾
		categoryAxis.setLabelPaint(this.createColor(categoryLabelColor)); //JeSxJ[

		categoryAxis.setLabelFont(this.getFont(doc)); //tHg
		categoryAxis.setTickLabelFont(this.getFont(doc)); //TickxtHg
	}

	/**
	 *  V[Y(c)ݒ肷郁\bh
	 */	
	public void setSeriesAxisByDoc(Document doc) throws IllegalAccessException, NoSuchFieldException {

		CategoryPlot categoryPlot = (CategoryPlot)this.getPlot();

		Element root           = doc.getDocumentElement();
		Element chartInfo      = (Element)root.getElementsByTagName("ChartInfo").item(0);

		// f[^ZbgXg
		ArrayList<Dataset> dataSetList = this.getDataSetList();
		int listSize = dataSetList.size();

		// f[^Zbg̐[v
		for(int i = 0; i < listSize; i++) {

			//vbg2Ԗڈȍ~̃f[^Zbgǉ
			//i1Ԗڂ̃f[^ZbǵAChartFactory.create** \bhŃ`[gIuWFNg쐬ɒǉς݁j
			if (i != 0) {
				DefaultCategoryDataset subDataset = (DefaultCategoryDataset)dataSetList.get(i);
				categoryPlot.setDataset(i,subDataset);

				//f[^ZbgV[Yɒǉ
				categoryPlot.mapDatasetToRangeAxis(i,1);
			}


			//V[YValueAxisIuWFNgxwŐ
			Element series = (Element)chartInfo.getElementsByTagName("Series").item(i);
			String seriesLabel = series.getElementsByTagName("Label").item(0).getFirstChild().getNodeValue();

			ValueAxis valueAxis = null;
			if (i == 0) {
				valueAxis = categoryPlot.getRangeAxis();
			} else {
				valueAxis = new NumberAxis(seriesLabel); 
			}
			
			//V[ỸxJ[AtHgݒ
			String seriesLabelColor   = series.getElementsByTagName("LabelColor").item(0).getFirstChild().getNodeValue();
			valueAxis.setLabelPaint(this.createColor(seriesLabelColor)); //V[YxJ[
			valueAxis.setLabelFont(this.getFont(doc)); //tHg
			valueAxis.setTickLabelFont(this.getFont(doc)); //TickxtHg

			String isAutoRangeEnable  = series.getElementsByTagName("isAutoRangeEnable").item(0).getFirstChild().getNodeValue();
			//V[YW蓮ݒ
			if("0".equals(isAutoRangeEnable)) {

				String maxRange           = series.getElementsByTagName("MaxRange").item(0).getFirstChild().getNodeValue();
				String minRange           = series.getElementsByTagName("MinRange").item(0).getFirstChild().getNodeValue();

				//Wől
				valueAxis.setUpperBound(Double.parseDouble(maxRange));

				//Wŏl
				valueAxis.setLowerBound(Double.parseDouble(minRange));

			}

			//vbgɐV[Yݒ
			if (i != 0) {
				categoryPlot.setRangeAxis(i, valueAxis);
			}

			//_[擾			
			CategoryItemRenderer renderer = null;
			if (i == 0) {
				renderer = this.createRenderer("byPlot");
			} else {
				renderer = this.createRenderer("create");
			}

			//c[`bv쐬
			setToolTip(doc, renderer);


//			//h_Eݒ
//			enableDrillDown(LSRenderer,(DefaultCategoryDataset)helper.codeDatasetList.elementAt(i));

			if (i != 0) {
				categoryPlot.setRenderer(i,renderer); //IWĩvbgɃ_[ǉ
				categoryPlot.setDatasetRenderingOrder(DatasetRenderingOrder.REVERSE);
			}

		}
		//[vI
	}


	/**
	 * ~Otp̃xݒ胁\bh
	 * @param doc XML(JFreeChartpXMLhLg)
	 */
	public void setPieLabel(Document doc) {

		Element root           = doc.getDocumentElement();
		Element chartInfo      = (Element)root.getElementsByTagName("ChartInfo").item(0);
		String hasPieLabel     = chartInfo.getElementsByTagName("hasPieLabel").item(0).getFirstChild().getNodeValue();
		
		// ~Otp̃xu\vɐݒ
		String falseString = Boolean.FALSE.toString();
		if ("0".equals(hasPieLabel)) {

			PiePlot piePlot = this.getPiePlot();								
			piePlot.setLabelGenerator(null);

		} else {
			// ~Ot̃ftHgxݒ́u\vł邽߁AȂĂ悢
		}
		
	}


	/**
	 *  _E܂Eʃ`[gpc[`bvݒ胁\bh
	 *  @param doc XML(JFreeChartpXMLhLg)
	 *  @param renderer _[IuWFNg
	 */	
	public void setToolTip(Document doc, CategoryItemRenderer renderer) {

		Element root           = doc.getDocumentElement();
		Element chartInfo      = (Element)root.getElementsByTagName("ChartInfo").item(0);
		String hasToolTip      = chartInfo.getElementsByTagName("hasToolTip").item(0).getFirstChild().getNodeValue();

		// c[`bvL
		if ("1".equals(hasToolTip)){
			renderer.setToolTipGenerator(new StandardCategoryToolTipGenerator());
		}

		// c[`bv
		else {
			// Ȃic[`bv\Ȃj
		}

	}

	/**
	 *  ~`[gpc[`bvݒ胁\bh
	 */	
	public void setToolTipForPie(Document doc) {

		Element root           = doc.getDocumentElement();
		Element chartInfo      = (Element)root.getElementsByTagName("ChartInfo").item(0);
		String hasToolTip      = chartInfo.getElementsByTagName("hasToolTip").item(0).getFirstChild().getNodeValue();

		// c[`bvL
		if ("1".equals(hasToolTip)){
			PiePlot piePlot = this.getPiePlot();
			piePlot.setToolTipGenerator(new StandardPieItemLabelGenerator());
		}

		// c[`bv
		else {
			// Ȃic[`bv\Ȃj
		}

	}


	/**
	 *  ~`[gpc[`bvݒ胁\bh
	 */	
	public void setPieFont(Document doc) throws IllegalAccessException, NoSuchFieldException {

		//xtHg̐ݒ
		PiePlot piePlot = this.getPiePlot();
		piePlot.setLabelFont(this.getFont(doc));

		//Tu`[g̃^CgtHg̐ݒ
		if(this.getPlot() instanceof MultiplePiePlot) {	// ~`[g̏ꍇ
			JFreeChart subChart = this.getSubPieChart();
			TextTitle subChartTitle = subChart.getTitle();
			subChartTitle.setFont(this.getFont(doc)); //Tu`[g̃^CgtHg(W[)
		}

	}
	
	/**
	 *  vbgGAwiFݒi~`[gpj
	 */	
	public void setMultiPiePlotBGColor(Document doc) {
		
		if (this.getPlot() instanceof MultiplePiePlot) {
			PiePlot piePlot = (PiePlot)this.getPiePlot();

			//vbgGAwiFݒ
			Element root         = doc.getDocumentElement();
			Element chartInfo    = (Element)root.getElementsByTagName("ChartInfo").item(0);
			String plotBGColor   = chartInfo.getElementsByTagName("MultiPiePlotBGColor").item(0).getFirstChild().getNodeValue();
		
			piePlot.setBackgroundPaint(createColor(plotBGColor)); 

		}
		
	}


	/**
	 *  _[擾\bh(_E܂Eʃ`[gp)
	 *  @param mode _[VKŐ邩Avbg擾邩
	 * 				 lFucreatev _[VK
	 * 				 lFubyPlotv _[vbg擾
	 */	
	public CategoryItemRenderer createRenderer(String mode) {
		if ( (!"create".equals(mode)) && (!"byPlot".equals(mode)) ) {
			throw new IllegalArgumentException();
		}

		CategoryPlot categoryPlot = (CategoryPlot)this.getPlot();
		CategoryItemRenderer renderer = null;

		//_`[g(SeriesɊւȂ)
		if(this.chartType.equals("VerticalBar") || this.chartType.equals("HorizontalBar") ||
			this.chartType.equals("VerticalMultiBar") || this.chartType.equals("HorizontalMultiBar")) {

			if ("create".equals(mode)) {
				renderer = new BarRenderer();
			} else if ("byPlot".equals(mode)) {
				renderer = (BarRenderer)categoryPlot.getRenderer();
			}
		}

		//3D_`[g(SeriesɊւȂ)
		else if (this.chartType.equals("Vertical3D_Bar") || this.chartType.equals("Horizontal3D_Bar") ||
				  this.chartType.equals("VerticalMulti3D_Bar") || this.chartType.equals("HorizontalMulti3D_Bar")) {

			if ("create".equals(mode)) {
				renderer = new BarRenderer3D();
			}  else if ("byPlot".equals(mode)) {
				renderer = (BarRenderer3D)categoryPlot.getRenderer();
			}
				
		}

		//ςݏグ_`[g(SeriesɊւȂ)
		else if(this.chartType.equals("VerticalStackedBar") || this.chartType.equals("HorizontalStackedBar")) {

			if ("create".equals(mode)) {
				renderer = new StackedBarRenderer();
			} else if ("byPlot".equals(mode)) {
				renderer = (StackedBarRenderer)categoryPlot.getRenderer();
			}
		}

		//3Dςݏグ_`[g(SeriesɊւȂ)
		else if(this.chartType.equals("VerticalStacked3D_Bar") || this.chartType.equals("HorizontalStacked3D_Bar")) {

			if ("create".equals(mode)) {
				renderer = new StackedBarRenderer3D();
			} else if ("byPlot".equals(mode)) {
				renderer = (StackedBarRenderer3D)categoryPlot.getRenderer();
			}
		}

		//܂`[g(SeriesɊւȂ)
		else if((this.chartType.equals("Line")) || (this.chartType.equals("MultiLine"))) {

			//ړ_\邽߂̃_[
			LineAndShapeRenderer tempRenderer = null;
			if ("create".equals(mode)) {
				tempRenderer = new LineAndShapeRenderer();
			} else if ("byPlot".equals(mode)) {
				tempRenderer = (LineAndShapeRenderer)categoryPlot.getRenderer();
			}

			//܂CategoryƂ̌_ɈiہAOpAlpȂǁj\悤ɐݒ
			tempRenderer.setDrawShapes(true); 
		
			renderer = tempRenderer;

		}

		//ʃ`[g(SeriesɊւȂ)
		else if((this.chartType.equals("Area")) || (this.chartType.equals("MultiArea"))) {

			if ("create".equals(mode)) {
				renderer = new AreaRenderer();
			} else if ("byPlot".equals(mode)) {
				renderer = (AreaRenderer)categoryPlot.getRenderer();
			}
		}

		//ςݏグʃ`[g(SeriesɊւȂ)
		else if(this.chartType.equals("StackedArea")) {

			if ("create".equals(mode)) {
				renderer = new StackedAreaRenderer();
			} else if ("byPlot".equals(mode)) {
				renderer = (StackedAreaRenderer)categoryPlot.getRenderer();
			}
		}

		return renderer;

	}



	/**
	 *  F\Ajava.awt.ColorIuWFNg擾
	 */
	public Color createColor(String selectedColor) {

		Color color = null;

		if(("Black").equals(selectedColor)) {

			color = Color.black;

		}
		else if(("Blue").equals(selectedColor)) {

			color = Color.blue;

		}
		else if(("Cyan").equals(selectedColor)) {

			color = Color.cyan;

		}
		else if(("DarkGray").equals(selectedColor)) {

			color = Color.darkGray;

		}
		else if(("Gray").equals(selectedColor)) {

			color = Color.gray;

		}
		else if(("Green").equals(selectedColor)) {

			color = Color.green;

		}
		else if(("LightGray").equals(selectedColor)) {

			color = Color.lightGray;

		}
		else if(("Orange").equals(selectedColor)) {

			color = Color.orange;

		}
		else if(("Pink").equals(selectedColor)) {

			color = Color.pink;

		}
		else if(("Red").equals(selectedColor)) {

			color = Color.red;

		}
		else if(("Yellow").equals(selectedColor)) {

			color = Color.yellow;

		}
		else if(("White").equals(selectedColor)){

			color = Color.white;

		}
		
		// RGBF̏ꍇ
		else {

			StringTokenizer st = new StringTokenizer(selectedColor,",");
			if (st.countTokens() != 3) {
				throw new IllegalArgumentException();
			}

			int rgb[] = new int[3];	// RGB킷l̔z
			int i = 0;

			while ( st.hasMoreTokens() ) {
				rgb[i] = Integer.parseInt(st.nextToken());
				i++;	
			}

			color = new Color(rgb[0],rgb[1],rgb[2]);
		}

		return color;

	}


	// ********** private\bh **********

	/**
	 *  ^ꂽXMLhLgŎw肳ꂽtHg킷 java.awt.Font IuWFNg擾
	 */
	private Font getFont( Document doc ) throws IllegalAccessException, NoSuchFieldException {

		Font font = null;

		Element root         = doc.getDocumentElement();
		Element chartInfo    = (Element)root.getElementsByTagName("ChartInfo").item(0);

		//tHgIuWFNg𐶐
		
		//  tHg
		String fontName = chartInfo.getElementsByTagName("FontName").item(0).getFirstChild().getNodeValue();

		//  tHgTCY
		int fontSize = Integer.parseInt(chartInfo.getElementsByTagName("FontSize").item(0).getFirstChild().getNodeValue());

		//  tHgX^C
		//  XMLŗ^ꂽtHgX^CiFuBOLDvAuITALICvAuBOLD,ITALICv etcj
		String fontStyleNames = chartInfo.getElementsByTagName("FontStyle").item(0).getFirstChild().getNodeValue();

		int fontStyle = 0; // (l OR ulv) = ulvƂȂ鏉ĺAu0v  PQ
		try {

			//̃tHgX^CXMLŎw肳ꂽꍇArbgZi_ajɂAX^Cl(int)߂
			StringTokenizer st = new StringTokenizer(fontStyleNames,",");

			//Staticϐ擾邽߂ɍ쐬FontIuWFNg
			Font dummyFont = new Font(fontName, Font.PLAIN, fontSize);
			while ( st.hasMoreTokens() ) {

				//tNVɂAFontNXstatictB[h̒l߁A_a߂ P
				fontStyle =	fontStyle | Font.class.getField(st.nextToken()).getInt(dummyFont);
			}

			//tHgIuWFNg
			font = new Font(fontName, fontStyle, fontSize);

		} catch (IllegalArgumentException e) {
			throw e;
		} catch (SecurityException e) {
			throw e;
		} catch (IllegalAccessException e) {
			throw e;
		} catch (NoSuchFieldException e) {
			throw e;
		}

		return font;
	
	}



	/**
	 *  ^ꂽXMLhLgA"Dataset"IuWFNg̔z(ArrayList)擾
	 */
	private ArrayList<Dataset> getDatasetList( Document doc ) {

		ArrayList<Dataset> dataSetList = new ArrayList<Dataset>();

		Element root         = doc.getDocumentElement();
		Element chartInfo    = (Element)root.getElementsByTagName("ChartInfo").item(0);

		NodeList dataSetNodeList = root.getElementsByTagName("DataSet");


		Dataset dataset = null;
		// XML"DataSetList"vfɂ"DataSet"vf̐܂
		for (int i = 0; i < dataSetNodeList.getLength(); i++){
			Element firstDataSet = (Element)dataSetNodeList.item(i);
			NodeList dataList    = firstDataSet.getElementsByTagName("Data");

			// f[^Zbg̏i~`[gARc~`[gj
			if( (this.chartType.equals("Pie")) || (this.chartType.equals("Pie_3D"))) {

				dataset = new DefaultPieDataset();
	
			// f[^Zbg̏iȊÕ`[g(A_AʁAѕSeries~`[g)j
			} else {

				// ~`[g̏ꍇ́AXMLɂ镡"DataSet"vf"Data"vfAJava "Dataset"IuWFNg
				// i[邽߁Adataset̐VK쐬sȂȂ
				// A_Aʃ`[g̏ꍇ́AXML"DataSet" Java "Dataset"IuWFNg
				if  ( (!this.chartType.equals("MultiPie")) || ( i == 0)) {
					dataset = new DefaultCategoryDataset();
				}
			}
	
			// XML"DataSet"vf(Ofor[vőIĂ)ɂ"Data"vf̐܂
			for ( int j = 0; j < dataList.getLength(); j++ ) {
	
				Element data = (Element)dataList.item(j);
	
				Number value = new Double(data.getElementsByTagName("Value").item(0).getFirstChild().getNodeValue());
	
				String categoryAxisName = categoryAxisName = data.getElementsByTagName("CategoryAxisName").item(0).getFirstChild().getNodeValue();
				String seriesAxisName   =   null;
	
				// ~`[gARc~`[g
				if( (this.chartType.equals("Pie")) || (this.chartType.equals("Pie_3D"))) {
					((DefaultPieDataset)dataset).setValue(categoryAxisName, value);
	
				// ȊÕ`[g(A_Aʃ`[g(SeriesɊւȂ)сASeries~`[g)
				} else {
					if ( data.getElementsByTagName("ValueAxisName").item(0).getFirstChild() != null ) {
						seriesAxisName = data.getElementsByTagName("ValueAxisName").item(0).getFirstChild().getNodeValue();
					}
					((DefaultCategoryDataset)dataset).addValue(value, seriesAxisName, categoryAxisName);
				}
			}
		
			// ~`[g̏ꍇ́AXMLɂ镡"DataSet"vf"Data"vfAJava "Dataset"IuWFNg
			// i[邽߁AdatasetdataSetListւ̓o^͑Sf[^f[^Zbgɓo^̈x̂ݍsȂB
			if  ( (!this.chartType.equals("MultiPie")) || ( i == (dataSetNodeList.getLength()-1))) {
				dataSetList.add(dataset);
			}
		
		}
		
		return dataSetList;
		
	}

	/**
	 *  JFreeChartIuWFNg쐬
	 */
	private JFreeChart createChartObject( Document doc ) {

		Element root            = doc.getDocumentElement();
		Element chartInfo       = (Element)root.getElementsByTagName("ChartInfo").item(0);
		String chartTitle       = chartInfo.getElementsByTagName("Title").item(0).getFirstChild().getNodeValue();
		this.chartType        = chartInfo.getElementsByTagName("Type").item(0).getFirstChild().getNodeValue();
		String categoryLabel    = ((Element)chartInfo.getElementsByTagName("Category").item(0)).getElementsByTagName("Label").item(0).getFirstChild().getNodeValue();
		
		Element firstSeries     = (Element)((Element)chartInfo.getElementsByTagName("SeriesList").item(0)).getElementsByTagName("Series").item(0);
		String firstSeriesLabel = firstSeries.getElementsByTagName("Label").item(0).getFirstChild().getNodeValue();
		
		// f[^Zbg̃Xg擾
		this.dataSetList = this.getDatasetList(doc);
		
		
		//_`[g(SeriesɊւȂ)
		if(this.chartType.equals("VerticalBar") || this.chartType.equals("HorizontalBar") ||
			this.chartType.equals("VerticalMultiBar") || this.chartType.equals("HorizontalMultiBar")) {

			chart = ChartFactory.createBarChart(
												chartTitle,
												categoryLabel,
												firstSeriesLabel,
												(CategoryDataset)this.dataSetList.get(0),
												getLayoutFromDoc(doc),
												false,
												false,
												false
												);


		}

		//3D_`[g(SeriesɊւȂ)
		else if (this.chartType.equals("Vertical3D_Bar") || this.chartType.equals("Horizontal3D_Bar") ||
				  this.chartType.equals("VerticalMulti3D_Bar") || this.chartType.equals("HorizontalMulti3D_Bar")) {
				
			chart = ChartFactory.createBarChart3D(
													chartTitle,
													categoryLabel,
													firstSeriesLabel,
													(CategoryDataset)this.dataSetList.get(0),
													getLayoutFromDoc(doc),
													false,
													false,
													false
												 );
		}

		//ςݏグ_`[g
		else if((this.chartType.equals("VerticalStackedBar")) || (this.chartType.equals("HorizontalStackedBar"))) {

				chart = ChartFactory.createStackedBarChart(
														chartTitle,
														categoryLabel,
														firstSeriesLabel,
														(CategoryDataset)this.dataSetList.get(0),
														getLayoutFromDoc(doc),
														false,
														false,
														false
													);

		}

		//3Dςݏグ_`[g
		else if((this.chartType.equals("VerticalStacked3D_Bar")) || (this.chartType.equals("HorizontalStacked3D_Bar"))) {

				chart = ChartFactory.createStackedBarChart3D(
														chartTitle,
														categoryLabel,
														firstSeriesLabel,
														(CategoryDataset)this.dataSetList.get(0),
														getLayoutFromDoc(doc),
														false,
														false,
														false
													);

		}

		//܂`[g(SeriesɊւȂ)
		else if((this.chartType.equals("Line")) || (this.chartType.equals("MultiLine"))) {

				chart = ChartFactory.createLineChart(
														chartTitle,
														categoryLabel,
														firstSeriesLabel,
														(CategoryDataset)this.dataSetList.get(0),
														PlotOrientation.VERTICAL,
														false,
														false,
														false
													);

		}


		//ʃ`[g(SeriesɊւȂ)
		else if((this.chartType.equals("Area")) || (this.chartType.equals("MultiArea"))) {

				chart = ChartFactory.createAreaChart(
														chartTitle,
														categoryLabel,
														firstSeriesLabel,
														(CategoryDataset)this.dataSetList.get(0),
														PlotOrientation.VERTICAL,
														false,
														false,
														false
													);

		}
		
		//ςݏグʃ`[g
		else if(this.chartType.equals("StackedArea")) {

				chart = ChartFactory.createStackedAreaChart(
														chartTitle,
														categoryLabel,
														firstSeriesLabel,
														(CategoryDataset)this.dataSetList.get(0),
														PlotOrientation.VERTICAL,
														false,
														false,
														false
													);

		}

		//~`[g(SeriesɊւȂ)
		else if(this.chartType.equals("Pie")) {

			chart = ChartFactory.createPieChart(
													chartTitle,
													(PieDataset)this.dataSetList.get(0),
													false,
													false,
													false 
												);


		}

 
		//3D~`[g(SeriesɊւȂ)
		else if(this.chartType.equals("Pie_3D")) {
  
			chart = ChartFactory.createPieChart3D(
													chartTitle,
													(PieDataset)this.dataSetList.get(0),
													false,
													false,
													false 
												 );


		}


		//~`[g(SeriesQȏ)
		else if(this.chartType.equals("MultiPie")) {

				//~`[g
				chart = ChartFactory.createMultiplePieChart(
																chartTitle,
																(CategoryDataset)this.dataSetList.get(0),
																TableOrder.BY_ROW,
																false,
																false,
																false
															);

		}

		return chart;

	}


	/**
	 *  ~`[gp̃vbg擾
	 */	
	private PiePlot getPiePlot() {

		PiePlot piePlot = null;

		// ~`[g̏ꍇ
		if(this.getPlot() instanceof MultiplePiePlot) {
				
			//Tu`[g̐
			JFreeChart subChart = this.getSubPieChart();
			piePlot = (PiePlot)subChart.getPlot();
		
		// ~`[g̏ꍇ	
		} else {
			piePlot = (PiePlot)this.getPlot();
		}
		
		return piePlot;
	}


	/**
	 *  ~`[gp̃Tu`[g擾
	 */	
	private JFreeChart getSubPieChart(){
		
		MultiplePiePlot multiplePiePlot = (MultiplePiePlot)this.getPlot();
				
		//Tu`[g̐
		JFreeChart subChart = multiplePiePlot.getPieChart();
		
		return subChart;
		
	}



	/**
	 *  XML`[g̕擾
	 */
	private int getChartWidthByDoc( Document doc ) {

		Element root   = doc.getDocumentElement();
		int chartWidth = Integer.parseInt(root.getElementsByTagName("ChartWidth").item(0).getFirstChild().getNodeValue());

		return chartWidth;
	}

	/**
	 *  XML`[g̍擾
	 */
	private int getChartHeightByDoc( Document doc ) {

		Element root   = doc.getDocumentElement();
		int chartHeight = Integer.parseInt(root.getElementsByTagName("ChartHeight").item(0).getFirstChild().getNodeValue());
		
		return chartHeight;
	}

	/**
	 *  XML`[gCAEg擾
	 */
	private PlotOrientation getLayoutFromDoc( Document doc ) {
		
		// `[gCAEgc^
		if ((this.chartType.equals("VerticalBar")) || 
		     (this.chartType.equals("Vertical3D_Bar")) || 
		     (this.chartType.equals("VerticalMultiBar")) || 
		     (this.chartType.equals("VerticalMulti3D_Bar")) ||
		     (this.chartType.equals("VerticalStackedBar")) ||
		     (this.chartType.equals("VerticalStacked3D_Bar"))) 
		{
			return PlotOrientation.VERTICAL;
					
		// `[gCAEg^
		} else if((this.chartType.equals("HorizontalBar")) || 
		           (this.chartType.equals("Horizontal3D_Bar")) ||
		           (this.chartType.equals("HorizontalMultiBar")) || 
		           (this.chartType.equals("HorizontalMulti3D_Bar")) ||
				   (this.chartType.equals("HorizontalStackedBar")) ||
				   (this.chartType.equals("HorizontalStacked3D_Bar"))) 
		           
		{
			return PlotOrientation.HORIZONTAL;

		// ȊȌꍇFG[
		} else {
			throw new IllegalStateException();
		}
		
	}


	// ********** Setter \bh **********
	
	/**
	 *  vbgݒ肷
	 */
	private void setPlot(JFreeChart chart) {

		// ~`[gARc~`[g
		if((this.chartType.equals("Pie")) || (this.chartType.equals("Pie_3D"))){
			this.plot = (PiePlot)chart.getPlot();

		// ~`[gARc~`[g
		} else if (this.chartType.equals("MultiPie")) {
			this.plot = (MultiplePiePlot)chart.getPlot();

		// ̑`[gʃvbg
		} else {
			this.plot = chart.getCategoryPlot();
		}

	}
	
	
	/**
	 *  `[g̕ݒ肷
	 */
	private void setChartWidth(int chartWidth) {
		this.chartWidth = chartWidth;
	}

	/**
	 *  `[g̍ݒ肷
	 */	
	private void setChartHeight(int chartHeight) {
		this.chartHeight = chartHeight;
	}
	
	// ********** Getter \bh **********

	/**
	 *  `[gIuWFNg擾
	 */
	public JFreeChart getChart() {
		return this.chart;
	}	

	/**
	 *  `[g̃vbgIuWFNg擾
	 */
	public Plot getPlot() {
		return this.plot;
	}	

	/**
	 *  `[g^Cv擾
	 */
	public String getChartType() {
		return this.chartType;
	}	
	
	/**
	 *  f[^ZbgXg擾
	 */
	public ArrayList<Dataset> getDataSetList() {
		return this.dataSetList;
	}	

	

	/**
	 *  `[g̕擾
	 */
	public int getChartWidth() {
		return this.chartWidth;
	}

	/**
	 *  `[g̍擾
	 */	
	public int getChartHeight() {
		return this.chartHeight;
	}

}
