/*  OpenOlap viewer
 *  pbP[WFopenolap.viewer.dao
 *  t@CFPostgresUserDAO.java
 *  F[U[̉iǗNXłB
 *
 *  쐬: 2004/01/30
 */
package openolap.viewer.dao;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

import org.apache.log4j.Logger;

import openolap.viewer.User;

/**
 *  NXFPostgresUserDAO<br>
 *  F[U[̉iǗNXłB
 */
public class PostgresUserDAO implements UserDAO {

	// ********** CX^Xϐ **********

	/** ConnectionIuWFNg */
	Connection conn = null;

	/** MOIuWFNg */
	private Logger log = Logger.getLogger(PostgresUserDAO.class.getName());

	// ********** RXgN^ **********

	/**
	 *  [U[̉iǗIuWFNg𐶐܂B
	 */
	public PostgresUserDAO (Connection conn) {
		this.conn = conn;
	}


	// ********** \bh **********
	
	/**
	 * ^ꂽ[U[ApX[hƂɃ[U[IuWFNg߂B<br>
	 * o^ĂȂꍇ̓OCsƂ݂ȂAnull߂B
	 * @param userName [U[
	 * @param password pX[h
	 * @return [U[IuWFNg
	 * @exception SQLException ɗO
	 */
	public User getUser(String userName, String password) throws SQLException {

		User user = null;

		String SQL = "";
		SQL += "select ";
		SQL += "    u.user_id,";					// id
		SQL += "    u.name,";						// [U
		SQL += "    u.adminflg, ";					// Ǘ҃tO
		SQL += "    u.export_file_type, ";			// GNX|[g^Cv
		SQL += "    s.name as color_style_name, ";	// J[X^C
		SQL += "    s.spreadstyle_file, ";			// J[X^CispreadStylẽt@Cj
		SQL += "    s.cellcolortable_file ";		// J[X^CicellColorTablẽt@Cj
		SQL += "from ";
		SQL += "    oo_v_user u, oo_v_color_style s ";
		SQL += "where ";
		SQL += "    u.color_style_id = s.id and ";
		SQL += "    u.name='" + userName + "' and ";
		SQL += "    u.password='" + password + "'";

		Statement stmt = null;
		ResultSet rs = null;

		try {
			stmt = conn.createStatement();
			if(log.isInfoEnabled()) {
				log.info("SQL(select user(by name, passwd))F\n" + SQL);
			}
			rs = stmt.executeQuery(SQL);

			while ( rs.next() ) {
				user = new User(rs.getString("user_id"),
								 rs.getString("name"),
								 rs.getString("adminflg"),
								 rs.getString("export_file_type"),
								 rs.getString("color_style_name"),
								 rs.getString("spreadstyle_file"),
								 rs.getString("cellcolortable_file")
								 );
			}
		

		} catch (SQLException e) {
			throw e;
		} finally {
			try {
				if (rs != null){
					rs.close();
				}
			} catch (SQLException e) {
				throw e;
			} finally {
				try {
					if (stmt != null){
						stmt.close();
					}
				} catch (SQLException e) {
					throw e;
				}
			}
		}
		
		return user;
	}

}
