/*  OpenOlap viewer
 *  pbP[WFopenolap.viewer.dao
 *  t@CFReportDAO.java
 *  F|[gIuWFNg̉iǗC^[tF[XłB
 *
 *  쐬: 2004/01/07
 */
package openolap.viewer.dao;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;

import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.xpath.XPathExpressionException;
import org.xml.sax.SAXException;

import openolap.viewer.Report;
import openolap.viewer.common.CommonSettings;
import openolap.viewer.controller.RequestHelper;

/**
 *  C^[tF[XFReportDAO<br>
 *  F|[gIuWFNg̉iǗC^[tF[XłB
 */
public interface ReportDAO {

	/**
	 * gp̃|[gID擾߂B
	 * @param conn ConnectionIuWFNg
	 * @return gp̃|[gID
	 * @exception SQLException ɗO
	 */
	public String getInitialReportID(Connection conn) throws SQLException;

	/**
	 * NCAg瑗MꂽftHgo[A̔zuf̃|[gIuWFNgɔfB
	 *   p[^j
	 *     defaultMembersFS̃ftHgo[
	 *     colItemsFGbWɔzuꂽID
	 *     rowItemsFsGbWɔzuꂽID
	 *     pageItemsFy[WGbWɔzuꂽID
	 * @param helper RequestHelperIuWFNg
	 * @param commonSettings AvP[V̋ʐݒIuWFNg
	 */
	public void registAxisPosition(RequestHelper helper, CommonSettings commonSettings);

	/**
	 * |[g̎̃GbWzuXVB
	 * @param colItemList ɔzuꂽIDXg
	 * @param rowItemList sɔzuꂽIDXg
	 * @param pageItemList y[WɔzuꂽIDXg
	 * @param report |[g킷IuWFNg
	 * @param commonSettings AvP[V̋ʐݒIuWFNg
	 */
	public void registAxisPosition(ArrayList<String> colItemList, ArrayList<String> rowItemList, ArrayList<String>  pageItemList, Report report);

	/**
	 * |[gf[^\[X֕ۑB
	 * @param report |[g킷IuWFNg
	 * @param conn ConnectionIuWFNg
	 * @exception SQLException ɗO
	 */
	public void saveReport(Report report, Connection conn) throws SQLException;


	/**
	 * |[gf[^\[X֕ۑB
	 * @param report |[g킷IuWFNg
	 * @param newReportName VK|[g
	 * @param userID [UID
	 * @param conn ConnectionIuWFNg
	 * @exception SQLException ɗO
	 */
	public void saveNewPersonalReport(Report report, String newReportName, String userID, Connection conn)  throws SQLException;


	/**
	 * L[uV[PXԍƂɁA|[gIuWFNg𐶐B
	 * @param cubeSeq L[uV[PXԍ
	 * @param userID |[g̏L[UID 
	 * @param commonSettings AvP[V̋ʐݒIuWFNg
	 * @return |[gIuWFNg
	 * @exception SQLException ɗO
	 */
	public Report getInitialReport(String cubeSeq, String userID, CommonSettings commonSettings) throws SQLException;

	/**
	 * |[gIDƂɊ̃|[gIuWFNg߂B
	 * @param reportId |[gID
	 * @param helper RequestHelperIuWFNg
	 * @param commonSettings AvP[V̋ʐݒIuWFNg
	 * @return |[gIuWFNg
	 * @exception SQLException ɗO
	 */
	public Report getExistingReport(String reportId, RequestHelper helper, CommonSettings commonSettings) throws SQLException;

	/**
	 * NCAg瑗Mꂽ|[ǵ̖AetH_f̃|[gIuWFNgɔfB
	 *   p[^j
	 *     reportNameF|[g
	 *     folderIDF|[gi[tH_ID
	 * @param helper RequestHelperIuWFNg
	 * @param commonSettings AvP[V̋ʐݒIuWFNg
	 */
	public void registReport(RequestHelper helper, CommonSettings commonSettings);

	/**
	 * f[^x[XAR|[g^łev[gXMLASQL擾B
	 * 
	 * @param sourceTable: ev[gXML,SQL ̎擾e[u 
	 * @param reportID: sourceTable ̍iݏi|[gIDj
	 * @return Li[HashMapIuWFNg
	 * 				templateXMLString: ev[gXML
	 * 				getDataSQL: SQL
	 * @exception SQLException ɗO
	 */
	public HashMap<String, String> getTemplateInfo(String sourceTable, String reportID) throws SQLException;

	/**
	 * f[^x[XAhX[ƂȂ郌|[g̏iIDƖ̂i[HashMapj擾B
	 * @param reportID: sourceTable ̍iݏi|[gIDj
	 * @return hX[ƂȂ郌|[gi[HashMap
	 * @exception SQLException ɗO
	 * @exception ParserConfigurationException ɗO
	 * @exception SAXException ɗO
	 * @exception IOException ɗO
	 * @exception TransformerException ɗO
	 */
	public HashMap<String, String> getDrillThrowInfo(String reportID) throws SQLException, ParserConfigurationException, SAXException, IOException, TransformerException, XPathExpressionException;



}
