/*  OpenOlap viewer
 *  pbP[WFopenolap.viewer.manager
 *  t@CFCellDataManager.java
 *  Ff[^e[ũZ̒l擾NXłB
 *
 *  쐬: 2004/02/02
 */
package openolap.viewer.manager;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.TreeMap;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

import openolap.viewer.CellData;
import openolap.viewer.EdgeCoordinates;
import openolap.viewer.Report;
import openolap.viewer.common.CommonSettings;
import openolap.viewer.common.Constants;
import openolap.viewer.common.StringUtil;
import openolap.viewer.controller.RequestHelper;
import openolap.viewer.dao.CellDataDAO;
import openolap.viewer.dao.CellDataSQL;
import openolap.viewer.dao.DAOFactory;

/**
 *  NXFCellDataManager<br>
 *  Ff[^e[ũZ̒l擾NXłB
 */
public class CellDataManager {

	// ********** static \bh **********

	/**
	 * Sessionɓo^ꂽZf[^擾ɃZf[^߂B
	 * @param helper RequestHelperIuWFNg
	 * @param conn ConnectionIuWFNg
	 * @param formatValue lɃW[o[ɐݒ肳ꂽMeasureMemberTypȅKpȂtrueAPʂ݂̂낦鏑KpȂfalse
	 * @param SQLType sSQL^Cv\BCellDataDAOQƁB
	 * @return Zf[^IuWFNg̃Xg
	 */
	public static ArrayList<CellData> selectCellDatas(RequestHelper helper, Connection conn, boolean formatValue, String SQLType) throws SQLException {

		HttpServletRequest request = helper.getRequest();
		HttpSession session = request.getSession();
		Report report =  (Report) session.getAttribute("report");

		int i;

//		   ===== wb_Eswb_Ey[WGbW =====
//		   AsAy[WGbW̎ID/W[Xg
//		   (y[WGbẂAID/W[ƑIꂽlyAŊi[B)
		Object[] items = new Object[3];		// 0:GbWA1:sGbWA2:y[WGbW
			String colItemLists;			// GbW
			String rowItemLists;			// sGbW
			String pageItemValuePairs;		// y[WGbW

			String colItems[];				// colItemListsAeڂi[z
			String rowItems[];				// rowItemListsAeڂi[z
			String pageItemValues[];		// pageItemValuePairsAeڂi[z
											//iz̊evf̏@uIDFKEYvj

			colItemLists       = (String) session.getAttribute("colEdgeIDList_hidden");
			rowItemLists       = (String) session.getAttribute("rowEdgeIDList_hidden");
			pageItemValuePairs = (String) session.getAttribute("pageEdgeIDValueList_hidden");
//System.out.println("colItemLists:" + colItemLists);
//System.out.println("rowItemLists:" + rowItemLists);


			ArrayList<String> colAxisList = StringUtil.splitString(colItemLists, ",");
			ArrayList<String> rowAxisList = StringUtil.splitString(rowItemLists, ",");
			ArrayList<String> pageItemValuePairList = StringUtil.splitString(pageItemValuePairs, ",");
			colItems       = (String[]) colAxisList.toArray(new String[colAxisList.size()]);
			rowItems       = (String[]) rowAxisList.toArray(new String[rowAxisList.size()]);
			pageItemValues = (String[]) pageItemValuePairList.toArray(new String[pageItemValuePairList.size()]);

		items[0] = colItems;
		items[1] = rowItems;
		items[2] = pageItemValues;

//		  Esy[WGbWɐݒ肳ꂽ/W[
		int[] hieNums = new int[3];				// 0:GbWA1:sGbWA2:y[WGbW
			hieNums[0] = colItems.length;		// GbW
			hieNums[1] = rowItems.length;		// sGbW
			hieNums[2] = pageItemValues.length;	// y[WGbW

//		   f[^擾ΏۂƂȂEswb_KeyXg
		Object[] selectKeys = new Object[2];	// 0:GbWA1:sGbW
			String selectColKeys[] = new String[hieNums[0]];	// wb_
			String selectRowKeys[] = new String[hieNums[1]];	// swb_
			for ( i = 0; i < hieNums[0]; i++ ) {
				selectColKeys[i] = (String)session.getAttribute("viewCol" + i + "KeyList_hidden");
			}
			for ( i = 0; i < hieNums[1]; i++ ) {
				selectRowKeys[i] = (String)session.getAttribute("viewRow" + i + "KeyList_hidden");
			}

			selectKeys[0] = selectColKeys;
			selectKeys[1] = selectRowKeys;

//		   f[^擾ΏۂƂȂEswb_Index,KeyXg
			ArrayList<EdgeCoordinates> colCoordinatesList = EdgeCoordinates.createCoordinates((String)session.getAttribute("viewColIndexKey_hidden"), colItems);	// EdgeCoordinates ̏Wi[
			ArrayList<EdgeCoordinates> rowCoordinatesList = EdgeCoordinates.createCoordinates((String)session.getAttribute("viewRowIndexKey_hidden"), rowItems);	// EdgeCoordinates ̏Wi[
				// <viewColIndexKey_hidden,viewRowIndexKey_hidden>
				//	<SpreadIndex>:<0Ԗڂ̒i/W[vfkey>;
				//	<1Ԗڂ̒i/W[vfkey>;
				//	<2Ԗڂ̒i/W[vfkey>

		// l擾SQL킷IuWFNg쐬
  		CommonSettings commonSettings = (CommonSettings) helper.getConfig().getServletContext().getAttribute("apCommonSettings");
		CellDataSQL cellDataSQL = CellDataSQL.getSelectReportDataSQL(report, conn, items, selectKeys, formatValue, commonSettings );

		//ZWAli[CellDataIuWFNg̃Xg쐬
		CellDataDAO cellDataDAO = DAOFactory.getDAOFactory().getCellDataDAO(conn);
		ArrayList<CellData> cellDataList = cellDataDAO.selectCellDatas( cellDataSQL,			// Z̒l擾SQL\IuWFNg
															  items,				// ID̃XgiƍsɁj
															  request,				// NGXgIuWFNg
															  report,				// |[gIuWFNg
															  colCoordinatesList,	// NCAg擾p[^ɍ쐬WXg
															  rowCoordinatesList,	// NCAg擾p[^ɍ쐬sWXg
															  SQLType);				// SQL^Cv

		cellDataSQL = null;

		return cellDataList;

	}


	/**
	 * ȉɎZf[^擾p^NGXg擾AZbVɉۑB
	 *   |colEdgeIDList_hidden ɔzuꂽID̃Xg
	 *   |rowEdgeIDList_hidden sɔzuꂽID̃Xg
	 *   |pageEdgeIDValueList_hidden y[WɔzuꂽIDƂ̃ftHgo[L[̃Xg
	 *   |viewCol<0,1,2>KeyList_hidden l擾̊eĩo[L[̃Xg
	 *   |viewRow<0,1,2>KeyList_hidden l擾s̊eĩo[L[̃Xg
	 *   |viewColIndexKey_hidden l擾SpreadIndexƊeĩo[L[̑gݍ킹̃Xg
	 *   |viewRowIndexKey_hidden l擾sSpreadIndexƊeĩo[L[̑gݍ킹̃Xg
	 * @param helper RequestHelperIuWFNg
	 */
	public static void saveRequestParamsToSession(RequestHelper helper) {
		HttpServletRequest request = helper.getRequest();
		HttpSession session = helper.getRequest().getSession();

		// Sessionɓo^
		session.setAttribute("colEdgeIDList_hidden", request.getParameter("colEdgeIDList_hidden"));
		session.setAttribute("rowEdgeIDList_hidden", request.getParameter("rowEdgeIDList_hidden"));
		session.setAttribute("pageEdgeIDValueList_hidden", request.getParameter("pageEdgeIDValueList_hidden"));

		String colIdList = (String)request.getParameter("colEdgeIDList_hidden");
		String rowIdList = (String)request.getParameter("rowEdgeIDList_hidden");

		int colSize = StringUtil.splitString(colIdList,",").size();
		int rowSize = StringUtil.splitString(rowIdList,",").size();

		int i = 0;
		for ( i = 0; i < colSize; i++ ) {
			session.setAttribute("viewCol" + i + "KeyList_hidden", request.getParameter("viewCol" + i + "KeyList_hidden"));
		}
		for ( i = 0; i < rowSize; i++ ) {
			session.setAttribute("viewRow" + i + "KeyList_hidden", request.getParameter("viewRow" + i + "KeyList_hidden"));
		}

		session.setAttribute("viewColIndexKey_hidden", request.getParameter("viewColIndexKey_hidden"));
		session.setAttribute("viewRowIndexKey_hidden", request.getParameter("viewRowIndexKey_hidden"));
		
	}


	/**
	 * ZbVAZf[^擾p̃^폜B
	 * 폜̂saveRequestParamsToSessionœo^p[^łB
	 * @param helper RequestHelperIuWFNg
	 */

	public static void clearRequestParamForGetDataInfo(RequestHelper helper) {
		HttpServletRequest request = helper.getRequest();
		HttpSession session = helper.getRequest().getSession();

		String colIdList = (String)session.getAttribute("colEdgeIDList_hidden");
		String rowIdList = (String)session.getAttribute("rowEdgeIDList_hidden");
		
		session.removeAttribute("colEdgeIDList_hidden");
		session.removeAttribute("rowEdgeIDList_hidden");
		session.removeAttribute("pageEdgeIDValueList_hidden");

		int colSize = StringUtil.splitString(colIdList,",").size();
		int rowSize = StringUtil.splitString(rowIdList,",").size();

		int i = 0;
		for ( i = 0; i < colSize; i++ ) {
			session.removeAttribute("viewCol" + i + "KeyList_hidden");
		}
		for ( i = 0; i < rowSize; i++ ) {
			session.removeAttribute("viewRow" + i + "KeyList_hidden");
		}
		session.removeAttribute("viewColIndexKey_hidden");
		session.removeAttribute("viewRowIndexKey_hidden");
	}


	/**
	 * Z̒lXgTreeMap̃e[u\i񎟌ljɊi[ȂĖ߂B
	 * sIndex, Index̏Ƀ\[gB
	 * @param report |[g킷IuWFNg
	 * @param cellDataList Zf[^IuWFNg̔z
	 * @return TreeMap̃e[u\
	 */
	public static TreeMap<Integer, TreeMap<Integer, CellData>> getCellDataTable(Report report, ArrayList<CellData> cellDataList) {

//		ArrayList colAxesList = report.getEdgeByType(Constants.Col).getAxisList();
//		ArrayList rowAxesList = report.getEdgeByType(Constants.Row).getAxisList();

		int colAxisMemberComboNum = report.getAxisMeberComboNum(Constants.Col);
		int rowAxisMemberComboNum = report.getAxisMeberComboNum(Constants.Row);

		TreeMap<Integer, TreeMap<Integer, CellData>> dataRowMap = new TreeMap<Integer, TreeMap<Integer, CellData>>();
		
		// sSpreadIndex̏ɕׂĂB
		// sSpreadIndexlvfWɑ΂ASpreadIndexɃ\[g
		// SpreadIndex͕KʔԂɂ͂ȂȂƂɒӁBiedrillꂸɔ\łEs̕j

		Iterator<CellData> it = cellDataList.iterator();
		while (it.hasNext()) {
			CellData cellData = it.next();
			
			if(dataRowMap.containsKey(cellData.getRowCoordinates().getIndex())) { // łɍso^ς݂̏ꍇAsɃZǉ
				TreeMap<Integer, CellData> dataCellMap = dataRowMap.get(cellData.getRowCoordinates().getIndex());
				dataCellMap.put(cellData.getColCoordinates().getIndex(), cellData);
			} else {	// so^̏ꍇAsǉ
				TreeMap<Integer, CellData> dataCellMap = new TreeMap<Integer, CellData>();
				dataCellMap.put(cellData.getColCoordinates().getIndex(), cellData);
				dataRowMap.put(cellData.getRowCoordinates().getIndex(), dataCellMap);
			}
		}

		return dataRowMap;
	}

}
