/*  OpenOlap viewer
 *  pbP[WFopenolap.viewer
 *  t@CFAxis.java
 *  F|[g̃GbWɔzu鎲킷abstractNXłB
 *
 *  쐬: 2003/12/28
 */
package openolap.viewer;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

import openolap.viewer.dao.DAOFactory;
import openolap.viewer.dao.DimensionMemberDAO;


/**
 *  ۃNXFAxis<br>
 *  F|[g̃GbWɔzu鎲킷ۃNXłB
 */
public abstract class Axis implements Serializable {

	// ********** CX^Xϐ **********

	/** ID */
	final private String id;

	/** ̖ */
	final private String name;

	/** ̃Rg */
	final private String comment;

	/** ̎Sx */
	final private ArrayList<AxisLevel> axisLevelList;

	/** ̃ftHgo[Key(uniqueName) */
	protected String defaultMemberKey = null;

	/** ̎W[(true:W[,false:) */
	final private boolean isMeasure;

	/** ̎ZN^ɂ郁o̍i݂sĂ邩H */
	private boolean isUsedSelecter = false;

	/** ̎o[̃Xg */
	protected ArrayList<AxisMember> axisMemberList = new ArrayList<AxisMember>();

	// ********** RXgN^ **********

	/**
	 *  |[g̃GbWɔzu鎲킷IuWFNg𐶐܂B
	 */
	public Axis(String id, String name, String comment, ArrayList<AxisLevel> axisLevelList, String defaultMemberKey, boolean isMeasure, boolean isUsedSelecter) {
		this.id = id;
		this.name = name;
		this.comment = comment;
		this.axisLevelList = axisLevelList;
		this.isMeasure = isMeasure;
		this.isUsedSelecter = isUsedSelecter;
	}



	// ********** \bh **********

	/**
	 *  ̃xXgɃxiAxisLevelIuWFNgjo^B
	 */
	public void addAxisLevelList(AxisLevel axisLevel) {
		this.axisLevelList.add(axisLevel);
	}

	/**
	 *  o[XgɎo[o^B
	 * @param axisMem o[킷AxisMemberIuWFNg
	 */
	public void addAxisMember(AxisMember axisMem) {
		this.axisMemberList.add(axisMem);
	}

	/**
	 *  o[XgɎo[̏Wo^B
	 * @param axisMemberList o[킷AxisMemberIuWFNg̏WiArrayListj
	 */	
	public void addAllAxisMember(ArrayList<AxisMember> axisMemberList) {
		this.axisMemberList.addAll(axisMemberList);
	}

	/**
	 *  o[XgNAB
	 */
	public void clearAxisMember() {
		this.axisMemberList.clear();
	}

	/**
	 *  ̎o[XgAw肳ꂽIDo[߂B
	 * @param id o[ID
	 * @return o[AxisMemberIuWFNgAȂnull
	 */	
	public AxisMember getAxisMemberById(String id) {
		Iterator<AxisMember> it = this.axisMemberList.iterator();
		while (it.hasNext()) {
			AxisMember axisMember = it.next();
			if(axisMember.getId().equals(id)){
				return axisMember;
			}
		}
		return null;
	}

	/**
	 *  ̎o[XgAw肳ꂽuniqueNameo[߂B
	 * @param uName o[uniqueName
	 * @return o[AxisMemberIuWFNgAȂnull
	 */	
	public AxisMember getAxisMemberByUniqueName(String uName) {
		Iterator<AxisMember> it = this.axisMemberList.iterator();

		while (it.hasNext()) {
			AxisMember axisMember = it.next();
			if(axisMember.getUniqueName().equals(uName)){
				return axisMember;
			}
		}
		return null;
	}


	/**
	 * ̃ftHgo[ł鎲o[߂B<br>
	 * ̃ftHgo[łꍇ́A̎o[XĝA擪̎o[߂B<br>
	 * oXgɃftHgoł鎲o܂܂ĂȂꍇ́ADB擾B
	 * @param conn ConnectionIuWFNg
	 * @return o[Aconnnull̏ꍇ܂͎Y郁o[ȂꍇAnull
	 * @exception SQLException DB̎o擾ŗO
	 */
	public AxisMember getDefaultMember(Connection conn) throws SQLException {

		String defaultMemberKey = this.getDefaultMemberKey();		
		if (defaultMemberKey == null) { // ftHgo[

			if (this instanceof Dimension) {
				Dimension dim = (Dimension) this;
				DimensionMemberDAO dimMemDAO = DAOFactory.getDAOFactory().getDimensionMemberDAO(conn);
				DimensionMember firstMember = dimMemDAO.getFirstMember(dim);
				return firstMember;

			} else {
				Measure measure = (Measure) this;
				MeasureMember firstMember = (MeasureMember) measure.getAxisMemberList().get(0);
				return firstMember;
			}

		} else { // ftHgo[肵Ă

			AxisMember axisMember = this.getAxisMemberByUniqueName(defaultMemberKey);
			if ( axisMember == null ) {	// oĂȂꍇ(̏ꍇ̂)ADB猟
				Dimension dim = null;
				if (this instanceof Dimension) {
					dim = (Dimension) this;
				} else {
					throw new IllegalStateException();
				}
				
				if (conn == null) {
					return null; 
				} else {
					DimensionMemberDAO dimMemDAO = DAOFactory.getDAOFactory().getDimensionMemberDAO(conn);
					
					ArrayList<AxisMember> dimMemberList = dimMemDAO.selectDimensionMembers(dim, null,null,null,"'," + defaultMemberKey + ",'");
					if (dimMemberList.size() > 1) {
						throw new IllegalStateException();
					}
					
					return (DimensionMember) dimMemberList.get(0);
				}
			} else {
				return axisMember;
			}
		}
	}

	/**
	 * ̃ftHgo[ł鎲o[̖̂߂B<br>
	 * W[̏ꍇÂ̓W[ƂȂ邪AfBV̏ꍇDimensioñCX^XϐdispMemberNameType<br>
	 * ݒ肳ꂽ́iOl[V[gl[̂ÂꂩjƂȂB 
	 * ̃ftHgo[łꍇ́A̎o[XĝA擪̎o[̖̂߂B<br>
	 * oXgɃftHgoł鎲o܂܂ĂȂꍇ́ADB擾B
	 * @param conn ConnectionIuWFNg
	 * @return o[Aconnnull̏ꍇ܂͎Y郁o[ȂꍇAnull
	 * @exception SQLException DB̎o擾ŗO
	 */
	public String getDefaultMemberName(Connection conn) throws SQLException {

		String defaultMemberKey = this.getDefaultMemberKey();		
		if (defaultMemberKey == null) { // ftHgo[

			if (this instanceof Dimension) {
				Dimension dim = (Dimension) this;
				DimensionMemberDAO dimMemDAO = DAOFactory.getDAOFactory().getDimensionMemberDAO(conn);
				DimensionMember firstMember = dimMemDAO.getFirstMember(dim);
				return firstMember.getSpecifiedDisplayName(dim);

			} else {
				Measure measure = (Measure) this;
				MeasureMember firstMember = (MeasureMember) measure.getAxisMemberList().get(0);
				return firstMember.getMeasureName();
			}

		} else { // ftHgo[肵Ă

			AxisMember axisMember = this.getAxisMemberByUniqueName(defaultMemberKey);
			if ( axisMember == null ) {	// oĂȂꍇ(̏ꍇ̂)ADB猟
				Dimension dim = null;
				if (this instanceof Dimension) {
					dim = (Dimension) this;
				} else {
					throw new IllegalStateException();
				}
				
				if (conn == null) {
					return null; 
				} else {
					DimensionMemberDAO dimMemDAO = DAOFactory.getDAOFactory().getDimensionMemberDAO(conn);
					
					ArrayList<AxisMember> dimMemberList = dimMemDAO.selectDimensionMembers(dim, null,null,null,"'," + defaultMemberKey + ",'");
					if (dimMemberList.size() > 1) {
						throw new IllegalStateException();
					}
					
					return ((DimensionMember) dimMemberList.get(0)).getSpecifiedDisplayName(dim);
				}
			} else {
				return axisMember.getSpecifiedDisplayName(this);
			}
		}
	}

	/**
	 * ftHgo[^ꂽMapIuWFNgɊ܂܂Ȃꍇ́AftHgo[(null)B
	 * @param memberNameDrillMap VɎoƂđIꂽo[̖̂ƃhԂMapIuWFNg
	 */
	public void modifyDefaultMember(HashMap<String, String> memberNameDrillMap) {
		if(!memberNameDrillMap.containsKey(this.getDefaultMemberKey())) {
			this.setDefaultMemberKey(null);
		}
	}


	/**
	 * ̃CX^X̕\߂B
	 * @return StringIuWFNg
	 */
	public String toString() {

		String sep = System.getProperty("line.separator");

		String stringInfo = "";
		stringInfo += "Axis.id:" + this.id + sep;
		stringInfo += "Axis.name:" + this.name + sep;
		stringInfo += "Axis.comment:" + this.comment + sep;
		stringInfo += "Axis.defaultMemberKey:" + this.defaultMemberKey + sep;

		stringInfo += "Axis.isMeasure:" + String.valueOf(this.isMeasure) + sep;
		stringInfo += "Axis.isUsedSelecter:" + String.valueOf(this.isUsedSelecter) + sep;

		//axisLevelList		// ̎Sx 
		//axisMemberList	// ̎o[̃Xg

		return stringInfo;

	}


	// ********** Setter \bh **********

	/**
	 * ftHgo[̃L[ZbgB
	 * @param memberKey o[̃L[(uniqueName)
	 */
	public void setDefaultMemberKey(String memberKey) {
		this.defaultMemberKey = memberKey;
	}
	/**
	 * o[XgZbgB
	 * @param axisMemberList o[̏W
	 */
	public void setAxisMemberList(ArrayList<AxisMember> axisMemberList) {
		this.axisMemberList = axisMemberList;
	}
	/**
	 * ̃ZN^gpăoi荞܂Ă邩ǂZbgB
	 * @param b ̃oZN^ɂi荞܂Ă邩
	 */
	public void setUsedSelecter(boolean b) {
		isUsedSelecter = b;
	}

	// ********** Getter \bh **********

	/**
	 * ID߂B
	 * @return ID
	 */
	public String getId() {
		return id;
	}
	/**
	 * ̂߂B
	 * @return 
	 */
	public String getName() {
		return name;
	}
	/**
	 * ̃Rg߂B
	 * @return Rg
	 */
	public String getComment() {
		return comment;
	}
	/**
	 * ̃x񃊃Xg߂B
	 * @return ̃x񃊃Xg
	 */	
	public ArrayList<AxisLevel> getAxisLevelList() {
		return axisLevelList;
	}
	/**
	 * ̃ftHgo[ł鎲o[Key(uniqueName)߂B
	 * @return o[Key(uniqueName)
	 */
	public String getDefaultMemberKey() {
		return defaultMemberKey;
	}
	/**
	 * W[ǂ߂B
	 * @return W[łꍇtrueAW[ł͂ȂꍇifBVjfalse
	 */
	public boolean isMeasure() {
		return isMeasure;
	}
	/**
	 * ̃ZN^gpăoi荞܂Ă邩ǂ߂B
	 * @return ZN^ɂ胁oi荞܂ĂꍇtrueAi荞܂ĂȂꍇfalse
	 */
	public boolean isUsedSelecter() {
		return isUsedSelecter;
	}
	/**
	 * o[Xg߂B<br>
	 * fBV̏ꍇ́ADBȂǂ狁߂ꂽo[Xg̈ꎞۑpƂĎgpA<br>ɑSĂ̎o[ێ킯ł͂ȂƂɒӂB
	 * @return o[̃Xg
	 */
	public ArrayList<AxisMember> getAxisMemberList() {
		return axisMemberList;
	}

}
