/*  OpenOlap viewer
 *  pbP[WFopenolap.viewer.common
 *  t@CFStringUtil.java
 *  F񑀍샆[eBeB[NXłB
 *
 *  쐬: 2004/01/09
 */
package openolap.viewer.common;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 *  NXFStringUtil<br>
 *  F񑀍샆[eBeB[NXłB
 */
public class StringUtil {

	// ********** static\bh **********

	/**
	 * ^ꂽStringIuWFNgnullł΁A󕶎("")ɕύXB
	 * @param string StringIuWFNg
	 * @return StringIuWFNg
	 */
	public static String changeNullToEmpty(String string) {
		if(string == null){
			return "";
		} else {
			return string;
		}
	}

	/**
	 * ^ꂽStringIuWFNg̑O"<"A">"ł߂B
	 * @param string StringIuWFNg
	 * @return StringIuWFNg
	 */
	public static String addStartTAGMark(String string) {
		return "<" + string + ">";
	}

	/**
	 * ^ꂽStringIuWFNg̑O"</"A">"ł߂B
	 * @param string StringIuWFNg
	 * @return StringIuWFNg
	 */
	public static String addEndTAGMark(String string){
		return "</" + string + ">";
	}

	/**
	 * Ɋ܂܂u*vASāu%vɒuB
	 * @param string StringIuWFNg
	 * @return StringIuWFNg
	 */
	public static String changeKomeToPercent(String string) {
		return string.replace('*', '%');
	}

	/**
	 * K\ɂ蕶̒usAuꂽԂB<br>
	 * }b`ׂ̂͂Ēu
	 * @param preString us̒ŒuΏۂƂȂ镶iK\j
	 * @param afterString prStringu镶
	 * @param string us
	 * @return uꂽ
	 */
	public static String regReplaceAll(String preString, String afterString, String string) {
		Pattern pattern = Pattern.compile(preString);
		Matcher matcher = pattern.matcher(string);
		return matcher.replaceAll(afterString);
	}

	/**
	 * ^ꂽf~^ŕAArrayListԂ
	 *   lFu0;;vf~^u;vŕƁA
	 *          list[0]=0 łsize()=1 ArrayListƂȂ
	 * @param string Ώە
	 * @param delimiter f~^
	 * @return ꂽ̃Xg
	 */
	public static ArrayList<String> splitString(String string, String delimiter) {
		ArrayList<String> list = new ArrayList<String>();
		StringTokenizer st = new StringTokenizer(string,delimiter);
		while ( st.hasMoreTokens() ) {
			list.add(st.nextToken());
		}
		return list;
	}

	/**
	 * ̕i[ArrayListAw肳ꂽf~^ŋ؂ЂƂ̕𐶐
	 * @param stringList ̃Xg
	 * @param delimiter f~^
	 * @return ꂽ
	 */
	public static String joinList(ArrayList<String> stringList, String delimiter) {
		if (stringList == null) {
			throw new IllegalArgumentException();
		}

		String returnString = "";
		Iterator<String> iter = stringList.iterator();
		int i = 0;
		while (iter.hasNext()) {
			if(i>0) {
				returnString += delimiter;
			}
			returnString += iter.next();
			i++;
		}
		return returnString;
	}


	/**
	 * ̕i[ArrayListA^ꂽ܂܂Ȃ擾
	 * @param stringList ̃Xg
	 * @param exceptString O镶
	 * @return ̃Xg
	 */
	public static ArrayList<String> exceptElement(ArrayList<String> stringList, String exceptString) {
		if (stringList == null) {
			throw new IllegalArgumentException();
		}

		ArrayList<String> exceptedList = new ArrayList<String>();
		Iterator<String> iter = stringList.iterator();
		while (iter.hasNext()) {
			String string = iter.next();
			if (string.indexOf(exceptString) == -1) {
				exceptedList.add(string);
			}
		}
		return exceptedList;
	}


	/**
	 * ̐ړ͐ڔɎw肳ꂽ̎w肳ꂽt^
	 * @param str t^O̕
	 * @param position t^ꏊړݔw肷
	 * @param repeatNumber t^鐔w肷
	 * @param repeatString JԂ
	 * @return t^ꂽ񃊃Xg
	 */
	public static String addString(String str, String position, int repeatNumber, String repeatString) {
		if ( (position == null) || (repeatString == null) ) { throw new IllegalArgumentException(); }
		if ( (!position.equals("last")) && (!position.equals("first")) ) { throw new IllegalArgumentException(); }
		if ( repeatNumber<0 ) { throw new IllegalArgumentException(); }

		String addedString = str;
		if (position.equals("last")) {
			for (int i = 0; i < repeatNumber; i++) {
				addedString = addedString + repeatString;
			}
		} else if (position.equals("first")) {
			for (int i = 0; i < repeatNumber; i++) {
				addedString = repeatString + addedString;
			}
		}

		return addedString;
	}

}
