/*  OpenOlap viewer
 *  pbP[WFopenolap.viewer.dao
 *  t@CFPostgresColorDAO.java
 *  FFIuWFNg̉iǗNXłB
 *
 *  쐬: 2004/01/15
 */
package openolap.viewer.dao;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.TreeMap;

import javax.servlet.http.HttpServletRequest;

import org.apache.log4j.Logger;

import openolap.viewer.Color;
import openolap.viewer.Report;
import openolap.viewer.common.CommonSettings;
import openolap.viewer.common.CommonUtils;
import openolap.viewer.common.StringUtil;
import openolap.viewer.controller.RequestHelper;

/**
 *  NXFPostgresColorDAO<br>
 *  FFIuWFNg̉iǗNXłB
 */
public class PostgresColorDAO implements ColorDAO {

	// ********** CX^Xϐ **********

	/** ConnectionIuWFNg */
	Connection conn = null;

	/** MOIuWFNg */
	private Logger log = Logger.getLogger(PostgresColorDAO.class.getName());

	// ********** RXgN^ **********

	/**
	 * FIuWFNg̉iǗIuWFNg𐶐܂B
	 */
	PostgresColorDAO(Connection conn) {
		this.conn = conn;
	}

	// ********** \bh **********

	/**
	 * f[^\[XFݒ߁A|[gIuWFNgɓo^B
	 * @param report |[gIuWFNg
	 * @param conn ConnectionIuWFNg
	 * @exception SQLException ɗO
	 */
	public void applyColor(Report report, Connection conn) throws SQLException {

		ArrayList<Color> colorList = new ArrayList<Color>();

		// SQL
		String SQL = "";
		SQL += "select ";
		SQL += "    edge_id_combo, ";
		SQL += "    edge_mem_key1, ";
		SQL += "    edge_mem_key2, ";
		SQL += "    edge_mem_key3, ";
		SQL += "    edge_mem_key4, ";
		SQL += "    edge_mem_key5, ";
		SQL += "    edge_mem_key6, ";
		SQL += "    headerFLG, ";
		SQL += "    html_color ";
		SQL += "from ";
		SQL += "    oo_v_color ";
		SQL += "where ";
		SQL += "    report_id=" + report.getReportID() + " ";
		SQL += "order by ";
		SQL += "    edge_id_combo";
		
		// SQLs
		Statement stmt = null;
		ResultSet rs = null;
		try {
			stmt = conn.createStatement();
			if(log.isInfoEnabled()) {
				log.info("SQL(select header and data cell color)F\n" + SQL);
			}
			rs = stmt.executeQuery(SQL);

			while ( rs.next() ) {

				// FÂꂽZ̍W\TreeMap쐬
				ArrayList<String> axisIdList = StringUtil.splitString(rs.getString("edge_id_combo"),",");
				TreeMap<Integer, String> axisIDAndMemberKeyMap = new TreeMap<Integer, String>();

				Iterator<String> axisIdIt = axisIdList.iterator();
				int i = 0;
				while (axisIdIt.hasNext()) {
					String axisId = axisIdIt.next();											// ID
					String axisMemberKey = rs.getString("edge_mem_key"+Integer.toString(i+1));	// L̃o[Key
					axisIDAndMemberKeyMap.put(Integer.decode(axisId),axisMemberKey);
					i++;
				}

				// ColorIuWFNg𐶐
				Color color = new Color( axisIDAndMemberKeyMap, 		// axisIDAndMemberKeyMap 
										  CommonUtils.FLGTobool(rs.getString("headerFLG")), // isHeader
										  rs.getString("html_color"));	// HTMLColor

				// 쐬ColorIuWFNgArrayListɒǉ
				colorList.add(color);

			}

		} catch (SQLException e) {
			throw e;
		} finally {
			try {
				if (rs != null){
					rs.close();
				}
			} catch (SQLException e) {
				throw e;
			} finally {
				try {
					if (stmt != null){
						stmt.close();
					}
				} catch (SQLException e) {
					throw e;
				}
			}
		}
		
		// |[gIuWFNgColorIuWFNg̏Wo^
		report.addColor(colorList);

	}

	/**
	 * NCAg瑗ĂFT[o[̃fɔfB<br>
	 * NCAgMF<br>
	 *   EdtColorInfo  F f[^e[u̐F
	 *   EhdrColorInfo F wb_[̐F
	 * @param helper RequestHelperIuWFNg
	 * @param commonSettings AvP[V̋ʐݒ킷IuWFNg
	 */
	public void registColor(RequestHelper helper, CommonSettings commonSettings) {

		// NCAgM擾
		HttpServletRequest request = helper.getRequest();
		String dtColorInfoListString = (String)request.getParameter("dtColorInfo");
		String hdrColorInfoListString = (String)request.getParameter("hdrColorInfo");

	  	Report report = (Report)request.getSession().getAttribute("report");

		// FNA
		report.clearColorList();

		// f[^e[u̐FReportIuWFNgɒǉ
		ArrayList<Color> dtColorInfoList = changeColorList(dtColorInfoListString, false);
		report.addColor(dtColorInfoList);

		// wb_̐FReportIuWFNgɒǉ
		ArrayList<Color> hdrColorInfoList = changeColorList(hdrColorInfoListString, true);
		report.addColor(hdrColorInfoList);

	}


	/**
	 * FiB
	 * @param report |[gIuWFNg
	 * @param reportID |[gID
	 *                ̃p[^NULL̏ꍇAReportIuWFNg|[gIDŐFۑB
	 *                  NULLł͂Ȃꍇ́AreportIDp[^̒lŐFۑB
	 * @param conn ConnectionIuWFNg
	 * @exception SQLException ɗO
	 */
	public void saveColor(Report report, String reportID, Connection conn) throws SQLException {

		// ۑΏۂƂȂ郌|[gID߂
		String reportIDValue = null;
		if (reportID == null) {
			reportIDValue = report.getReportID();
		} else {
			reportIDValue = reportID;
		}

		// ̐Fݒ͑Sč폜Ăinsert
		// delete
		this.deleteColor(reportIDValue, conn);

		Iterator<Color> it = report.getColorList().iterator();
		while (it.hasNext()) {
			Color color = it.next();
			String edgeIdCombo = "";
			String[] edgeMemKey = new String[6];

			TreeMap<Integer, String> axisIDAndMemberKeyTree = color.getAxisIDAndMemberKeyMap();
			Iterator<Integer> keyIt = axisIDAndMemberKeyTree.keySet().iterator();
			int i = 0;
			while (keyIt.hasNext()) {
				if(i>0){
					edgeIdCombo += ",";
				}
				Integer key = keyIt.next();
				edgeIdCombo += key.toString();
				edgeMemKey[i] = axisIDAndMemberKeyTree.get(key);
				i++;
			}

			Statement stmt = conn.createStatement();
			try {
				// insert
				String SQL = "";
				SQL =  "";
				SQL += "INSERT INTO oo_v_color ";
				SQL += "       (report_id, edge_id_combo,";
				for (int j = 0; j < edgeMemKey.length; j++) {
					SQL +=            "edge_mem_key" + (j+1) +",";
				}
				SQL += "       headerflg, html_color) ";
				SQL += "values ( ";
				SQL +=                reportIDValue + ", ";
				SQL +=          "'" + edgeIdCombo + "', ";
				
				for (int j = 0; j < edgeMemKey.length; j++) {
					SQL +=            edgeMemKey[j] + ", ";
				}

				SQL +=          "'" + CommonUtils.boolToFLG(color.isHeader()) + "', ";
				SQL +=          "'" + color.getHtmlColor() + "'"; 
	            SQL +=        ")";

				if(log.isInfoEnabled()) {
					log.info("SQL(insert header and data cell color)F\n" + SQL);
				}
				int insertCount = stmt.executeUpdate(SQL);
				if (insertCount != 1) {
					throw new IllegalStateException();
				}

			} catch (IllegalStateException e) {
				throw e;
			} catch (SQLException e) {
				throw e;
			} finally {
				if (stmt != null) {
					stmt.close();
				}
			} 
		}
	}


	/**
	 * ꂽ|[g̐Ff[^\[X폜B
	 * @param report |[gIuWFNg
	 * @param conn ConnectionIuWFNg
	 * @exception SQLException ɗO
	 */
	public void deleteColor(Report report, Connection conn) throws SQLException {

		deleteColor(report.getReportID(), conn);

	}


	/**
	 * ꂽ|[g̐Ff[^\[X폜B
	 * @param reportID |[gID
	 * @param conn ConnectionIuWFNg
	 * @exception SQLException ɗO
	 */
	public void deleteColor(String reportID, Connection conn) throws SQLException {

		String SQL = "";
		SQL =  "";
		SQL += "delete from oo_v_color ";
		SQL += "where ";
		SQL += "    report_id=" + reportID;

		Statement stmt = conn.createStatement();
		try {
			if(log.isInfoEnabled()) {
				log.info("SQL(delete header and data cell color)F\n" + SQL);
			}
			stmt.executeUpdate(SQL);
		} catch (SQLException e) {
			throw e;
		} finally {
			if (stmt != null) {
				stmt.close();
			}
		} 
	}



	// ********** private\bh **********

	/**
	 * J[񕶎J[IuWFNg̃Xg𐶐B
	 * @param sourceString J[񕶎
	 * @param isHeader sEwb_[̐FłtrueAłȂȂfalse
	 * @return J[IuWFNg̃Xg
	 */

	private ArrayList<Color> changeColorList(String sourceString, boolean isHeader) {

		ArrayList<Color> colorList = new ArrayList<Color>();	// ColorIuWFNg̃Xg
		Color color = null;

		// f[^e[uZ̐Fݒǉ
		ArrayList<String> colorInfoList = StringUtil.splitString(sourceString, ",");	// uID.Key:EEE:ID.Key;colorvXg
		Iterator<String> colorInfoIt = colorInfoList.iterator();


		int i = 0;
		while (colorInfoIt.hasNext()) {
			TreeMap<Integer, String> idKeyList = new TreeMap<Integer, String>();	// ID(Key)ƎoKey(Value)

			String colorInfo = colorInfoIt.next();						// uID.Key:EEE:ID.Key;colorv
			ArrayList<String> comboKeyColorList = StringUtil.splitString(colorInfo,";");	// uID.Key:EEE:ID.Keyv,ucolorvXg

			String comboKeyListString = comboKeyColorList.get(0);	// uID.Key:EEE:ID.Keyv
			String colorString = comboKeyColorList.get(1);			// ucolorv

			ArrayList<String> comboKeyList = StringUtil.splitString(comboKeyListString, ":");	// uID.KeyṽXg
			Iterator<String> comboKeyIte = comboKeyList.iterator();

			while (comboKeyIte.hasNext()) {
				String comboKeyString = comboKeyIte.next();

				ArrayList<String> axisIDAndKey = StringUtil.splitString(comboKeyString, ".");

				idKeyList.put(Integer.decode(axisIDAndKey.get(0)), axisIDAndKey.get(1));	// ID,o[L[

			}

			color = new Color( idKeyList, 			// axisIDAndMemberKeyMap 
							    isHeader, 			// isHeader
							    colorString);		// HTMLColor

			colorList.add(color);
			i++;
		}

		return colorList;

	}

}
