/*  OpenOlap viewer
 *  pbP[WFopenolap.viewer
 *  t@CFDimensionMember.java
 *  F
 *
 *  쐬: 2004/01/10
 */
package openolap.viewer;

import java.io.Serializable;

/**
 *  NXFDimensionMember
 *  F
 */
public class DimensionMember extends AxisMember implements Serializable {

	// ********** CX^Xϐ **********	

	final private String code;				//R[h
	final private String short_name;			//short_name
	final private String long_name;			//long_name
	final private String indentedShortName;	//xɂCfgς݂short_name
	final private String indentedLongName;	//xɂCfgς݂long_name
	final private boolean isLeaf;			//leaf(qȂo)ǂ

	private boolean isDrilled;				//hĂ邩

	// ********** RXgN^ **********

	public DimensionMember(String id, String uniqueName, String code, String short_name, String long_name, String indentedShortName, String indentedLongName, int level, boolean isLeaf) {

		super(id, uniqueName, level);
		this.code = code;
		this.short_name = short_name;
		this.long_name = long_name;
		this.indentedShortName = indentedShortName;
		this.indentedLongName = indentedLongName;
		this.isLeaf = isLeaf;

		if(level == 1){
			this.isDrilled = true;
		} else {
			this.isDrilled = false;
		}
		this.isSelected = true;

	}

	// ********** \bh **********

	public String getSpecifiedDisplayName(Axis axis) {
		if(axis instanceof Dimension){
			if(((Dimension)axis).getDispMemberNameType().equals(Dimension.DISP_SHORT_NAME)){
				return short_name;
			} else if(((Dimension)axis).getDispMemberNameType().equals(Dimension.DISP_LONG_NAME)){
				return long_name;
			} else {
				throw new IllegalStateException();
			}
		} else {	// fBṼo[\郁\bhłAW[ł邱Ƃ͂
			throw new IllegalArgumentException();
		}
	}

	public String getSpecifiedIndentedDisplayName(Axis axis){
		if(axis instanceof Dimension){
			if(((Dimension)axis).getDispMemberNameType().equals(Dimension.DISP_SHORT_NAME)){
				return indentedShortName;
			} else if(((Dimension)axis).getDispMemberNameType().equals(Dimension.DISP_LONG_NAME)){
				return indentedLongName;
			} else {
				throw new IllegalStateException();
			}		
		} else {	// fBṼo[\郁\bhłAW[ł邱Ƃ͂
			throw new IllegalArgumentException();
		}
	}

	public String getNameByDispNameType(String dispNameType){
		if (dispNameType == null) { throw new IllegalArgumentException();}
		if ((!Dimension.DISP_SHORT_NAME.equals(dispNameType)) && (!Dimension.DISP_LONG_NAME.equals(dispNameType)) ) { throw new IllegalArgumentException(); }

		String name = null;
		if (Dimension.DISP_SHORT_NAME.equals(dispNameType)) {
			name = this.getShort_name();
		} else if (Dimension.DISP_LONG_NAME.equals(dispNameType)) {
			name = this.getLong_name();
		}
		
		return name;
	}

	public String getIndentedNameByDispNameType(String dispNameType){
		if (dispNameType == null) { throw new IllegalArgumentException();}
		if ((!Dimension.DISP_SHORT_NAME.equals(dispNameType)) && (!Dimension.DISP_LONG_NAME.equals(dispNameType)) ) { throw new IllegalArgumentException(); }

		String indentedName = null;
		if (Dimension.DISP_SHORT_NAME.equals(dispNameType)) {
			indentedName = this.getIndentedShortName();
		} else if (Dimension.DISP_LONG_NAME.equals(dispNameType)) {
			indentedName = this.getIndentedLongName();
		}
		
		return indentedName;
	}

	// ********** setter **********

	public void setDrilled(boolean b) {
		isDrilled = b;
	}
	public void setSelected(boolean b) {
		isSelected = b;
	}

	// ********** getter **********

	public String getCode() {
		return code;
	}
	public String getShort_name() {
		return short_name;
	}
	public String getLong_name() {
		return long_name;
	}
	public String getIndentedShortName() {
		return indentedShortName;
	}
	public String getIndentedLongName() {
		return indentedLongName;
	}
	public boolean isLeaf() {
		return isLeaf;
	}
	public boolean isDrilled() {
		return isDrilled;
	}







}
