/*  OpenOlap viewer
 *  pbP[WFopenolap.viewer
 *  t@CFEdgeCoordinates.java
 *  F
 *
 *  쐬: 2004/01/19
 */
package openolap.viewer;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;

import openolap.viewer.common.StringUtil;

/**
 *  NXFEdgeCoordinates
 *  F
 */
public class EdgeCoordinates implements Serializable {

	// ********** CX^Xϐ **********

	final private Integer index;					// /sCfbNX(/sňӂɂȂ0start̒ʔ)
	final private LinkedHashMap axisIdMemKeyMap;	// /s̊ei̎IDƒl̃yȀW


	// ********** RXgN^ **********

	public EdgeCoordinates(Integer index,LinkedHashMap axisIdMemKeyMap) {
		this.index = index;
		this.axisIdMemKeyMap = axisIdMemKeyMap;
	}

	// ********** Static \bh **********

	public static ArrayList createCoordinates(String indexKey, String[] axisIdList) {

		ArrayList axisCoordinatesList = new ArrayList();		// WXg
		EdgeCoordinates axisCoordinates = null;				// W

		Iterator axisIt = StringUtil.splitString(indexKey,",").iterator();

//System.out.println("indexKey:" + indexKey);

		while (axisIt.hasNext()) {
			LinkedHashMap axisIdKeyMap = new LinkedHashMap();

			String indexKeysString = (String) axisIt.next();
			ArrayList indexKeysList = StringUtil.splitString(indexKeysString,":");
			Integer axisIndex = Integer.decode((String) indexKeysList.get(0));		// ̃CfbNX
			String colKeys = (String) indexKeysList.get(1);							// ̃L[̑gݍ킹()
			ArrayList axisKeyList = StringUtil.splitString(colKeys,";");			// ̃L[̑gݍ킹(z)

			Iterator keyListIte = axisKeyList.iterator();
			int j = 0;
			while (keyListIte.hasNext()){
				String key = (String) keyListIte.next();
				axisIdKeyMap.put(Integer.decode(axisIdList[j]), key);
				j++;
			}

//System.out.println("axisIndex, axisIdKeyMap:" + axisIndex + "," + axisIdKeyMap);

			axisCoordinatesList.add(new EdgeCoordinates(axisIndex, axisIdKeyMap));
		}

//Iterator it = axisCoordinatesList.iterator();
//System.out.println("size:" + axisCoordinatesList.size());
//while (it.hasNext()) {
//	EdgeCoordinates coordinates = (EdgeCoordinates) it.next();
//	System.out.println("index:" + coordinates.getIndex());
//	
//	Iterator it2 = coordinates.getAxisIdMemKeyMap().keySet().iterator();
//	while (it2.hasNext()) {
//		Integer id = (Integer) it2.next();
//		System.out.println("id,key:" + id + "," + coordinates.getAxisIdMemKeyMap().get(id) + "\n");
//	}
//}

		return axisCoordinatesList;
	}

	// ********** Getter \bh **********

	public Integer getIndex() {
		return index;
	}
	public LinkedHashMap getAxisIdMemKeyMap() {
		return axisIdMemKeyMap;
	}
}
