/*
 * 쐬: 2003/12/29
 *
 */
package openolap.viewer;

import java.io.Serializable;

/**
 */
public class MeasureMember extends AxisMember implements Serializable {

	// ********** CX^Xϐ **********

	protected final String measureSeq;
	protected final String measureName;
	private MeasureMemberType measureMemberType = null; 	// W[o[^Cv

	// ********** RXgN^ **********

	public MeasureMember(String id, String measureName, MeasureMemberType meaMemType, String uniqueName, String measureSeq) {
		super(id, uniqueName, 1);				// W[͊Kwɂ͂ȂȂ߁Ax͏ɁuPv
		this.measureSeq = measureSeq;
		this.measureName = measureName;
		this.measureMemberType = meaMemType;
	}

	// ********** \bh **********

	public String getSpecifiedDisplayName(Axis axis) {
		return measureName;
	}

	public String getSpecifiedIndentedDisplayName(Axis axis){
		return measureName;
	}

	// ********** Setter\bh **********

	public void setMeasureMemberType(MeasureMemberType meaMemType) {
		this.measureMemberType = meaMemType;
	}

	// ********** getter **********

	public String getMeasureSeq() {
		return this.measureSeq;
	}
	public String getMeasureName() {
		return this.measureName;
	}
	public MeasureMemberType getMeasureMemberType() {
		return this.measureMemberType;
	}
	public String getIndentedShortName() {
		return measureName;
	}
	public String getIndentedLongName() {
		return measureName;
	}

}
