/*  OpenOlap viewer
 *  pbP[WFopenolap.viewer.common
 *  t@CFStringUtil.java
 *  F
 *
 *  쐬: 2004/01/09
 */
package openolap.viewer.common;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 *  NXFStringUtil
 *  F
 */
public class StringUtil {

	public static String changeNullToEmpty(String string){
		if(string == null){
			return "";
		} else {
			return string;
		}
	}

	public static String addStartTAGMark(String string){
		return "<" + string + ">";
	}

	public static String addEndTAGMark(String string){
		return "</" + string + ">";
	}


	// Ɋ܂܂u*vASāu%vɒu
	public static String changeKomeToPercent(String string){
		return string.replace('*', '%');
	}

	/**
	 * ̒usAuꂽԂB
	 * }b`ׂ̂͂Ēu
	 */
	public static String regReplaceAll(String preString, String afterString, String string) {
		Pattern pattern = Pattern.compile(preString);
		Matcher matcher = pattern.matcher(string);
		return matcher.replaceAll(afterString);
	}



	// f~^ŕAArrayListԂ
	public static ArrayList splitString(String string, String delimiter) {
		ArrayList list = new ArrayList();
		StringTokenizer st = new StringTokenizer(string,delimiter);
		while ( st.hasMoreTokens() ) {
			list.add(st.nextToken());
		}
		return list;
	}

	// ̕i[ArrayListAw肳ꂽf~^ŋ؂ЂƂ̕𐶐
	public static String joinList(ArrayList stringList, String delimiter) {
		if (stringList == null) {
			throw new IllegalArgumentException();
		}

		String returnString = "";
		Iterator iter = stringList.iterator();
		int i = 0;
		while (iter.hasNext()) {
			if(i>0) {
				returnString += delimiter;
			}
			returnString += (String) iter.next();
			i++;
		}
		return returnString;
	}

	// ̕i[ArrayListAw肳ꂽ܂܂Ȃ擾
	public static ArrayList exceptElement(ArrayList stringList, String exceptString) {
		if (stringList == null) {
			throw new IllegalArgumentException();
		}

		ArrayList exceptedList = new ArrayList();
		Iterator iter = stringList.iterator();
		while (iter.hasNext()) {
			String string = (String) iter.next();
			if (string.indexOf(exceptString) == -1) {
				exceptedList.add(string);
			}
		}
		return exceptedList;
	}



	// ̐ړ͐ڔɎw肳ꂽ̎w肳ꂽt^
	public static String addString(String str, String position, int repeatNumber, String repeatString) {
		if ( (position == null) || (repeatString == null) ) { throw new IllegalArgumentException(); }
		if ( (!position.equals("last")) && (!position.equals("first")) ) { throw new IllegalArgumentException(); }
		if ( repeatNumber<0 ) { throw new IllegalArgumentException(); }

		String addedString = str;
		if (position.equals("last")) {
			for (int i = 0; i < repeatNumber; i++) {
				addedString = addedString + repeatString;
			}
		} else if (position.equals("first")) {
			for (int i = 0; i < repeatNumber; i++) {
				addedString = repeatString + addedString;
			}
		}

		return addedString;
	}

}
